/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Kernel;
import cds.aladin.KernelList;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.aladin.prop.PropPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class FrameConvolution
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String FWHM;
    String SIGMA;
    String RADIUS;
    String PIXRES;
    String PLANE;
    String KERNEL;
    String GAUSSIAN;
    JTextField pixres;
    JTextField fwhm;
    JTextField sigma;
    JTextField radius;
    JRadioButton gaussian;
    JRadioButton kernels;
    JComboBox comboKernel;
    JButton show;
    private boolean lockRadius = false;
    private double res = 2.777777777777778E-4;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("CONVTITLE");
        this.INFO = Aladin.chaine.getString("CONVINFO");
        this.HELP1 = Aladin.chaine.getString("CONVHELP");
        this.PIXRES = Aladin.chaine.getString("CONVPIXRES");
        this.FWHM = "FWHM";
        this.SIGMA = "or   Sigma";
        this.RADIUS = Aladin.chaine.getString("CONVRADIUS");
        this.KERNEL = Aladin.chaine.getString("CONVKERNEL");
        this.GAUSSIAN = Aladin.chaine.getString("CONVGAUSSIAN");
        this.PLANE = Aladin.chaine.getString("ARITHPLANE");
    }

    protected FrameConvolution(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected String getLabelSelector(int n) {
        return this.PLANE;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 1;
    }

    @Override
    protected JButton[] getAddButtons() {
        this.show = new JButton("Show");
        JButton[] jButtonArray = new JButton[]{this.show};
        this.show.setEnabled(false);
        jButtonArray[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConvolution.this.showKernel((PlanImage)FrameConvolution.this.getPlan(FrameConvolution.this.ch[0]));
            }
        });
        return jButtonArray;
    }

    protected PlanImage[] getPlan() {
        Vector<Plan> vector = this.a.calque.getPlans(1);
        if (vector == null) {
            return new PlanImage[0];
        }
        Object[] objectArray = new PlanImage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected Color getColorLabel(int n) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints, 15, 0);
        gridBagConstraints.anchor = 13;
        JRadioButton jRadioButton = this.gaussian = new JRadioButton(this.GAUSSIAN, true);
        jRadioButton.setFont(jRadioButton.getFont().deriveFont(1));
        gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
        jPanel.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        gridBagConstraints.anchor = 10;
        JPanel jPanel2 = new JPanel(new GridLayout(2, 4, 5, 5));
        jPanel2.add(new JLabel(this.FWHM, 4));
        this.fwhm = new JTextField(5);
        jPanel2.add(this.fwhm);
        jPanel2.add(new JLabel(this.SIGMA, 4));
        this.sigma = new JTextField(5);
        jPanel2.add(this.sigma);
        jPanel2.add(new JLabel(this.PIXRES, 4));
        this.pixres = new JTextField(5);
        jPanel2.add(this.pixres);
        this.pixres.setEditable(false);
        jPanel2.add(new JLabel(this.RADIUS, 4));
        this.radius = new JTextField(5);
        jPanel2.add(this.radius);
        this.fwhm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConvolution.this.gaussian.setSelected(true);
                FrameConvolution.this.lockRadius = false;
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.sigma.setText("");
                FrameConvolution.this.show.setEnabled(true);
                FrameConvolution.this.adjustWidgets();
            }
        });
        this.fwhm.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.sigma.setText("");
            }
        });
        this.sigma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConvolution.this.gaussian.setSelected(true);
                FrameConvolution.this.lockRadius = false;
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.show.setEnabled(true);
                FrameConvolution.this.fwhm.setText("");
                FrameConvolution.this.adjustWidgets();
            }
        });
        this.sigma.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.fwhm.setText("");
            }
        });
        this.radius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConvolution.this.gaussian.setSelected(true);
                FrameConvolution.this.lockRadius = true;
                FrameConvolution.this.adjustWidgets();
            }
        });
        this.radius.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                FrameConvolution.this.lockRadius = true;
            }
        });
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints, 10, 0);
        gridBagConstraints.anchor = 13;
        jRadioButton = this.kernels = new JRadioButton(this.KERNEL);
        jRadioButton.setFont(jRadioButton.getFont().deriveFont(1));
        gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
        jPanel.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.comboKernel = new JComboBox<String>(this.a.kernelList.getKernelListAsVector());
        this.comboKernel.setMinimumSize(new Dimension(200, this.comboKernel.getPreferredSize().height));
        this.comboKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConvolution.this.kernels.setSelected(true);
                FrameConvolution.this.show.setEnabled(true);
            }
        });
        gridBagLayout.setConstraints(this.comboKernel, gridBagConstraints);
        jPanel.add(this.comboKernel);
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints, 15, 0);
        return jPanel;
    }

    public void reloadComboKernel(String string) {
        boolean bl = this.gaussian.isSelected();
        String string2 = string == null ? (String)this.comboKernel.getSelectedItem() : string;
        this.comboKernel.removeAllItems();
        Enumeration<String> enumeration = this.a.kernelList.getKernelListAsVector().elements();
        while (enumeration.hasMoreElements()) {
            this.comboKernel.addItem(enumeration.nextElement());
        }
        if (string2 != null) {
            this.comboKernel.setSelectedItem(string2);
        }
        this.gaussian.setSelected(bl);
    }

    private void showKernel(PlanImage planImage) {
        try {
            String string = this.getConvCmd();
            Kernel kernel = this.a.kernelList.getKernel(string, this.res);
            AladinData aladinData = this.a.createAladinImage(kernel.name);
            String string2 = aladinData.getLabel();
            aladinData.setPixels(kernel.matrix, -64);
            if (!planImage.hasNoReduction()) {
                double d = planImage.projd.getPixResAlpha();
                Coord coord = new Coord(this.a.view.repere.raj, this.a.view.repere.dej);
                int n = kernel.matrix.length;
                String string3 = "SIMPLE  = T\nBITPIX  = -64\nNAXIS   = 2\nNAXIS1  = " + n + "\nNAXIS2  = " + n + "\nCRPIX1  = " + (n / 2 + 1) + "\nCRPIX2  = " + (n / 2 + 1) + "\nCRVAL1  = " + coord.al + "\nCRVAL2  = " + coord.del + "\nCTYPE1  = RA---TAN\nCTYPE2  = DEC--TAN\nRADECSYS= FK5\nCD1_1   = " + -d + "\nCD1_2   = 0\nCD2_1   = 0\nCD2_2   = " + d + "\n";
                aladinData.setFitsHeader(string3);
                this.a.command.execLater("set " + string2 + " opacity=75");
                this.a.command.execLater("set " + string2 + " shown");
                this.a.command.execLater("cm " + string2 + " asinh reverse autocut");
            } else {
                this.a.command.execLater("show " + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getConvCmd() throws Exception {
        String string = null;
        if (this.gaussian.isSelected()) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = this.fwhm.getText().trim();
            if (string2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("fwhm=" + string2);
            } else {
                string2 = this.sigma.getText().trim();
                if (string2.length() > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append("sigma=" + string2);
                }
            }
            string2 = this.radius.getText().trim();
            if (string2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("radius=" + string2);
            }
            string = "gauss(" + stringBuffer + ")";
            double[] dArray = KernelList.parseGaussCmd(string);
            dArray = KernelList.computeGaussParam(dArray[0], dArray[1], this.res, 0);
            this.fwhm.setText(Coord.getUnit(dArray[0]));
            this.sigma.setText(Coord.getUnit(dArray[1]));
            if (!this.lockRadius) {
                this.radius.setText("" + (int)dArray[2]);
            }
        } else {
            string = (String)this.comboKernel.getSelectedItem();
        }
        return string;
    }

    @Override
    protected void submit() {
        try {
            PlanImage planImage = (PlanImage)this.getPlan(this.ch[0]);
            String string = this.getConvCmd();
            String string2 = string.replace('=', ':');
            this.a.console.printCommand(string2 + "=conv " + Tok.quote(planImage.label) + " " + Tok.quote(string));
            this.a.calque.newPlanImageAlgo(string2, planImage, null, 6, 0.0, string, 0);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("Convolution failed !");
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.fwhm.setText("");
        this.sigma.setText("");
        this.adjustWidgets();
        this.comboKernel.setSelectedIndex(0);
        this.gaussian.setSelected(true);
        this.show.setEnabled(false);
    }

    @Override
    protected void adjustWidgets() {
        PlanImage planImage = (PlanImage)this.getPlan(this.ch[0]);
        String string = "--";
        if (planImage != null) {
            try {
                this.res = planImage.projd.getPixResDelta();
                string = Coord.getUnit(this.res);
            }
            catch (Exception exception) {
                string = "--";
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.fwhm.getText().trim();
        if (string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("fwhm=" + string2);
            bl2 = true;
        } else {
            string2 = this.sigma.getText().trim();
            if (string2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("sigma=" + string2);
                bl = true;
            }
        }
        string2 = this.radius.getText().trim();
        if (string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("radius=" + string2);
        } else {
            this.lockRadius = false;
        }
        if (stringBuffer.length() > 0) {
            double[] dArray = KernelList.parseGaussCmd("gauss(" + stringBuffer + ")");
            dArray = KernelList.computeGaussParam(dArray[0], dArray[1], this.res, 0);
            if (!this.lockRadius) {
                this.radius.setText("" + (int)dArray[2]);
            }
            if (bl2) {
                this.sigma.setText(Coord.getUnit(dArray[1]));
            } else if (bl) {
                this.fwhm.setText(Coord.getUnit(dArray[0]));
            }
        } else {
            this.radius.setText("");
        }
        this.pixres.setText(string);
    }
}

