/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.SliderEpochTool;
import cds.aladin.Source;
import cds.aladin.prop.PropPanel;
import cds.astro.Astrocoo;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Unit;
import cds.tools.Computer;
import cds.tools.Util;
import cds.xml.TableParser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameCooToolbox
extends JFrame {
    protected Aladin aladin;
    private boolean init = false;
    private double ra;
    private double dec;
    private double originEpoch = 2000.0;
    private double pmra = 0.0;
    private double pmdec = 0.0;
    private double rv = 0.0;
    private double plx = 0.0;
    private double targetEpoch = 2000.0;
    private JTextField[] cooField;
    private JTextField pmraField;
    private JTextField pmdeField;
    private JTextField originEpochField;
    private JTextField targetEpochField;
    private JTextField distField;
    private JTextField plxField;
    private JTextField rvField;
    private JTextField distALField;
    private JTextField distParsecField;
    private SliderEpochTool sliderEpoch;
    private static double PARSEC2AL = 3.2614945566008;

    protected FrameCooToolbox(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle("Coordinate toolbox");
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.getContentPane().add((Component)this.createPanelLeft(), "West");
        this.getContentPane().add((Component)this.createPanelRight(), "East");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.aladin.frameCooTool = null;
        }
        super.processWindowEvent(windowEvent);
    }

    private JPanel createPanelRight() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(gridBagLayout);
        int n = Localisation.REPERE.length - 3;
        JLabel[] jLabelArray = new JLabel[n];
        this.cooField = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jLabelArray[i] = new JLabel(Localisation.REPERE[i]);
            this.cooField[i] = new JTextField(22);
            this.cooField[i].setActionCommand(i + "");
            this.cooField[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameCooToolbox.this.setCoordFrom(actionEvent.getActionCommand(), ((JTextField)actionEvent.getSource()).getText());
                }
            });
            gridBagConstraints.insets.top = i == 5 ? 10 : 0;
            PropPanel.addCouple(jPanel, jLabelArray[i], this.cooField[i], gridBagLayout, gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel createPanelLeft() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel("PMRA (mas/yr)");
        this.pmraField = new JTextField(10);
        this.pmraField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel jLabel2 = new JLabel("PMDEC (mas/yr)");
        this.pmdeField = new JTextField(10);
        this.pmdeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel jLabel3 = new JLabel("Parallax (mas)");
        this.plxField = new JTextField(10);
        this.plxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel jLabel4 = new JLabel("Dist (parsec)");
        this.distParsecField = new JTextField(10);
        this.distParsecField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify(2);
            }
        });
        JLabel jLabel5 = new JLabel("Dist (light-year)");
        this.distALField = new JTextField(10);
        this.distALField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify(1);
            }
        });
        JLabel jLabel6 = new JLabel("Radial velocity (km/s)");
        this.rvField = new JTextField(10);
        this.rvField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel jLabel7 = new JLabel("Origin epoch (Jy)");
        this.originEpochField = new JTextField(10);
        this.originEpochField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel jLabel8 = new JLabel("Target epoch (Jy)");
        this.targetEpochField = new JTextField(10);
        this.targetEpochField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameCooToolbox.this.modify();
            }
        });
        this.sliderEpoch = new SliderEpochTool(this);
        PropPanel.addCouple(jPanel, jLabel, this.pmraField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel2, this.pmdeField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel3, this.plxField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel4, this.distParsecField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel5, this.distALField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel6, this.rvField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel7, this.originEpochField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, jLabel8, this.targetEpochField, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.sliderEpoch, gridBagConstraints);
        jPanel.add(this.sliderEpoch);
        JLabel jLabel9 = new JLabel("Ang.dist. from orig.loc");
        this.distField = new JTextField(10);
        this.distField.setEditable(false);
        PropPanel.addCouple(jPanel, jLabel9, this.distField, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected void setSource(Source source) {
        block9: {
            Legende legende = source.leg;
            int n = legende.getRa();
            int n2 = legende.getDe();
            String string = source.getValue(n);
            String string2 = source.getValue(n2);
            try {
                Astrocoo astrocoo = new Astrocoo();
                TableParser.getRaDec(astrocoo, string, string2, 0);
                this.ra = astrocoo.getLon();
                this.dec = astrocoo.getLat();
                int n3 = legende.getPmRa();
                int n4 = legende.getPmDe();
                if (n3 > 0 && n4 > 0) {
                    Unit unit = new Unit();
                    try {
                        unit.setUnit(source.getUnit(n3));
                        unit.setValue(source.getValue(n3));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Unit unit2 = new Unit();
                    try {
                        unit2.setUnit(source.getUnit(n4));
                        unit2.setValue(source.getValue(n4));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (unit.getValue() == 0.0 && unit2.getValue() == 0.0) break block9;
                    try {
                        unit.convertTo(new Unit("mas/yr"));
                    }
                    catch (Exception exception) {
                        unit.setUnit(source.getUnit(n3));
                        unit.setValue(source.getValue(n3));
                        unit.convertTo(new Unit("ms/yr"));
                        double d = 15.0 * unit.getValue() * Math.cos(astrocoo.getLat() * Math.PI / 180.0);
                        unit = new Unit(d + "mas/yr");
                    }
                    this.pmra = Util.round(unit.getValue(), 3);
                    unit2.convertTo(new Unit("mas/yr"));
                    this.pmdec = Util.round(unit2.getValue(), 3);
                    break block9;
                }
                this.pmdec = 0.0;
                this.pmra = 0.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.originEpoch = 2000.0;
        this.targetEpoch = source.plan.getEpoch().getJyr();
        this.init = true;
        this.resume();
    }

    protected void setReticle(double d, double d2) {
        this.ra = d;
        this.dec = d2;
        this.targetEpoch = 2000.0;
        this.originEpoch = 2000.0;
        try {
            String string;
            Plan plan = this.aladin.calque.getPlanBase();
            if (plan instanceof PlanImage && (string = ((PlanImage)plan).getDateObs()) != null) {
                Astrotime astrotime = new Astrotime();
                astrotime.set(string);
                this.originEpoch = astrotime.getJyr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pmdec = 0.0;
        this.pmra = 0.0;
        this.init = true;
        this.resume(false);
    }

    protected void setCoordFrom(String string, String string2) {
        try {
            int n = Integer.parseInt(string);
            Astrocoo astrocoo = new Astrocoo(Localisation.getAstroframe(n));
            if (string2.indexOf(40) < 0 && this.originEpochField.getText().trim().length() > 0) {
                string2 = string2 + " (J" + this.originEpochField.getText().trim() + ")";
            }
            astrocoo.set(string2);
            astrocoo.convertTo(Localisation.getAstroframe(0));
            this.originEpochField.setText(astrocoo.epoch + "");
            this.targetEpochField.setText(astrocoo.epoch + "");
            this.ra = astrocoo.getLon();
            this.dec = astrocoo.getLat();
            this.init = true;
            this.modify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void modify() {
        this.modify(0);
    }

    protected void modify(int n) {
        String string;
        try {
            string = this.originEpochField.getText();
            if (Character.isDigit(string.charAt(0))) {
                string = "J" + string;
            }
            this.originEpoch = new Astrotime(string).getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = this.targetEpochField.getText();
            if (Character.isDigit(string.charAt(0))) {
                string = "J" + string;
            }
            this.targetEpoch = new Astrotime(string).getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pmra = this.getField(this.pmraField);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pmdec = this.getField(this.pmdeField);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (n == 2) {
                double d = this.getField(this.distParsecField);
                this.plx = this.arsec2plx(d);
            } else if (n == 1) {
                double d = this.getField(this.distALField);
                this.plx = this.al2plx(d);
            } else {
                this.plx = this.getField(this.plxField);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rv = this.getField(this.rvField);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume();
    }

    private double getField(JTextField jTextField) throws Exception {
        String string = jTextField.getText();
        return Computer.compute(string);
    }

    protected void setEpoch(String string) {
        try {
            if (Character.isDigit(string.charAt(0))) {
                string = "J" + string;
            }
            this.targetEpoch = new Astrotime(string).getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume(false);
    }

    private void resume() {
        this.resume(true);
    }

    private void resume(boolean bl) {
        if (this.cooField == null) {
            return;
        }
        for (int i = 0; i < this.cooField.length; ++i) {
            this.cooField[i].setText(this.getCoordIn(i));
        }
        this.originEpochField.setText(!this.init ? "" : this.originEpoch + "");
        this.targetEpochField.setText(!this.init ? "" : this.targetEpoch + "");
        this.pmraField.setText(this.pmdec == 0.0 && this.pmra == 0.0 ? "" : Util.myRound(this.pmra));
        this.pmdeField.setText(this.pmdec == 0.0 && this.pmra == 0.0 ? "" : Util.myRound(this.pmdec));
        this.rvField.setText(this.rv == 0.0 ? "" : Util.myRound(this.rv));
        this.plxField.setText(this.getParallaxe());
        this.distField.setText(this.getDistance());
        this.distALField.setText(this.getDistAL());
        this.distParsecField.setText(this.getDistParsec());
        this.sliderEpoch.setValue((int)this.targetEpoch);
        if (bl) {
            this.aladin.glu.log("CoordToolbox", "");
        }
    }

    private String getDistAL() {
        if (this.plx == 0.0) {
            return "";
        }
        return Util.myRound(1000.0 * PARSEC2AL / this.plx);
    }

    private String getDistParsec() {
        if (this.plx == 0.0) {
            return "";
        }
        return Util.myRound(1000.0 / this.plx);
    }

    private double al2plx(double d) {
        return 1000.0 * PARSEC2AL / d;
    }

    private double arsec2plx(double d) {
        return 1000.0 / d;
    }

    private String getParallaxe() {
        if (this.plx == 0.0) {
            return "";
        }
        if (this.targetEpoch == this.originEpoch || this.rv == 0.0) {
            return this.plx + "";
        }
        Astropos astropos = new Astropos(Localisation.AF_ICRS);
        astropos.set(this.ra, this.dec, this.originEpoch, null, this.pmra, this.pmdec, this.originEpoch, null, new double[]{this.plx, 0.0}, new double[]{this.rv, 0.0});
        astropos.toEpoch(this.targetEpoch);
        return Util.myRound("" + astropos.plx, 6);
    }

    private String getDistance() {
        if (!this.init || this.targetEpoch == this.originEpoch || this.pmra == 0.0 && this.pmdec == 0.0) {
            return "";
        }
        Astropos astropos = new Astropos(Localisation.AF_ICRS);
        astropos.set(this.ra, this.dec, this.originEpoch, null, this.pmra, this.pmdec, this.originEpoch, null, new double[]{this.plx, 0.0}, new double[]{this.rv, 0.0});
        astropos.toEpoch(this.targetEpoch);
        double d = Coo.distance(this.ra, this.dec, astropos.getLon(), astropos.getLat());
        return Coord.getUnit(d);
    }

    private String getCoordIn(int n) {
        String string;
        if (!this.init) {
            return "";
        }
        Astropos astropos = new Astropos(Localisation.AF_ICRS);
        astropos.set(this.ra, this.dec, this.originEpoch, null, this.pmra, this.pmdec, this.originEpoch, null, new double[]{this.plx, 0.0}, new double[]{this.rv, 0.0});
        astropos.convertTo(Localisation.getAstroframe(n));
        astropos.toEpoch(this.targetEpoch);
        String string2 = string = n == 6 || n == 8 || n == 1 || n == 2 || n == 3 || n == 4 ? astropos.toString("2d") : astropos.toString("2s");
        if (string.indexOf("--") >= 0) {
            return "";
        }
        return string;
    }
}

