/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Grid;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Select;
import cds.aladin.ServerFile;
import cds.aladin.Slide;
import cds.aladin.ViewSimple;
import cds.aladin.WidgetControl;
import cds.aladin.Words;
import cds.aladin.bookmark.Bookmarks;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public final class FrameFullScreen
extends JFrame
implements ActionListener {
    static final int WINDOW = 0;
    static final int WINDOW_HIDDEN = 1;
    static final int FULL = 2;
    static final int CINEMA = 3;
    private static String[] MODE = new String[]{"Window", "Window-hidden", "Full", "Cinema"};
    static GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    static GraphicsDevice device = env.getDefaultScreenDevice();
    static DisplayMode display = device.getDisplayMode();
    private Aladin aladin = null;
    protected ViewSimple viewSimple;
    private Rectangle bounds;
    private Vector ligne = null;
    private int ocursor = -1;
    private int mode;
    private Timer timer = null;
    private JPopupMenu popMenu;
    private JMenuItem menuDel;
    private JMenuItem menuProp;
    private StringBuffer cmd = new StringBuffer();
    private boolean blinkState = true;
    private Plan currentPlan = null;
    private int XBLINK = -1;
    private int YBLINK;
    private int XGRID = -1;
    private int YGRID;
    private int XARROW = -1;
    private int YARROW;
    private int XSAVE = -1;
    private int YSAVE;
    static final int YMARGE = 175;
    static final int XMARGE = 40;
    static final int YGAP = 18;
    static final int MAXCHECK = 20;
    private int nCheck = 0;
    private Check[] memoCheck = null;
    private Component box1 = Box.createGlue();
    private Component box2 = Box.createGlue();
    private Component box3 = Box.createGlue();
    private JMenu menuFrame = null;
    private JMenu menuBookmark = null;
    private Image cross = null;
    private Image arrow = null;
    private Image save = null;
    private int XOUT;
    private int YOUT;
    private Image logo = null;

    protected FrameFullScreen(Aladin aladin, ViewSimple viewSimple, int n) {
        super(env.getDefaultScreenDevice().getDefaultConfiguration());
        this.aladin = aladin;
        this.setTitle("Aladin " + aladin.getReleaseNumber());
        Aladin.setIcon(this);
        this.viewSimple = viewSimple;
        this.mode = n;
        Aladin.trace(4, "FrameFullScreen(mode=" + MODE[n] + ")");
        this.createPopupMenu();
        this.insertMenu();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.end();
            }
        }, KeyStroke.getKeyStroke(114, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.zoom(1);
            }
        }, KeyStroke.getKeyStroke(113, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.zoom(-1);
            }
        }, KeyStroke.getKeyStroke(122, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.end();
            }
        }, KeyStroke.getKeyStroke(123, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.end1();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.delete();
            }
        }, KeyStroke.getKeyStroke(127, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.grid();
            }
        }, KeyStroke.getKeyStroke(71, 8), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.hpxGrid();
            }
        }, KeyStroke.getKeyStroke(87, 8), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameFullScreen.this.constellation();
            }
        }, KeyStroke.getKeyStroke(67, 8), 2);
        if (n != 3) {
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.dist();
                }
            }, KeyStroke.getKeyStroke(68, 8), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.prop();
                }
            }, KeyStroke.getKeyStroke(10, 8), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.pixel();
                }
            }, KeyStroke.getKeyStroke(77, 2), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.open();
                }
            }, KeyStroke.getKeyStroke(79, 2), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.openDialog();
                }
            }, KeyStroke.getKeyStroke(76, 2), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.zoom(-1);
                }
            }, KeyStroke.getKeyStroke(113, 0), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.zoom(1);
                }
            }, KeyStroke.getKeyStroke(114, 0), 2);
            viewSimple.setFocusTraversalKeysEnabled(false);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.next(1);
                }
            }, KeyStroke.getKeyStroke(9, 1), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameFullScreen.this.next(-1);
                }
            }, KeyStroke.getKeyStroke(9, 0), 2);
        }
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().add((Component)viewSimple, "Center");
        this.bounds = viewSimple.getBounds();
        viewSimple.setBounds(this.getBounds());
        if (n == 2 || n == 3) {
            this.full();
        } else {
            this.window();
        }
        if (n != 1) {
            this.setVisible(true);
        }
        if (!aladin.isApplet() || aladin.flagDetach) {
            aladin.f.setVisible(false);
        }
    }

    private void insertMenu() {
        if (this.mode == 3) {
            return;
        }
        this.setJMenuBar(this.aladin.jBar);
        this.aladin.jBar.setVisible(false);
        this.aladin.jBar.remove(this.aladin.jBar.getMenuCount() - 1);
        this.aladin.jBar.add(this.box1, this.aladin.jbarLastIndex);
        this.aladin.jBar.add(this.box1, this.aladin.jbarLastIndex);
        this.aladin.jBar.add((Component)this.getFrameMenu(), this.aladin.jbarLastIndex);
        this.aladin.jBar.add((Component)this.getBookmarkMenu(), this.aladin.jbarLastIndex);
        this.aladin.jBar.add(this.box3, this.aladin.jbarLastIndex);
    }

    private void removeMenu() {
        if (this.mode == 3) {
            return;
        }
        this.aladin.jBar.remove(this.menuBookmark);
        this.aladin.jBar.remove(this.menuFrame);
        this.aladin.jBar.remove(this.box1);
        this.aladin.jBar.remove(this.box2);
        this.aladin.jBar.remove(this.box3);
        this.aladin.jBar.add(this.aladin.iconFullScreen);
        this.aladin.jBar.setVisible(true);
        this.aladin.setJMenuBar(this.aladin.jBar);
        this.aladin.jBar.setBorderPainted(true);
    }

    private JMenu getFrameMenu() {
        int n;
        if (this.menuFrame != null) {
            return this.menuFrame;
        }
        this.menuFrame = new JMenu("Frame");
        ButtonGroup buttonGroup = new ButtonGroup();
        JComboBox jComboBox = this.aladin.localisation.getComboBox();
        int n2 = jComboBox.getItemCount();
        Vector<String> vector = new Vector<String>(n2);
        for (n = 0; n < n2; ++n) {
            vector.add((String)jComboBox.getItemAt(n));
        }
        n = jComboBox.getSelectedIndex();
        for (int i = 0; i < n2; ++i) {
            String string = (String)vector.get(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem.setSelected(i == n);
            buttonGroup.add(jRadioButtonMenuItem);
            this.menuFrame.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((JMenuItem)actionEvent.getSource()).getActionCommand();
                    ((FrameFullScreen)FrameFullScreen.this).aladin.localisation.setPositionMode(string);
                }
            });
        }
        return this.menuFrame;
    }

    private JMenu getBookmarkMenu() {
        if (this.menuBookmark != null) {
            return this.menuBookmark;
        }
        this.menuBookmark = new JMenu("Bookmark");
        Bookmarks bookmarks = this.aladin.bookmarks;
        int n = bookmarks.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = bookmarks.getComponentAtIndex(i);
            if (!(component instanceof JButton)) continue;
            JButton jButton = (JButton)component;
            String string = jButton.getText();
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(jButton.getActionListeners()[0]);
            this.menuBookmark.add(jMenuItem);
        }
        return this.menuBookmark;
    }

    private void prop() {
        Properties.createProperties(this.aladin.calque.getPlanBase());
    }

    private void pixel() {
        this.aladin.pixel();
    }

    private void open() {
        ((ServerFile)this.aladin.dialog.localServer).browseFile();
    }

    private void openDialog() {
        this.aladin.dialog.show();
    }

    protected int getMode() {
        return this.mode;
    }

    private void full() {
        this.setUndecorated(true);
        if (this.mode == 2) {
            this.setLocation(0, 0);
            this.setSize(Aladin.SCREENSIZE);
        } else if (this.mode == 3) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            graphicsDevice.setFullScreenWindow(this);
        }
    }

    private void window() {
        Dimension dimension = this.aladin.f.getSize();
        if (dimension.width < 10 || dimension.height < 10) {
            Rectangle rectangle = this.aladin.configuration.getWinLocation();
            if (rectangle.width < 0 || rectangle.height < 0) {
                rectangle.height = 600;
                rectangle.width = 600;
            }
            this.setSize(rectangle.width, rectangle.height);
            this.setLocation(rectangle.x, rectangle.y);
        } else {
            this.setSize(dimension);
            this.setLocation(this.aladin.f.getLocation());
        }
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.mode != 2 && this.mode != 3) {
                FrameFullScreen frameFullScreen = this;
                if (frameFullScreen.aladin.isApplet()) {
                    this.setVisible(false);
                } else {
                    this.aladin.quit(0);
                }
            } else {
                this.end();
            }
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    private void end1() {
        if (this.hasCmd() && !this.aladin.view.isFree()) {
            Util.resetString(this.cmd);
        } else {
            this.end();
        }
    }

    protected void end() {
        if (this.mode == 3) {
            return;
        }
        this.viewSimple.aladin.fullScreen = null;
        this.viewSimple.setToolTipText(null);
        this.viewSimple.setBounds(this.bounds);
        this.aladin.view.adjustPanel();
        if (this.mode != 2 && this.mode != 3) {
            this.aladin.toolBox.calcConf(500);
            this.aladin.f.setSize(this.getSize());
        }
        this.removeMenu();
        this.aladin.f.setVisible(true);
        this.aladin.calque.repaintAll();
        this.memoCheck = null;
        this.currentPlan = null;
        this.dispose();
    }

    private void delete() {
        this.aladin.calque.Free(this.viewSimple.pref);
        this.aladin.view.findBestDefault();
    }

    private void next(int n) {
        this.aladin.view.next(n);
    }

    private void grid() {
        this.aladin.calque.setGrid(!this.aladin.calque.hasGrid(), true);
    }

    private void hpxGrid() {
        this.aladin.calque.setOverlayFlag("hpxgrid", !this.aladin.calque.hasHpxGrid());
        this.aladin.view.repaintAll();
    }

    private void constellation() {
        boolean bl = !this.aladin.calque.hasConst();
        this.aladin.calque.setOverlayFlag("const", bl);
        this.aladin.console.printCommand("setconf overlay=" + (bl ? "+" : "-") + "const");
        this.aladin.view.repaintAll();
    }

    private void dist() {
        this.aladin.graphic(4);
        Aladin.makeCursor(this.viewSimple, 3);
    }

    private void zoom(int n) {
        this.aladin.command.exec("zoom " + (n == 1 ? (char)'+' : '-'));
    }

    protected void startMemo() {
        if (this.memoCheck == null) {
            this.memoCheck = new Check[20];
        }
        this.nCheck = 0;
    }

    private Plan getCheckPlan(int n, int n2) {
        if (this.memoCheck == null) {
            return null;
        }
        try {
            for (int i = this.nCheck - 1; i >= 0; --i) {
                Check check = this.memoCheck[i];
                if (!check.in(n, n2)) continue;
                return check.p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void setCheck(Plan plan) {
        if (this.nCheck >= 20) {
            return;
        }
        Check check = this.memoCheck[this.nCheck];
        if (check == null) {
            this.memoCheck[this.nCheck] = check = new Check();
        }
        check.x = this.getWidth() - 40;
        check.y = this.getHeight() - 175 - this.nCheck * 18 - 18;
        check.p = plan;
        ++this.nCheck;
    }

    protected void drawChecks(Graphics graphics) {
        if (this.memoCheck == null || this.aladin.calque.isFree()) {
            return;
        }
        for (int i = this.nCheck - 1; i >= 0; --i) {
            Check check = this.memoCheck[i];
            Util.drawCheckbox(graphics, check.x, check.y, check.p.c, null, null, check.p.active);
        }
    }

    protected void drawIcons(Graphics graphics) {
        if (this.mode == 3) {
            return;
        }
        int n = 175;
        if (this.viewSimple.pref != null && Projection.isOk(this.viewSimple.getProj())) {
            this.XGRID = this.getWidth() - 42;
            this.YGRID = this.getHeight() - n + 8;
            Grid cfr_ignored_0 = this.aladin.grid;
            Grid.fillBG(graphics, this.XGRID, this.YGRID, Color.white);
            Grid cfr_ignored_1 = this.aladin.grid;
            Grid.drawGrid(graphics, this.XGRID, this.YGRID, this.aladin.calque.hasGrid() ? Aladin.GREEN : Color.black);
        } else {
            this.XGRID = -1;
        }
        if (this.viewSimple.pref != null) {
            if (this.save == null) {
                this.save = this.aladin.getImagette("Export.gif");
            }
            try {
                this.XSAVE = this.getWidth() - 41;
                this.YSAVE = this.getHeight() - n + 18 + 6;
                graphics.drawImage(this.save, this.XSAVE, this.YSAVE, this.viewSimple);
            }
            catch (Exception exception) {
                this.XSAVE = -1;
            }
        } else {
            this.XSAVE = -1;
        }
        if (this.aladin.calque.getNbPlanImg() > 1) {
            if (this.arrow == null) {
                this.arrow = this.aladin.getImagette("Next.gif");
            }
            try {
                this.XARROW = this.getWidth() - 40;
                this.YARROW = this.getHeight() - n + 36 + 6;
                graphics.drawImage(this.arrow, this.XARROW, this.YARROW, this.viewSimple);
            }
            catch (Exception exception) {
                this.XARROW = -1;
            }
        } else {
            this.XARROW = -1;
        }
    }

    private boolean inIconOut(int n, int n2) {
        n -= this.XOUT;
        n2 -= this.YOUT;
        try {
            return n >= 0 && n < this.cross.getWidth(this.viewSimple) && n2 >= 0 && n2 < this.cross.getHeight(this.viewSimple);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean inIconArrow(int n, int n2) {
        if (this.XARROW < 0) {
            return false;
        }
        n -= this.XARROW;
        n2 -= this.YARROW;
        try {
            return n >= 0 && n < this.arrow.getWidth(this.viewSimple) && n2 >= 0 && n2 < this.arrow.getHeight(this.viewSimple);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean inIconSave(int n, int n2) {
        if (this.XSAVE < 0) {
            return false;
        }
        n -= this.XSAVE;
        n2 -= this.YSAVE;
        try {
            return n >= 0 && n < this.save.getWidth(this.viewSimple) && n2 >= 0 && n2 < this.save.getHeight(this.viewSimple);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean hasCmd() {
        return this.cmd.length() > 0;
    }

    protected boolean sendKey(KeyEvent keyEvent) {
        boolean bl = false;
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        this.aladin.endMsg();
        if (keyEvent.isControlDown() || keyEvent.isAltDown()) {
            return bl;
        }
        this.blinkState = true;
        if (n == 10) {
            this.aladin.execAsyncCommand(this.cmd.toString());
            this.cmd.delete(0, this.cmd.length());
            bl = true;
        } else if (n == 8 || n == 127) {
            if (this.cmd.length() > 0) {
                this.cmd.deleteCharAt(this.cmd.length() - 1);
            }
            if (this.cmd.length() == 0) {
                bl = true;
            }
        } else if (c >= '\u001f' && c <= '\u00ff') {
            this.cmd.append(c);
        }
        return bl;
    }

    protected void drawBlinkInfo(Graphics graphics) {
        boolean bl;
        block14: {
            boolean bl2;
            bl = this.aladin.calque.isBlinking();
            boolean bl3 = this.hasCmd();
            boolean bl4 = bl2 = this.aladin.view.isFree() && !Aladin.isApplet();
            if (!(bl3 || bl || bl2)) {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                return;
            }
            int n = 0;
            if (bl3 || bl2) {
                int n2;
                int n3 = 200;
                int n4 = 20;
                int n5 = bl2 ? this.getWidth() / 2 - n3 / 2 : 10;
                n = n2 = bl2 ? this.getHeight() / 2 - 100 - n4 / 2 : 10;
                graphics.setColor(Color.white);
                graphics.fillRect(n5, n2, n3, n4);
                Util.drawEdge(graphics, n5, n2, n3, n4);
                graphics.setFont(Aladin.BOLD);
                String string = this.cmd.toString();
                if (bl2) {
                    graphics.setColor(Color.black);
                    String string2 = Localisation.YOUROBJ;
                    graphics.drawString(string2, this.getWidth() / 2 - graphics.getFontMetrics().stringWidth(string2) / 2, n2 + n4 + 15);
                }
                graphics.setColor(Aladin.GREEN);
                if (this.blinkState) {
                    string = string + "_";
                }
                graphics.drawString(string, n5 + 5, n2 + n4 - 5);
            }
            if (bl2) {
                try {
                    if (this.logo == null) {
                        this.logo = this.aladin.getImagette("Aladin.png");
                    } else {
                        graphics.drawImage(this.logo, this.getWidth() / 2 - this.logo.getWidth(this.viewSimple) / 2, n - this.logo.getHeight(this.viewSimple) - 10, this.viewSimple);
                    }
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block14;
                    exception.printStackTrace();
                }
            }
        }
        WidgetControl widgetControl = this.aladin.calque.select.getWidgetControl();
        if (bl && widgetControl.isCollapsed()) {
            this.XBLINK = widgetControl.getX() + 2;
            this.YBLINK = widgetControl.getY() - 10;
            Slide.drawBall(graphics, this.XBLINK, this.YBLINK, this.blinkState ? Color.green : Color.white);
        } else {
            this.XBLINK = -1;
        }
        if (this.timer == null) {
            this.timer = new Timer(500, this);
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            if (this.currentPlan == null) {
                return;
            }
            if (object == this.menuDel) {
                this.aladin.calque.Free(this.currentPlan);
            } else if (object == this.menuProp) {
                Properties.createProperties(this.currentPlan);
            }
            return;
        }
        boolean bl = this.blinkState = !this.blinkState;
        if (!Aladin.NOGUI) {
            this.repaint();
        }
    }

    protected void showMesures() {
        int n = this.aladin.mesure.getNbSrc();
        if (n == 0 || this.aladin.mesure.f != null && this.aladin.mesure.f.isVisible()) {
            return;
        }
        if (this.aladin.mesure.f == null) {
            this.aladin.mesure.split();
        } else if (!this.aladin.mesure.isVisible()) {
            this.aladin.mesure.setReduced(false);
            this.aladin.mesure.f.setVisible(true);
        }
    }

    private void createPopupMenu() {
        JMenuItem jMenuItem;
        Select select = this.aladin.view.calque.select;
        this.popMenu = new JPopupMenu();
        this.menuDel = jMenuItem = new JMenuItem(select.MDEL);
        this.popMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.menuProp = jMenuItem = new JMenuItem(select.MPROP);
        this.popMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.getContentPane().add(this.popMenu);
    }

    private void showPopMenu(int n, int n2) {
        this.popMenu.show(this, n, n2);
    }

    protected boolean mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (this.inIconOut(n, n2)) {
            this.end();
            return true;
        }
        if (this.inIconArrow(n, n2)) {
            this.next(mouseEvent.isShiftDown() ? 1 : -1);
            return true;
        }
        if (this.inIconSave(n, n2)) {
            this.aladin.save.saveFile(1, mouseEvent.isShiftDown() ? 4 : 8, -1.0f);
            return true;
        }
        Plan plan = this.getCheckPlan(n, n2);
        if (plan != null) {
            bl = true;
            if (mouseEvent.isPopupTrigger()) {
                this.currentPlan = plan;
                this.showPopMenu(n, n2);
            } else {
                plan.setActivated(!plan.active);
                this.aladin.view.repaintAll();
            }
        } else if (this.XGRID > 0 && n >= this.XGRID && n <= this.XGRID + 15 && n2 >= this.YGRID && n2 <= this.YGRID + 15) {
            this.aladin.calque.switchGrid(true);
            bl = true;
        } else if (this.ligne != null) {
            Enumeration enumeration = this.ligne.elements();
            Obj obj = (Obj)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                Words words = (Words)enumeration.nextElement();
                if (!words.inside(n, n2)) continue;
                bl = true;
                if (!words.glu) continue;
                words.haspushed = true;
                if (words.archive) {
                    this.end();
                    words.callArchive(this.aladin, obj);
                } else {
                    words.callGlu(this.aladin.glu, this.aladin.mesure.mcanvas);
                }
                return true;
            }
        }
        return bl;
    }

    private void menu(int n) {
        boolean bl = this.aladin.jBar.isVisible();
        this.aladin.jBar.setVisible(n < 50);
        if (bl != this.aladin.jBar.isVisible()) {
            this.viewSimple.repaint();
        }
    }

    protected boolean mouseMoved(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        this.currentPlan = null;
        this.menu(n2);
        if (this.inIconOut(n, n2)) {
            n3 = 2;
            bl = true;
            Util.toolTip(this.viewSimple, this.aladin.FULLINT);
        } else if (this.inIconArrow(n, n2)) {
            n3 = 2;
            bl = true;
            Util.toolTip(this.viewSimple, this.aladin.NEXT);
        } else if (this.inIconSave(n, n2)) {
            n3 = 2;
            bl = true;
            Util.toolTip(this.viewSimple, "Save currentview (PNG format)");
        } else if (this.XBLINK > 0 && n >= this.XBLINK && n <= this.XBLINK + 10 && n2 >= this.YBLINK && n2 <= this.YBLINK + 10) {
            String string = this.aladin.calque.getBlinkingInfo();
            if (string.length() > 0) {
                string = "Waiting " + string + "...";
            }
            Util.toolTip(this.viewSimple, string);
            bl = true;
        } else if (this.XGRID > 0 && n >= this.XGRID && n <= this.XGRID + 15 && n2 >= this.YGRID && n2 <= this.YGRID + 15) {
            n3 = 2;
            Util.toolTip(this.viewSimple, this.aladin.grid.getHelpTip());
            bl = true;
        } else {
            Plan plan = this.getCheckPlan(n, n2);
            if (plan != null) {
                n3 = 2;
                bl = true;
                Util.toolTip(this.viewSimple, plan.getInfo());
            } else {
                Util.toolTip(this.viewSimple, "");
                if (this.ligne != null) {
                    Enumeration enumeration = this.ligne.elements();
                    enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        Words words = (Words)enumeration.nextElement();
                        if (!words.inside(n, n2) || !words.glu) continue;
                        n3 = 2;
                        bl = true;
                        break;
                    }
                }
            }
        }
        if (n3 != this.ocursor) {
            this.ocursor = n3;
            Aladin.makeCursor(this.viewSimple, n3);
        }
        return bl;
    }

    class Check {
        int x;
        int y;
        Plan p;

        Check() {
        }

        boolean in(int n, int n2) {
            return n >= this.x && n <= this.x + 10 && n2 >= this.y && n2 <= this.y + 10;
        }
    }
}

