/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Chaine;
import cds.aladin.FrameHeaderPDS;
import cds.aladin.FrameHipsProperties;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FrameHeaderFits
extends JFrame {
    private JTextPane ta;
    private JTextField ts;
    static String CLOSE;
    static String CLEAR;
    static String SAVE;
    static String CANCEL;
    static String SAVEINFO;
    private DefaultStyledDocument df;
    private JButton clear;
    private JButton cancel;
    private JButton save;
    private Plan plan;
    protected HeaderFits headerFits;
    private static SimpleAttributeSet atKey;
    private static SimpleAttributeSet atValue;
    private static SimpleAttributeSet atComment;
    private static SimpleAttributeSet atCom;
    private static SimpleAttributeSet atHist;
    private static SimpleAttributeSet atYellow;
    private static SimpleAttributeSet atWhite;
    private static SimpleAttributeSet atErr;
    private boolean first = true;
    boolean isEdited = false;
    private String originalHeader = null;

    static void createChaine(Chaine chaine) {
        SAVE = chaine.getString("HSAVE");
        CANCEL = chaine.getString("HUNDO");
        CLOSE = chaine.getString("CLOSE");
        CLEAR = chaine.getString("CLEAR");
        SAVEINFO = chaine.getString("HSAVEINFO");
    }

    public FrameHeaderFits() {
        this.headerFits = new HeaderFits();
    }

    public FrameHeaderFits(HeaderFits headerFits) {
        this.headerFits = headerFits;
        this.makeTA(false);
    }

    protected FrameHeaderFits(Plan plan, MyInputStream myInputStream) throws Exception {
        super("FITS header");
        this.plan = plan;
        Aladin.setIcon(this);
        this.makeTA(true);
        this.headerFits = new HeaderFits();
        this.headerFits.readHeader(myInputStream, this);
    }

    protected FrameHeaderFits(Plan plan, String string) {
        this(plan, string, false);
    }

    protected FrameHeaderFits(Plan plan, String string, boolean bl) {
        Aladin.setIcon(this);
        this.plan = plan;
        this.makeTA(true);
        this.headerFits = new HeaderFits();
        this.headerFits.readFreeHeader(string, bl, this);
    }

    protected void free() {
        this.dispose();
    }

    protected HeaderFits getHeaderFits() {
        return this.headerFits;
    }

    private void search(String string) {
        int n;
        int n2;
        if (string.length() == 0) {
            this.first = true;
        }
        if (atKey == null) {
            atKey = new SimpleAttributeSet();
            atKey.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.blue);
            atKey.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atValue = new SimpleAttributeSet();
            atValue.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
            atValue.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atComment = new SimpleAttributeSet();
            atComment.addAttribute(StyleConstants.CharacterConstants.Foreground, Aladin.DARKBLUE);
            atComment.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atCom = new SimpleAttributeSet();
            atCom.addAttribute(StyleConstants.CharacterConstants.Foreground, Aladin.GREEN);
            atCom.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atErr = new SimpleAttributeSet();
            atErr.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.red);
            atErr.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atHist = new SimpleAttributeSet();
            atHist.addAttribute(StyleConstants.CharacterConstants.Foreground, new Color(127, 0, 85));
            atHist.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atWhite = new SimpleAttributeSet();
            atWhite.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atYellow = new SimpleAttributeSet();
            atYellow.addAttribute(StyleConstants.CharacterConstants.Background, Color.yellow);
        }
        String string2 = this.ta.getText();
        if (this.first && string2.length() < 131072) {
            this.first = false;
            n2 = 0;
            while ((n = string2.indexOf("\n", n2)) >= 0) {
                String string3 = "";
                if (n2 + 7 < string2.length()) {
                    string3 = string2.substring(n2, n2 + 8).trim();
                }
                if (string3.equals("HISTORY") || string3.equals("CONTINUE")) {
                    this.df.setCharacterAttributes(n2, n, atHist, true);
                } else if (string3.startsWith("/") || string3.equals("COMMENT") || string3.startsWith("#")) {
                    this.df.setCharacterAttributes(n2, n, atComment, true);
                } else {
                    int n3;
                    int n4;
                    boolean bl;
                    boolean bl2 = bl = this instanceof FrameHeaderPDS || this instanceof FrameHipsProperties;
                    if (bl) {
                        n4 = string2.indexOf(61, n2);
                        if (n4 > n2 && (n == -1 || n4 <= n)) {
                            this.df.setCharacterAttributes(n2, n4, atKey, true);
                            this.df.setCharacterAttributes(n4 + 1, n, atValue, true);
                        }
                    } else if (string3.equals("HIERARCH")) {
                        n4 = string2.indexOf(61, n2);
                        if (n4 > 0) {
                            this.df.setCharacterAttributes(n2, n2 + 8, atHist, true);
                            this.df.setCharacterAttributes(n2 + 8, n4, atKey, true);
                            this.df.setCharacterAttributes(n4 + 1, n, atValue, true);
                            n3 = string2.indexOf(47, n4);
                            if (n3 >= 0) {
                                this.df.setCharacterAttributes(n3, n, atCom, true);
                            }
                        }
                    } else {
                        int n5 = n4 = string2.indexOf(61, n2) != n2 + 8 ? 1 : 0;
                        if (n4 != 0) {
                            this.df.setCharacterAttributes(n2, n, atErr, true);
                        } else {
                            this.df.setCharacterAttributes(n2, n2 + 8, atKey, true);
                            this.df.setCharacterAttributes(n2 + 9, n, atValue, true);
                            n3 = string2.indexOf(47, n2 + 30);
                            if (n3 >= 0) {
                                this.df.setCharacterAttributes(n3, n, atCom, true);
                            }
                        }
                    }
                }
                n2 = n + 1;
            }
        } else {
            this.df.setCharacterAttributes(0, string2.length() - 1, atWhite, false);
        }
        if (string.length() == 0) {
            this.clear.setEnabled(false);
            return;
        }
        this.clear.setEnabled(true);
        n = -1;
        while ((n = string2.indexOf(string, n + 1)) >= 0) {
            this.df.setCharacterAttributes(n, string.length(), atYellow, false);
        }
        n = -1;
        n2 = -1;
        while ((n = string2.indexOf(string, n + 1)) >= 0) {
            this.df.setCharacterAttributes(n, string.length(), atYellow, false);
            if (n2 != -1) continue;
            n2 = n;
        }
        if (n2 != -1) {
            this.ta.setCaretPosition(n2);
        }
    }

    protected void save() {
        String string = this.ta.getText();
        try {
            this.applyThisHeader(string);
        }
        catch (Exception exception) {
            Aladin.warning(this, "Not a valid FITS header: " + exception.getMessage());
            return;
        }
        if (!Aladin.confirmation(this, SAVEINFO)) {
            return;
        }
        this.plan.aladin.save(this.plan.aladin.EXPORT);
    }

    private void applyThisHeader(String string) throws Exception {
        this.setOriginalHeaderFits(null);
        this.headerFits = new HeaderFits(string, this);
        if (this.plan != null) {
            Calib calib = new Calib(this.headerFits);
            this.plan.projd = new Projection(2, calib);
            this.plan.setHasSpecificCalib();
            this.plan.aladin.view.newView(1);
            this.plan.aladin.view.repaintAll();
        }
        this.ta.setText(this.getOriginalHeaderFits());
        this.search("");
    }

    protected String getOriginalHeaderFits() {
        return this.headerFits.getOriginalHeaderFits();
    }

    protected void setOriginalHeaderFits(String string) {
        this.headerFits.setOriginalHeaderFits(string);
    }

    public void appendMHF(String string) {
        this.headerFits.appendMHF(string);
    }

    protected void cancel() {
        try {
            this.applyThisHeader(this.originalHeader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateWidgets() {
        if (this.originalHeader == null) {
            return;
        }
        this.isEdited = true;
        if (this.cancel != null) {
            this.cancel.setEnabled(!this.originalHeader.equals(this.ta.getText()));
        }
        if (this.save != null) {
            this.save.setEnabled(!this.originalHeader.equals(this.ta.getText()));
        }
    }

    public void makeTA(boolean bl) {
        JButton jButton;
        this.df = new DefaultStyledDocument();
        this.ta = new JTextPane(this.df);
        this.ta.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FrameHeaderFits.this.updateWidgets();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FrameHeaderFits.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FrameHeaderFits.this.updateWidgets();
            }
        });
        this.ta.setFont(Aladin.COURIER);
        this.ta.setEditable(bl);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setPreferredSize(new Dimension(600, 600));
        JPanel jPanel = new JPanel();
        this.ts = new JTextField(10);
        this.ts.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                FrameHeaderFits.this.search(string);
            }
        });
        try {
            jPanel.add(Aladin.createLabel(Aladin.chaine.getString("MFSEARCHL")));
        }
        catch (Exception exception) {
            jPanel.add(Aladin.createLabel("Search"));
        }
        jPanel.add(this.ts);
        this.clear = jButton = new JButton(CLEAR);
        jButton.setEnabled(false);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameHeaderFits.this.ts.setText("");
                FrameHeaderFits.this.search("");
            }
        });
        jPanel.add(new JLabel(" - "));
        this.save = jButton = new JButton(SAVE);
        jButton.setEnabled(false);
        if (bl) {
            jPanel.add(jButton);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameHeaderFits.this.save();
            }
        });
        this.cancel = jButton = new JButton(CANCEL);
        jButton.setEnabled(false);
        if (bl) {
            jPanel.add(jButton);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameHeaderFits.this.cancel();
            }
        });
        jButton = new JButton(CLOSE);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameHeaderFits.this.setVisible(false);
            }
        });
        Aladin.makeAdd(this, jScrollPane, "Center");
        Aladin.makeAdd(this, jPanel, "South");
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, null);
        this.setLocation(Aladin.computeLocation(this));
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
        }
        super.processWindowEvent(windowEvent);
    }

    protected void seeHeaderFits() {
        this.ta.setText(this.getOriginalHeaderFits());
        this.originalHeader = this.ta.getText();
        this.isEdited = false;
        this.ta.setCaretPosition(0);
        this.ts.requestFocusInWindow();
        this.first = true;
        this.search("");
        this.pack();
        this.setVisible(true);
    }

    protected int getSizeHeader() {
        return this.headerFits.getSizeHeader();
    }

    protected boolean hasKey(String string) {
        return this.headerFits.hasKey(string);
    }

    protected int getIntFromHeader(String string) throws NumberFormatException, NullPointerException {
        return this.headerFits.getIntFromHeader(string);
    }

    protected void setKeyword(String string, String string2) {
        this.headerFits.setKeyword(string, string2);
    }

    protected double getDoubleFromHeader(String string) throws NumberFormatException, NullPointerException {
        return this.headerFits.getDoubleFromHeader(string);
    }

    protected String getStringFromHeader(String string) throws NullPointerException {
        return this.headerFits.getStringFromHeader(string);
    }

    protected void setToHeader(String string, String string2) {
        this.headerFits.setToHeader(string, string2);
    }

    protected void setKeyValue(String string, String string2) {
        this.headerFits.setKeyValue(string, string2);
    }

    protected void writeHeader(OutputStream outputStream) throws Exception {
        this.headerFits.writeHeader(outputStream);
    }

    static {
        atKey = null;
    }
}

