/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanHealpix;
import cds.tools.Util;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameHealpixArithmetic
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String ADD;
    String SUB;
    String MUL;
    String DIV;
    String PLANE;
    String PLANEVALUE;
    private ButtonGroup cbg;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("HARITHTITLE");
        this.INFO = Aladin.chaine.getString("HARITHINFO");
        this.HELP1 = Aladin.chaine.getString("HARITHHELP");
        this.ADD = Aladin.chaine.getString("ARITHADD");
        this.SUB = Aladin.chaine.getString("ARITHSUB");
        this.MUL = Aladin.chaine.getString("ARITHMUL");
        this.DIV = Aladin.chaine.getString("ARITHDIV");
        this.PLANE = Aladin.chaine.getString("ARITHPLANE");
        this.PLANEVALUE = Aladin.chaine.getString("ARITHPLANEVALUE");
    }

    protected FrameHealpixArithmetic(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 2;
    }

    @Override
    protected String getLabelSelector(int n) {
        return n == 0 ? this.PLANE : this.PLANEVALUE;
    }

    protected PlanHealpix[] getPlan() {
        Vector<Plan> vector = this.a.calque.getPlans(PlanHealpix.class);
        if (vector == null) {
            return new PlanHealpix[0];
        }
        Object[] objectArray = new PlanHealpix[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected Color getColorLabel(int n) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.cbg = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        JRadioButton jRadioButton = new JRadioButton(this.ADD);
        jRadioButton.setActionCommand(this.ADD);
        this.cbg.add(jRadioButton);
        jPanel2.add(jRadioButton);
        jRadioButton.setSelected(true);
        jRadioButton = new JRadioButton(this.SUB);
        jRadioButton.setActionCommand(this.SUB);
        this.cbg.add(jRadioButton);
        jPanel2.add(jRadioButton);
        jRadioButton = new JRadioButton(this.MUL);
        jRadioButton.setActionCommand(this.MUL);
        this.cbg.add(jRadioButton);
        jPanel2.add(jRadioButton);
        jRadioButton = new JRadioButton(this.DIV);
        jRadioButton.setActionCommand(this.DIV);
        this.cbg.add(jRadioButton);
        jPanel2.add(jRadioButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private int getOperation(String string) {
        if (string.equals(this.ADD)) {
            return 0;
        }
        if (string.equals(this.SUB)) {
            return 1;
        }
        if (string.equals(this.MUL)) {
            return 2;
        }
        return 3;
    }

    @Override
    protected void submit() {
        try {
            PlanHealpix planHealpix = (PlanHealpix)this.getPlan(this.ch[0]);
            PlanHealpix planHealpix2 = (PlanHealpix)this.getPlan(this.ch[1]);
            while (planHealpix != null && !planHealpix.isSync() || planHealpix2 != null && !planHealpix2.isSync()) {
                Util.pause(500);
            }
            double d = 0.0;
            if (planHealpix2 == null) {
                d = Double.parseDouble(((String)this.ch[1].getSelectedItem()).trim());
            }
            String string = this.cbg.getSelection().getActionCommand();
            int n = this.getOperation(string);
            this.a.calque.newPlanHealpixAlgo(string.substring(0, 3), planHealpix, planHealpix2, n, d);
            this.hide();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("Healpix arithmetic operation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
        this.ch[1].setEditable(true);
    }
}

