/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Chaine;
import cds.aladin.MetaDataTree;
import cds.aladin.MyLink;
import cds.aladin.MyListener;
import cds.aladin.ResourceNode;
import cds.aladin.ServerAladin;
import cds.aladin.ServerDialog;
import cds.aladin.Slider;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class FrameInfo
extends JFrame
implements WindowListener,
MyListener,
ActionListener {
    static final int SCROLL_MAX_WIDTH = 300;
    static final int SCROLL_MAX_HEIGHT = 240;
    static String FOV_STACK;
    static String TITLE;
    static String SLICE;
    static String SUBIMG;
    static String CUTTARGET;
    static String SLICE1;
    static String SLICE2;
    static String GETIN;
    static String MODE;
    static String TARGET;
    static String GRAB;
    static String FILTERCHAR;
    static String STICK;
    static String CLOSE;
    static String LOAD;
    static String LOADIN;
    static String DOWNLOAD;
    static String DISPLAY;
    static String VALUE;
    static String FIELD;
    static String DISTTOCENTER;
    private static final Insets BUTTON_INSETS;
    private static Dimension screenSize;
    private JButton loadBtn;
    private JButton loadInBtn;
    private JButton fovBtn;
    private JButton grabBtn;
    private JButton mosaicGrabBtn;
    private boolean grabMode = false;
    private boolean mosaicGrabMode = false;
    private boolean imagePosGrabMode = false;
    private JTextField xPosTF;
    private JTextField yPosTF;
    private JButton imagePosGrabBtn;
    private Slider sliderVel;
    private JPanel btnPanel;
    private JPanel infoPanel;
    private JPanel cutoutPanel;
    private JPanel formatPanel;
    private JPanel modePanel;
    private JPanel subImgPanel;
    private JPanel imagePosGrabPanel;
    private JPanel sub;
    JTextField target;
    JTextField size;
    JTextField mosaicTarget;
    JTextField subImg;
    JMenuBar menuBar;
    private JTable infoTable;
    private static boolean[] visibleCol;
    private static int nbVisibleColumn;
    private static Vector<String> colNames;
    private ButtonGroup fmt;
    private ButtonGroup mode;
    private JPanel bottomPanel;
    private JButton lockBtn;
    private JButton closeBtn;
    private Aladin aladin;
    private ResourceNode node;
    private MetaDataTree tree;
    private boolean firstUpdate = true;
    @Deprecated
    private String memorySlice;
    private JPopupMenu plasticPopup;

    protected static void createChaine(Chaine chaine) {
        if (TITLE != null) {
            return;
        }
        FOV_STACK = chaine.getString("FIFOSTACK");
        TITLE = chaine.getString("FITITLE");
        SLICE = chaine.getString("FISLICE");
        SUBIMG = chaine.getString("FISUBIMG");
        CUTTARGET = chaine.getString("FICUTTARGET");
        SLICE1 = chaine.getString("FISLICE1");
        SLICE2 = chaine.getString("FISLICE2");
        GETIN = chaine.getString("FIGETIN");
        MODE = chaine.getString("FIMODE");
        TARGET = chaine.getString("FITARGET");
        GRAB = chaine.getString("FIGRAB");
        FILTERCHAR = chaine.getString("FIFILTERCHAR");
        STICK = chaine.getString("FISTICK");
        CLOSE = chaine.getString("CLOSE");
        LOAD = chaine.getString("FILOAD");
        LOADIN = chaine.getString("FILOADIN");
        DOWNLOAD = chaine.getString("FIDOWNLOAD");
        DISPLAY = chaine.getString("FIDISPLAY");
        VALUE = chaine.getString("FIVALUE");
        FIELD = chaine.getString("FIFIELD");
        DISTTOCENTER = chaine.getString("FIDISTTOCENTER");
    }

    protected FrameInfo(Aladin aladin) {
        Aladin.setIcon(this);
        this.setTitle(TITLE);
        this.aladin = aladin;
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.createComponents();
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.infoPanel = new JPanel();
        this.getContentPane().add((Component)this.infoPanel, "Center");
        this.bottomPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        this.bottomPanel.setLayout(gridBagLayout);
        this.imagePosGrabPanel = new JPanel();
        this.imagePosGrabPanel.setLayout(new GridLayout(0, 1));
        this.imagePosGrabPanel.add(this.createLabel("Warning : position must be grabbed in the correct image !"));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createLabel("X pos.:"));
        this.xPosTF = new JTextField(3);
        jPanel.add(this.xPosTF);
        this.xPosTF.setFont(Aladin.PLAIN);
        jPanel.add(this.createLabel("Y pos.:"));
        this.yPosTF = new JTextField(3);
        jPanel.add(this.yPosTF);
        this.yPosTF.setFont(Aladin.PLAIN);
        this.imagePosGrabBtn = this.createButton("Grab image pos.");
        jPanel.add(this.imagePosGrabBtn);
        this.imagePosGrabPanel.add(jPanel);
        this.subImgPanel = new JPanel();
        this.subImgPanel.setLayout(new GridLayout(0, 1));
        this.subImgPanel.add(this.createLabel(SLICE));
        this.sliderVel = new Slider();
        this.subImgPanel.add(this.sliderVel);
        this.sub = new JPanel();
        this.sub.setLayout(new FlowLayout());
        this.sub.add(this.createLabel(SUBIMG));
        this.subImg = new JTextField(3);
        this.subImg.setFont(Aladin.PLAIN);
        this.sub.add(this.subImg);
        this.subImgPanel.add(this.sub);
        this.cutoutPanel = new JPanel();
        this.cutoutPanel.setLayout(new FlowLayout(1, 4, 5));
        this.cutoutPanel.add(this.createLabel(CUTTARGET));
        this.target = new JTextField(15);
        this.target.setFont(Aladin.PLAIN);
        this.target.setEditable(false);
        this.cutoutPanel.add(this.target);
        this.cutoutPanel.add(this.grabBtn);
        gridBagLayout.setConstraints(this.cutoutPanel, gridBagConstraints);
        this.bottomPanel.add(this.cutoutPanel);
        gridBagLayout.setConstraints(this.formatPanel, gridBagConstraints);
        this.bottomPanel.add(this.formatPanel);
        gridBagLayout.setConstraints(this.modePanel, gridBagConstraints);
        this.bottomPanel.add(this.modePanel);
        gridBagLayout.setConstraints(this.imagePosGrabPanel, gridBagConstraints);
        this.bottomPanel.add(this.imagePosGrabPanel);
        gridBagLayout.setConstraints(this.subImgPanel, gridBagConstraints);
        this.bottomPanel.add(this.subImgPanel);
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout());
        gridBagLayout.setConstraints(this.btnPanel, gridBagConstraints);
        this.bottomPanel.add(this.btnPanel);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.addWindowListener(this);
    }

    private Point computeAbsLoc() {
        if (screenSize == null) {
            screenSize = Aladin.SCREENSIZE;
        }
        return Aladin.computeLocation(this);
    }

    public void initTarget() {
        if (this.node == null) {
            return;
        }
        if (this.node.isLeaf && (this.node.cutout || this.node.type == 2)) {
            String string;
            if (this.node.getCutoutTarget() == null && this.node.server != null) {
                this.node.setCutoutTarget(this.node.server.getTarget(false), false);
            }
            if ((string = this.node.getCutoutTarget()) != null) {
                this.target.setText(this.aladin.localisation.getFrameCoord(string));
            }
        }
    }

    public void update(ResourceNode resourceNode, MetaDataTree metaDataTree) {
        String[] stringArray;
        this.grabMode = false;
        this.imagePosGrabMode = false;
        this.node = resourceNode;
        this.tree = metaDataTree;
        this.memorySlice = resourceNode.curImgNumber;
        if (this.firstUpdate) {
            this.firstUpdate = false;
            stringArray = this.computeAbsLoc();
            this.setLocation(stringArray.x, stringArray.y);
        }
        this.infoPanel.removeAll();
        this.infoPanel.setLayout(new BorderLayout());
        this.initTarget();
        this.btnPanel.removeAll();
        this.btnPanel.add(this.lockBtn);
        if (resourceNode.type == 1 || resourceNode.type == 3) {
            this.btnPanel.add(this.fovBtn);
        }
        if (resourceNode.isLeaf || resourceNode.hasData) {
            boolean bl = this.aladin.getMessagingMgr().isRegistered();
            ArrayList<String> arrayList = null;
            if (bl) {
                AppMessagingInterface appMessagingInterface = this.aladin.getMessagingMgr();
                arrayList = appMessagingInterface.getAppsSupporting(resourceNode.getPlasticMsg());
            }
            if (resourceNode.type != 3 || resourceNode.type == 3 && resourceNode.location != null || resourceNode.location != null && resourceNode.location.indexOf("Xpix") >= 0) {
                this.btnPanel.add(this.loadBtn);
                if (bl && arrayList != null && arrayList.size() > 0) {
                    this.btnPanel.add(this.loadInBtn);
                    this.loadInBtn.setEnabled(true);
                    this.fillPlasticPopupMenu(arrayList);
                }
            } else {
                this.btnPanel.add(this.loadInBtn);
                this.loadInBtn.setEnabled(arrayList != null && arrayList.size() > 0);
                this.fillPlasticPopupMenu(arrayList);
            }
        }
        this.btnPanel.add(this.closeBtn);
        if (resourceNode.type == 3 && resourceNode.location != null || resourceNode.indexing != null && resourceNode.indexing.equals("HTML")) {
            this.loadBtn.setText(DOWNLOAD);
        } else {
            this.loadBtn.setText(LOAD);
        }
        if (resourceNode.isLeaf && resourceNode.cutout) {
            this.cutoutPanel.setVisible(true);
        } else {
            this.cutoutPanel.setVisible(false);
        }
        if (resourceNode.dataOrga != null && resourceNode.dataOrga.equals("SPECTRUM") && resourceNode.location != null && resourceNode.location.indexOf("Xpix") >= 0) {
            this.imagePosGrabPanel.setVisible(true);
            stringArray = resourceNode.getImagePosTarget();
            this.xPosTF.setText(stringArray[0]);
            this.yPosTF.setText(stringArray[1]);
        } else {
            this.imagePosGrabPanel.setVisible(false);
        }
        if (!resourceNode.maxImgNumber.equals("1") && resourceNode.dataOrga != null && resourceNode.dataOrga.equals("SLICES")) {
            this.subImgPanel.setVisible(true);
            int n = Integer.parseInt(resourceNode.maxImgNumber) - 1;
            int n2 = Integer.parseInt(resourceNode.curImgNumber) - 1;
            this.sliderVel.setListener(this);
            this.sliderVel.setPosition(n2);
            this.sliderVel.setParams(resourceNode.beginVel, n, resourceNode.velStep);
            this.sliderVel.repaint();
            if (resourceNode.velStep == 0.0) {
                this.sliderVel.setVisible(false);
                this.subImgPanel.remove(0);
                this.subImgPanel.add((Component)this.createLabel(""), 0);
            } else {
                this.sliderVel.setVisible(true);
                this.subImgPanel.remove(0);
                this.subImgPanel.add((Component)this.createLabel(SLICE), 0);
            }
        } else {
            this.subImgPanel.setVisible(false);
        }
        this.subImg.setText(this.node.curImgNumber);
        this.sub.remove(0);
        if (resourceNode.velStep == 0.0) {
            this.sub.add((Component)this.createLabel(SLICE1 + " " + resourceNode.maxImgNumber + "):"), 0);
        } else {
            this.sub.add((Component)this.createLabel(SLICE2 + " " + resourceNode.maxImgNumber + "):"), 0);
        }
        if (resourceNode.isLeaf && resourceNode.formats != null && resourceNode.formats.length > 1) {
            this.formatPanel.removeAll();
            this.fmt = new ButtonGroup();
            this.formatPanel.add(this.createLabel(GETIN));
            for (int i = 0; i < resourceNode.formats.length; ++i) {
                if (resourceNode.formats[i].equals("MRCOMP")) continue;
                boolean bl = resourceNode.formats[i].equals(resourceNode.curFormat);
                JRadioButton jRadioButton = new JRadioButton(resourceNode.formats[i], bl);
                this.formatPanel.add(jRadioButton);
                jRadioButton.setFont(Aladin.PLAIN);
                jRadioButton.addActionListener(this);
                this.fmt.add(jRadioButton);
            }
            this.formatPanel.setVisible(true);
        } else {
            this.formatPanel.setVisible(false);
        }
        if (resourceNode.isLeaf && resourceNode.modes != null && resourceNode.modes.length > 1) {
            String string;
            this.modePanel.removeAll();
            this.mode = new ButtonGroup();
            this.modePanel.add(this.createLabel(MODE));
            for (int i = 0; i < resourceNode.modes.length; ++i) {
                boolean bl = resourceNode.modes[i].equals(resourceNode.curMode);
                JRadioButton jRadioButton = new JRadioButton(resourceNode.modes[i], bl);
                this.modePanel.add(jRadioButton);
                jRadioButton.setFont(Aladin.PLAIN);
                jRadioButton.addActionListener(this);
                this.mode.add(jRadioButton);
            }
            this.modePanel.add(this.createLabel(TARGET));
            this.mosaicTarget = new JTextField(15);
            this.mosaicTarget.setFont(Aladin.PLAIN);
            this.mosaicTarget.setEditable(false);
            if (resourceNode.getMosaicTarget() == null && resourceNode.server != null) {
                resourceNode.setMosaicTarget(resourceNode.server.getTarget(false), false);
            }
            if ((string = resourceNode.getMosaicTarget()) != null) {
                this.mosaicTarget.setText(this.aladin.localisation.getFrameCoord(string));
            }
            this.modePanel.add(this.mosaicTarget);
            this.mosaicGrabBtn = this.createButton(GRAB);
            this.mosaicGrabBtn.setFont(Aladin.SBOLD);
            this.modePanel.add(this.mosaicGrabBtn);
            this.modePanel.setVisible(true);
        } else {
            this.modePanel.setVisible(false);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (resourceNode.type == 1 || resourceNode.type == 3 || resourceNode.type == 4 || resourceNode.type == 6 || resourceNode.type == 2) {
            if (!(resourceNode.type != 1 && resourceNode.type != 3 || Double.isNaN(resourceNode.getDistanceToCenter()))) {
                arrayList.add(DISTTOCENTER);
                arrayList2.add(this.formatDistance(resourceNode.getDistanceToCenter()));
                arrayList3.add("");
                arrayList4.add("");
                this.addEmptyRow(arrayList, arrayList2, arrayList3, arrayList4);
            }
            if (resourceNode.criteria != null && resourceNode.valueCriteria != null) {
                arrayList.add(resourceNode.criteria);
                arrayList2.add(resourceNode.valueCriteria);
                arrayList3.add("");
                arrayList4.add("");
            }
            this.displayInfo(resourceNode, arrayList, arrayList3, arrayList4, arrayList2);
            if (resourceNode.desc != null && resourceNode.desc.length() > 0) {
                arrayList.add(MetaDataTree.replace(resourceNode.desc, "\\n", "\n", -1));
                arrayList2.add("");
                arrayList3.add("");
                arrayList4.add("");
            }
            if (resourceNode.filterDesc != null && resourceNode.filterExpla != null) {
                arrayList.add("");
                arrayList2.add("");
                arrayList3.add("");
                arrayList4.add("");
                arrayList.add(FILTERCHAR);
                arrayList2.add("");
                arrayList3.add("");
                arrayList4.add("");
                for (int i = 0; i < resourceNode.filterDesc.length; ++i) {
                    if (resourceNode.filterExpla[i].length() == 0) continue;
                    arrayList.add(resourceNode.filterDesc[i]);
                    arrayList2.add(resourceNode.filterExpla[i]);
                    arrayList3.add("");
                    arrayList4.add("");
                }
            }
        }
        FrameInfoTableModel frameInfoTableModel = new FrameInfoTableModel();
        frameInfoTableModel.setData(arrayList.toArray(new Object[arrayList.size()]), arrayList3.toArray(new Object[arrayList3.size()]), arrayList4.toArray(new Object[arrayList4.size()]), arrayList2.toArray(new Object[arrayList2.size()]));
        this.infoTable = new TwoColorJTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.infoTable.setGridColor(Color.lightGray);
        this.infoTable.setShowHorizontalLines(false);
        this.infoTable.setModel(frameInfoTableModel);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.infoTable, 20, 30);
        this.infoPanel.add((Component)jScrollPane, "Center");
        int n = this.infoTable.getRowHeight() * this.infoTable.getRowCount();
        int n3 = n > 240 ? 240 : n;
        this.infoTable.setPreferredScrollableViewportSize(new Dimension(300, n3));
        this.infoTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n == 0 && n2 == 0 && object.equals(DISTTOCENTER)) {
                    component.setFont(Aladin.BOLD);
                } else if (n2 == 0) {
                    component.setFont(Aladin.ITALIC);
                }
                return component;
            }
        });
        this.infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, resourceNode.name, 2, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        this.infoPanel.invalidate();
        this.infoPanel.validate();
        this.infoPanel.setSize(0, 0);
        this.pack();
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        int n4 = point.x;
        int n5 = point.y;
        boolean bl = false;
        int n6 = FrameInfo.screenSize.width - (point.x + dimension.width);
        int n7 = FrameInfo.screenSize.height - (point.y + dimension.height);
        if (n6 < 0) {
            bl = true;
            n4 += n6;
        }
        if (n7 < 25) {
            bl = true;
            n5 = n7 < 0 ? (n5 += n7 - 25) : (n5 += -(25 - n7));
        }
        if (bl) {
            this.setLocation(n4, n5);
        }
    }

    private void addEmptyRow(ArrayList<Object> arrayList, ArrayList<Object> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4) {
        arrayList.add("");
        arrayList2.add("");
        arrayList3.add("");
        arrayList4.add("");
    }

    private void displayInfo(ResourceNode resourceNode, ArrayList<Object> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, ArrayList<Object> arrayList4) {
        if (resourceNode.description == null || resourceNode.explanation == null) {
            return;
        }
        for (int i = 0; i < resourceNode.description.length; ++i) {
            Object object;
            if (resourceNode.explanation[i].length() == 0) continue;
            String string = resourceNode.description[i];
            if (resourceNode.links != null && resourceNode.links.get(resourceNode.description[i]) != null) {
                MyLink myLink = new MyLink(this.aladin, resourceNode.explanation[i]);
                myLink.setFont(Aladin.SBOLD);
                myLink.baratin = resourceNode.description[i];
                object = myLink;
            } else {
                object = resourceNode.explanation[i];
            }
            arrayList.add(string);
            arrayList4.add(object);
            arrayList2.add(resourceNode.ucds == null ? "" : resourceNode.ucds[i]);
            arrayList3.add(resourceNode.utypes == null ? "" : resourceNode.utypes[i]);
        }
    }

    @Override
    public boolean keyUp(Event event, int n) {
        if (event.target.equals(this.subImg) && (n < 48 || n > 57) && n < 127 && n > 31) {
            int n2 = this.subImg.getCaretPosition();
            this.subImg.setText(this.memorySlice);
            this.subImg.setCaretPosition(n2 == 0 ? 0 : n2 - 1);
        }
        this.memorySlice = this.node.curImgNumber = this.subImg.getText();
        try {
            if (this.sliderVel != null) {
                this.sliderVel.setPosition(Integer.parseInt(this.memorySlice) - 1, false);
                this.sliderVel.repaint();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return super.keyUp(event, n);
    }

    private void createComponents() {
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu(DISPLAY);
        this.menuBar.add(jMenu);
        colNames = new Vector<String>(Arrays.asList(FIELD, "UCD", "UType", VALUE));
        Enumeration<String> enumeration = colNames.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, visibleCol[n]);
            jMenu.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.addActionListener(this);
            ++n;
        }
        this.setJMenuBar(this.menuBar);
        this.formatPanel = new JPanel();
        this.formatPanel.setLayout(new FlowLayout(0));
        this.formatPanel.setFont(Aladin.PLAIN);
        this.modePanel = new JPanel();
        this.modePanel.setLayout(new FlowLayout(0));
        this.modePanel.setFont(Aladin.PLAIN);
        this.grabBtn = this.createButton(GRAB);
        this.grabBtn.setFont(Aladin.SBOLD);
        this.fovBtn = this.createButton(FOV_STACK);
        this.fovBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (((FrameInfo)FrameInfo.this).node.type == 1 || ((FrameInfo)FrameInfo.this).node.type == 3) {
                    FrameInfo.this.tree.showFov(FrameInfo.this.node);
                    if (((FrameInfo)FrameInfo.this).node.cutout) {
                        FrameInfo.this.tree.showCutoutFov(FrameInfo.this.node);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FrameInfo.this.tree.hideFov();
                FrameInfo.this.tree.deactivateCutoutFov();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.fovBtn.setFont(Aladin.PLAIN);
        this.lockBtn = this.createButton(STICK);
        this.lockBtn.setFont(Aladin.PLAIN);
        this.closeBtn = this.createButton(CLOSE);
        this.closeBtn.setFont(Aladin.PLAIN);
        this.loadBtn = this.createButton(LOAD);
        this.loadBtn.setFont(Aladin.BOLD);
        this.loadInBtn = this.createButton(LOADIN);
        this.loadInBtn.setIcon(new ImageIcon(this.aladin.getImagette("arrow.gif")));
        this.loadInBtn.setFont(Aladin.BOLD);
        this.loadInBtn.setHorizontalTextPosition(2);
        this.loadInBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FrameInfo.this.plasticPopup.show(FrameInfo.this.loadInBtn, mouseEvent.getX(), mouseEvent.getY() + 5);
            }
        });
    }

    boolean inGrabMode() {
        return this.grabMode;
    }

    boolean inMosaicGrabMode() {
        return this.mosaicGrabMode;
    }

    boolean inImagePosGrabMode() {
        return this.imagePosGrabMode;
    }

    ResourceNode getNode() {
        return this.node;
    }

    void setTarget(String string) {
        this.node.setCutoutTarget(string);
        this.toFront();
        this.grabMode = false;
    }

    void setTargetTF(String string) {
        this.target.setText(this.aladin.localisation.getFrameCoord(string));
    }

    void setMosaicTarget(String string) {
        this.node.setMosaicTarget(string);
        this.toFront();
        this.mosaicGrabMode = false;
    }

    void setMosaicTargetTF(String string) {
        this.mosaicTarget.setText(this.aladin.localisation.getFrameCoord(string));
    }

    void setImagePosTarget(String string, String string2) {
        this.node.setImagePosTarget(string, string2);
        this.toFront();
        this.imagePosGrabMode = false;
    }

    void setImagePosTargeTFt(String string, String string2) {
        this.xPosTF.setText(string);
        this.yPosTF.setText(string2);
    }

    private void fillPlasticPopupMenu(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return;
        }
        this.plasticPopup = new JPopupMenu();
        for (String string : arrayList) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand(LOADIN);
            this.plasticPopup.add(jMenuItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof JCheckBoxMenuItem) {
            this.toggleColumnVisibility(((JCheckBoxMenuItem)object).getText());
        } else if (object.equals(this.grabBtn)) {
            this.grabMode = true;
            this.aladin.getFrame(this.aladin).toFront();
        } else if (object.equals(this.mosaicGrabBtn)) {
            this.mosaicGrabMode = true;
            this.aladin.getFrame(this.aladin).toFront();
        } else if (object.equals(this.imagePosGrabBtn)) {
            this.imagePosGrabMode = true;
            this.aladin.getFrame(this.aladin).toFront();
        } else if (object.equals(this.closeBtn)) {
            this.setVisible(false);
        } else if (object.equals(this.lockBtn)) {
            this.lockBtn.setEnabled(false);
            this.aladin.frameInfo = new FrameInfo(this.aladin);
        } else if (object.equals(this.loadBtn)) {
            if (this.loadBtn.getText().equals(DOWNLOAD) && this.node.type == 3) {
                this.aladin.glu.showDocument("Http", this.node.location, true);
                return;
            }
            this.node.setCutoutTarget(this.aladin.localisation.getICRSCoord(this.target.getText()), false);
            if (this.imagePosGrabPanel.isVisible()) {
                this.node.setImagePosTarget(this.xPosTF.getText(), this.yPosTF.getText());
            }
            if (!this.node.maxImgNumber.equals("1")) {
                this.memorySlice = this.node.curImgNumber = this.subImg.getText();
            }
            this.tree.load(this.node, null, null, this);
        } else if (object.equals(this.fovBtn)) {
            String string2 = this.node.name;
            if (this.node.server != null && this.node.server instanceof ServerAladin && this.node.machine != null && this.node.machine.length() != 0) {
                string2 = this.node.machine + "." + string2;
            }
            this.aladin.calque.newPlanFov("FoV_" + string2, this.tree.getFovs(this.node, false, true));
            this.aladin.view.repaintAll();
            if (this.aladin.dialog.server[this.aladin.dialog.current].grab != null) {
                this.aladin.dialog.server[this.aladin.dialog.current].grab.setEnabled(true);
            }
        } else if (object instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (this.fmt != null && jRadioButton.equals(this.getSelectedJRadioButton(this.fmt))) {
                this.node.curFormat = jRadioButton.getText();
            } else if (this.mode != null && jRadioButton.equals(this.getSelectedJRadioButton(this.mode))) {
                this.node.curMode = jRadioButton.getText();
            }
        } else if (object instanceof JMenuItem && string.equals(LOADIN)) {
            this.aladin.dialog.server[ServerDialog.ALADIN].tree.loadNodeWithPlastic(this.node, ((JMenuItem)object).getText());
        }
    }

    private JRadioButton getSelectedJRadioButton(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton;
            try {
                jRadioButton = (JRadioButton)enumeration.nextElement();
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!jRadioButton.isSelected()) continue;
            return jRadioButton;
        }
        return null;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(BUTTON_INSETS);
        jButton.addActionListener(this);
        return jButton;
    }

    private String formatDistance(double d) {
        double d2 = d;
        String string = "deg";
        if (d2 < 1.0) {
            d2 = d * 60.0;
            string = "arcmin";
        }
        if (d2 < 1.0) {
            d2 = d * 3600.0;
            string = "arcsec";
        }
        return Util.myRound(d2 + "", 2) + " " + string;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(Aladin.PLAIN);
        return jLabel;
    }

    private void toggleColumnVisibility(String string) {
        boolean bl;
        int n = colNames.indexOf(string);
        if (n < 0) {
            return;
        }
        FrameInfo.visibleCol[n] = bl = !visibleCol[n];
        nbVisibleColumn = bl ? ++nbVisibleColumn : --nbVisibleColumn;
        ((AbstractTableModel)this.infoTable.getModel()).fireTableStructureChanged();
    }

    protected void load() {
        this.node.setCutoutTarget(this.aladin.localisation.getICRSCoord(this.target.getText()), false);
        this.tree.load(this.node, null, null, this);
    }

    @Override
    public void fireStateChange(String string) {
        if (this.node != null) {
            this.node.curImgNumber = string;
        }
        if (this.subImg != null) {
            this.subImg.setText(string);
        }
    }

    @Override
    public void fireStateChange(int n) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    static {
        BUTTON_INSETS = new Insets(1, 1, 1, 1);
        visibleCol = new boolean[]{true, false, false, true};
        nbVisibleColumn = 2;
    }

    class FrameInfoTableModel
    extends AbstractTableModel {
        Object[] names;
        Object[] values;
        Object[] ucds;
        Object[] utypes;

        FrameInfoTableModel() {
        }

        public void setData(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4) {
            this.names = objectArray;
            this.ucds = objectArray2;
            this.utypes = objectArray3;
            this.values = objectArray4;
        }

        @Override
        public int getRowCount() {
            return this.names == null ? -1 : this.names.length;
        }

        @Override
        public int getColumnCount() {
            return nbVisibleColumn;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == -1 || n == -1) {
                return null;
            }
            n2 = this.getRealColIdx(n2);
            switch (n2) {
                case 0: {
                    return this.names[n];
                }
                case 1: {
                    return this.ucds[n];
                }
                case 2: {
                    return this.utypes[n];
                }
                case 3: {
                    return this.values[n];
                }
            }
            return null;
        }

        private int getRealColIdx(int n) {
            int n2 = 0;
            for (int i = 0; i < visibleCol.length; ++i) {
                if (!visibleCol[i]) continue;
                if (n2 == n) {
                    return i;
                }
                ++n2;
            }
            return -1;
        }

        @Override
        public String getColumnName(int n) {
            int n2 = 0;
            for (int i = 0; i < visibleCol.length; ++i) {
                if (!visibleCol[i]) continue;
                if (n2 == n) {
                    return (String)colNames.get(i);
                }
                ++n2;
            }
            return null;
        }
    }
}

