/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Server;
import cds.aladin.ServerGlu;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FrameInfoServer
extends JFrame
implements ActionListener {
    static String TITLE;
    static String CLOSE;
    static String INFO;
    static String TYPE;
    static String DESC;
    static String MORE;
    static String ORIGIN;
    static String LASTQUERY;
    static String STATUS;
    static String ERRORMSG;
    static String IDENTIFIER;
    private JTextArea ta;
    private JLabel nom;
    private JButton btInfo;
    private Aladin aladin;
    private Server server;

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("ISTITLE");
        CLOSE = Aladin.chaine.getString("CLOSE");
        INFO = Aladin.chaine.getString("ISINFO");
        TYPE = Aladin.chaine.getString("ISTYPE");
        DESC = Aladin.chaine.getString("ISDESC");
        MORE = Aladin.chaine.getString("ISMORE");
        IDENTIFIER = Aladin.chaine.getString("ISIDENTIFIER");
        ORIGIN = Aladin.chaine.getString("ISORIGIN");
        LASTQUERY = Aladin.chaine.getString("ISLASTQUERY");
        STATUS = Aladin.chaine.getString("ISSTATUS");
        ERRORMSG = Aladin.chaine.getString("ERROR");
    }

    protected FrameInfoServer(Aladin aladin) {
        JButton jButton;
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.createChaine();
        this.setTitle(TITLE);
        this.ta = new JTextArea(20, 85);
        this.ta.setFont(Aladin.COURIER);
        this.ta.setBackground(Color.white);
        this.ta.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.nom = new JLabel(TITLE);
        this.nom.setFont(Aladin.LLITALIC);
        this.nom.setForeground(Aladin.GREEN);
        jPanel.add(this.nom);
        JPanel jPanel2 = new JPanel();
        this.btInfo = jButton = new JButton(INFO);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(CLOSE);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.setLocation(Aladin.computeLocation(this));
    }

    private String A(String string) {
        return Util.align(string, 14) + ": ";
    }

    protected void show(Server server) {
        this.server = server;
        this.btInfo.setEnabled(this.server.docUser != null);
        this.nom.setText(server.aladinLabel.replace('\n', ' '));
        String string = null;
        if (server instanceof ServerGlu) {
            string = "GLU record:\n" + ((ServerGlu)server).record.toString();
        }
        this.ta.setText("\n" + (server.description != server.aladinLabel ? this.A(DESC) + Util.fold(server.description, 70) + "\n" : "") + (server.type != 8 && server.type != 16 ? this.A(TYPE) + server.getType() + "\n" : "") + (server.docUser != null && server.docUser != server.aladinLabel ? this.A(MORE) + server.docUser + "\n" : "") + (server.institute != null && server.institute != server.aladinLabel && server.institute != server.description ? this.A(ORIGIN) + server.institute + "\n" : "") + (server.type != 8 && server.type != 16 && server.statusUrl != null ? this.A(LASTQUERY) + server.statusUrl + "\n" : "") + (server.type == 8 || server.type == 16 ? "" : this.A(STATUS) + (server.statusAllVO != null ? server.statusAllVO.getText() + "\n" : "Not yet tested\n")) + (server.statusError != null ? this.A(ERRORMSG) + server.statusError + "\n" : "") + (server instanceof ServerGlu ? this.A(IDENTIFIER) + ((ServerGlu)server).actionName + "\n" : "") + (server.verboseDescr != null ? "\n" + Util.fold(server.verboseDescr) + "\n" : "") + (string != null ? "\n\n" + string : ""));
        this.ta.setCaretPosition(0);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CLOSE)) {
            this.setVisible(false);
        } else if (string.equals(INFO)) {
            this.aladin.glu.showDocument("Http", this.server.docUser, true);
        }
    }
}

