/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrameInfoTable
extends JFrame {
    private Aladin aladin;
    private Plan plan;

    protected FrameInfoTable(Aladin aladin, Plan plan) {
        JComponent jComponent;
        Serializable serializable;
        this.aladin = aladin;
        this.plan = plan;
        Aladin.setIcon(this);
        this.setTitle(plan.getLabel());
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        JPanel jPanel = (JPanel)this.getContentPane();
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        Vector<Legende> vector = plan.getLegende();
        boolean bl = plan.getNbTable() > 1;
        Enumeration<Legende> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            jComponent = new JPanel(new BorderLayout(5, 5));
            if (bl) {
                jComponent.setBorder(BorderFactory.createTitledBorder(((Legende)serializable).name));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            }
            jComponent.add((Component)((Legende)serializable).getTablePanel(aladin, plan), "Center");
            jPanel2.add(jComponent);
        }
        jPanel.add((Component)jScrollPane, "Center");
        serializable = new JPanel();
        if (plan.pcat != null && plan.pcat.hasCatalogInfo()) {
            jComponent = new JButton(Aladin.chaine.getString("CHECK"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameInfoTable.this.check(true);
                }
            });
            ((Container)serializable).add(jComponent);
            jComponent = new JButton(Aladin.chaine.getString("UNCHECK"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameInfoTable.this.check(false);
                }
            });
            ((Container)serializable).add(jComponent);
            ((Container)serializable).add(new JLabel(" - "));
            jComponent = new JButton(Aladin.chaine.getString("PARSING"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameInfoTable.this.seeCatalogInfo();
                }
            });
            ((Container)serializable).add(jComponent);
            jComponent = new JButton(Aladin.chaine.getString("COORDCOLUMN"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameInfoTable.this.seeCoordColumnInfo();
                }
            });
            ((Container)serializable).add(jComponent);
            ((Container)serializable).add(new JLabel(" - "));
        }
        jComponent = new JButton(Aladin.chaine.getString("CLOSE"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfoTable.this.dispose();
            }
        });
        ((Container)serializable).add(jComponent);
        jPanel.add((Component)serializable, "South");
        this.setLocation(Aladin.computeLocation(this));
        this.pack();
        this.setVisible(true);
    }

    private void seeCoordColumnInfo() {
        Aladin.info(this, Util.fold(Aladin.chaine.getString("COORDCOLUMNDETAIL"), 50));
    }

    private void seeCatalogInfo() {
        this.plan.pcat.seeCatalogInfo();
    }

    private void check(boolean bl) {
        Vector<Legende> vector = this.plan.getLegende();
        Enumeration<Legende> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Legende legende = enumeration.nextElement();
            for (Field field : legende.field) {
                field.visible = bl;
            }
            legende.fireTableDataChanged();
        }
        this.aladin.mesure.redisplay();
    }
}

