/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Command;
import cds.aladin.MacroController;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.ByteArrayInputStream;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FrameMacro
extends JFrame {
    protected static String SCRIPT;
    protected static String PARAMS;
    protected static String EXECUTE;
    protected static String LOAD_SCRIPT;
    protected static String SAVE_SCRIPT;
    protected static String LOAD_PARAMS;
    protected static String SAVE_PARAMS;
    protected static String IMPORT_PARAMS;
    protected static String ADD_COL;
    protected static String CLEAR_PARAMS;
    protected static String EXEC_ALL;
    protected static String EXEC_ALL_FROM_CURRENT;
    protected static String EXEC_CURRENT;
    protected static String EXEC_NEXT;
    protected static String FILE;
    protected static String HELP;
    protected static String LOADEX;
    protected static String SEEHELP;
    protected static String CLOSE;
    protected static String STOP;
    protected static String DELETE;
    private MacroController macroController;
    private JTextPane scriptTP;
    private JTable paramTable;
    private JPopupMenu popup;
    private JButton stopBtn;
    private Aladin a;
    int mousePosInScript = -1;
    Vector cmdWordsPos;
    private ScriptSyntaxRenderer scriptRenderer;
    private String cmdWordUnderMouse;
    private String ocmdWordUnderMouse;
    private int hlScriptRow = -1;
    private int ohlScriptRow = -1;
    HelpFrame helpFrame;

    protected FrameMacro(Aladin aladin) {
        this.a = aladin;
        this.setIconImage(aladin.getImagette("AladinIconSS.gif"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.macroController = new MacroController(this, aladin);
        this.createChaine();
        this.buildFrame();
    }

    private void createChaine() {
        SCRIPT = Aladin.chaine.getString("FMSCRIPT");
        PARAMS = Aladin.chaine.getString("FMPARAMS");
        EXECUTE = Aladin.chaine.getString("FMEXEC");
        LOAD_SCRIPT = Aladin.chaine.getString("FMLOADSCRIPT");
        SAVE_SCRIPT = Aladin.chaine.getString("FMSAVESCRIPT");
        LOAD_PARAMS = Aladin.chaine.getString("FMLOADPARAMS");
        SAVE_PARAMS = Aladin.chaine.getString("FMSAVEPARAMS");
        IMPORT_PARAMS = Aladin.chaine.getString("FMIMPORTPARAMS");
        ADD_COL = Aladin.chaine.getString("FMADDCOL");
        CLEAR_PARAMS = Aladin.chaine.getString("FMCLEARPARAMS");
        EXEC_ALL = Aladin.chaine.getString("FMEXECALL");
        EXEC_ALL_FROM_CURRENT = Aladin.chaine.getString("FMEXECALLFROMCURRENT");
        EXEC_CURRENT = Aladin.chaine.getString("FMEXECCURRENT");
        EXEC_NEXT = Aladin.chaine.getString("FMEXECNEXT");
        FILE = Aladin.chaine.getString("FMFILE");
        HELP = Aladin.chaine.getString("FMHELP");
        LOADEX = Aladin.chaine.getString("FMLOADEX");
        SEEHELP = Aladin.chaine.getString("FMSEEHELP");
        CLOSE = Aladin.chaine.getString("FMCLOSE");
        STOP = Aladin.chaine.getString("FMSTOP");
        DELETE = Aladin.chaine.getString("FMDELETE");
    }

    private void buildFrame() {
        this.setTitle("Macros");
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JSplitPane jSplitPane = new JSplitPane(0, true, this.buildScriptPanel(), this.buildParamPanel());
        jSplitPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)jSplitPane, "Center");
        jSplitPane.setPreferredSize(new Dimension(300, 400));
        this.getContentPane().add((Component)this.buildCommandPanel(), "South");
        this.setJMenuBar(this.buildMenuBar());
        this.pack();
        jSplitPane.setDividerLocation(0.5);
    }

    private JPanel buildScriptPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        this.scriptTP = new JTextPane();
        this.scriptTP.getDocument().putProperty("__EndOfLine__", "\n");
        Aladin.makeCursor(this.scriptTP, 6);
        this.scriptTP.addMouseMotionListener(this.macroController);
        this.scriptTP.addMouseListener(this.macroController);
        Dimension dimension = new Dimension(300, 100);
        this.scriptTP.setPreferredSize(dimension);
        this.scriptRenderer = new ScriptSyntaxRenderer();
        this.scriptTP.getDocument().addDocumentListener(this.scriptRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.scriptTP);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(dimension);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SCRIPT), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        return jPanel;
    }

    private JPanel buildParamPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(ADD_COL);
        jButton.addActionListener(this.macroController);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(CLEAR_PARAMS);
        jButton2.addActionListener(this.macroController);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "North");
        this.paramTable = new TwoColorJTable();
        this.paramTable.setGridColor(Color.lightGray);
        this.paramTable.setSelectionMode(0);
        this.paramTable.setModel(this.macroController.getMacroModel().getParamTableModel());
        this.paramTable.setDefaultEditor(String.class, this.macroController.getMacroModel().getTableCellEditor());
        this.paramTable.addMouseListener(this.macroController);
        this.macroController.getMacroModel().getParamTableModel().initTable();
        this.macroController.getMacroModel().getParamTableModel().addEmptyCol();
        JScrollPane jScrollPane = new JScrollPane(this.paramTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PARAMS), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        return jPanel;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        int n = Aladin.macPlateform ? 4 : 2;
        JMenu jMenu = new JMenu(FILE);
        jMenuBar.add(jMenu);
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem(LOAD_SCRIPT);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        jMenuItem = new JMenuItem(SAVE_SCRIPT);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem(LOAD_PARAMS);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, n));
        jMenuItem = new JMenuItem(IMPORT_PARAMS);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, n));
        jMenuItem = new JMenuItem(SAVE_PARAMS);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem(CLOSE);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        JMenu jMenu2 = new JMenu(HELP);
        jMenuBar.add(jMenu2);
        jMenuItem = new JMenuItem(LOADEX);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem(SEEHELP);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this.macroController);
        return jMenuBar;
    }

    private JPanel buildCommandPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(EXEC_CURRENT);
        jButton.addActionListener(this.macroController);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(EXEC_NEXT);
        jButton2.addActionListener(this.macroController);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JButton jButton3 = new JButton(EXEC_ALL);
        jButton3.addActionListener(this.macroController);
        jPanel3.add(jButton3);
        JButton jButton4 = new JButton(EXEC_ALL_FROM_CURRENT);
        jButton4.addActionListener(this.macroController);
        jPanel3.add(jButton4);
        this.stopBtn = new JButton(STOP);
        this.stopBtn.addActionListener(this.macroController);
        this.stopBtn.setEnabled(false);
        jPanel3.add(this.stopBtn);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(EXECUTE), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return jPanel;
    }

    protected void setScript(String string) {
        this.scriptTP.setText(string);
        this.scriptTP.setCaretPosition(0);
        this.scriptTP.requestFocus();
    }

    protected String getScriptText() {
        return this.scriptTP.getText();
    }

    protected void setEnabledStopBtn(boolean bl) {
        this.stopBtn.setEnabled(bl);
    }

    protected void testIfColorLink(int n) {
        this.mousePosInScript = n;
        this.ocmdWordUnderMouse = this.cmdWordUnderMouse;
        if (this.cmdWordsPos == null) {
            return;
        }
        Enumeration enumeration = this.cmdWordsPos.elements();
        String string = null;
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            if (n < nArray[0] || this.mousePosInScript >= nArray[1]) continue;
            string = this.scriptTP.getText().substring(nArray[0], nArray[1]);
            break;
        }
        this.cmdWordUnderMouse = string;
        if (this.cmdWordUnderMouse != this.ocmdWordUnderMouse) {
            if (this.cmdWordUnderMouse != null) {
                Aladin.makeCursor(this.scriptTP, 2);
            } else {
                Aladin.makeCursor(this.scriptTP, 6);
            }
            this.scriptRenderer.doColoringLater();
        }
    }

    protected void hilightScriptLine(int n) {
        this.hlScriptRow = n;
        if (this.hlScriptRow != this.ohlScriptRow) {
            this.scriptRenderer.doColoringLater();
            try {
                if (n >= 0) {
                    Element element = this.scriptTP.getDocument().getDefaultRootElement();
                    int n2 = element.getElement(n).getStartOffset();
                    this.scriptTP.setCaretPosition(n2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.ohlScriptRow = this.hlScriptRow;
    }

    protected void showHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame();
        }
        this.helpFrame.setVisible(true);
        this.helpFrame.toFront();
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DELETE);
        jMenuItem.addActionListener(this.macroController);
        this.popup.add(jMenuItem);
    }

    protected JPopupMenu getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    protected JTable getParamTable() {
        return this.paramTable;
    }

    protected String getCmdWordUnderMouse() {
        return this.cmdWordUnderMouse;
    }

    class ScriptSyntaxRenderer
    implements DocumentListener,
    Runnable {
        StyledDocument TEMPLATE;
        Style COMMENT_STYLE;
        Style DEFAULT_STYLE;
        Style PARAM_STYLE;
        Style KEYWORD_STYLE;
        Style LINK_STYLE;
        Style HILIGHT_STYLE;
        Color COMMENT_COLOR = new Color(63, 180, 95);
        Color PARAM_COLOR = new Color(182, 0, 85);
        Color KEYWORD_COLOR = new Color(100, 163, 224);
        Color HILIGHT_COLOR = new Color(249, 237, 130);
        boolean isColoring = false;
        private Document doc;

        public ScriptSyntaxRenderer() {
            this.initStyles();
        }

        private void initStyles() {
            this.TEMPLATE = new DefaultStyledDocument();
            this.COMMENT_STYLE = this.TEMPLATE.addStyle("comment", null);
            StyleConstants.setItalic(this.COMMENT_STYLE, true);
            StyleConstants.setForeground(this.COMMENT_STYLE, this.COMMENT_COLOR);
            this.DEFAULT_STYLE = this.TEMPLATE.addStyle("default", null);
            this.PARAM_STYLE = this.TEMPLATE.addStyle("param", null);
            StyleConstants.setBold(this.PARAM_STYLE, true);
            StyleConstants.setForeground(this.PARAM_STYLE, this.PARAM_COLOR);
            this.KEYWORD_STYLE = this.TEMPLATE.addStyle("kw", null);
            StyleConstants.setBold(this.KEYWORD_STYLE, true);
            StyleConstants.setForeground(this.KEYWORD_STYLE, this.KEYWORD_COLOR);
            this.LINK_STYLE = this.TEMPLATE.addStyle("link", null);
            StyleConstants.setBold(this.LINK_STYLE, true);
            StyleConstants.setForeground(this.LINK_STYLE, this.KEYWORD_COLOR);
            StyleConstants.setUnderline(this.LINK_STYLE, true);
            this.HILIGHT_STYLE = this.TEMPLATE.addStyle("hl", null);
            StyleConstants.setBackground(this.HILIGHT_STYLE, this.HILIGHT_COLOR);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.doc = documentEvent.getDocument();
            this.doColoringLater();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.doc = documentEvent.getDocument();
            this.doColoringLater();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.doc = documentEvent.getDocument();
            this.doColoringLater();
        }

        private void doColoringLater() {
            if (!this.isColoring) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            this.isColoring = true;
            try {
                this.coloration();
            }
            finally {
                this.isColoring = false;
            }
        }

        private void coloration() {
            String string;
            String string2;
            if (this.doc == null) {
                return;
            }
            Position position = this.doc.getStartPosition();
            Position position2 = this.doc.getEndPosition();
            try {
                string2 = this.doc.getText(position.getOffset(), position2.getOffset() - position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return;
            }
            Vector<int[]> vector = new Vector<int[]>();
            int n = 0;
            int n2 = -1;
            StyledDocument styledDocument = (StyledDocument)this.doc;
            String string3 = string = "\n";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals(string)) {
                    if (!string.equals(string3)) {
                        string3 = string4;
                    } else {
                        string3 = string4;
                        ++n2;
                    }
                    n += string4.length();
                    continue;
                }
                string3 = string4;
                ++n2;
                if (string4.trim().startsWith("#")) {
                    styledDocument.setCharacterAttributes(n, string4.length(), this.COMMENT_STYLE, true);
                } else {
                    int n3;
                    Object object;
                    styledDocument.setCharacterAttributes(n, string4.length(), this.DEFAULT_STYLE, true);
                    int n4 = -1;
                    try {
                        String string5;
                        object = new StreamTokenizer(new ByteArrayInputStream(string4.getBytes()));
                        n3 = ((StreamTokenizer)object).nextToken();
                        if (n3 == -3 && Util.indexInArrayOf((string5 = ((StreamTokenizer)object).sval).toLowerCase(), Command.CMD) >= 0) {
                            n4 = string4.indexOf(string5);
                            int n5 = n + n4;
                            vector.add(new int[]{n5, n5 + string5.length()});
                            if (FrameMacro.this.mousePosInScript >= n5 && FrameMacro.this.mousePosInScript < n5 + string5.length()) {
                                styledDocument.setCharacterAttributes(n5, string5.length(), this.LINK_STYLE, true);
                            } else {
                                styledDocument.setCharacterAttributes(n5, string5.length(), this.KEYWORD_STYLE, true);
                            }
                            if (string5.equalsIgnoreCase("get") && (n3 = ((StreamTokenizer)object).nextToken()) == -3) {
                                string5 = ((StreamTokenizer)object).sval;
                                String[] stringArray = new String[]{"aladin", "simbad", "vizier"};
                                if (Util.indexInArrayOf(string5.toLowerCase(), stringArray) >= 0) {
                                    n4 = string4.indexOf(string5);
                                    styledDocument.setCharacterAttributes(n + n4, string5.length(), this.KEYWORD_STYLE, true);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    while ((n4 = string4.indexOf(36, n4 + 1)) >= 0) {
                        for (n3 = n4 + 2; n3 <= string4.length(); ++n3) {
                            object = string4.substring(n4 + 1, n3);
                            try {
                                Integer.parseInt((String)object);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        if (n3 <= n4 + 2) continue;
                        styledDocument.setCharacterAttributes(n + n4, n3 - n4 - 1, this.PARAM_STYLE, true);
                    }
                }
                if (n2 == FrameMacro.this.hlScriptRow) {
                    styledDocument.setCharacterAttributes(n, string4.length(), this.HILIGHT_STYLE, false);
                }
                n += string4.length();
            }
            FrameMacro.this.cmdWordsPos = vector;
        }
    }

    class HelpFrame
    extends JFrame {
        HelpFrame() {
            this.setIconImage(FrameMacro.this.a.getImagette("AladinIconSS.gif"));
            FrameMacro.this.a;
            this.setTitle(Aladin.chaine.getString("FMHELPTITLE"));
            this.setDefaultCloseOperation(1);
            this.getContentPane().setLayout(new BorderLayout());
            ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(true);
            FrameMacro.this.a;
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Aladin.chaine.getString("FMHOWTO")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            FrameMacro.this.a;
            jEditorPane.setText(Aladin.chaine.getString("FMHELPCONTENT"));
            jEditorPane.setEditable(false);
            jEditorPane.setFont(Aladin.PLAIN);
            jEditorPane.setOpaque(true);
            jEditorPane.setBackground(Color.white);
            jEditorPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            final JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            jScrollPane.setPreferredSize(new Dimension(530, 250));
            jPanel.add((Component)jScrollPane, "Center");
            this.getContentPane().add((Component)jPanel, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
            this.pack();
        }
    }
}

