/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanMoc;
import cds.aladin.Source;
import cds.aladin.Tok;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameMocFiltering
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String CATPLANE;
    String MOCPLANE;
    String IN;
    String OUT;
    private ButtonGroup cbg;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCFILTERINGTITLE");
        this.INFO = Aladin.chaine.getString("MOCFILTERINGINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.CATPLANE = Aladin.chaine.getString("MOCFILTERINGCAT");
        this.MOCPLANE = Aladin.chaine.getString("MOCFILTERINGMOC");
        this.IN = Aladin.chaine.getString("MOCFILTERINGIN");
        this.OUT = Aladin.chaine.getString("MOCFILTERINGOUT");
    }

    protected FrameMocFiltering(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 8;
    }

    @Override
    protected String getLabelSelector(int n) {
        return n == 0 ? this.MOCPLANE : this.CATPLANE;
    }

    @Override
    protected Plan[] getPlan() {
        Vector<Plan> vector = this.a.calque.getPlans(19);
        Vector<Plan> vector2 = this.a.calque.getPlans(8);
        if (vector == null) {
            vector = vector2;
        } else if (vector2 != null) {
            vector.addAll(vector2);
        }
        if (vector == null) {
            return new Plan[0];
        }
        Object[] objectArray = new Plan[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected Color getColorLabel(int n) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.cbg = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        JRadioButton jRadioButton = new JRadioButton(this.IN);
        jRadioButton.setActionCommand(this.IN);
        this.cbg.add(jRadioButton);
        jPanel2.add(jRadioButton);
        jRadioButton.setSelected(true);
        jRadioButton = new JRadioButton(this.OUT);
        jRadioButton.setActionCommand(this.OUT);
        this.cbg.add(jRadioButton);
        jPanel2.add(jRadioButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected PlanCatalog createPlane(String string, PlanMoc planMoc, Plan[] planArray, boolean bl) throws Exception {
        Coord coord = new Coord();
        Healpix healpix = new Healpix();
        HealpixMoc healpixMoc = planMoc.getMoc();
        Vector<Obj> vector = new Vector<Obj>();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (plan == null) continue;
            Iterator<Obj> iterator = plan.iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                coord.al = obj.getRa();
                coord.del = obj.getDec();
                if (Double.isNaN(coord.al) || Double.isNaN(coord.del)) continue;
                coord = Localisation.frameToFrame(coord, 0, planMoc.frameOrigin);
                boolean bl2 = healpixMoc.contains(healpix, coord.al, coord.del);
                if (bl != bl2) continue;
                vector.add(obj);
            }
        }
        return this.a.calque.newPlanCatalogBySources(vector, string, false);
    }

    @Override
    protected void submit() {
        try {
            StringBuilder stringBuilder = null;
            String string = this.cbg.getSelection().getActionCommand();
            boolean bl = string.equals(this.IN);
            Plan plan = this.getPlan(this.ch[0]);
            if (plan.type != 19) {
                throw new Exception("Not a MOC");
            }
            String string2 = "";
            ArrayList<Plan> arrayList = new ArrayList<Plan>();
            for (int i = 1; i < this.ch.length; ++i) {
                Plan plan2 = this.getPlan(this.ch[i]);
                if (plan2 == null) continue;
                string2 = string2.length() == 0 ? plan2.label : string2 + ", " + plan2.label;
                arrayList.add(plan2);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(Tok.quote(plan2.label));
                    continue;
                }
                stringBuilder.append(" " + Tok.quote(plan2.label));
            }
            Plan[] planArray = new Plan[arrayList.size()];
            arrayList.toArray(planArray);
            this.createPlane(string2, (PlanMoc)plan, planArray, bl);
            this.a.calque.repaintAll();
            this.hide();
            this.a.console.printCommand("ccat -uniq " + (!bl ? "-out " : " ") + Tok.quote(plan.label) + (stringBuilder.length() > 0 ? " " + stringBuilder.toString() : ""));
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("Catalog filtering by MOC failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

