/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.Server;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class FrameMocGenCat
extends FrameMocGenImg {
    private JTextField radius;

    protected FrameMocGenCat(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.INFO = Aladin.chaine.getString("MOCGENCATINFO");
    }

    @Override
    protected boolean isPlanOk(Plan plan) {
        return plan.isCatalog();
    }

    @Override
    protected void addSpecifPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Radius (in arcsec):"));
        this.radius = new JTextField(5);
        jPanel2.add(this.radius);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
    }

    private double getRadius() throws Exception {
        double d = 0.0;
        try {
            String string = this.radius.getText().trim();
            if (string.length() > 0) {
                d = Server.getAngleInArcmin(string, 16) / 60.0;
            }
        }
        catch (Exception exception) {
            this.radius.setForeground(Color.red);
            throw exception;
        }
        this.radius.setForeground(Color.black);
        return d;
    }

    @Override
    protected void submit() {
        try {
            Plan[] planArray = new Plan[]{this.getPlan(this.ch[0])};
            int n = this.getOrder();
            double d = this.getRadius();
            String string = "";
            if (d != 0.0) {
                string = " -radius=" + Coord.getUnit(d);
            }
            this.a.console.printCommand("cmoc -order=" + n + string + " " + FrameMocGenCat.labelList(planArray));
            this.a.calque.newPlanMoc(planArray[0].label + " MOC", planArray, n, d, 0.0, 0.0, Double.NaN);
            this.hide();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("MOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

