/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameMocGenImg
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String PLANE;
    private ButtonGroup cbg;
    JComboBox mocOrder;
    JTextField minRange;
    JTextField maxRange;
    JTextField threshold;
    JCheckBox rangeCheckBox;
    private static final int FIRSTORDER = 3;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCGENTITLE");
        this.INFO = Aladin.chaine.getString("MOCGENIMGINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.PLANE = Aladin.chaine.getString("MOCPLANE");
    }

    protected FrameMocGenImg(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 1;
    }

    @Override
    protected String getLabelSelector(int n) {
        return this.PLANE;
    }

    protected boolean isPlanOk(Plan plan) {
        if (plan instanceof PlanBG && !((PlanBG)plan).isLocalAllSky()) {
            return false;
        }
        if (plan instanceof PlanImage && ((PlanImage)plan).isPixel()) {
            return true;
        }
        return plan.isCatalog();
    }

    @Override
    protected Plan[] getPlan() {
        Plan[] planArray = this.a.calque.getPlans();
        int n = 0;
        for (int i = 0; i < planArray.length; ++i) {
            if (!this.isPlanOk(planArray[i])) continue;
            ++n;
        }
        Plan[] planArray2 = new Plan[n];
        int n2 = 0;
        for (int i = 0; i < planArray.length; ++i) {
            if (!this.isPlanOk(planArray[i])) continue;
            planArray2[n2++] = planArray[i];
        }
        return planArray2;
    }

    @Override
    protected Color getColorLabel(int n) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.addSpecifPanel(jPanel, gridBagConstraints, gridBagLayout);
        this.cbg = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("MOC resolution :"));
        this.mocOrder = this.getComboRes();
        jPanel2.add(this.mocOrder);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected void addSpecifPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Pixel range: ["));
        this.minRange = new JTextField(3);
        jPanel2.add(this.minRange);
        jPanel2.add(new JLabel(".."));
        this.maxRange = new JTextField(3);
        jPanel2.add(this.maxRange);
        jPanel2.add(new JLabel("]"));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
    }

    private JComboBox getComboRes() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 3; i <= 29; ++i) {
            String string = "Order " + i + " => " + Coord.getUnit(CDSHealpix.pixRes(CDSHealpix.pow2(i)) / 3600.0);
            jComboBox.addItem(string);
        }
        jComboBox.setSelectedIndex(7);
        return jComboBox;
    }

    protected int getOrder() {
        return this.mocOrder.getSelectedIndex() + 3;
    }

    private double getMin() throws Exception {
        double d = Double.NaN;
        try {
            String string = this.minRange.getText().trim();
            if (string.length() > 0) {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.minRange.setForeground(Color.red);
            throw exception;
        }
        this.minRange.setForeground(Color.black);
        return d;
    }

    private double getMax() throws Exception {
        double d = Double.NaN;
        try {
            String string = this.maxRange.getText().trim();
            if (string.length() > 0) {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.maxRange.setForeground(Color.red);
            throw exception;
        }
        this.maxRange.setForeground(Color.black);
        return d;
    }

    @Override
    protected void submit() {
        try {
            Plan[] planArray = new Plan[]{this.getPlan(this.ch[0])};
            int n = this.getOrder();
            double d = this.getMin();
            double d2 = this.getMax();
            String string = "";
            if (!Double.isNaN(d) || !Double.isNaN(d2)) {
                string = " -pixelCut=\"" + d + " " + d2 + "\"";
            }
            this.a.console.printCommand("cmoc -order=" + n + string + " " + FrameMocGenImg.labelList(planArray));
            this.a.calque.newPlanMoc(planArray[0].label + " MOC", planArray, n, 0.0, d, d2, Double.NaN);
            this.hide();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("MOC generation failed !");
        }
    }

    protected static String labelList(Plan[] planArray) {
        StringBuilder stringBuilder = null;
        for (Plan plan : planArray) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(Tok.quote(plan.label));
                continue;
            }
            stringBuilder.append(" " + Tok.quote(plan.label));
        }
        return stringBuilder.toString();
    }

    @Override
    protected void adjustWidgets() {
    }
}

