/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.allsky.Context;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameMocGenImgs
extends FrameMocGenImg {
    private JTextField dirField;
    private JCheckBox strictBox;
    private JCheckBox recBox;
    private JTextField fieldBlank;
    private JTextField fieldHDU;
    private JLabel labelBlank;
    private JLabel labelHDU;
    private JButton browseButton;
    private static final String DEFAULT_FILENAME = "-";

    protected FrameMocGenImgs(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCGENTITLE");
        this.INFO = Aladin.chaine.getString("MOCGENIMGSINFO");
    }

    @Override
    protected int getNb() {
        return 0;
    }

    @Override
    protected void reset() {
        this.dirField.setText("");
        this.recBox.setSelected(false);
        this.strictBox.setSelected(false);
        this.labelBlank.setEnabled(false);
        this.fieldBlank.setEnabled(false);
        this.fieldBlank.setText("");
        this.fieldHDU.setText("");
        super.reset();
    }

    @Override
    protected void addSpecifPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(Aladin.chaine.getString("REPSALLSKY")));
        this.dirField = new JTextField(29);
        jPanel2.add(this.dirField);
        this.dirField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                if (jTextField.getForeground() != Color.black) {
                    jTextField.setForeground(Color.black);
                }
            }
        });
        this.browseButton = new JButton("Browse");
        jPanel2.add(this.browseButton);
        this.browseButton.setMargin(new Insets(2, 4, 2, 4));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameMocGenImgs.this.actionBrowse();
            }
        });
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.labelHDU = new JLabel("Specifical FITS HDU (e.g 1,3-5|all)");
        this.fieldHDU = new JTextField(10);
        this.fieldHDU.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                if (jTextField.getForeground() != Color.black) {
                    jTextField.setForeground(Color.black);
                }
            }
        });
        jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(this.labelHDU);
        jPanel2.add(this.fieldHDU);
        jPanel2.add(new JLabel("(first one by default)"));
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.recBox = new JCheckBox("Scanning sub-directories");
        gridBagLayout.setConstraints(this.recBox, gridBagConstraints);
        jPanel.add(this.recBox);
        this.labelBlank = new JLabel("=> Alternative BLANK value");
        this.fieldBlank = new JTextField(10);
        this.fieldBlank.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                if (jTextField.getForeground() != Color.black) {
                    jTextField.setForeground(Color.black);
                }
            }
        });
        this.strictBox = new JCheckBox("Scanning image pixel values (not just WCS)");
        this.strictBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                FrameMocGenImgs.this.fieldBlank.setEnabled(bl);
                FrameMocGenImgs.this.labelBlank.setEnabled(bl);
            }
        });
        gridBagLayout.setConstraints(this.strictBox, gridBagConstraints);
        jPanel.add(this.strictBox);
        jPanel2 = new JPanel();
        jPanel2.add(this.labelBlank);
        jPanel2.add(this.fieldBlank);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.reset();
    }

    private void actionBrowse() {
        FileDialog fileDialog = new FileDialog(this.a.dialog);
        fileDialog.setFile(DEFAULT_FILENAME);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        boolean bl = false;
        if (string2 != null && string2.equals(DEFAULT_FILENAME)) {
            string2 = "";
            bl = true;
        }
        if (string2 != null && string2.length() > 0 || bl) {
            this.dirField.setText(string);
        }
    }

    private boolean getStrict() {
        return this.strictBox.isSelected();
    }

    private boolean getRecursive() {
        return this.recBox.isSelected();
    }

    private double getBlank() throws Exception {
        if (!this.getStrict()) {
            return Double.NaN;
        }
        double d = Double.NaN;
        try {
            String string = this.fieldBlank.getText().trim();
            d = string.length() == 0 || Util.indexOfIgnoreCase(string, "NaN", 0) >= 0 ? Double.NaN : Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.fieldBlank.setForeground(Color.red);
            throw exception;
        }
        this.fieldBlank.setForeground(Color.black);
        return d;
    }

    private int[] getHDU() throws Exception {
        int[] nArray = null;
        try {
            String string = this.fieldHDU.getText().trim();
            nArray = Context.parseHDU(string);
        }
        catch (Exception exception) {
            this.fieldHDU.setForeground(Color.red);
            throw exception;
        }
        this.fieldBlank.setForeground(Color.black);
        return nArray;
    }

    private String getDir() throws Exception {
        String string = "";
        try {
            string = this.dirField.getText().trim();
            if (string.length() > 0 && !new File(string).isDirectory()) {
                throw new Exception("Not a directory");
            }
        }
        catch (Exception exception) {
            this.dirField.setForeground(Color.red);
            throw exception;
        }
        this.dirField.setForeground(Color.black);
        return string;
    }

    @Override
    protected void submit() {
        block2: {
            try {
                String string = this.getDir();
                String string2 = new File(string).getName() + " MOC";
                this.a.calque.newPlanMocColl(this.a, string2, string, this.getOrder(), this.getStrict(), this.getRecursive(), this.getBlank(), this.getHDU());
                this.hide();
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block2;
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

