/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class FrameMocGenProba
extends FrameMocGenImg {
    protected FrameMocGenProba(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCGENTITLE");
        this.INFO = Aladin.chaine.getString("MOCGENPROBAINFO");
        this.PLANE = Aladin.chaine.getString("MOCFILTERINGPROBA");
    }

    @Override
    protected boolean isPlanOk(Plan plan) {
        return plan.type == 16;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.addSpecifPanel(jPanel, gridBagConstraints, gridBagLayout);
        return jPanel;
    }

    @Override
    protected void addSpecifPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Probability threshold : "));
        this.threshold = new JTextField(5);
        jPanel2.add(this.threshold);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        if (Aladin.BETA) {
            jPanel.add(jPanel2);
        }
    }

    private double getThreshold() throws Exception {
        double d = Double.NaN;
        try {
            String string = this.threshold.getText().trim();
            if (string.length() > 0) {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    @Override
    protected void submit() {
        try {
            Plan[] planArray = new Plan[]{this.getPlan(this.ch[0])};
            int n = ((PlanBG)planArray[0]).getMaxHealpixOrder();
            double d = this.getThreshold();
            this.a.console.printCommand("cmoc -threshold=" + d + " " + FrameMocGenProba.labelList(planArray));
            this.a.calque.newPlanMoc("MOC " + d + " " + planArray[0].label, planArray, n, 0.0, Double.NaN, Double.NaN, d);
            this.hide();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("MOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

