/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Server;
import cds.aladin.ViewSimple;
import cds.aladin.prop.PropPanel;
import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.ICRS;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FrameNewCalib
extends JFrame
implements ActionListener,
ChangeListener {
    static final int SIMPLE = 0;
    static final int QUADRUPLET = 1;
    static final int WCS = 2;
    static int num = 0;
    String TITLE;
    String SUBMIT;
    String MODIFY;
    String UNDO;
    String REDO;
    String HELP;
    String RESET;
    String CLEAR;
    String CANCEL;
    String ONE;
    String TWO;
    String THREE;
    String HELPSTRING;
    String MYPROJ;
    String ADJUST1;
    String ADJUST2;
    String TRUE;
    String FALSE;
    String CHOOSECAL;
    String LABEL;
    String FRAME;
    String COORD;
    String XY;
    String PIXSIZE;
    String PROJECT;
    String ROT;
    String RASYM;
    String QUADMSG;
    String XYPOS;
    String ERRNOXY;
    String ERRNOBEST;
    String ERRIMG;
    Aladin a;
    Plan plan;
    Projection oldp;
    MyLabel titleFrame;
    JTextField labelT;
    JTextField cooT;
    JTextField xyT;
    JTextField xyS;
    JTextField rotT;
    JTextArea wcsT;
    JComboBox frameChoice = null;
    JComboBox projChoice = null;
    JRadioButton trueSym;
    JRadioButton falseSym;
    ButtonGroup symRadio = null;
    JPanel pSym;
    JButton modifyButton;
    JButton resetButton;
    int maxPosT = 7;
    FrameNewCalibTextField[] xyPosT;
    FrameNewCalibTextField[] cooPosT;
    String label;
    double raj;
    double dej;
    double cx;
    double cy;
    double rm;
    double r;
    double rot;
    boolean sym;
    int t;
    int system;
    JTextField focusTextField = null;
    boolean flagXY = false;
    JPanel panelOne;
    JPanel panelTwo;
    JPanel panelThree;
    JTabbedPane panelMethod;
    private JButton undoButton;
    private JButton redoButton;
    int modeCalib;
    private Stack undo;
    private Stack redo;
    private long oplanHashCode = -1L;
    public static int W = 20;
    private Obj prevObj = null;
    Plan drawPlan = null;

    protected void createChaine() {
        this.TITLE = Aladin.chaine.getString("NCTITLE");
        this.SUBMIT = Aladin.chaine.getString("NCSUBMIT");
        this.MODIFY = Aladin.chaine.getString("NCMODIFY");
        this.UNDO = Aladin.chaine.getString("NCUNDO");
        this.REDO = Aladin.chaine.getString("NCREDO");
        this.HELP = Aladin.chaine.getString("NCHELP");
        this.RESET = Aladin.chaine.getString("NCRESET");
        this.CLEAR = Aladin.chaine.getString("NCCLEAR");
        this.CANCEL = Aladin.chaine.getString("NCCANCEL");
        this.ONE = Aladin.chaine.getString("NCONE");
        this.TWO = Aladin.chaine.getString("NCTWO");
        this.THREE = Aladin.chaine.getString("NCTHREE");
        this.HELPSTRING = Aladin.chaine.getString("NCHELPSTRING");
        this.MYPROJ = Aladin.chaine.getString("NCMYPROJ");
        this.ADJUST1 = Aladin.chaine.getString("NCADJUST1");
        this.ADJUST2 = Aladin.chaine.getString("NCADJUST2");
        this.TRUE = Aladin.chaine.getString("NCTRUE");
        this.FALSE = Aladin.chaine.getString("NCFALSE");
        this.CHOOSECAL = Aladin.chaine.getString("NCCHOOSECAL");
        this.LABEL = Aladin.chaine.getString("NCLABEL");
        this.FRAME = Aladin.chaine.getString("UPFRAMEB");
        this.COORD = Aladin.chaine.getString("NCCOORD");
        this.XY = Aladin.chaine.getString("NCXY");
        this.PIXSIZE = Aladin.chaine.getString("NCPIXSIZE");
        this.PROJECT = Aladin.chaine.getString("NCPROJECT");
        this.ROT = Aladin.chaine.getString("NCROT");
        this.RASYM = Aladin.chaine.getString("NCRASYM");
        this.QUADMSG = Aladin.chaine.getString("NCQUADMSG");
        this.XYPOS = Aladin.chaine.getString("NCXYPOS");
        this.ERRNOXY = Aladin.chaine.getString("NCERRNOXY");
        this.ERRIMG = Aladin.chaine.getString("NCERRIMG");
        this.ERRNOBEST = Aladin.chaine.getString("NCERRNOBEST");
    }

    protected FrameNewCalib(Aladin aladin, Plan plan, Projection projection) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.TITLE);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.plan = plan;
        this.oldp = projection;
        this.setLocation(Aladin.computeLocation(this));
        this.createPanel();
        this.pack();
        this.majFrameNewCalib(plan, projection);
    }

    protected void majFrameNewCalib(Plan plan) {
        this.majFrameNewCalib(plan, null);
    }

    protected void majFrameNewCalib(Plan plan, Projection projection) {
        this.plan = plan;
        this.oldp = projection;
        this.modifyButton.setText(projection == null ? this.SUBMIT : this.MODIFY);
        this.initUndo();
        this.setData();
        this.show();
        this.a.calque.zoom.wenOn();
        this.resumeFlagPlanRecalibrating();
    }

    private void initUndo() {
        this.undo = new Stack();
        this.redo = new Stack();
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    private void setUndo(Projection projection) {
        this.redo = new Stack();
        this.undo.push(projection.copy());
    }

    private boolean undoable() {
        return !this.undo.empty();
    }

    private boolean redoable() {
        return !this.redo.empty();
    }

    private void undo() throws Exception {
        Projection projection = (Projection)this.undo.pop();
        this.redo.push(this.plan.projd.copy());
        this.oldp = this.plan.projd = projection;
        this.setData(projection, true);
        this.submit(true);
    }

    private void redo() throws Exception {
        Projection projection = (Projection)this.redo.pop();
        this.undo.push(this.plan.projd.copy());
        this.oldp = this.plan.projd = projection;
        this.setData(projection, true);
        this.submit(true);
    }

    private String getNewLabel() {
        return this.MYPROJ + " " + ++num;
    }

    private void setData() {
        this.setData(this.plan.projd, false);
    }

    private void setData(Projection projection, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        this.titleFrame.setText(this.oldp == null ? this.ADJUST1 + " \"" + this.plan.label + "\"" : this.ADJUST2 + " \"" + this.plan.label + "\"");
        if (this.plan.isSimpleCatalog() && !this.plan.hasXYorig) {
            ((PlanCatalog)this.plan).setXYorig();
        }
        if (Projection.isOk(projection)) {
            this.label = this.oldp != null ? projection.label : this.getNewLabel();
            try {
                Coord coord = projection.c.getProjCenter();
                this.raj = coord.al;
                this.dej = coord.del;
                this.cx = coord.x;
                this.cy = coord.y;
                this.rm = projection.c.getImgWidth() * 60.0;
                d = projection.c.getImgHeight() * 60.0;
                this.r = projection.c.getImgSize().width;
                d2 = projection.c.getImgSize().height;
                this.rot = projection.c.getProjRot();
                this.sym = projection.c.getProjSym();
                this.system = projection.c.getSystem();
                this.t = projection.c.getProj();
            }
            catch (Exception exception) {
                System.err.println("Error on projd: " + exception);
            }
        } else {
            this.label = this.getNewLabel();
            this.rot = 0.0;
            d2 = 0.0;
            this.r = 0.0;
            this.cy = 0.0;
            this.cx = 0.0;
            this.dej = 0.0;
            this.raj = 0.0;
            this.sym = false;
            this.system = Calib.ICRS;
            this.t = 1;
            if (this.plan.isImage()) {
                this.r = ((PlanImage)this.plan).naxis1;
                d2 = ((PlanImage)this.plan).naxis2;
                this.cx = ((PlanImage)this.plan).naxis1 / 2;
                this.cy = ((PlanImage)this.plan).naxis2 / 2;
                this.rm = d = this.r / 60.0;
                if (this.plan.hasFitsHeader()) {
                    try {
                        String string = this.plan.headerFits.getStringFromHeader("OBJCTRA");
                        String string2 = this.plan.headerFits.getStringFromHeader("OBJCTDEC");
                        Astrocoo astrocoo = new Astrocoo();
                        astrocoo.set(string + " " + string2);
                        this.raj = astrocoo.getLon();
                        this.dej = astrocoo.getLat();
                    }
                    catch (Exception exception) {}
                }
            } else if (this.plan.isSimpleCatalog() && this.plan.hasXYorig) {
                double[] dArray = new double[4];
                ((PlanCatalog)this.plan).getXYRange(dArray);
                d2 = this.r = Math.max(dArray[1] - dArray[0], dArray[3] - dArray[2]);
                this.cx = dArray[0] + (dArray[1] - dArray[0]) / 2.0;
                this.cy = dArray[2] + (dArray[3] - dArray[2]) / 2.0;
            }
        }
        this.labelT.setText(this.label);
        this.cooT.setText(Coord.getSexa(this.raj, this.dej, "s"));
        this.xyT.setText(Util.myRound(this.cx + "", 2) + " " + Util.myRound(this.cy + "", 2));
        this.xyS.setText(this.rm == 0.0 || this.r == 0.0 ? "1\"" : Coord.getUnit(this.rm / 60.0 / this.r));
        this.rotT.setText(this.rot + "");
        this.setSymRadio(this.sym);
        this.setFrameChoice(this.system);
        this.setProjChoice(this.t >= 0 ? this.t : 0);
        this.setCoo(projection);
        if (bl && projection != null) {
            this.modeCalib = 0;
            if (projection.modeCalib == 4) {
                this.modeCalib = 1;
            } else if (projection.modeCalib == 2) {
                this.modeCalib = 2;
            }
        }
        this.panelMethod.setSelectedIndex(this.modeCalib);
        if (this.modeCalib == 1) {
            this.setFocusPos(this.xyPosT[0]);
            this.a.calque.repaintAll();
        }
        if (projection == null) {
            this.getWCS(new Projection(this.label, 3, this.raj, this.dej, this.rm, d, this.cx, this.cy, this.r, d2, this.rot, this.sym, 2, this.system));
        } else {
            this.getWCS(projection);
        }
        this.pack();
    }

    protected void newXY(PointD pointD, PointD pointD2, ViewSimple viewSimple) {
        if (this.modeCalib != 0) {
            return;
        }
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        double d = 0.0;
        double d2 = 0.0;
        coord.x = pointD.x;
        coord.y = pointD.y;
        coord2.x = pointD2.x;
        coord2.y = pointD2.y;
        Plan plan = viewSimple.pref;
        Projection projection = viewSimple.getProj();
        try {
            if (plan != null && Projection.isOk(projection)) {
                projection.getCoord(coord);
                projection.getCoord(coord2);
                if (!Double.isNaN(coord.al) && !Double.isNaN(coord2.al)) {
                    double d3;
                    double d4 = coord2.al - coord.al;
                    double d5 = coord2.del - coord.del;
                    d = d3 = d4 * AstroMath.cosd(coord.del);
                    d2 = d5;
                }
            }
            Coord coord3 = new Coord(this.raj, this.dej);
            coord3.al += d;
            coord3.del += d2;
            this.cooT.setText(coord3.getSexa(" "));
            this.modifyButton.setEnabled(true);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void clear() {
        this.cooT.setText("");
        this.xyT.setText("");
        this.xyS.setText("");
        this.rotT.setText("0");
        this.setSymRadio(this.sym);
        this.setFrameChoice(this.system);
        this.setProjChoice(this.t >= 0 ? this.t : 0);
        this.setCoo(null);
        this.getWCS(null);
    }

    private void getWCS(Projection projection) {
        this.wcsT.setText("");
        if (projection == null) {
            return;
        }
        this.wcsT.setText(projection.getWCS());
    }

    private void updaterm() {
        double d = Server.getAngleInArcmin(this.xyS.getText(), 1);
        if (this.r <= 0.0) {
            this.r = 1024.0;
        }
        this.rm = d * this.r;
    }

    private void setFrameChoice(int n) {
        if (this.frameChoice == null) {
            this.frameChoice = Localisation.createFrameComboBis();
        }
        try {
            this.frameChoice.setSelectedIndex(n);
        }
        catch (Exception exception) {
            this.frameChoice.setSelectedIndex(0);
        }
    }

    private void setProjChoice(int n) {
        int n2;
        if (this.projChoice == null) {
            this.projChoice = new JComboBox<String>(Projection.getAlaProj());
        }
        if ((n2 = Projection.getAlaProjIndex(Calib.getProjName(n))) >= Projection.getAlaProj().length) {
            n2 = 2;
        }
        this.projChoice.setSelectedIndex(n2);
    }

    private void setSymRadio(boolean bl) {
        if (this.symRadio == null) {
            this.symRadio = new ButtonGroup();
            this.trueSym = new JRadioButton(this.TRUE);
            this.symRadio.add(this.trueSym);
            this.trueSym.setSelected(true);
            this.falseSym = new JRadioButton(this.FALSE);
            this.symRadio.add(this.falseSym);
            this.pSym = new JPanel();
            this.pSym.add(this.trueSym);
            this.pSym.add(this.falseSym);
        }
        if (bl) {
            this.trueSym.setSelected(true);
        } else {
            this.falseSym.setSelected(true);
        }
    }

    private void createPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.titleFrame = new MyLabel(this.CHOOSECAL, 1, Aladin.ITALIC);
        jPanel2.add(this.titleFrame);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        Aladin.makeAdd(jPanel3, jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setFont(Aladin.BOLD);
        jPanel4.add(new JLabel(this.LABEL));
        this.labelT = new JTextField(20);
        jPanel4.add(this.labelT);
        Aladin.makeAdd(jPanel3, jPanel4, "Center");
        Aladin.makeAdd(jPanel, jPanel3, "North");
        jPanel2.setBackground(Aladin.BLUE);
        jPanel3.setBackground(Aladin.BLUE);
        jPanel4.setBackground(Aladin.BLUE);
        this.titleFrame.setBackground(Aladin.BLUE);
        jPanel.setBackground(Aladin.BLUE);
        this.getContentPane().setBackground(Aladin.BLUE);
        this.panelOne = this.createPanelOne();
        this.panelTwo = this.createPanelTwo();
        this.panelThree = this.createPanelThree();
        this.panelMethod = new JTabbedPane();
        this.panelMethod.addChangeListener(this);
        this.panelMethod.add(this.ONE, this.panelOne);
        this.panelMethod.add(this.TWO, this.panelTwo);
        this.panelMethod.add(this.THREE, this.panelThree);
        Aladin.makeAdd(jPanel, this.panelMethod, "Center");
        JPanel jPanel5 = this.valid();
        Aladin.makeAdd(jPanel, jPanel5, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Aladin.makeAdd(this, jPanel, "Center");
    }

    private JPanel createPanelOne() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 2;
        JPanel jPanel = new JPanel(gridBagLayout);
        this.cooT = new JTextField(20);
        this.xyT = new JTextField(20);
        this.xyS = new JTextField(20);
        this.rotT = new JTextField(20);
        this.frameChoice = Localisation.createFrameComboBis();
        this.setSymRadio(this.sym);
        this.setProjChoice(this.t);
        PropPanel.addCouple(jPanel, this.COORD, this.cooT, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, this.XY, this.xyT, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, this.PIXSIZE, this.xyS, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, this.FRAME, this.frameChoice, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, this.PROJECT, this.projChoice, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, this.ROT, this.rotT, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, this.RASYM, this.pSym, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel createPanelTwo() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.xyPosT = new FrameNewCalibTextField[this.maxPosT];
        this.cooPosT = new FrameNewCalibTextField[this.maxPosT];
        int n = 150;
        int n2 = 200;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setFont(Aladin.ITALIC);
        MyLabel myLabel = new MyLabel(this.QUADMSG);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(new JLabel(this.XYPOS));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        jPanel4.add(new JLabel("hh mm ss +dd mm ss"));
        Aladin.makeAdd(jPanel2, myLabel, "North");
        Aladin.makeAdd(jPanel2, jPanel3, "West");
        Aladin.makeAdd(jPanel2, jPanel4, "East");
        Aladin.makeAdd(jPanel, jPanel2, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 2));
        for (int i = 0; i < this.maxPosT; ++i) {
            this.xyPosT[i] = new FrameNewCalibTextField();
            this.cooPosT[i] = new FrameNewCalibTextField();
            jPanel5.add(this.xyPosT[i]);
            jPanel5.add(this.cooPosT[i]);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel5);
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        Aladin.makeAdd(jPanel, jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createPanelThree() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.wcsT = new JTextArea(50, 70);
        this.wcsT.setFont(Aladin.COURIER);
        Aladin.makeAdd(jPanel2, this.wcsT, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setPreferredSize(new Dimension(150, 200));
        Aladin.makeAdd(jPanel, jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel valid() {
        JButton jButton;
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.setFont(Aladin.LBOLD);
        jPanel.setBackground(Aladin.BLUE);
        Insets insets = new Insets(2, 2, 2, 2);
        this.modifyButton = jButton = new JButton(this.oldp == null ? this.SUBMIT : this.MODIFY);
        jPanel.add(jButton);
        jButton.setFont(jButton.getFont().deriveFont(1));
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        this.undoButton = jButton = new JButton(this.UNDO);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        this.redoButton = jButton = new JButton(this.REDO);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        jButton = new JButton(this.HELP);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        this.resetButton = jButton = new JButton(this.RESET);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        jButton = new JButton(this.CLEAR);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        jButton = new JButton(this.CANCEL);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton.setOpaque(false);
        return jPanel;
    }

    protected int getModeCalib() {
        return this.modeCalib;
    }

    private void changeMethod() {
        int n;
        this.modeCalib = n = this.panelMethod.getSelectedIndex();
        if (this.modeCalib == 1) {
            this.xyPosT[0].requestFocus();
            this.setFocusPos(this.xyPosT[0]);
            if (!this.plan.hasNoReduction() && (long)this.plan.hashCode() != this.oplanHashCode) {
                if (Aladin.confirmation(this, Aladin.chaine.getString("NCALIBAGAIN") + "\n=> " + this.plan.label)) {
                    this.oplanHashCode = this.plan.hashCode();
                }
            }
        }
        this.resumeFlagPlanRecalibrating();
    }

    private void resumeFlagPlanRecalibrating() {
    }

    protected void reset() {
        this.setData();
        this.setFocusPos(this.xyPosT[0]);
    }

    private void setCoo(Projection projection) {
        for (int i = 0; i < this.maxPosT; ++i) {
            String string;
            String string2;
            if (projection == null || projection.coo == null || i >= projection.coo.length) {
                string2 = "";
                string = "";
            } else {
                string = projection.coo[i].x + " " + projection.coo[i].y;
                string2 = projection.coo[i].getSexa();
            }
            this.xyPosT[i].setText(string);
            this.cooPosT[i].setText(string2);
        }
    }

    private Coord[] getCoo() throws Exception {
        int n = 0;
        FrameNewCalibTextField frameNewCalibTextField = this.xyPosT[0];
        Vector<Coord> vector = new Vector<Coord>();
        Coord[] coordArray = null;
        try {
            Object object;
            for (n = 0; n < this.maxPosT; ++n) {
                object = this.xyPosT[n].getText().trim();
                String string = this.cooPosT[n].getText().trim();
                if (((String)object).length() == 0 || string.length() == 0) continue;
                frameNewCalibTextField = this.cooPosT[n];
                Coord coord = new Coord(string);
                frameNewCalibTextField = this.xyPosT[n];
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                coord.x = Double.valueOf(stringTokenizer.nextToken());
                coord.y = Double.valueOf(stringTokenizer.nextToken());
                vector.addElement(coord);
            }
            int n2 = vector.size();
            object = vector.elements();
            coordArray = new Coord[n2];
            for (n = 0; n < n2; ++n) {
                coordArray[n] = (Coord)object.nextElement();
            }
        }
        catch (Exception exception) {
            ((Component)frameNewCalibTextField).requestFocus();
            this.setFocusPos(frameNewCalibTextField);
            exception.printStackTrace();
            throw new Exception("Error on field " + n);
        }
        return coordArray;
    }

    private int getHauteur() {
        if (this.plan.isImage()) {
            return ((PlanImage)this.plan).height;
        }
        double[] dArray = new double[4];
        ((PlanCatalog)this.plan).getXYRange(dArray);
        return (int)Math.round(dArray[3] - dArray[2]);
    }

    private void submit(boolean bl) {
        Projection projection = null;
        String string = this.labelT.getText();
        String string2 = null;
        double d = 0.0;
        double d2 = 0.0;
        if (bl && this.oldp != null) {
            this.oldp.frame = 0;
        }
        try {
            if (this.modeCalib == 0) {
                string2 = "coordinate";
                Astrocoo astrocoo = new Astrocoo(new ICRS(), this.cooT.getText());
                double d3 = astrocoo.getLon();
                double d4 = astrocoo.getLat();
                StringTokenizer stringTokenizer = new StringTokenizer(this.xyT.getText());
                string2 = "XY position";
                double d5 = Double.valueOf(stringTokenizer.nextToken());
                double d6 = Double.valueOf(stringTokenizer.nextToken());
                string2 = "Pixel size";
                this.updaterm();
                d = this.r;
                d2 = this.rm;
                if (this.plan.isImage()) {
                    d = ((PlanImage)this.plan).naxis2;
                    d2 = this.rm * d / this.r;
                }
                string2 = "rotation";
                double d7 = Double.valueOf(this.rotT.getText());
                int n = Projection.getProjType((String)this.projChoice.getSelectedItem());
                int n2 = Localisation.getFrameComboBisValue((String)this.frameChoice.getSelectedItem());
                boolean bl2 = this.trueSym.isSelected();
                string2 = null;
                if (bl && this.oldp != null) {
                    projection = this.oldp;
                    projection.modify(string, 3, d3, d4, this.rm, d2, d5, d6, this.r, d, d7, bl2, n, n2);
                } else {
                    projection = new Projection(string, 3, d3, d4, this.rm, d2, d5, d6, this.r, d, d7, bl2, n, n2);
                }
            } else if (this.modeCalib == 1) {
                Coord[] coordArray = this.getCoo();
                if (coordArray == null) {
                    return;
                }
                projection = bl ? this.oldp : (this.plan.projd != null ? this.plan.projd.copy() : new Projection(string, 3, coordArray[0].al, coordArray[0].del, this.cx, this.cy, coordArray[0].x, coordArray[0].y, this.cx * 2.0, this.cy * 2.0, 0.0, false, 2, this.system));
                projection.modify(string, coordArray);
            } else if (this.modeCalib == 2) {
                String string3 = this.wcsT.getText();
                HeaderFits headerFits = new HeaderFits(string3);
                Calib calib = new Calib(headerFits);
                projection = bl ? this.oldp : new Projection(string, 2, calib.alphai, calib.deltai, this.rm, d2, this.cx, this.cy, this.r, d, this.rot, this.sym, 2, this.system);
                projection.modify(string, calib);
            }
            if (this.plan.hasXYorig) {
                this.plan.pcat.setCoord(projection);
            }
            if (!bl) {
                this.plan.setNewProjD(projection);
            } else {
                this.plan.projd = projection;
            }
            this.plan.co = new Coord(this.raj, this.dej);
            Properties.majProp();
            this.plan.setHasSpecificCalib();
            this.a.view.newView(1);
            this.a.calque.repaintAll();
            this.oldp = projection;
            this.modifyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.setData();
            this.a.log("Recalibration", "[" + this.plan.getLogInfo() + "]");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = string2 == null ? "Calibration error: \n" + exception : "Calibration error\non \"" + string2 + "\" field";
            Aladin.warning(this, string2, 1);
        }
        this.a.view.repaintAll();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!(changeEvent.getSource() instanceof JTabbedPane)) {
            return;
        }
        this.changeMethod();
        if (this.undoButton != null) {
            this.undoButton.setEnabled(this.undoable());
        }
        if (this.redoButton != null) {
            this.redoButton.setEnabled(this.redoable());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.panelMethod == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = ((JButton)object).getActionCommand();
            if (this.CANCEL.equals(string)) {
                this.hide();
            } else if (this.UNDO.equals(string)) {
                try {
                    this.undo();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.REDO.equals(string)) {
                try {
                    this.redo();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.HELP.equals(string)) {
                Aladin.info(this, this.HELPSTRING);
            } else if (this.CLEAR.equals(string)) {
                this.clear();
            } else if (this.RESET.equals(string)) {
                this.reset();
                if (this.modifyButton.getText().equals(this.MODIFY)) {
                    this.modifyButton.setEnabled(false);
                }
            } else if (this.MODIFY.equals(string)) {
                this.setUndo(this.plan.projd);
                this.submit(true);
            } else if (this.SUBMIT.equals(string)) {
                Projection projection = this.plan.projd;
                this.submit(false);
                if (projection != null) {
                    this.setUndo(projection.copy());
                    this.undoButton.setEnabled(true);
                }
                this.modifyButton.setText(this.MODIFY);
            }
        }
        this.undoButton.setEnabled(this.undoable());
        this.redoButton.setEnabled(this.redoable());
    }

    private int getIndexPos(Component component) {
        for (int i = 0; i < this.maxPosT; ++i) {
            if (component != this.xyPosT[i] && component != this.cooPosT[i]) continue;
            return i;
        }
        return -1;
    }

    private void setFocusPos(Component component) {
        int n = this.getIndexPos(component);
        if (this.focusTextField != null) {
            this.focusTextField.setBackground(Color.white);
        }
        if (n == -1) {
            this.focusTextField = null;
            return;
        }
        this.flagXY = component == this.xyPosT[n];
        this.focusTextField = (JTextField)component;
        this.focusTextField.setBackground(Color.yellow);
        String string = this.flagXY ? this.xyPosT[n].getText().trim() : this.cooPosT[n].getText().trim();
        this.setRepere(string, this.flagXY);
        component.requestFocus();
    }

    private void setRepere(String string, boolean bl) {
        Coord coord;
        block7: {
            if (string.length() == 0) {
                return;
            }
            if (bl) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    coord = new Coord();
                    coord.x = Double.valueOf(stringTokenizer.nextToken()) - 0.5;
                    coord.y = Double.valueOf(stringTokenizer.nextToken()) - 0.5;
                    coord.y = (double)this.getHauteur() - coord.y;
                    this.plan.projd.getCoord(coord);
                    if (Double.isNaN(coord.al)) {
                        return;
                    }
                    break block7;
                }
                catch (Exception exception) {
                    return;
                }
            }
            try {
                coord = new Coord(string);
            }
            catch (Exception exception) {
                return;
            }
        }
        this.a.view.setRepere(coord);
    }

    private void changeFocus() {
        int n = this.getIndexPos(this.focusTextField);
        if (n == -1) {
            this.focusTextField = null;
            return;
        }
        this.focusTextField.setBackground(Color.white);
        if (this.focusTextField == this.xyPosT[n]) {
            this.focusTextField = this.cooPosT[n];
            this.flagXY = false;
        } else if (++n == this.maxPosT) {
            this.focusTextField = null;
        } else {
            this.focusTextField = this.xyPosT[n];
            this.flagXY = true;
        }
        if (this.focusTextField != null) {
            this.focusTextField.setBackground(Color.yellow);
            this.focusTextField.requestFocus();
        }
    }

    protected static void test(int n, int n2, int n3, double[] dArray, int[] nArray, double d, double d2) {
        for (int i = 1; i <= 4; ++i) {
            int n4;
            int n5;
            switch (i) {
                case 1: {
                    n5 = n - 1;
                    n4 = n2;
                    break;
                }
                case 2: {
                    n5 = n + 1;
                    n4 = n2;
                    break;
                }
                case 3: {
                    n5 = n;
                    n4 = n2 - 1;
                    break;
                }
                case 4: {
                    n5 = n;
                    n4 = n2 + 1;
                    break;
                }
                default: {
                    n5 = n;
                    n4 = n2;
                }
            }
            if (n5 < 0 || n5 >= W || n4 < 0 || n4 >= W || nArray[n4 * W + n5] != 0 || !(dArray[n4 * W + n5] - d2 > 3.0 * d)) continue;
            nArray[n4 * FrameNewCalib.W + n5] = n3;
            FrameNewCalib.test(n5, n4, n3, dArray, nArray, d, d2);
        }
    }

    protected static PointD[] bestPoint(double[] dArray, Plan plan) throws Exception {
        double d;
        int n;
        int n2;
        int n3 = (int)Math.sqrt(dArray.length);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        int[] nArray = new int[n3 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (!(d5 < dArray[n2 * n3 + n])) continue;
                d5 = dArray[n2 * n3 + n];
                d2 = n;
                d3 = n2;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            d6 = 0.0;
            for (n = 0; n < n3; ++n) {
                d6 += dArray[n2 * n3 + n];
            }
            d7 += d6 / (double)n3;
        }
        double d11 = d7 /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            d9 = 0.0;
            for (n = 0; n < n3; ++n) {
                d9 += (dArray[n2 * n3 + n] - d7) * (dArray[n2 * n3 + n] - d7);
            }
            d10 += d9 / (double)n3;
        }
        d10 /= (double)n3;
        double d12 = d10 = Math.sqrt(d10);
        double d13 = 0.0;
        d7 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d6 = 0.0;
            for (n = 0; n < n3; ++n) {
                if (!(dArray[n2 * n3 + n] - d11 < 4.0 * d12)) continue;
                d6 += dArray[n2 * n3 + n];
                d13 += 1.0;
            }
            d7 += d6 / (double)n3;
        }
        d7 /= d13 / (double)n3;
        d10 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d9 = 0.0;
            for (n = 0; n < n3; ++n) {
                if (!(dArray[n2 * n3 + n] - d11 < 4.0 * d12)) continue;
                d9 += (dArray[n2 * n3 + n] - d7) * (dArray[n2 * n3 + n] - d7);
            }
            d10 += d9 / d13;
        }
        d10 = Math.sqrt(d10);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                nArray[n2 * n3 + n] = 0;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (nArray[n2 * n3 + n] != 0 || !(dArray[n2 * n3 + n] - d7 > 3.0 * d10)) continue;
                nArray[n2 * n3 + n] = ++n4;
                FrameNewCalib.test(n, n2, n4, dArray, nArray, d10, d7);
            }
        }
        double d14 = (double)(n3 * n3) / 2.0;
        int n5 = 1;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (nArray[n2 * n3 + n] == 0 || !(d14 > ((double)n3 / 2.0 - (double)n2) * ((double)n3 / 2.0 - (double)n2) + ((double)n3 / 2.0 - (double)n) * ((double)n3 / 2.0 - (double)n))) continue;
                d14 = ((double)n3 / 2.0 - (double)n2) * ((double)n3 / 2.0 - (double)n2) + ((double)n3 / 2.0 - (double)n) * ((double)n3 / 2.0 - (double)n);
                n5 = nArray[n2 * n3 + n];
            }
        }
        d2 = 0.0;
        d3 = 0.0;
        d8 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (nArray[n2 * n3 + n] != n5) continue;
                d3 += (dArray[n2 * n3 + n] - d7) * (double)n2;
                d2 += (dArray[n2 * n3 + n] - d7) * (double)n;
                d8 += dArray[n2 * n3 + n] - d7;
            }
        }
        if (d8 == 0.0) {
            d2 = (double)n3 / 2.0;
            d3 = (double)n3 / 2.0;
            throw new Exception("Too large source for the centering algorithm");
        }
        n2 = (int)(d3 /= d8);
        n = (int)(d2 /= d8);
        double d15 = dArray[n2 * n3 + n] - d7;
        double d16 = 256.0;
        double d17 = 0.0;
        for (n = 0; n < (int)d2 + 1; ++n) {
            if (!(dArray[n2 * n3 + n] - d7 > 3.0 * d10)) continue;
            d = dArray[n2 * n3 + n] - d7 - d15 / 2.0;
            if (d < 0.0) {
                d = -d;
            }
            if (!(d < d16)) continue;
            d16 = d;
            d17 = d2 - (double)n;
        }
        d4 += d17;
        d16 = 256.0;
        for (n = (int)d2 + 1; n < n3; ++n) {
            if (!(dArray[n2 * n3 + n] - d7 > 3.0 * d10)) continue;
            d = dArray[n2 * n3 + n] - d7 - d15 / 2.0;
            if (d < 0.0) {
                d = -d;
            }
            if (!(d < d16)) continue;
            d16 = d;
            d17 = (double)n - d2;
        }
        d4 += d17;
        n2 = (int)d3;
        n = (int)d2;
        d15 = (double)((int)dArray[n2 * n3 + n] & 0xFF) - d7;
        d16 = 256.0;
        for (n2 = 0; n2 < (int)d3 + 1; ++n2) {
            if (!(dArray[n2 * n3 + n] - d7 > 3.0 * d10)) continue;
            d = dArray[n2 * n3 + n] - d7 - d15 / 2.0;
            if (d < 0.0) {
                d = -d;
            }
            if (!(d < d16)) continue;
            d16 = d;
            d17 = d3 - (double)n2;
        }
        d4 += d17;
        d16 = 256.0;
        for (n2 = (int)d3 + 1; n2 < n3; ++n2) {
            if (!(dArray[n2 * n3 + n] - d7 > 3.0 * d10)) continue;
            d = dArray[n2 * n3 + n] - d7 - d15 / 2.0;
            if (d < 0.0) {
                d = -d;
            }
            if (!(d < d16)) continue;
            d16 = d;
            d17 = (double)n2 - d3;
        }
        d4 += d17;
        double d18 = 2.0 * (d4 /= 4.0);
        double d19 = ((PlanImage)plan).pixelMin;
        double d20 = ((PlanImage)plan).pixelMax;
        d7 *= (d20 - d19) / 256.0;
        PointD[] pointDArray = new PointD[]{new PointD(d2 - (double)n3 / 2.0 + 0.5, d3 - (double)n3 / 2.0 + 0.5), new PointD(d7 += d19, d10 *= (d20 - d19) / 256.0), new PointD(d15 *= (d20 - d19) / 256.0, d18)};
        return pointDArray;
    }

    protected boolean isGettingOriginalXY() {
        return this.plan.hasXYorig && this.flagXY;
    }

    protected PointD mouse(double object, double object2, PlanImage planImage, Position position) {
        String string;
        PointD pointD = null;
        Point point = null;
        if (this.modeCalib != 1) {
            return pointD;
        }
        Aladin.trace(4, "FrameNewCalib.mouse() x=" + object + " y=" + object2 + (position != null ? " source=" + position.id : ""));
        if (this.focusTextField == null) {
            return pointD;
        }
        if (this.plan.isCatalog() && !this.plan.hasXYorig && !Projection.isOk(this.plan.projd)) {
            return pointD;
        }
        if (this.flagXY) {
            if (this.plan.hasXYorig) {
                if (position == null) {
                    Aladin.warning(this.ERRNOXY);
                    return null;
                }
                object = position.x;
                object2 = position.y;
                this.prevObj = position;
            } else {
                if (planImage != this.plan) {
                    Aladin.warning(this.ERRIMG);
                    return null;
                }
                this.prevObj = null;
                try {
                    point = new Point((int)object, (int)object2);
                    double[] dArray = planImage.getPixelStats(point);
                    if (dArray == null) {
                        throw new Exception("IQE autocenter failed => use XY mouse position");
                    }
                    object = dArray[0];
                    object2 = dArray[2];
                }
                catch (Exception exception) {
                    this.a.status.setText(exception.getMessage() + "\n " + this.ERRNOBEST);
                }
            }
            pointD = new PointD((double)object, (double)object2);
            if (this.plan.isImage()) {
                object2 = (double)((PlanImage)this.plan).naxis2 - object2;
            }
            string = Util.myRound("" + object, 4) + "  " + Util.myRound("" + object2, 4);
        } else if (Projection.isOk(this.a.calque.getPlanRef().projd) || this.plan.hasXYorig) {
            String string2 = null;
            if (position != null && position != this.prevObj) {
                string = Coord.getSexa(position.raj, position.dej);
                string2 = Coord.getSexa(position.raj, position.dej, ":");
            } else {
                Object object3;
                Projection projection;
                Plan plan = this.a.calque.getPlanRef();
                Projection projection2 = projection = plan == null || plan.projd == null ? null : plan.projd;
                if (projection == null) {
                    Aladin.warning("No RA/DEC reference plane !");
                    return null;
                }
                try {
                    point = new Point((int)object, (int)object2);
                    object3 = ((PlanImage)plan).getPixelStats(point);
                    if (object3 == null) {
                        throw new Exception("IQE autocenter failed => assume XY mouse");
                    }
                    object = object3[0];
                    object2 = object3[2];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object3 = new Coord();
                ((Coord)object3).x = object;
                ((Coord)object3).y = object2;
                projection.getCoord((Coord)object3);
                if (Double.isNaN(((Coord)object3).al)) {
                    string = "";
                } else {
                    string = Coord.getSexa(((Coord)object3).al, ((Coord)object3).del);
                    string2 = Coord.getSexa(((Coord)object3).al, ((Coord)object3).del, ":");
                }
            }
        } else {
            if (position == null || position == this.prevObj) {
                Aladin.warning("No object near the pointer, try again !!");
                return null;
            }
            string = Coord.getSexa(position.raj, position.dej);
        }
        this.focusTextField.setText(string);
        this.changeFocus();
        return pointD;
    }

    @Override
    public void hide() {
        if (this.plan != null) {
            this.plan = null;
        }
        super.hide();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.hide();
        }
        super.processWindowEvent(windowEvent);
    }

    class FrameNewCalibTextField
    extends JTextField
    implements MouseListener {
        FrameNewCalibTextField() {
            super(15);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FrameNewCalib.this.setFocusPos(this);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void setText(String string) {
            super.setText(string);
            FrameNewCalib.this.modifyButton.setEnabled(true);
            FrameNewCalib.this.resetButton.setEnabled(true);
        }
    }
}

