/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FramePixelExtraction
extends JFrame {
    private Aladin aladin;
    private PlanImage pimg;

    protected FramePixelExtraction(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle("Pixel extraction");
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 15, 10));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createPanel(), "Center");
        this.setLocation(Aladin.computeLocation(this));
        this.pack();
        this.setVisible(true);
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.pimg = (PlanImage)this.aladin.calque.getPlanBase();
        String string = "<center>" + Aladin.chaine.getString("PIXEXTRINFO1") + "<br> <b>Reference image : " + this.pimg.label + "\nNumber of pixels: " + this.pimg.naxis1 * this.pimg.naxis2 + "</b></center>";
        JLabel jLabel = new JLabel(Util.fold(string, 40, true));
        jPanel.add((Component)jLabel, "North");
        string = Aladin.chaine.getString("PIXEXTRINFO2");
        JLabel jLabel2 = new JLabel(Util.fold(string, 40, true), 0);
        jPanel.add((Component)jLabel2, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Aladin.chaine.getString("PIXELEXTRSUBMIT"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePixelExtraction.this.pixelExtraction();
                FramePixelExtraction.this.dispose();
            }
        });
        jPanel2.add(jButton);
        jButton = new JButton(Aladin.chaine.getString("SFCANCEL"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePixelExtraction.this.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void pixelExtraction() {
        try {
            Vector<Plan> vector = this.aladin.calque.getPlanImg();
            int n = this.pimg.naxis1;
            int n2 = this.pimg.naxis2;
            PlanImage[] planImageArray = null;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    planImageArray = new PlanImage[n3 + 1];
                    planImageArray[n4++] = this.pimg;
                }
                for (int j = vector.size() - 1; j >= 0; --j) {
                    PlanImage planImage = (PlanImage)vector.elementAt(j);
                    if (planImage == this.pimg || !planImage.selected || !planImage.hasAvailablePixels() || planImage instanceof PlanBG) continue;
                    if (i == 0) {
                        ++n3;
                        continue;
                    }
                    planImageArray[n4++] = planImage;
                }
            }
            final PlanImage[] planImageArray2 = planImageArray;
            final AladinData aladinData = this.aladin.createAladinCatalog("Pixels");
            aladinData.plan.flagProcessing = true;
            this.aladin.calque.repaintAll();
            new Thread(){

                @Override
                public void run() {
                    try {
                        FramePixelExtraction.this.pixelExtraction(aladinData, planImageArray2);
                    }
                    catch (Exception exception) {
                        FramePixelExtraction.this.aladin;
                        if (Aladin.levelTrace >= 3) {
                            exception.printStackTrace();
                        }
                        aladinData.plan.error = "Pixel extraction error !";
                        FramePixelExtraction.this.aladin;
                        Aladin.warning(aladinData.plan.error);
                    }
                    finally {
                        aladinData.plan.flagProcessing = false;
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("Pixel extraction error !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pixelExtraction(AladinData aladinData, PlanImage[] planImageArray) throws Exception {
        int n;
        int n2 = planImageArray.length + 4;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < planImageArray.length; ++n) {
            stringArray[n] = planImageArray[n].label;
            stringArray2[n] = "double";
        }
        stringArray[n2 - 4] = "X";
        stringArray2[n2 - 4] = "integer";
        stringArray[n2 - 3] = "Y";
        stringArray2[n2 - 3] = "integer";
        stringArray[n2 - 2] = "RAJ2000";
        stringArray2[n2 - 2] = "double";
        stringArray[n2 - 1] = "DEJ2000";
        stringArray2[n2 - 1] = "double";
        aladinData.setName(stringArray);
        aladinData.setDatatype(stringArray2);
        for (n = 0; n < planImageArray.length; ++n) {
            planImageArray[n].setLockCacheFree(true);
            planImageArray[n].pixelsOriginFromCache();
        }
        try {
            double d = Double.NaN;
            double d2 = Double.NaN;
            Coord coord = new Coord();
            String[] stringArray3 = new String[n2];
            int n3 = planImageArray[0].naxis2;
            int n4 = planImageArray[0].naxis1;
            int n5 = n4 * n3 > 10000 ? 9 : 8;
            int n6 = 1;
            boolean bl = Projection.isOk(planImageArray[0].projd);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (bl) {
                        coord.x = (double)j + 0.5;
                        coord.y = (double)i + 0.5;
                        planImageArray[0].projd.getCoord(coord);
                        d = coord.al;
                        d2 = coord.del;
                    }
                    stringArray3[n2 - 2] = d + "";
                    stringArray3[n2 - 1] = d2 + "";
                    coord.x = j;
                    coord.y = i;
                    if (bl) {
                        planImageArray[0].projd.getCoord(coord);
                    }
                    for (int k = 0; k < planImageArray.length; ++k) {
                        int n7;
                        int n8;
                        stringArray3[k] = " ";
                        if (bl && k > 0) {
                            if (!Projection.isOk(planImageArray[k].projd)) continue;
                            planImageArray[k].projd.getXY(coord);
                        }
                        if (!planImageArray[k].isInside(n8 = (int)Math.round(coord.x), n7 = planImageArray[k].naxis2 - (int)Math.round(coord.y) - 1)) continue;
                        stringArray3[k] = planImageArray[k].getPixel(n8, n7) + "";
                    }
                    stringArray3[n2 - 4] = j + 1 + "";
                    stringArray3[n2 - 3] = n3 - i + "";
                    aladinData.addSource("Pix_" + n6++, d, d2, stringArray3).setShape(n5);
                }
            }
            aladinData.objModified();
            aladinData.plan.flagProcessing = false;
        }
        finally {
            for (int i = 0; i < planImageArray.length; ++i) {
                planImageArray[i].setLockCacheFree(false);
            }
        }
    }
}

