/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.ViewSimple;
import cds.aladin.prop.PropPanel;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FramePixelToolbox
extends JFrame {
    protected Aladin aladin;
    private static final int[] W = new int[]{100, 100, 50, 75, 25};
    private PixelLine pVal;
    private PixelLine pCutMin;
    private PixelLine pCutMax;
    private PixelLine pDataMin;
    private PixelLine pDataMax;
    private PixelLine pMin;
    private PixelLine pMax;
    private JTextField bzeroField;
    private JTextField bscaleField;
    private JTextField bitpixField;
    private JTextField blankField;
    private double raw;
    private int bitpix = 0;
    private double bzero = 0.0;
    private double bscale = 1.0;
    private double blank = Double.NaN;
    private double cutMin;
    private double cutMax;
    private double dataMin;
    private double dataMax;
    private ColorModel cm;
    private boolean isTransparent;

    protected FramePixelToolbox(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle("Pixel toolbox");
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.getContentPane().add((Component)this.createPanelTop(), "North");
        this.getContentPane().add((Component)this.createPanelBottom(), "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.aladin.framePixelTool = null;
        }
        super.processWindowEvent(windowEvent);
    }

    private JPanel createPanelTop() {
        PixelLine pixelLine;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(new MyLabel("Physical", "Physical value associated to the raw pixel value", W[0]));
        jPanel2.add(new MyLabel("Raw", "Encoded pixel value", W[1]));
        jPanel2.add(new MyLabel("IndexCM", "Index in the color map (normalized in [cutMin..cutMax])", W[2]));
        jPanel2.add(new MyLabel("R G B", "Color map Red,Green,Blue components", W[3]));
        jPanel2.add(new MyLabel("Color", "Displayed color", W[4]));
        PropPanel.addCouple(jPanel, "", jPanel2, gridBagLayout, gridBagConstraints);
        this.pMin = pixelLine = new PixelLine("Min enc.", "Smallest encodable value", false, false);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        this.pDataMin = pixelLine = new PixelLine("Data min", "Smallest value in the image", false, true);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        this.pCutMin = pixelLine = new PixelLine("Cut min", "Smallest displayed value", false, true);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        this.pVal = pixelLine = new PixelLine("Pixel value", "Pixel value", true, true);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        this.pCutMax = pixelLine = new PixelLine("Cut max", "Largest displayed value", false, true);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        this.pDataMax = pixelLine = new PixelLine("Data max", "Largest value in the image", false, true);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        this.pMax = pixelLine = new PixelLine("Max enc.", "Largest encodable value", false, false);
        PropPanel.addCouple(jPanel, pixelLine.label, pixelLine.getPanel(), gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(459, super.getPreferredSize().height);
    }

    private JPanel createPanelBottom() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createPanelBottomLeft(), "West");
        jPanel.add((Component)this.createPanelBottomRight(), "East");
        return jPanel;
    }

    private JPanel createPanelBottomRight() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel.setLayout(gridBagLayout);
        this.bitpixField = new JTextField(10);
        this.bitpixField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        this.blankField = new JTextField(10);
        this.blankField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        PropPanel.addCouple(jPanel, new JLabel("BITPIX"), this.bitpixField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, new JLabel("BLANK"), this.blankField, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel createPanelBottomLeft() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 5));
        jPanel.setLayout(gridBagLayout);
        this.bzeroField = new JTextField(10);
        this.bzeroField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        this.bscaleField = new JTextField(10);
        this.bscaleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePixelToolbox.this.modify(-1);
            }
        });
        PropPanel.addCouple(jPanel, new JLabel("BZERO"), this.bzeroField, gridBagLayout, gridBagConstraints);
        PropPanel.addCouple(jPanel, new JLabel("BSCALE"), this.bscaleField, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private void modify(int n) {
        try {
            if (this.bzeroField.getText().length() > 0) {
                this.bzero = Double.parseDouble(this.bzeroField.getText());
            }
            if (this.bscaleField.getText().length() > 0) {
                this.bscale = Double.parseDouble(this.bscaleField.getText());
            }
            if (this.blankField.getText().length() > 0) {
                this.blank = this.blankField.getText().equalsIgnoreCase("NaN") ? Double.NaN : Double.parseDouble(this.blankField.getText());
            }
            if (n == 1) {
                this.raw = Double.parseDouble(this.pVal.field[n].getText());
                this.cutMin = Double.parseDouble(this.pCutMin.field[n].getText());
                this.cutMax = Double.parseDouble(this.pCutMax.field[n].getText());
                this.dataMin = Double.parseDouble(this.pDataMin.field[n].getText());
                this.dataMax = Double.parseDouble(this.pDataMax.field[n].getText());
            } else if (n == 0) {
                this.raw = (Double.parseDouble(this.pVal.field[n].getText()) - this.bzero) / this.bscale;
                this.cutMin = (Double.parseDouble(this.pCutMin.field[n].getText()) - this.bzero) / this.bscale;
                this.cutMax = (Double.parseDouble(this.pCutMax.field[n].getText()) - this.bzero) / this.bscale;
                this.dataMin = (Double.parseDouble(this.pDataMin.field[n].getText()) - this.bzero) / this.bscale;
                this.dataMax = (Double.parseDouble(this.pDataMax.field[n].getText()) - this.bzero) / this.bscale;
            }
            if (this.bitpixField.getText().length() > 0) {
                this.bitpix = (int)Double.parseDouble(this.bitpixField.getText());
                this.bitpix = this.bitpix / 8 * 8;
                if (Math.abs(this.bitpix) > 64) {
                    throw new Exception();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume();
    }

    protected void setPixel(ViewSimple viewSimple, double d, double d2) {
        double d3;
        PlanImage planImage = (PlanImage)viewSimple.pref;
        PointD pointD = viewSimple.getPosition(d, d2);
        if (planImage instanceof PlanBG) {
            planImage.projd = viewSimple.projLocal.copy();
            d3 = ((PlanBG)planImage).getPixelInDouble(pointD.x, pointD.y);
        } else {
            int n = (int)Math.floor(pointD.y);
            int n2 = (int)Math.floor(pointD.x);
            if (n < 0 || n >= planImage.naxis2 || n2 < 0 || n2 > planImage.naxis1) {
                d3 = Double.NaN;
            } else if (planImage.pixelsOrigin != null) {
                d3 = planImage.getPixVal(planImage.pixelsOrigin, planImage.bitpix, (planImage.naxis2 - n - 1) * planImage.naxis1 + n2) * planImage.bScale + planImage.bZero;
            } else {
                byte[] byArray;
                if (!planImage.pixelsOriginFromDisk()) {
                    d3 = Double.NaN;
                }
                d3 = !planImage.getOnePixelFromCache(byArray = new byte[planImage.npix], planImage.npix, n2, n) ? Double.NaN : planImage.getPixVal(byArray, this.bitpix, 0) * planImage.bScale + planImage.bZero;
            }
        }
        this.setParams(planImage, d3);
    }

    protected void setParams(PlanImage planImage, double d) {
        this.bzero = planImage.bZero;
        this.bscale = planImage.bScale;
        this.blank = planImage.isBlank ? planImage.blank : Double.NaN;
        this.bitpix = planImage.bitpix;
        this.raw = d == this.blank ? this.blank : (d - this.bzero) / this.bscale;
        this.cutMin = planImage.pixelMin;
        this.cutMax = planImage.pixelMax;
        this.dataMin = planImage.dataMin;
        this.dataMax = planImage.dataMax;
        this.isTransparent = planImage.isTransparent();
        this.cm = planImage.getCM();
        this.resume();
    }

    private void resume() {
        String string;
        if (this.pVal == null) {
            return;
        }
        this.pVal.setValue(this.raw);
        this.pCutMin.setValue(this.cutMin);
        this.pCutMax.setValue(this.cutMax);
        this.pDataMin.setValue(this.dataMin);
        this.pDataMax.setValue(this.dataMax);
        this.bzeroField.setText(Util.myRound(this.bzero));
        this.bscaleField.setText(Util.myRound(this.bscale));
        this.bitpixField.setText(this.bitpix + "");
        this.blankField.setText(this.blank + "");
        this.pMin.setValue(this.dataMin);
        String string2 = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "0" : (this.bitpix == 16 ? "-32768" : (this.bitpix == 32 ? "-2147483648" : (this.bitpix == 64 ? "-2^63" : (this.bitpix == -32 ? Util.myRound("-3.4028235E38", 2) : Util.myRound("-1.7976931348623157E308", 2))))));
        this.pMin.setValue(string2, 1);
        if (this.bzero == 0.0 && this.bscale == 1.0) {
            this.pMin.setValue(string2, 0);
        } else {
            string = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "" + this.bzero : (this.bitpix == 16 ? Util.myRound("" + (-32768.0 * this.bscale + this.bzero), 2) : (this.bitpix == 32 ? Util.myRound("" + (-9.223372036854776E18 * this.bscale + this.bzero), 2) : (this.bitpix == 64 ? Util.myRound("" + (-Math.pow(2.0, 63.0) * this.bscale + this.bzero), 2) : (this.bitpix == -32 ? Util.myRound("" + (-3.4028234663852886E38 * this.bscale + this.bzero), 2) : Util.myRound("" + (-1.7976931348623157E308 * this.bscale + this.bzero), 2))))));
            this.pMin.setValue(string, 0);
        }
        this.pMax.setValue(this.dataMax);
        string = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "255" : (this.bitpix == 16 ? "32767" : (this.bitpix == 32 ? "2147483647" : (this.bitpix == 64 ? "2^63" : (this.bitpix == -32 ? Util.myRound("3.4028235E38", 2) : Util.myRound("1.7976931348623157E308", 2))))));
        this.pMax.setValue(string, 1);
        if (this.bzero == 0.0 && this.bscale == 1.0) {
            this.pMax.setValue(string, 0);
        } else {
            String string3 = this.bitpix == 0 ? "" : (this.bitpix == 8 ? "" + (255.0 * this.bscale + this.bzero) : (this.bitpix == 16 ? Util.myRound("" + (32767.0 * this.bscale + this.bzero), 2) : (this.bitpix == 32 ? Util.myRound("" + (9.223372036854776E18 * this.bscale + this.bzero), 2) : (this.bitpix == 64 ? Util.myRound("" + (Math.pow(2.0, 63.0) * this.bscale + this.bzero), 2) : (this.bitpix == -32 ? Util.myRound("" + (3.4028234663852886E38 * this.bscale + this.bzero), 2) : Util.myRound("" + (Double.MAX_VALUE * this.bscale + this.bzero), 2))))));
            this.pMax.setValue(string3, 0);
        }
        this.aladin.glu.log("PixelToolbox", "");
    }

    class PixelLine {
        JLabel label;
        MyField[] field = new MyField[FramePixelToolbox.access$100().length];

        PixelLine(String string, String string2, boolean bl, boolean bl2) {
            this.label = new JLabel(string);
            Util.toolTip(this.label, string2);
            if (bl) {
                this.label.setFont(this.label.getFont().deriveFont(1));
            }
            for (int i = 0; i < this.field.length; ++i) {
                MyField myField = this.field[i] = new MyField(W[i]);
                if (i == 4) {
                    this.field[i].setOpaque(true);
                }
                myField.setEditable(bl2 && i < 2);
                if (myField.isEditable()) {
                    myField.setActionCommand(i + "");
                    myField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            FramePixelToolbox.this.modify(Integer.parseInt(actionEvent.getActionCommand()));
                        }
                    });
                }
                if (!bl) continue;
                myField.setFont(myField.getFont().deriveFont(1));
            }
        }

        JPanel getPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
            for (int i = 0; i < this.field.length; ++i) {
                jPanel.add(this.field[i]);
            }
            return jPanel;
        }

        void setValue(double d) {
            this.field[0].setText(Double.isNaN(d) || d == FramePixelToolbox.this.blank ? "" : Util.myRound(d * FramePixelToolbox.this.bscale + FramePixelToolbox.this.bzero));
            this.field[1].setText(Double.isNaN(d) ? "NaN" : Util.myRound(d));
            int n = this.getColormapIndex(d);
            this.field[2].setText(n + "");
            if (FramePixelToolbox.this.cm != null) {
                int n2 = FramePixelToolbox.this.cm.getRed(n);
                int n3 = FramePixelToolbox.this.cm.getGreen(n);
                int n4 = FramePixelToolbox.this.cm.getBlue(n);
                this.field[3].setText(String.format("%02X-%02X-%02X", n2, n3, n4));
                this.field[4].setBackground(new Color(n2, n3, n4));
                this.field[4].setOpaque(true);
            } else {
                this.field[3].setText("");
                this.field[4].setBackground(Color.white);
            }
        }

        void setValue(String string, int n) {
            this.field[n].setText(string);
        }

        int getColormapIndex(double d) {
            int n = FramePixelToolbox.this.isTransparent ? 255 : 256;
            int n2 = FramePixelToolbox.this.isTransparent ? 1 : 0;
            double d2 = (double)n / (FramePixelToolbox.this.cutMax - FramePixelToolbox.this.cutMin);
            int n3 = Double.isNaN(d) || d == FramePixelToolbox.this.blank ? 0 : n2 + (d <= FramePixelToolbox.this.cutMin ? 0 : (d >= FramePixelToolbox.this.cutMax ? --n : (int)((d - FramePixelToolbox.this.cutMin) * d2)));
            return n3;
        }
    }

    class MyField
    extends JTextField {
        int width = 75;

        MyField(int n) {
            this.width = n;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, super.getPreferredSize().height);
        }
    }

    class MyLabel
    extends JLabel {
        int width;

        MyLabel(String string, String string2, int n) {
            super(string, 0);
            this.width = 75;
            Util.toolTip(this, string2);
            this.width = n;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, super.getPreferredSize().height);
        }
    }
}

