/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.tools.Util;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameRGB
extends FrameRGBBlink {
    String R;
    String G;
    String B;
    String X;
    String TITLE;
    String INFO;
    String HELP1;
    String RED;
    String GREEN;
    String BLUE;
    String LUM;
    String RSAMPREF;
    String SUBSTR;
    private ButtonGroup cbg;
    private JRadioButton cbDiff;
    private JRadioButton cbX;
    protected JComboBox cR;
    protected JComboBox cG;
    protected JComboBox cB;
    protected JComboBox cL;
    private static String[] WAVEBAND = new String[]{"92CM", "100MU", "60MU", "25MU", "12MU", "z", "2MASS J", "IRSA  J", "H", "K", "IR", "i", "N", "red", "ER", "SR", "E", "F", "green", "V", "g", "blue", "O", "J", "u"};
    private static double[] WAVELEN = new double[]{920000.0, 100.0, 60.0, 25.0, 12.0, 1.0, 1.2, 1.6, 2.2, 0.8, 0.8, 0.8, 0.8, 0.6, 0.6, 0.6, 0.6, 0.6, 0.5, 0.5, 0.5, 0.4, 0.4, 0.4, 0.3};
    private Object[] choicePlanSort = null;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.X = Aladin.chaine.getString("IMGBEST");
        this.TITLE = Aladin.chaine.getString("RGBTITLE");
        this.INFO = Aladin.chaine.getString("RGBINFO");
        this.HELP1 = Aladin.chaine.getString("IMGHELP1");
        this.RED = Aladin.chaine.getString("RGBRED");
        this.GREEN = Aladin.chaine.getString("RGBGREEN");
        this.BLUE = Aladin.chaine.getString("RGBBLUE");
        this.LUM = "Luminosity";
        this.RSAMPREF = Aladin.chaine.getString("RGBRSAMPREF");
        this.SUBSTR = Aladin.chaine.getString("RGBSUBSTR");
        this.R = "R";
        this.G = "G";
        this.B = "B";
    }

    protected FrameRGB(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return 11;
    }

    @Override
    protected int getNb() {
        return 3;
    }

    @Override
    protected String getLabelSelector(int n) {
        return n == 0 ? this.RED : (n == 1 ? this.GREEN : (n == 2 ? this.BLUE : this.LUM));
    }

    @Override
    protected Color getColorLabel(int n) {
        return n == 0 ? Color.red : (n == 1 ? Color.green : (n == 2 ? Color.blue : Color.black));
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(this.RSAMPREF);
        this.cbg = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(this.R);
        jRadioButton.setActionCommand(this.R);
        this.cbg.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton(this.G);
        jRadioButton2.setActionCommand(this.G);
        this.cbg.add(jRadioButton2);
        JRadioButton jRadioButton3 = new JRadioButton(this.B);
        jRadioButton3.setActionCommand(this.B);
        this.cbg.add(jRadioButton3);
        this.cbX = new JRadioButton(this.X);
        this.cbX.setActionCommand(this.X);
        this.cbg.add(this.cbX);
        this.cbX.setSelected(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jPanel2.add(jRadioButton3);
        jPanel2.add(this.cbX);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.cbDiff = new JRadioButton(this.SUBSTR);
        this.cbDiff.setEnabled(false);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbDiff, gridBagConstraints);
        jPanel.add(this.cbDiff);
        gridBagConstraints.fill = 1;
        return jPanel;
    }

    @Override
    protected void reset() {
        this.cbX.setSelected(true);
        super.reset();
    }

    @Override
    protected void adjustWidgets() {
        this.adjustCbDiff();
    }

    private void adjustCbDiff() {
        boolean bl;
        int n = (this.ch[0].getSelectedIndex() > 0 ? 1 : 0) + (this.ch[1].getSelectedIndex() > 0 ? 1 : 0) + (this.ch[2].getSelectedIndex() > 0 ? 1 : 0);
        boolean bl2 = this.cbDiff.isEnabled();
        boolean bl3 = bl = n == 2;
        if (bl2 == bl) {
            return;
        }
        this.cbDiff.setEnabled(bl);
    }

    private double getWaveLen(String string) {
        if (string == null) {
            return Double.MAX_VALUE;
        }
        for (int i = 0; i < WAVEBAND.length; ++i) {
            int n = -1;
            do {
                if ((n = Util.indexOfIgnoreCase(string, WAVEBAND[i], n + 1)) < 0 || n != 0 && Character.isLetter(string.charAt(n - 1)) || n + WAVEBAND[i].length() != string.length() && Character.isLetter(string.charAt(n + WAVEBAND[i].length()))) continue;
                return WAVELEN[i];
            } while (n != -1);
        }
        return Double.MAX_VALUE;
    }

    private void sortPlan() {
        int n;
        Vector<Plan> vector = new Vector<Plan>(this.choicePlan.length);
        int n2 = 0;
        for (n = 0; n < this.choicePlan.length; ++n) {
            if (!this.choicePlan[n].selected) continue;
            ++n2;
        }
        n = n2 <= 1 ? 1 : 0;
        for (int i = 0; i < this.choicePlan.length && vector.size() <= 3; ++i) {
            if (n == 0 && !this.choicePlan[i].selected) continue;
            vector.addElement(this.choicePlan[i]);
        }
        this.choicePlanSort = vector.toArray();
        Arrays.sort(this.choicePlanSort, new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                PlanImage planImage = (PlanImage)object;
                PlanImage planImage2 = (PlanImage)object2;
                double d2 = FrameRGB.this.getWaveLen(planImage.survey());
                return d2 == (d = FrameRGB.this.getWaveLen(planImage2.survey())) ? 0 : (d2 > d ? -1 : 1);
            }
        });
    }

    @Override
    protected synchronized int[] getChoiceOrder() {
        int n = this.getNb();
        this.sortPlan();
        int[] nArray = new int[this.choicePlanSort.length];
        for (int i = 0; i < this.choicePlanSort.length; ++i) {
            nArray[i] = Util.indexInArrayOf(this.choicePlanSort[i], this.choicePlan) + 1;
        }
        this.choicePlanSort = null;
        return nArray;
    }

    @Override
    public void show() {
        this.cR = this.ch[0];
        this.cG = this.ch[1];
        this.cB = this.ch[2];
        super.show();
    }

    @Override
    protected void submit() {
        boolean bl;
        PlanImage planImage = (PlanImage)this.getPlan(this.ch[0]);
        PlanImage planImage2 = (PlanImage)this.getPlan(this.ch[1]);
        PlanImage planImage3 = (PlanImage)this.getPlan(this.ch[2]);
        String string = this.cbg.getSelection().getActionCommand();
        PlanImage planImage4 = string.equals(this.R) ? planImage : (string.equals(this.B) ? planImage3 : (string.equals(this.G) ? planImage2 : null));
        boolean bl2 = bl = this.cbDiff.isEnabled() && this.cbDiff.isSelected();
        if (planImage != null && planImage2 != null && planImage3 != null && planImage4 == null) {
            this.a.console.printCommand("RGB " + Tok.quote(planImage.label) + " " + Tok.quote(planImage2.label) + " " + Tok.quote(planImage3.label));
        }
        this.a.calque.newPlanImageRGB(planImage, planImage2, planImage3, planImage4, null, bl);
        this.hide();
    }
}

