/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGB;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class FrameRGBBlink
extends JFrame
implements ActionListener {
    String SUBMIT;
    String RESET;
    String HELP;
    String CANCEL;
    String NONE;
    Aladin a;
    boolean flagHide = true;
    protected JComboBox[] ch;
    Plan[] choicePlan;
    JButton submitBtn;

    protected void createChaine() {
        this.SUBMIT = Aladin.chaine.getString("IMGCREATE");
        this.RESET = Aladin.chaine.getString("IMGRESET");
        this.HELP = Aladin.chaine.getString("IMGHELP");
        this.CANCEL = Aladin.chaine.getString("IMGCLOSE");
        this.NONE = Aladin.chaine.getString("IMGNONE");
    }

    protected FrameRGBBlink(Aladin aladin) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.getTitre());
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.choicePlan = new Plan[0];
        this.createPanel();
    }

    protected abstract String getTitre();

    protected abstract String getHelp();

    protected abstract String getInformation();

    protected abstract int getNb();

    protected abstract String getLabelSelector(int var1);

    protected abstract Color getColorLabel(int var1);

    protected abstract JPanel getAddPanel();

    protected JButton[] getAddButtons() {
        return null;
    }

    protected abstract int getToolNumber();

    protected void createPanel() {
        JComponent jComponent;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Util.fold("<center>" + this.getInformation() + "</center>", 80, true), 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel2 = new JPanel(gridBagLayout2);
        int n = this.getNb();
        this.ch = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            this.ch[i] = new JComboBox();
            this.ch[i].addActionListener(this);
            this.ch[i].setFont(Aladin.BOLD);
            jComponent = new JLabel(this.getLabelSelector(i));
            jComponent.setForeground(this.getColorLabel(i));
            jComponent.setFont(Aladin.BOLD);
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout2.setConstraints(jComponent, gridBagConstraints);
            jPanel2.add(jComponent);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 10.0;
            gridBagLayout2.setConstraints(this.ch[i], gridBagConstraints);
            jPanel2.add(this.ch[i]);
        }
        if (n <= 6) {
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
        } else {
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setPreferredSize(new Dimension(300, 180));
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel.add(jScrollPane);
        }
        JPanel jPanel3 = this.getAddPanel();
        if (jPanel3 != null) {
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
        }
        jComponent = this.valid();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
    }

    protected void adjustImageChoice(JComboBox jComboBox, int n) {
        int n2 = jComboBox.getSelectedIndex();
        String string = n2 >= 0 ? (String)jComboBox.getItemAt(n2) : null;
        jComboBox.removeAllItems();
        this.setItems(jComboBox);
        if (n >= 0) {
            jComboBox.setSelectedIndex(n);
        } else if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private synchronized void setItems(JComboBox jComboBox) {
        jComboBox.addItem(this.NONE);
        for (int i = 0; i < this.choicePlan.length; ++i) {
            jComboBox.addItem(this.choicePlan[i].label + " - \"" + this.choicePlan[i].objet + "\"");
        }
    }

    protected Plan[] getPlan() {
        Vector<Plan> vector = this.a.calque.getPlanImg();
        if (vector == null) {
            return new PlanImage[0];
        }
        Object[] objectArray = new PlanImage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void reset() {
        for (int i = this.getNb() - 1; i >= 0; --i) {
            this.ch[i].setSelectedIndex(0);
        }
    }

    protected abstract void adjustWidgets();

    protected synchronized int[] getChoiceOrder() {
        int n = this.getNb();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < this.choicePlan.length && n2 < n; ++i) {
            if (!this.choicePlan[i].selected) continue;
            nArray[n2++] = i + 1;
        }
        return nArray;
    }

    @Override
    public void show() {
        this.choicePlan = this.getPlan();
        int n = this.getNb();
        int[] nArray = this.getChoiceOrder();
        if (this instanceof FrameRGB && nArray.length == 2) {
            this.adjustImageChoice(this.ch[0], nArray[0]);
            this.adjustImageChoice(this.ch[1], 0);
            this.adjustImageChoice(this.ch[2], nArray[1]);
        } else {
            for (int i = 0; i < n; ++i) {
                this.adjustImageChoice(this.ch[i], i < nArray.length ? nArray[i] : 0);
            }
        }
        this.adjustWidgets();
        if (this.flagHide) {
            super.show();
        }
        this.flagHide = false;
    }

    protected void toolButtonUp() {
        int n = this.getToolNumber();
        if (n < 0) {
            return;
        }
        this.a.toolBox.setMode(n, 1);
    }

    protected void maj() {
        int n = this.getToolNumber();
        if (n == -1) {
            return;
        }
        if (n == -2 || this.a.toolBox.tool[n].mode == -1) {
            Plan[] planArray = this.getPlan();
            if (!this.flagHide && planArray.length == this.choicePlan.length) {
                return;
            }
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void hide() {
        this.choicePlan = null;
        this.flagHide = true;
        this.toolButtonUp();
        super.hide();
    }

    protected JPanel valid() {
        JButton jButton;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setFont(Aladin.LBOLD);
        Insets insets = new Insets(4, 5, 4, 5);
        JButton[] jButtonArray = this.getAddButtons();
        if (jButtonArray != null) {
            for (int i = 0; i < jButtonArray.length; ++i) {
                jPanel.add(jButtonArray[i]);
                jButtonArray[i].setMargin(insets);
            }
        }
        if (jButtonArray != null) {
            jPanel.add(new JLabel(" - "));
        }
        this.submitBtn = jButton = new JButton(this.SUBMIT);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton = new JButton(this.RESET);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton = new JButton(this.CANCEL);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setMargin(insets);
        jButton = Util.getHelpButton(this, this.getHelp());
        jPanel.add(jButton);
        return jPanel;
    }

    protected Plan getPlan(JComboBox jComboBox) {
        int n = jComboBox.getSelectedIndex() - 1;
        if (n < 0) {
            return null;
        }
        return this.choicePlan[n];
    }

    protected abstract void submit();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.execute(((JButton)object).getActionCommand());
        } else {
            this.adjustWidgets();
        }
    }

    public void execute(String string) {
        if (this.CANCEL.equals(string)) {
            this.hide();
        } else if (this.SUBMIT.equals(string)) {
            this.submit();
        } else if (this.HELP.equals(string)) {
            Aladin.info(this, this.getHelp());
        } else if (this.RESET.equals(string)) {
            this.reset();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.hide();
        }
        super.processWindowEvent(windowEvent);
    }
}

