/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import cds.aladin.MyByteArrayStream;
import cds.aladin.Server;
import cds.aladin.ServerAllVO;
import cds.aladin.ServerGlu;
import cds.aladin.VOResource;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public final class FrameServer
extends JFrame
implements ActionListener,
KeyListener {
    static String TITLE;
    static String INFO;
    static String CHECK;
    static String UNCHECK;
    static String SUBMIT;
    static String CLOSE;
    static String CHECKUNCHECK;
    static String IMGSRV;
    static String CATSRC;
    static String SPECSRV;
    static String TIPSUBMIT;
    static String TIPCLOSE;
    static String FILTER;
    static String RESET;
    static String GO;
    Aladin aladin;
    ServerAllVO discoveryServer;
    JTextField filter = null;
    private JPanel panelScroll;
    private static final String QUERY_NVO = "Query NVO registry";
    private static final String QUERY_WORKSHOP_REGISTRY = "Query workshop registry";
    private static final String REFRESH = "Refresh";
    private static final String MODIFY_ENDPOINT = "Modify registry endpoint";
    private ButtonGroup registryCbg;
    GridBagLayout g;
    GridBagConstraints c;
    protected static String REGISTRY_BASE_URL;
    private static final String URL_RESOLVE_IVORN = "http://esavo.esa.int/registry/GetResource.jsp?identifier=";

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("FSTITLE");
        CHECK = Aladin.chaine.getString("FSCHECK");
        UNCHECK = Aladin.chaine.getString("FSUNCHECK");
        GO = Aladin.chaine.getString("FSGO");
        RESET = Aladin.chaine.getString("RESET");
        FILTER = Aladin.chaine.getString("FSFILTER");
        SUBMIT = Aladin.chaine.getString("FSSUBMIT");
        CLOSE = Aladin.chaine.getString("CLOSE");
        CHECKUNCHECK = Aladin.chaine.getString("FSCHECKUNCHECK");
        IMGSRV = Aladin.chaine.getString("FSIMGSRV");
        CATSRC = Aladin.chaine.getString("FSCATSRC");
        SPECSRV = Aladin.chaine.getString("FSSPECSRV");
        TIPSUBMIT = Aladin.chaine.getString("TIPSUBMIT");
        TIPCLOSE = Aladin.chaine.getString("TIPCLOSE");
    }

    protected FrameServer(Aladin aladin, ServerAllVO serverAllVO) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(TITLE);
        this.discoveryServer = serverAllVO;
        this.aladin = aladin;
        this.setLocation(Aladin.computeLocation(this));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.pack();
        this.setVisible(true);
        serverAllVO.clearStepLabel();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 800);
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        int n = 650;
        int n2 = 500;
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(CHECK);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(UNCHECK);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jPanel2.add(new JLabel("      " + FILTER + ": "));
        this.filter = new JTextField(15);
        jPanel2.add(this.filter);
        this.filter.addKeyListener(this);
        jButton = new JButton(GO);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(RESET);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(CHECKUNCHECK, 0), "North");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.registryCbg = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(QUERY_NVO);
        jPanel4.add(jRadioButton);
        this.registryCbg.add(jRadioButton);
        jRadioButton.setSelected(true);
        jRadioButton.setActionCommand(QUERY_NVO);
        jRadioButton = new JRadioButton(QUERY_WORKSHOP_REGISTRY);
        jPanel4.add(jRadioButton);
        this.registryCbg.add(jRadioButton);
        jRadioButton.setActionCommand(QUERY_WORKSHOP_REGISTRY);
        jButton = new JButton(REFRESH);
        jPanel4.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(MODIFY_ENDPOINT);
        jPanel4.add(jButton);
        jButton.addActionListener(this);
        if (Aladin.PROTO) {
            jPanel3.add((Component)jPanel4, "South");
        }
        jPanel.add((Component)jPanel3, "North");
        this.g = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.panelScroll = new JPanel(this.g);
        JScrollPane jScrollPane = new JScrollPane(this.panelScroll);
        jScrollPane.setSize(n, n2);
        jScrollPane.setBackground(Color.white);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(70);
        this.fillWithServers();
        Aladin.makeAdd(jPanel, jScrollPane, "Center");
        JPanel jPanel5 = new JPanel();
        jButton = new JButton(SUBMIT);
        jPanel5.add(jButton);
        jButton.addActionListener(this);
        jButton.setToolTipText(TIPSUBMIT);
        jButton = new JButton(CLOSE);
        jPanel5.add(jButton);
        jButton.addActionListener(this);
        jButton.setToolTipText(TIPCLOSE);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void fillWithServers() {
        this.panelScroll.removeAll();
        for (int i = 0; i < 3; ++i) {
            int n = i == 0 ? 1 : (i == 1 ? 2 : 4);
            this.c.gridx = 0;
            this.c.gridwidth = 4;
            ++this.c.gridy;
            this.c.weightx = 1.0;
            this.c.weighty = 0.1;
            int n2 = this.c.insets.top;
            this.c.insets.top = 15;
            JLabel jLabel = new JLabel(i == 0 ? IMGSRV : (i == 1 ? CATSRC : SPECSRV));
            jLabel.setFont(Aladin.LITALIC);
            JPanel jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.add(jLabel);
            jPanel.setBackground(i == 0 ? MetaDataTree.LABEL_COL[1] : (i == 1 ? MetaDataTree.LABEL_COL[2] : MetaDataTree.LABEL_COL[3]));
            this.g.setConstraints(jPanel, this.c);
            this.panelScroll.add(jPanel);
            this.c.insets.top = n2;
            int n3 = 0;
            String string = this.filter.getText().trim();
            if (string.length() == 0) {
                string = null;
            }
            for (int j = 0; j < this.aladin.dialog.server.length; ++j) {
                Color color;
                Server server = this.aladin.dialog.server[j];
                if (!server.isDiscovery() || server.type != n) continue;
                if (string != null && Util.indexOfIgnoreCase(server.description, string) < 0) {
                    server.filterAllVO = false;
                    continue;
                }
                server.filterAllVO = true;
                ++n3;
                if (server.cbAllVO == null) {
                    server.cbAllVO = new JCheckBox(server.description);
                    server.cbAllVO.setSelected(true);
                    server.cbAllVO.setOpaque(true);
                }
                int n4 = server.cbAllVO.getPreferredSize().height;
                server.cbAllVO.setPreferredSize(new Dimension(330, n4));
                server.statusAllVO.setFont(Aladin.ITALIC);
                server.statusAllVO.setOpaque(true);
                server.statusAllVO.setPreferredSize(new Dimension(50, n4));
                Color color2 = color = n3 % 2 == 0 ? TwoColorJTable.DEFAULT_ALTERNATE_COLOR : this.getBackground();
                if (server.statusReport == null) {
                    server.statusReport = new JButton(INFO);
                    server.statusReport.setMargin(new Insets(0, 0, 0, 0));
                    server.statusReport.setPreferredSize(new Dimension(20, n4));
                    server.statusReport.addActionListener(this);
                    server.statusReport.setOpaque(true);
                }
                this.c.gridx = 0;
                ++this.c.gridy;
                this.c.gridwidth = 1;
                this.c.weightx = 0.1;
                JLabel jLabel2 = new JLabel((n3 < 10 ? "  " : "") + n3 + ")");
                jLabel2.setOpaque(true);
                jLabel2.setBackground(color);
                jLabel2.setPreferredSize(new Dimension(jLabel2.getPreferredSize().width, n4));
                this.g.setConstraints(jLabel2, this.c);
                this.panelScroll.add(jLabel2);
                ++this.c.gridx;
                this.c.weightx = 0.6;
                server.cbAllVO.setBackground(color);
                this.g.setConstraints(server.cbAllVO, this.c);
                this.panelScroll.add(server.cbAllVO);
                this.c.weightx = 0.2;
                ++this.c.gridx;
                server.statusAllVO.setBackground(color);
                this.g.setConstraints(server.statusAllVO, this.c);
                this.panelScroll.add(server.statusAllVO);
                this.c.weightx = 0.05;
                ++this.c.gridx;
                int n5 = this.c.insets.left;
                this.c.insets.left = 5;
                if (server.statusReport == null) {
                    jLabel2 = new JLabel("");
                    jLabel2.setOpaque(true);
                    jLabel2.setBackground(color);
                    this.g.setConstraints(jLabel2, this.c);
                    this.panelScroll.add(jLabel2);
                } else {
                    server.statusReport.setBackground(color);
                    this.g.setConstraints(server.statusReport, this.c);
                    this.panelScroll.add(server.statusReport);
                }
                this.c.insets.left = n5;
                if (server instanceof ServerGlu && ((ServerGlu)server).actionName.startsWith("IVOA")) continue;
                server.cbAllVO.setFont(server.cbAllVO.getFont().deriveFont(1));
            }
        }
        ++this.c.gridy;
        this.c.gridwidth = 4;
        this.c.weighty = 0.9;
        JLabel jLabel = new JLabel(" ");
        this.g.setConstraints(jLabel, this.c);
        this.panelScroll.add(jLabel);
        this.panelScroll.invalidate();
        this.panelScroll.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof JButton)) {
            return;
        }
        String string = ((JButton)object).getActionCommand();
        if (string.equals(INFO)) {
            for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
                if (object != this.aladin.dialog.server[i].statusReport) continue;
                this.aladin.dialog.server[i].showStatusReport();
            }
        } else if (string.equals(CHECK) || string.equals(UNCHECK)) {
            boolean bl = string.equals(CHECK);
            this.check(-1, bl);
        } else if (string.equals(CLOSE)) {
            this.setVisible(false);
        } else if (string.equals(GO)) {
            this.go();
        } else if (string.equals(RESET)) {
            this.reset();
        } else if (string.equals(REFRESH)) {
            this.refresh();
        } else if (string.equals(SUBMIT)) {
            this.discoveryServer.tree.clear();
            this.discoveryServer.submit();
        } else if (string.equals(MODIFY_ENDPOINT)) {
            this.modifyEndpoint();
        }
    }

    private void go() {
        this.fillWithServers();
        this.pack();
    }

    private void reset() {
        this.filter.setText("");
        for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
            this.aladin.dialog.server[i].statusError = null;
            if (this.aladin.dialog.server[i].statusAllVO == null) continue;
            this.aladin.dialog.server[i].statusAllVO.setText(" ");
        }
        this.fillWithServers();
        this.check(-1, true);
    }

    protected void check(int n, boolean bl) {
        for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
            if (bl && !this.aladin.dialog.server[i].filterAllVO || this.aladin.dialog.server[i].cbAllVO == null || n != -1 && this.aladin.dialog.server[i].type != n) continue;
            this.aladin.dialog.server[i].cbAllVO.setSelected(bl);
        }
    }

    private void modifyEndpoint() {
        String string = (String)JOptionPane.showInputDialog(this, "Enter OAI endpoint (eg http://myserver.org/oai.pl) :", "Registry OAI endpoint", 3, null, null, REGISTRY_BASE_URL);
        if (string != null) {
            REGISTRY_BASE_URL = string;
        }
    }

    private void refresh() {
        Aladin.makeCursor(this, 1);
        this.panelScroll.removeAll();
        this.removeIVOA();
        if (this.registryCbg.getSelection().getActionCommand().equals(QUERY_NVO)) {
            this.aladin.dialog.ivoaServersLoaded = false;
            this.aladin.dialog.appendIVOAServer();
        } else {
            this.appendWorkshopRegistryServers(REGISTRY_BASE_URL, null);
        }
        this.fillWithServers();
        Aladin.makeCursor(this, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendWorkshopRegistryServers(String string, String string2) {
        URL uRL;
        Object object;
        try {
            object = string2 != null ? "resumptionToken=" + URLEncoder.encode(string2) : "metadataPrefix=ivo_vor";
            uRL = new URL(string + "&verb=ListRecords&" + (String)object);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
        object = null;
        try {
            object = new DataInputStream(new BufferedInputStream(uRL.openStream()));
            MyByteArrayStream myByteArrayStream = new MyByteArrayStream();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            KXmlParser kXmlParser = new KXmlParser();
            kXmlParser.setInput(new InputStreamReader((InputStream)object));
            int n = 0;
            while ((n = kXmlParser.next()) != 1) {
                boolean bl;
                if (n != 2 && n != 3) continue;
                String string11 = kXmlParser.getName();
                boolean bl2 = n == 2;
                boolean bl3 = bl = n == 3;
                if (bl2 && (string11.indexOf("ri:Resource") >= 0 || string11.indexOf("vr:Resource") >= 0 || string11.equalsIgnoreCase("resource"))) {
                    string10 = kXmlParser.getAttributeValue(null, "status");
                    if (string10 == null || !string10.equals("active") || (string3 = kXmlParser.getAttributeValue(null, "xsi:type")) == null) continue;
                    string3 = string3.trim();
                    continue;
                }
                if (bl2 && string11.equalsIgnoreCase("capability")) {
                    if (string3 != null && FrameServer.supportType(string3) != null || string10 != null && !string10.equals("active") || (string3 = kXmlParser.getAttributeValue(null, "xsi:type")) == null) continue;
                    string3 = string3.trim();
                    continue;
                }
                if (bl2 && (string11.indexOf("vr:shortName") >= 0 || string11.equalsIgnoreCase("shortName"))) {
                    kXmlParser.next();
                    string4 = kXmlParser.getText();
                    if (string4 == null) continue;
                    string4 = string4.trim();
                    continue;
                }
                if (bl2 && (string11.indexOf("vr:publisher") >= 0 || string11.equalsIgnoreCase("publisher"))) {
                    kXmlParser.next();
                    string5 = kXmlParser.getText();
                    if (string5 == null) continue;
                    string5 = string5.trim();
                    continue;
                }
                if (bl2 && string11.indexOf("vr:accessURL") >= 0) {
                    kXmlParser.next();
                    string6 = kXmlParser.getText();
                    if (string6 == null) continue;
                    string6 = string6.trim();
                    continue;
                }
                if (bl2 && string11.toLowerCase().indexOf("accessurl") >= 0 && string6 == null) {
                    kXmlParser.next();
                    string6 = kXmlParser.getText();
                    if (string6 == null) continue;
                    string6 = string6.trim();
                    continue;
                }
                if (bl2 && (string11.indexOf("vr:title") >= 0 || string11.equalsIgnoreCase("title"))) {
                    kXmlParser.next();
                    string7 = kXmlParser.getText();
                    if (string7 == null) continue;
                    string7 = string7.trim();
                    continue;
                }
                if (bl2 && (string11.indexOf("vr:identifier") >= 0 || string11.equalsIgnoreCase("identifier"))) {
                    kXmlParser.next();
                    string8 = kXmlParser.getText();
                    if (string8 == null) continue;
                    string8 = string8.trim();
                    continue;
                }
                if (bl && (string11.indexOf("oai:record") >= 0 || string11.equalsIgnoreCase("resource"))) {
                    String string12 = FrameServer.supportType(string3);
                    if (string12 != null) {
                        FrameServer.createRecord(myByteArrayStream, string12, string4, string5, string6, string7, string8);
                    }
                    string8 = null;
                    string7 = null;
                    string6 = null;
                    string5 = null;
                    string4 = null;
                    string3 = null;
                    string10 = null;
                    continue;
                }
                if (!bl2 || string11.indexOf("resumptionToken") < 0) continue;
                kXmlParser.next();
                string9 = kXmlParser.getText();
            }
            if (string9 != null) {
                this.appendWorkshopRegistryServers(string, string9);
            }
            this.aladin.dialog.appendServersFromStream(myByteArrayStream.getInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                ((FilterInputStream)object).close();
            }
            catch (IOException iOException) {
                System.out.println("can't close");
            }
        }
    }

    protected static VOResource[] getGluStreamFromIvornList(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            VOResource vOResource = FrameServer.getIvorn(stringArray[i]);
            if (vOResource == null) continue;
            System.out.println(vOResource.desc);
        }
        return arrayList.toArray(new VOResource[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static VOResource getIvorn(String string) {
        URL uRL;
        Object object;
        try {
            object = "";
            uRL = new URL(URL_RESOLVE_IVORN + URLEncoder.encode(string) + (String)object);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        object = null;
        try {
            object = new DataInputStream(new BufferedInputStream(uRL.openStream()));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            KXmlParser kXmlParser = new KXmlParser();
            kXmlParser.setInput(new InputStreamReader((InputStream)object));
            int n = 0;
            while ((n = kXmlParser.next()) != 1) {
                boolean bl;
                if (n != 2 && n != 3) continue;
                String string10 = kXmlParser.getName();
                boolean bl2 = n == 2;
                boolean bl3 = bl = n == 3;
                if (bl2 && (string10.indexOf("ri:Resource") >= 0 || string10.indexOf("vr:Resource") >= 0 || string10.equalsIgnoreCase("resource"))) {
                    string9 = kXmlParser.getAttributeValue(null, "status");
                    if (string9 == null || !string9.equals("active") || (string2 = kXmlParser.getAttributeValue(null, "xsi:type")) == null) continue;
                    string2 = string2.trim();
                    continue;
                }
                if (bl2 && string10.equalsIgnoreCase("capability")) {
                    if (string2 != null && FrameServer.supportType(string2) != null || string9 != null && !string9.equals("active") || (string2 = kXmlParser.getAttributeValue(null, "xsi:type")) == null) continue;
                    string2 = string2.trim();
                    continue;
                }
                if (bl2 && (string10.indexOf("vr:shortName") >= 0 || string10.equalsIgnoreCase("shortName"))) {
                    kXmlParser.next();
                    string3 = kXmlParser.getText();
                    if (string3 == null) continue;
                    string3 = string3.trim();
                    continue;
                }
                if (bl2 && (string10.indexOf("vr:publisher") >= 0 || string10.equalsIgnoreCase("publisher"))) {
                    kXmlParser.next();
                    string4 = kXmlParser.getText();
                    if (string4 == null) continue;
                    string4 = string4.trim();
                    continue;
                }
                if (bl2 && string10.indexOf("vr:accessURL") >= 0 && (string5 == null || string5.length() == 0)) {
                    kXmlParser.next();
                    string5 = kXmlParser.getText();
                    if (string5 == null) continue;
                    string5 = string5.trim();
                    continue;
                }
                if (bl2 && string10.toLowerCase().indexOf("accessurl") >= 0 && (string5 == null || string5.length() == 0)) {
                    kXmlParser.next();
                    string5 = kXmlParser.getText();
                    if (string5 == null) continue;
                    string5 = string5.trim();
                    continue;
                }
                if (bl2 && (string10.indexOf("vr:title") >= 0 || string10.equalsIgnoreCase("title"))) {
                    kXmlParser.next();
                    string6 = kXmlParser.getText();
                    if (string6 == null) continue;
                    string6 = string6.trim();
                    continue;
                }
                if (bl2 && (string10.indexOf("vr:identifier") >= 0 || string10.equalsIgnoreCase("identifier"))) {
                    kXmlParser.next();
                    string7 = kXmlParser.getText();
                    if (string7 == null) continue;
                    string7 = string7.trim();
                    continue;
                }
                if (bl && (string10.indexOf("oai:record") >= 0 || string10.indexOf("Resource") >= 0 && string10.toLowerCase().indexOf("related") < 0)) {
                    String string11 = FrameServer.supportType(string2);
                    VOResource vOResource = new VOResource();
                    vOResource.type = string11 != null ? string11 : string2;
                    vOResource.actionName = string3;
                    vOResource.baseUrl = string5;
                    vOResource.desc = string6;
                    vOResource.identifier = string7;
                    VOResource vOResource2 = vOResource;
                    return vOResource2;
                }
                if (!bl2 || string10.indexOf("resumptionToken") < 0) continue;
                kXmlParser.next();
                string8 = kXmlParser.getText();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                ((FilterInputStream)object).close();
            }
            catch (IOException iOException) {
                System.out.println("can't close");
            }
        }
        return null;
    }

    protected static void createRecord(MyByteArrayStream myByteArrayStream, String string, String string2, String string3, String string4, String string5, String string6) {
        FrameServer.createRecord(myByteArrayStream, string, string2, string3, string4, string5, string6, "IVOA");
    }

    protected static void createRecord(MyByteArrayStream myByteArrayStream, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        myByteArrayStream.write("%ActionName\t" + string7 + "-" + string + "-" + string6);
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Identifier\t" + string6);
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Institute\t" + string3);
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Description\t" + string5.substring(0, Math.min(60, string5.length())));
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Owner\tCDS'aladin");
        myByteArrayStream.write("\n");
        if (string4 != null) {
            if ((string4 = string4.trim()).indexOf(63) < 0) {
                string4 = string4 + "?";
            }
            if (!(string4.endsWith("?") || string4.endsWith("/") || string4.endsWith("&"))) {
                string4 = string4 + "&";
            }
        }
        if (string4 != null && string.equals("ssap")) {
            string4 = string4 + "REQUEST=queryData&";
        }
        if (string.equals("siap")) {
            myByteArrayStream.write("%Url\t" + string4 + "POS=$1,$2&SIZE=$3");
            myByteArrayStream.write("\n");
        } else if (string.equals("ssap")) {
            myByteArrayStream.write("%Url\t" + string4 + "POS=$1,$2&SIZE=$3");
            myByteArrayStream.write("\n");
        } else if (string.equals("cs")) {
            myByteArrayStream.write("%Url\t" + string4 + "RA=$1&DEC=$2&SR=$3&VERB=2");
            myByteArrayStream.write("\n");
        }
        myByteArrayStream.write("%Param.Description\t$1=Right Ascension");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Param.Description\t$2=Declination");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Param.Description\t$3=Radius in deg");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Param.DataType\t$1=Target(RAd)");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Param.DataType\t$2=Target(DEd)");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Param.DataType\t$3=Field(RADIUSd)");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Param.Value\t$3=0.17");
        myByteArrayStream.write("\n");
        if (string.equals("cs")) {
            myByteArrayStream.write("%ResultDataType\tMime(text/xml)");
            myByteArrayStream.write("\n");
        } else if (string.equals("ssap")) {
            myByteArrayStream.write("%ResultDataType\tMime(ssa/xml)");
            myByteArrayStream.write("\n");
        } else if (string.equals("siap")) {
            myByteArrayStream.write("%ResultDataType\tMime(sia/xml)");
            myByteArrayStream.write("\n");
        }
        myByteArrayStream.write("%Aladin.Label\t" + string5.substring(0, Math.min(60, string5.length())));
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Aladin.Menu\tIVOA...");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%Aladin.LabelPlane\t" + string + string2 + " $1");
        myByteArrayStream.write("\n");
        myByteArrayStream.write("%DistribDomain\tALADIN");
        myByteArrayStream.write("\n");
    }

    private static String supportType(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.toLowerCase()).indexOf("simpleimageaccess") >= 0) {
            return "siap";
        }
        if (string.indexOf("simplespec") >= 0) {
            return "ssap";
        }
        if (string.indexOf("conesearch") >= 0 || string.indexOf("tabularskyservice") >= 0) {
            return "cs";
        }
        return null;
    }

    private String getServiceType(String string) {
        if (string.indexOf("\"active\"") < 0) {
            return null;
        }
        int n = string.indexOf("xsi:type=");
        if (n < 0) {
            return null;
        }
        if ((n = (string = string.substring(n + 10)).indexOf("\"")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String getActionName(String string) {
        int n = string.indexOf("<vr:shortName>");
        if (n < 0) {
            return null;
        }
        string = string.substring(n + 14);
        n = string.indexOf(32);
        int n2 = string.indexOf(60);
        if (n < 0) {
            return string.substring(0, n2);
        }
        if (n2 < 0) {
            return string.substring(0, n);
        }
        return string.substring(0, Math.min(n, n2));
    }

    private String getInstitute(String string) {
        int n = string.indexOf("<vr:publisher>");
        if (n < 0) {
            return null;
        }
        int n2 = (string = string.substring(n + 14)).indexOf(60);
        if (n2 >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    private String getBaseUrl(String string) {
        int n = string.indexOf(">");
        if (n < 0) {
            return null;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(60)) < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getDesc(String string) {
        int n = string.indexOf(">");
        if (n < 0) {
            return null;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(60)) < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getIdentifier(String string) {
        int n = string.indexOf(">");
        if (n < 0) {
            return null;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(60)) < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getResumptionToken(String string) {
        int n = string.indexOf(">");
        if (n < 0) {
            return null;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(60)) < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private void removeIVOA() {
        int n;
        Server[] serverArray = this.aladin.dialog.server;
        for (n = 0; !(n >= serverArray.length || serverArray[n] instanceof ServerGlu && ((ServerGlu)serverArray[n]).actionName.startsWith("IVOA")); ++n) {
        }
        Server[] serverArray2 = new Server[n];
        System.arraycopy(serverArray, 0, serverArray2, 0, n);
        this.aladin.dialog.server = serverArray2;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.go();
        }
    }

    static {
        INFO = " ? ";
        REGISTRY_BASE_URL = "http://manaslu.star.le.ac.uk/astrogrid-registry/OAIHandlerv1_0?set=ivo_managed";
    }
}

