/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Glu;
import cds.aladin.GluApp;
import cds.aladin.VOToolDescription;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FrameVOTool
extends JFrame
implements ActionListener,
KeyListener {
    private Aladin aladin;
    private VOToolDescription voForm;
    private JList voList;
    private JButton install;
    private JButton run;
    private JButton remove;
    protected JButton apply;
    protected static String INSTALL;
    protected static String NEWINSTALL;
    protected static String REINSTALL;
    protected static String REMOVE;
    protected static String INTERRUPT;
    protected static String NEW;
    protected static String __NEW__;
    protected static String WARNING;
    protected static String DELCONF;
    protected static String DOWNLOADMAN;
    protected static String DISCARD;
    protected static String NOYET;
    protected static String CANNOT;
    protected static String APPLY;
    protected static String RUN;
    protected static String CLOSE;
    protected static String JARMAN;

    static void display(Aladin aladin) {
        if (aladin.frameVOTool == null) {
            aladin.frameVOTool = new FrameVOTool(aladin);
        }
        aladin.frameVOTool.setVisible(true);
    }

    protected void createChaine(Chaine chaine) {
        INSTALL = "Install...";
        NEWINSTALL = "Install new release...";
        REINSTALL = "Re-install...";
        REMOVE = "Delete...";
        INTERRUPT = "Interrupt!";
        __NEW__ = "__New__";
        NEW = "New...";
        APPLY = "Apply";
        RUN = "Run...";
        CLOSE = "Close";
        WARNING = "This list shows a selection of VO tools compatible with Aladin. These softwares are able to cooperate with Aladin by exchanging data, cross selecting sources...\nSelect, install if required, or define yourself (Running directory + Command line) the VO applications  directly runnable from the Aladin menu.\nContact directly the authors for any questions, bugs...";
        DELCONF = "You are going to delete local description of this VO tool.\nDo you want to continue ?";
        DOWNLOADMAN = "This application requires a dedicated installation method.\nFollow the author instructions and after you successfully installed\nthe application, specify manually the command line\nand the running directory.";
        JARMAN = "Aladin is going to download this following jar file\n Do you want to continue ?\n \n";
        DISCARD = "Discard your modifications ?";
        NOYET = "This installation method is not supported\nby your Aladin version";
        CANNOT = "Cannot install this application";
    }

    private FrameVOTool(Aladin aladin) {
        Aladin.setIcon(this);
        this.createChaine(Aladin.chaine);
        this.setTitle("VOTool Application installer & controller");
        this.aladin = aladin;
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FrameVOTool.this.close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.setLocation(50, 100);
        this.pack();
    }

    private JPanel createPanel() {
        JButton jButton;
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.voList = new JList(new VOList());
        this.voList.setVisibleRowCount(10);
        this.voList.setFixedCellWidth(100);
        this.voList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FrameVOTool.this.selectionne();
            }
        });
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea jTextArea = new JTextArea(WARNING);
        jPanel.add((Component)jTextArea, "North");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setFont(Aladin.ITALIC);
        jTextArea.setBackground(this.getContentPane().getBackground());
        jPanel.add((Component)new JScrollPane(this.voList), "West");
        this.voForm = new VOToolDescription(this.aladin, this);
        jPanel.add((Component)this.voForm, "Center");
        JPanel jPanel2 = new JPanel();
        this.install = jButton = new JButton(INSTALL);
        jPanel2.add(jButton);
        jButton.setFont(jButton.getFont().deriveFont(1));
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameVOTool.this.install();
            }
        });
        this.apply = jButton = new JButton(APPLY);
        jPanel2.add(jButton);
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameVOTool.this.apply();
            }
        });
        this.run = jButton = new JButton(RUN);
        jPanel2.add(jButton);
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameVOTool.this.run();
            }
        });
        this.remove = jButton = new JButton(REMOVE);
        jPanel2.add(jButton);
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameVOTool.this.remove();
            }
        });
        jPanel2.add(new JLabel("      "));
        jButton = new JButton(NEW);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameVOTool.this.nouveau();
            }
        });
        jButton = new JButton(CLOSE);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameVOTool.this.close();
            }
        });
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void setButtonMode(GluApp gluApp) {
        this.install.setEnabled(gluApp != null && gluApp.canBeInstall());
        this.run.setEnabled(gluApp != null && gluApp.canBeRun());
        if (gluApp != null) {
            if (gluApp.isDownloading()) {
                this.install.setText(INTERRUPT);
            } else {
                this.install.setText(gluApp.hasNewRelease() ? NEWINSTALL : (gluApp.dir != null ? REINSTALL : INSTALL));
            }
        }
        this.apply.setEnabled(gluApp != null && this.voForm.hasBeenChanged());
        this.remove.setEnabled(gluApp != null && !gluApp.isDownloading());
    }

    private void apply() {
        GluApp gluApp = this.voForm.apply();
        this.setButtonMode(gluApp);
        if (gluApp.tagGlu.equals(__NEW__)) {
            int n = gluApp.aladinLabel.indexOf(32);
            if (n == -1) {
                n = gluApp.aladinLabel.indexOf(58);
            }
            if (n == -1) {
                n = gluApp.aladinLabel.indexOf(45);
            }
            if (n == -1) {
                n = gluApp.aladinLabel.length();
            }
            gluApp.tagGlu = gluApp.aladinLabel.substring(0, n);
            this.listUpdate();
        }
        this.aladin.glu.writeGluAppDic();
        this.aladin.VOReload();
    }

    private void close() {
        if (!this.discard()) {
            return;
        }
        this.setVisible(false);
    }

    protected void downloadEnd() {
        this.aladin.glu.writeGluAppDic();
        this.aladin.VOReload();
        this.selectionne();
    }

    private boolean discard() {
        if (this.voForm.hasBeenChanged()) {
            return Aladin.confirmation(this, DISCARD);
        }
        return true;
    }

    protected void selectionne() {
        String string = (String)this.voList.getSelectedValue();
        GluApp gluApp = this.aladin.glu.getGluApp(this.aladin.glu.findGluApp(string));
        this.voForm.setEditable(false);
        if (this.voForm.vo != gluApp && !this.discard()) {
            return;
        }
        this.voForm.setVOtool(gluApp);
        if (gluApp.tagGlu.equals(__NEW__)) {
            this.voForm.setEditable(true);
        }
        this.setButtonMode(gluApp);
    }

    protected void selectionne(GluApp gluApp) {
        int n = this.aladin.glu.findGluApp(gluApp.tagGlu);
        if (n < 0) {
            return;
        }
        this.voList.setSelectedIndex(n);
        this.voForm.setVOtool(gluApp);
        this.setButtonMode(gluApp);
    }

    private void nouveau() {
        if (!this.discard()) {
            return;
        }
        GluApp gluApp = this.aladin.glu.addApplication(__NEW__);
        this.listUpdate();
        this.selectionne(gluApp);
        this.voForm.setEditable(true);
    }

    private void install() {
        GluApp gluApp = this.voForm.vo;
        if (gluApp.isDownloading()) {
            gluApp.interrupt();
            return;
        }
        if (gluApp.getInstallMode() == 1) {
            if (!Aladin.confirmation(this, JARMAN + "\n - Url: " + gluApp.jarUrl + "\n - Target: " + this.aladin.getVOPath() + "\n")) {
                return;
            }
        }
        int n = gluApp.install();
        switch (n) {
            case 0: {
                Aladin.warning(this, CANNOT);
                break;
            }
            case -1: {
                Util.pause(1000);
                Aladin.info(this, DOWNLOADMAN);
                break;
            }
            case -2: {
                Aladin.warning(this, NOYET);
            }
        }
        this.aladin.glu.writeGluAppDic();
        this.aladin.log("VOinstall", gluApp.tagGlu + " " + (n == 1 ? "Ok" : "Error"));
        this.voForm.setVOtool(gluApp);
        this.setButtonMode(gluApp);
    }

    private void run() {
        GluApp gluApp = this.voForm.vo;
        gluApp.exec();
    }

    private void listUpdate() {
        Glu cfr_ignored_0 = this.aladin.glu;
        ((VOList)this.voList.getModel()).listListener.contentsChanged(new ListDataEvent(this, 0, 0, Glu.vGluApp.size()));
    }

    private void remove() {
        String string = (String)this.voList.getSelectedValue();
        if (!Aladin.confirmation(this, DELCONF)) {
            return;
        }
        this.aladin.glu.removeGluApp(string);
        this.voList.setSelectedIndex(0);
        this.listUpdate();
        this.selectionne();
        this.aladin.glu.writeGluAppDic();
        this.aladin.VOReload();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setButtonMode(this.voForm.vo);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.setButtonMode(this.voForm.vo);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class VOList
    implements ListModel {
        protected ListDataListener listListener;

        VOList() {
        }

        public Object getElementAt(int n) {
            Glu cfr_ignored_0 = ((FrameVOTool)FrameVOTool.this).aladin.glu;
            return ((GluApp)Glu.vGluApp.elementAt((int)n)).tagGlu;
        }

        @Override
        public int getSize() {
            Glu cfr_ignored_0 = ((FrameVOTool)FrameVOTool.this).aladin.glu;
            return Glu.vGluApp.size();
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listListener = listDataListener;
        }
    }
}

