/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Tok;
import cds.tools.Util;

public class Function {
    private StringBuffer name = new StringBuffer();
    private StringBuffer param = new StringBuffer();
    private StringBuffer code = new StringBuffer();
    private StringBuffer description = new StringBuffer();
    private boolean localDefinition = false;
    private boolean bookmark = false;
    private int nbParam = -1;
    private int etat = 0;
    private int nbAcc = 0;
    private boolean NL = true;
    private boolean modif = false;

    public Function() {
    }

    public Function(String string, String string2, String string3, String string4) {
        this.setName(string);
        this.setParam(string2);
        this.setCode(string3);
        this.setDescription(string4);
    }

    public Function(String string) throws Exception {
        if (!this.parseFunction(string)) {
            throw new Exception("Function truncated [" + string + "]");
        }
    }

    public String getName() {
        return this.name.toString().trim();
    }

    public String getCode() {
        return this.code.toString();
    }

    public String getParam() {
        return this.param.toString();
    }

    public String getDescription() {
        return this.description.toString();
    }

    public void setName(String string) {
        this.name = new StringBuffer(string == null ? "" : string);
        this.modif = true;
    }

    public void setCode(String string) {
        this.code = new StringBuffer(string == null ? "" : string);
        this.modif = true;
    }

    public void setParam(String string) {
        this.param = new StringBuffer(string == null ? "" : string);
        this.nbParam = -1;
        this.modif = true;
    }

    public void setDescription(String string) {
        this.description = new StringBuffer(string == null ? "" : string);
        this.modif = true;
    }

    public void setLocalDefinition(boolean bl) {
        this.localDefinition = bl;
    }

    public void setBookmark(boolean bl) {
        this.bookmark = bl;
    }

    public boolean isLocalDefinition() {
        return this.localDefinition;
    }

    public boolean isBookmark() {
        return this.bookmark;
    }

    public void setModif(boolean bl) {
        this.modif = bl;
    }

    public boolean hasBeenModif() {
        return this.modif;
    }

    public int getNbParam() {
        if (this.nbParam < 0) {
            if (this.param.toString().trim().length() == 0) {
                this.nbParam = 0;
            } else {
                this.nbParam = 1;
                for (int i = this.param.length() - 1; i >= 0; --i) {
                    if (this.param.charAt(i) != ',') continue;
                    ++this.nbParam;
                }
            }
        }
        return this.nbParam;
    }

    public boolean isOk() {
        return this.etat == 6;
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.description.length() > 0 ? "#" + this.description + string : "");
        stringBuffer.append("function " + this.getName());
        if (this.getNbParam() > 0) {
            stringBuffer.append("(" + this.param + ")");
        }
        stringBuffer.append(" {" + string);
        String string2 = this.getCode();
        if (!string.equals("\n")) {
            string2 = string2.replaceAll("\n", string);
        }
        stringBuffer.append(string2);
        stringBuffer.append(string + "}" + string);
        return stringBuffer.toString();
    }

    public String exec(Aladin aladin, String string, boolean bl) throws Exception {
        String string2 = this.getCodeWithParam(aladin, string);
        if (bl) {
            aladin.execAsyncCommand(string2);
        } else {
            aladin.execCommand(string2);
        }
        return "";
    }

    private String getCodeWithParam(Aladin aladin, String string) throws Exception {
        String string2 = this.getCode();
        Tok tok = new Tok(this.getParam(), ", ");
        Tok tok2 = new Tok(string, ", ");
        while (tok.hasMoreTokens()) {
            String string3 = tok.nextToken();
            String string4 = tok2.nextToken();
            string4 = this.targetRadiusSpecialCase(aladin, string3, string4);
            string2 = string2.replaceAll("\\" + string3, string4);
        }
        return string2;
    }

    private String targetRadiusSpecialCase(Aladin aladin, String string, String string2) {
        if (string2.length() == 0) {
            if (string.equals("$TARGET")) {
                return this.getTarget(aladin);
            }
            if (string.equals("$RADIUS")) {
                return this.getRadius(aladin);
            }
        }
        return string2;
    }

    protected String getTarget(Aladin aladin) {
        String string = "";
        try {
            string = aladin.localisation.getTextSaisie().trim();
            if (string.length() == 0 || string.equals(aladin.GETOBJ) || aladin.command.isCommand(new Tok(string).nextToken())) {
                string = aladin.view.getCurrentView().getCentre();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected String getRadius(Aladin aladin) {
        String string = "";
        try {
            double d = Util.round(aladin.view.getCurrentView().getTaille() * 60.0, 1);
            string = d + "'";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected boolean parseFunction(String string) throws Exception {
        int n;
        this.modif = true;
        char[] cArray = string.toCharArray();
        block9: for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            if (c == '\r') continue;
            if (this.etat != 5 && this.etat != -1 && c == '\n') {
                c = ' ';
            }
            switch (this.etat) {
                case -1: {
                    if (c == '\n' || n == cArray.length - 1) {
                        this.etat = 0;
                    }
                    if (c == 10) continue block9;
                    this.description.append(c);
                    continue block9;
                }
                case 0: {
                    if (Character.isSpaceChar(c)) continue block9;
                    if (c == '#') {
                        this.etat = -1;
                        continue block9;
                    }
                    if (!string.substring(n, n + 8).equals("function")) {
                        throw new Exception("Function syntax error [" + string + "]");
                    }
                    this.etat = 1;
                    n += 7;
                    continue block9;
                }
                case 1: {
                    if (Character.isSpaceChar(c)) continue block9;
                    this.etat = 2;
                }
                case 2: {
                    if (c == '(') {
                        this.etat = 4;
                        continue block9;
                    }
                    if (c == '{') {
                        this.etat = 5;
                        this.nbAcc = 1;
                        continue block9;
                    }
                    this.name.append(c);
                    continue block9;
                }
                case 3: {
                    if (Character.isSpaceChar(c)) continue block9;
                    if (c == '(') {
                        this.etat = 4;
                        continue block9;
                    }
                    if (c == '{') {
                        this.etat = 5;
                        this.nbAcc = 1;
                        continue block9;
                    }
                    throw new Exception("function syntax error [" + string + "]");
                }
                case 4: {
                    if (c == ')') {
                        this.etat = 3;
                        continue block9;
                    }
                    this.param.append(c);
                    continue block9;
                }
                case 5: {
                    if (c == '{') {
                        ++this.nbAcc;
                    } else if (c == '}') {
                        --this.nbAcc;
                    }
                    if (this.nbAcc == 0) {
                        this.etat = 6;
                        if (this.NL && this.code.length() > 0) {
                            this.code.delete(this.code.length() - 1, this.code.length());
                        }
                        return true;
                    }
                    if (this.NL && (c == 10 || c == ' ')) continue block9;
                    if (this.NL) {
                        this.code.append("   ");
                    }
                    this.NL = c == '\n';
                    this.code.append(c);
                    if (n != cArray.length - 1 || this.NL) continue block9;
                    this.code.append('\n');
                    this.NL = true;
                }
            }
        }
        n = this.code.indexOf("get allsky");
        if (n > 0) {
            this.code = this.code.replace(n + 4, n + 10, "hips");
        }
        return false;
    }
}

