/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Configuration;
import cds.aladin.GluApp;
import cds.aladin.MyInputStream;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.ServerGlu;
import cds.aladin.ServerSkybot;
import cds.aladin.Tok;
import cds.aladin.TreeNode;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.TreeNodeCategory;
import cds.tools.UrlLoader;
import cds.tools.Util;
import cds.vizier.VizieRQuery;
import java.awt.Dimension;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Glu
implements Runnable {
    private static int MAXPROF = 6;
    private static final int CHECKTIMEOUT = 1000;
    protected static String LOGSCRIPT = "nph-alalog.pl";
    protected static String ALADINLOG = "http://aladin.u-strasbg.fr/java/" + LOGSCRIPT;
    protected static String NPHGLU = "nph-glu.pl";
    protected static String NPHGLUALADIN = "http://aladin.u-strasbg.fr/java/" + NPHGLU;
    private static String KONQUEROR = "konqueror";
    private String[] BROWSERS = new String[]{"firefox", "mozilla", "netscape", "Netscape", KONQUEROR, "google-chrome"};
    static String BROWSER = null;
    public Aladin aladin;
    Thread thread;
    String param;
    static int nWindow = 0;
    static boolean newWindow = false;
    protected Hashtable aladinDic = null;
    protected Hashtable<String, GluTest> aladinDicT = null;
    protected Hashtable aladinDicFilters = null;
    protected static Vector vGluServer;
    protected static Vector vGluApp;
    protected static Vector<TreeNodeAllsky> vGluSky;
    protected static Vector vGluCategory;
    private static final String GLUDICPARAM = "?param=-p+-a+-w+Z:ALADIN";
    private static Method openURL;
    protected ServerGlu lastGluServer = null;
    private String lastA = null;
    protected Vector AlaSites = new Vector();
    private boolean flagNoGlu;
    public static final int URL = 0;
    public static final int ENCODE = 1;
    public static final int NOURL = 2;
    private boolean chut = false;
    private String lastId = null;
    private String indId = null;
    private boolean flagVers;
    private boolean lock = false;
    private int logCpt = 0;
    private Object lockLog = new Object();

    protected void tri() {
        Comparator comparator = TreeNode.getComparator();
        Collections.sort(vGluSky, comparator);
        Collections.sort(vGluCategory, comparator);
        comparator = Server.getComparator();
        Collections.sort(vGluServer, comparator);
    }

    protected Glu(Aladin aladin) {
        this.aladin = aladin;
        this.aladinDic = new Hashtable();
        this.aladinDicT = new Hashtable();
        vGluServer = new Vector(50);
        vGluApp = new Vector(10);
        vGluSky = new Vector(10);
        vGluCategory = new Vector(10);
        try {
            String string = aladin.configuration.get(Configuration.GLU);
            if (string != null) {
                NPHGLUALADIN = string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Aladin.STANDALONE) {
            try {
                if (Aladin.NETWORK) {
                    DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + Aladin.ALAGLU));
                    this.loadGluDic(dataInputStream, false, false);
                    dataInputStream.close();
                    this.testNetwork();
                }
            }
            catch (Exception exception) {
                Aladin.warning("AlaGlu.dic not found !", 1);
            }
            this.addVOGluFile();
            this.addOtherGluFiles();
        }
        if (Aladin.NETWORK) {
            this.getRemoteGluDic();
        }
        this.tri();
    }

    protected void testNetwork() {
        if (!Aladin.TESTNETWORK) {
            return;
        }
        new Thread("Network test"){

            @Override
            public void run() {
                try {
                    Aladin.trace(3, "Testing network...");
                    if (!Glu.this.testCurrentAlaSite() && !Glu.this.testAlaSites(true, false)) {
                        Aladin cfr_ignored_0 = Glu.this.aladin;
                        Aladin.info(Aladin.chaine.getString("NONET"));
                    } else {
                        Glu.this.flagNoGlu = true;
                    }
                }
                catch (Exception exception) {
                    Aladin cfr_ignored_1 = Glu.this.aladin;
                    Aladin.info(Aladin.chaine.getString("No full network access !"));
                    Glu.this.flagNoGlu = true;
                }
            }
        }.start();
    }

    void reload(boolean bl, boolean bl2) {
        int n;
        if (bl) {
            Aladin.cache.clear();
            this.aladin.glu = new Glu(this.aladin);
        }
        ServerDialog serverDialog = this.aladin.dialog;
        Point point = null;
        Dimension dimension = null;
        int n2 = this.aladin.dialog.current;
        try {
            point = this.aladin.dialog.getLocationOnScreen();
            dimension = this.aladin.dialog.getSize();
        }
        catch (Exception exception) {
            point = null;
        }
        VizieRQuery.resetKeywords();
        this.aladin.gluSkyReload();
        this.aladin.dialog = new ServerDialog(this.aladin);
        if (bl2 && (n = this.aladin.dialog.getLastGluServerIndice()) != -1) {
            n2 = n;
        }
        this.aladin.dialog.setCurrent(n2);
        if (point != null) {
            this.aladin.dialog.flagSetPos = true;
            this.aladin.dialog.setLocation(point);
            this.aladin.dialog.setSize(dimension);
        }
        if (serverDialog.isVisible() || bl2) {
            this.aladin.dialog.showNow();
        }
        serverDialog.dispose();
    }

    private void addOtherGluFiles() {
        if (Aladin.GLUFILE == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(Aladin.GLUFILE, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                DataInputStream dataInputStream;
                File file = new File(string);
                boolean bl = false;
                try {
                    InputStream inputStream = null;
                    if (string.startsWith("http://")) {
                        inputStream = Util.openStream(string);
                    } else {
                        inputStream = new FileInputStream(file);
                        bl = true;
                    }
                    dataInputStream = new DataInputStream(inputStream);
                }
                catch (Exception exception) {
                    dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + string));
                }
                if (dataInputStream == null) {
                    throw new Exception();
                }
                if (!this.loadGluDic(dataInputStream, false, bl)) {
                    throw new Exception();
                }
                Aladin.trace(1, "Additionnal " + (bl ? "local" : "remote") + " Glu dic loaded [" + string + "]");
                dataInputStream.close();
            }
            catch (Throwable throwable) {
                System.err.println("Cannot load the Glu dictionary: [" + string + "]");
            }
        }
    }

    private void getRemoteGluDic() {
        URL uRL = null;
        try {
            uRL = Aladin.STANDALONE ? new URL(NPHGLUALADIN + GLUDICPARAM) : new URL(Aladin.CGIPATH + "/" + NPHGLU + GLUDICPARAM);
            Aladin.trace(1, "Loading the remote glu dictionary");
            Aladin.trace(3, "  => " + uRL);
            InputStream inputStream = Aladin.cache.get(uRL);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.loadGluDic(dataInputStream, true, false);
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            System.err.println("Remote Glu dictionary not reached");
        }
    }

    static String quote(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("'");
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[i]);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    private void setBrowser() {
        String[] stringArray = new String[2];
        String string = this.aladin.configuration.get(Configuration.BROWSER);
        if (string != null) {
            BROWSER = string;
            return;
        }
        for (int i = 0; i < this.BROWSERS.length; ++i) {
            stringArray[0] = this.BROWSERS[i];
            stringArray[1] = "-v";
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                int n = process.exitValue();
                if (n != 0) continue;
                BROWSER = this.BROWSERS[i];
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Aladin.warning(Aladin.chaine.getString("NOBROWSER"));
        BROWSER = "";
    }

    protected void newWindow(boolean bl) {
        newWindow = bl;
    }

    protected void showDocument(String string, String string2) {
        this.showDocument(string, string2, false);
    }

    protected void showDocument(String string) {
        if (!Aladin.STANDALONE) {
            return;
        }
        try {
            this.showDocument(new URL(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showDocument(String string, String string2, boolean bl) {
        URL uRL = this.getURL(string, string2, bl);
        if (uRL == null) {
            return;
        }
        this.showDocument(uRL);
    }

    private void showDocument(URL uRL) {
        String string = "";
        if (!Aladin.isApplet()) {
            String[] stringArray = new String[3];
            if (newWindow) {
                string = ",aladin-" + nWindow;
                ++nWindow;
            }
            String string2 = System.getProperty("os.name");
            Aladin.trace(1, "Launching the browser for [" + string2 + "]");
            if (string2 != null && string2.startsWith("Windows")) {
                try {
                    stringArray[0] = "rundll32";
                    stringArray[1] = "url.dll,FileProtocolHandler";
                    stringArray[2] = uRL.toString();
                    Aladin.trace(2, "trying: " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2]);
                    Process process = Runtime.getRuntime().exec(stringArray);
                }
                catch (Exception exception) {
                    Aladin.warning(Aladin.chaine.getString("ERRORBROWSER") + " " + exception);
                }
            } else if (string2 != null && string2.startsWith("Mac")) {
                try {
                    if (openURL == null) {
                        Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                        openURL = clazz.getDeclaredMethod("openURL", String.class);
                    }
                    openURL.invoke(null, uRL.toString());
                }
                catch (Exception exception) {
                    Aladin.warning(Aladin.chaine.getString("ERRORBROWSER") + " " + exception);
                }
            } else {
                if (BROWSER == null) {
                    this.setBrowser();
                }
                if (BROWSER.length() == 0) {
                    return;
                }
                try {
                    if (BROWSER.indexOf(KONQUEROR) >= 0) {
                        byte by;
                        String string3 = "dcop " + KONQUEROR + "*";
                        Process process = Runtime.getRuntime().exec(string3);
                        InputStream inputStream = process.getInputStream();
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((by = (byte)inputStream.read()) != -1 && by != 13 && by != 10) {
                            stringBuffer.append((char)by);
                        }
                        process.waitFor();
                        if (process.exitValue() == 0 && stringBuffer.toString().indexOf(KONQUEROR) >= 0) {
                            string3 = "dcop " + stringBuffer + " konqueror-mainwindow#1 openURL " + uRL;
                            Aladin.trace(2, "Trying: " + string3);
                            process = Runtime.getRuntime().exec(string3);
                            process.waitFor();
                            if (process.exitValue() == 0) {
                                return;
                            }
                        }
                        Aladin.trace(2, "Trying: " + KONQUEROR + " " + uRL);
                        process = Runtime.getRuntime().exec(KONQUEROR + " " + uRL.toString());
                    } else {
                        if (BROWSER.indexOf("chrome") >= 0) {
                            String string4 = BROWSER + " " + uRL.toString();
                            Aladin.trace(2, string4);
                            Process process = Runtime.getRuntime().exec(string4);
                            process.waitFor();
                            if (process.exitValue() == 0) {
                                return;
                            }
                            throw new Exception("Can not launch Chrome browser !");
                        }
                        stringArray[0] = BROWSER;
                        stringArray[1] = "-remote";
                        stringArray[2] = "openURL(" + uRL.toString() + string + ")";
                        Aladin.trace(2, "Trying: " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2]);
                        Process process = Runtime.getRuntime().exec(stringArray);
                        process.waitFor();
                        if (process.exitValue() == 0) {
                            return;
                        }
                        Aladin.trace(2, "Trying: " + stringArray[0] + " " + uRL);
                        process = Runtime.getRuntime().exec(BROWSER + " " + uRL.toString());
                    }
                }
                catch (Exception exception) {
                    System.out.println("Browser launching problem : " + exception);
                }
            }
            return;
        }
        Aladin.trace(1, "Opening a new browser page");
        try {
            if (newWindow) {
                this.aladin.getAppletContext().showDocument(uRL, string);
            } else {
                this.aladin.getAppletContext().showDocument(uRL, "aladin");
            }
        }
        catch (Exception exception) {
            System.err.println("showDocument() error : " + exception);
        }
    }

    static int afterWord(char[] cArray, int n) {
        while (n < cArray.length && cArray[n] != ' ' && cArray[n] != '\t' && cArray[n] != '\n') {
            ++n;
        }
        return n == cArray.length ? -1 : n;
    }

    static int afterSpace(char[] cArray, int n) {
        while (n < cArray.length && (cArray[n] == ' ' || cArray[n] == '\t' || cArray[n] == '\n')) {
            ++n;
        }
        return n == cArray.length ? -1 : n;
    }

    static String getName(String string) {
        char[] cArray = string.toCharArray();
        if (cArray[0] != '%') {
            return null;
        }
        int n = Glu.afterWord(cArray, 1);
        if (n == -1) {
            return null;
        }
        return new String(cArray, 1, n - 1);
    }

    static String getValue(String string, DataInputStream dataInputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String(string);
        char[] cArray = string2.toCharArray();
        int n = Glu.afterWord(cArray, 0);
        if (n == -1) {
            return null;
        }
        if ((n = Glu.afterSpace(cArray, n)) == -1) {
            return null;
        }
        while (cArray[cArray.length - 1] == '\\') {
            block8: {
                stringBuffer.append(cArray, n, cArray.length - n - 1);
                try {
                    while ((string2 = dataInputStream.readLine()) != null && (string2.charAt(0) == '#' || string2.trim().length() == 0)) {
                    }
                    if (string2 == null) {
                    }
                    break block8;
                }
                catch (Exception exception) {
                    string2 = null;
                }
                break;
            }
            cArray = string2.toCharArray();
            n = Glu.afterSpace(cArray, 0);
        }
        if (string2 != null) {
            stringBuffer.append(cArray, n, cArray.length - n);
        }
        return stringBuffer.toString();
    }

    static String getNumParam(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && (cArray[n2] < '0' || cArray[n2] > '9'); ++n2) {
        }
        for (n = n2 + 1; n < cArray.length && cArray[n] >= '0' && cArray[n] <= '9'; ++n) {
        }
        return n < cArray.length ? new String(cArray, n2, n - n2) : "";
    }

    static String getValParam(String string) {
        int n;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length && cArray[n] != ':' && cArray[n] != '='; ++n) {
        }
        return n < cArray.length ? new String(cArray, n + 1, cArray.length - n - 1) : string;
    }

    protected int findGluSky(String string) {
        return this.findGluSky(string, 0);
    }

    protected int findGluSky(String string, int n) {
        int n2;
        TreeNodeAllsky treeNodeAllsky;
        int n3;
        for (n3 = vGluSky.size() - 1; n3 >= 0; --n3) {
            treeNodeAllsky = vGluSky.elementAt(n3);
            if (string.equals(treeNodeAllsky.id) || string.equals(treeNodeAllsky.label) || string.equals(treeNodeAllsky.internalId)) {
                return n3;
            }
            if (n == 1 && Util.indexOfIgnoreCase(treeNodeAllsky.label, string) >= 0) {
                return n3;
            }
            if (n != 2) continue;
            if (treeNodeAllsky.internalId != null && treeNodeAllsky.internalId.endsWith(string)) {
                return n3;
            }
            n2 = treeNodeAllsky.label.lastIndexOf(47);
            if (!string.equals(treeNodeAllsky.label.substring(n2 + 1))) continue;
            return n3;
        }
        if (n == 2) {
            for (n3 = vGluSky.size() - 1; n3 >= 0; --n3) {
                treeNodeAllsky = vGluSky.elementAt(n3);
                n2 = treeNodeAllsky.label.lastIndexOf(47);
                if (Util.indexOfIgnoreCase(treeNodeAllsky.label.substring(n2 + 1), string) < 0) continue;
                return n3;
            }
        }
        return -1;
    }

    protected TreeNodeAllsky getGluSky(int n) {
        TreeNodeAllsky treeNodeAllsky = vGluSky.elementAt(n);
        return treeNodeAllsky;
    }

    private int findGluServer(String string) {
        for (int i = vGluServer.size() - 1; i >= 0; --i) {
            ServerGlu serverGlu = (ServerGlu)vGluServer.elementAt(i);
            if (serverGlu == null || serverGlu.actionName == null || !string.equals(serverGlu.actionName)) continue;
            return i;
        }
        return -1;
    }

    protected boolean removeGluServer(String string) {
        int n = this.findGluServer(string);
        if (n == -1) {
            return false;
        }
        vGluServer.removeElementAt(n);
        return true;
    }

    protected int findGluApp(String string) {
        for (int i = vGluApp.size() - 1; i >= 0; --i) {
            GluApp gluApp = (GluApp)vGluApp.elementAt(i);
            if (string.equals(gluApp.tagGlu)) {
                return i;
            }
            if (gluApp.aladinLabel == null || !string.equals(gluApp.aladinLabel)) continue;
            return i;
        }
        return -1;
    }

    protected GluApp getGluApp(String string) {
        for (int i = vGluApp.size() - 1; i >= 0; --i) {
            GluApp gluApp = (GluApp)vGluApp.elementAt(i);
            if (!string.equals(gluApp.tagGlu)) continue;
            return gluApp;
        }
        return null;
    }

    protected GluApp getGluApp(int n) {
        return (GluApp)vGluApp.elementAt(n);
    }

    protected boolean removeGluApp(String string) {
        int n = this.findGluApp(string);
        if (n == -1) {
            return false;
        }
        vGluApp.removeElementAt(n);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeGluAppDic() {
        RandomAccessFile randomAccessFile = null;
        try {
            Comparator comparator;
            String string = this.aladin.getVOPath() + Util.FS + "VOTools.dic";
            File file = new File(string);
            file.delete();
            randomAccessFile = new RandomAccessFile(string, "rw");
            Enumeration<Object> enumeration = vGluApp.elements();
            while (enumeration.hasMoreElements()) {
                comparator = (GluApp)enumeration.nextElement();
                randomAccessFile.writeBytes(((GluApp)comparator).getGluDic());
            }
            enumeration = vGluSky.elements();
            while (enumeration.hasMoreElements()) {
                comparator = (TreeNodeAllsky)enumeration.nextElement();
                if (!((TreeNodeAllsky)comparator).isLocalDef()) continue;
                randomAccessFile.writeBytes(((TreeNodeAllsky)comparator).getGluDic());
            }
            Aladin.trace(3, string + " successfully saved");
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private void addVOGluFile() {
        try {
            String string = this.aladin.getVOPath() + Util.FS + "VOTools.dic";
            File file = new File(string);
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            if (dataInputStream == null) {
                throw new Exception();
            }
            if (!this.loadGluDic(dataInputStream, false, true)) {
                throw new Exception();
            }
            Aladin.trace(1, "VOTools Glu dic loaded [" + string + "]");
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void memoApplication(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17) {
        GluApp gluApp = this.getGluApp(string);
        if (gluApp != null) {
            gluApp.merge(string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string16, 3);
        } else {
            vGluApp.addElement(new GluApp(this.aladin, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string15, string12, string13, string14, string16, string17, 3));
        }
    }

    protected GluApp addApplication(String string) {
        this.removeGluApp(string);
        GluApp gluApp = new GluApp(this.aladin, string);
        vGluApp.addElement(gluApp);
        return gluApp;
    }

    protected String[] getAppMenu() {
        String[] stringArray = new String[vGluApp.size()];
        Enumeration enumeration = vGluApp.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            GluApp gluApp = (GluApp)enumeration.nextElement();
            if (gluApp.canBeMenu()) {
                stringArray[n] = Util.slash(gluApp.aladinLabel != null ? gluApp.aladinLabel : gluApp.tagGlu);
            }
            ++n;
        }
        return stringArray;
    }

    protected String[] getGluSkyMenu() {
        String[] stringArray = new String[vGluSky.size()];
        Enumeration<TreeNodeAllsky> enumeration = vGluSky.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TreeNodeAllsky treeNodeAllsky = enumeration.nextElement();
            stringArray[n] = treeNodeAllsky.path != null ? treeNodeAllsky.path : treeNodeAllsky.label;
            ++n;
        }
        return stringArray;
    }

    private void memoGluSky(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        int n = this.findGluSky(string);
        if (n >= 0 && bl) {
            System.err.println("Allsky [" + string + ":" + string6 + "] redefined => Aladin will use the last one (remote)");
        }
        String string16 = string3.replace("/", "\\/");
        String string17 = string12 == null ? string16 : string12 + "/" + string16;
        TreeNodeAllsky treeNodeAllsky = new TreeNodeAllsky(this.aladin, string, string2, string4, string5, string3, string6, string7, string8, string9, string10, string11, string17, string14, string15);
        if (n < 0) {
            vGluSky.addElement(treeNodeAllsky);
        } else {
            vGluSky.setElementAt(treeNodeAllsky, n);
        }
    }

    private void memoTree(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string3 == null || !string3.startsWith("WP5:/")) {
            return;
        }
        string3 = string3.substring(5);
        Enumeration enumeration = vGluCategory.elements();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            if (!treeNode.id.equals(string)) continue;
            vGluCategory.remove(treeNode);
            break;
        }
        vGluCategory.addElement(new TreeNodeCategory(this.aladin, string, string2, string3, string4, string5, string6));
    }

    private void memoServer(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, String string9, String string10, Vector vector, String string11, String string12, String string13, StringBuffer stringBuffer, String string14) {
        Object object;
        int n;
        if (this.removeGluServer(string)) {
            System.err.println("Server [" + string + ":" + string2 + "] redefined => Aladin will use the last one (remote)");
        }
        if (hashtable == null) {
            return;
        }
        int n2 = hashtable.size();
        String[] stringArray = new String[n2];
        for (n = 1; n <= n2; ++n) {
            stringArray[n - 1] = (String)hashtable.get(n + "");
        }
        String[] stringArray2 = new String[n2];
        for (n = 1; n <= n2; ++n) {
            stringArray2[n - 1] = (String)hashtable2.get(n + "");
        }
        String[] stringArray3 = new String[n2];
        for (n = 1; n <= n2; ++n) {
            stringArray3[n - 1] = (String)hashtable3.get(n + "");
        }
        String[] stringArray4 = null;
        if (vector != null && (n2 = vector.size()) > 0) {
            stringArray4 = new String[n2];
            object = vector.elements();
            for (n = 0; n < n2; ++n) {
                stringArray4[n] = (String)object.nextElement();
            }
        }
        if (string13 != null && string13.trim().length() == 0) {
            string13 = null;
        }
        if (string10 == null) {
            string10 = string2;
        }
        object = null;
        if (this.aladin != null) {
            object = string.equals("SkyBoT.IMCCE") ? new ServerSkybot(this.aladin, string, string2, string3, string4, string5, string6, string7, string8, stringArray, stringArray2, stringArray3, string9, string10, stringArray4, string11, stringBuffer) : new ServerGlu(this.aladin, string, string2, string3, string4, string5, string6, string7, string8, stringArray, stringArray2, stringArray3, string9, string10, stringArray4, string11, string12, string13, stringBuffer, string14);
            vGluServer.addElement(object);
            if (!((Server)object).isHidden()) {
                this.lastGluServer = object;
            }
        }
    }

    private static String subCR(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (n2 < cArray.length - 1 && cArray[n2] == '\\' && cArray[n2 + 1] == 'n') {
                cArray[n] = 10;
                ++n2;
            } else {
                cArray[n] = cArray[n2];
            }
            ++n2;
            ++n;
        }
        return new String(cArray, 0, n).trim();
    }

    protected boolean loadGluDic(DataInputStream dataInputStream, boolean bl, boolean bl2) {
        return this.loadGluDic(dataInputStream, 0, bl, true, bl2);
    }

    private boolean isKey(String string, String string2) {
        return this.isKey(string, string2, false);
    }

    private boolean isKey(String string, String string2, boolean bl) {
        if (bl) {
            try {
                String string3 = this.aladin.configuration.getLang();
                if (string3.length() > 0 && string.equalsIgnoreCase(string2 + string3)) {
                    return true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return string.equalsIgnoreCase(string2);
    }

    protected boolean loadGluDic(DataInputStream dataInputStream, int n, boolean bl, boolean bl2, boolean bl3) {
        return this.loadGluDic(dataInputStream, n, bl, bl2, bl3, true);
    }

    protected boolean loadGluDic(DataInputStream dataInputStream, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = this.lastA;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        String string19 = null;
        String string20 = null;
        String string21 = null;
        String string22 = null;
        String string23 = null;
        String string24 = null;
        String string25 = null;
        String string26 = null;
        String string27 = null;
        String string28 = null;
        String string29 = null;
        String string30 = null;
        String string31 = null;
        Vector<String> vector = new Vector<String>();
        Hashtable<String, String> hashtable = null;
        Hashtable<String, String> hashtable2 = null;
        Hashtable<Object, String> hashtable3 = null;
        Vector<String> vector2 = null;
        String string32 = null;
        String string33 = null;
        String string34 = null;
        String string35 = null;
        StringBuffer stringBuffer = null;
        boolean bl5 = false;
        boolean bl6 = !bl;
        boolean bl7 = false;
        String string36 = null;
        boolean bl8 = false;
        boolean bl9 = false;
        int n2 = Integer.MAX_VALUE;
        hashtable = new Hashtable<String, String>();
        hashtable2 = new Hashtable<String, String>();
        hashtable3 = new Hashtable<Object, String>(10);
        vector2 = new Vector<String>(10);
        try {
            String string37;
            if (n > MAXPROF) {
                throw new Exception("Cyclic GLU definitions");
            }
            while ((string21 = dataInputStream.readLine()) != null) {
                String string38;
                Object object;
                String string39;
                String string40;
                if (string21.equals("") || string21.charAt(0) == '#' || (string40 = Glu.getName(string21)) == null || (string39 = Glu.getValue(string21, dataInputStream)) == null) continue;
                if (!bl2) {
                    if (this.isKey(string40, "A") || this.isKey(string40, "ActionName")) {
                        if (bl5) {
                            bl5 = false;
                        }
                        object = new StringTokenizer(string39);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string37 = ((StringTokenizer)object).nextToken();
                            if (this.aladinDic.get(string37) == null) continue;
                            bl5 = true;
                            Aladin.trace(3, "GLU record overwrite ignored: " + string39);
                            break;
                        }
                    }
                    if (bl5) continue;
                }
                if (stringBuffer != null && !this.isKey(string40, "A") && !this.isKey(string40, "ActionName")) {
                    stringBuffer.append("%" + Util.fillWithBlank(string40, 4) + " " + string39 + "\n");
                }
                if (this.isKey(string40, "Aladin.Menu", true)) {
                    string14 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.Tree", true)) {
                    string29 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.UrlDemo")) {
                    string30 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.Protocol")) {
                    string31 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "SkyFraction")) {
                    string34 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "ReleaseNumber")) {
                    string3 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Download")) {
                    string7 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Jar")) {
                    string6 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Id")) {
                    string2 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Webstart")) {
                    string8 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Applet")) {
                    string9 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "JavaParam")) {
                    string10 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Dir")) {
                    string11 = string39;
                    continue;
                }
                if (this.isKey(string40, "Aladin.Activated")) {
                    string12 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.Survey")) {
                    string32 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.HpxParam")) {
                    string33 = Glu.subCR(string39);
                    bl9 = true;
                    continue;
                }
                if (this.isKey(string40, "Aladin.Bookmarks")) {
                    string35 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "System")) {
                    string13 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "M.C", true) || this.isKey(string40, "Copyright", true)) {
                    string4 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Copyright.Url", false)) {
                    string5 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.MenuNumber")) {
                    string15 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.LabelPlane", true)) {
                    string17 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.Logo")) {
                    string28 = Glu.subCR(string39);
                    continue;
                }
                if (this.isKey(string40, "Aladin.Filter")) {
                    vector2.addElement(Glu.subCR(string39));
                    continue;
                }
                if (this.isKey(string40, "F.U", true) || this.isKey(string40, "Doc.User", true)) {
                    string18 = string39;
                    continue;
                }
                if (this.isKey(string40, "D", true) || this.isKey(string40, "Description", true)) {
                    string22 = string39;
                    continue;
                }
                if (this.isKey(string40, "M.D", true) || this.isKey(string40, "M.V", true) || this.isKey(string40, "VD", true) || this.isKey(string40, "VerboseDescr", true)) {
                    string23 = string39;
                    continue;
                }
                if (this.isKey(string40, "Acknowledgement", true) || this.isKey(string40, "Ack", true)) {
                    string24 = string39;
                    continue;
                }
                if (this.isKey(string40, "R") || this.isKey(string40, "ResultDataType")) {
                    string25 = string39;
                    continue;
                }
                if (this.isKey(string40, "A") || this.isKey(string40, "ActionName")) {
                    if (string26 != null) {
                        vector.addElement(string26);
                        object = new StringTokenizer(string);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string37 = ((StringTokenizer)object).nextToken();
                            this.aladinDic.put(string37, "%I " + string26);
                        }
                    }
                    if (this.hasValidProfile(string36, string29, bl8) && bl6) {
                        if (this.aladin != null && string35 != null) {
                            this.aladin.bookmarks.memoGluBookmarks(string, string35);
                        } else if (bl9) {
                            this.memoGluSky(bl4, string, string2, string16, string15, string19, string22, string23, string24, string36, string4, string5, string29, string32, string33, string34);
                        } else if (string29 != null) {
                            this.memoTree(string, string22, string29, string19, string18, string30);
                        } else if (bl8) {
                            this.memoApplication(string, string16, string15, string22, string23, string27, string3, string4, string18, string6, string10, string7, string8, string9, string11, string12, string13);
                        } else if (bl7) {
                            this.memoServer(string, string22, string23, string14, string15, string16, string17, string18, hashtable, hashtable2, hashtable3, string25, string27, vector2, string28, string11, bl3 ? string13 : null, stringBuffer, string31);
                        }
                    }
                    bl6 = !bl;
                    bl7 = false;
                    bl8 = false;
                    bl9 = false;
                    string31 = null;
                    string36 = null;
                    string29 = null;
                    string30 = null;
                    if (!bl7) {
                        this.putAladinFilter(string, vector2);
                    }
                    n2 = Integer.MAX_VALUE;
                    string34 = null;
                    string2 = null;
                    string35 = null;
                    string33 = null;
                    string32 = null;
                    string28 = null;
                    string27 = null;
                    string20 = null;
                    string19 = null;
                    string26 = null;
                    string18 = null;
                    string17 = null;
                    string16 = null;
                    string15 = null;
                    string14 = null;
                    string25 = null;
                    string24 = null;
                    string23 = null;
                    string22 = null;
                    string = null;
                    string12 = null;
                    string13 = null;
                    string11 = null;
                    string9 = null;
                    string8 = null;
                    string7 = null;
                    string10 = null;
                    string6 = null;
                    string3 = null;
                    string5 = null;
                    string4 = null;
                    hashtable = new Hashtable();
                    hashtable2 = new Hashtable();
                    hashtable3 = new Hashtable(10);
                    vector2 = new Vector(10);
                    string = Glu.subCR(Glu.getValue(string21, dataInputStream));
                    stringBuffer = new StringBuffer(1000);
                    stringBuffer.append("%" + Util.fillWithBlank(string40, 4) + " " + string + "\n");
                    continue;
                }
                if (string != null && (string40.equals("T") || string40.equals("Test"))) {
                    string20 = string39;
                    object = new StringTokenizer(string);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string37 = ((StringTokenizer)object).nextToken();
                        try {
                            if (this.aladinDicT.get(string37) != null) continue;
                            this.aladinDicT.put(string37, new GluTest(string20, string40.equals("Test")));
                        }
                        catch (Exception exception) {
                            if (Aladin.levelTrace < 3) continue;
                            exception.printStackTrace();
                        }
                    }
                    continue;
                }
                if (string40.equals("U") || string40.equals("Url")) {
                    string19 = string39;
                    object = new StringTokenizer(string);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        this.aladinDic.put(((StringTokenizer)object).nextToken(), string19);
                    }
                    continue;
                }
                if (string40.equals("L") || string40.equals("FullTextResult")) {
                    string19 = string39;
                    object = new StringTokenizer(string);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        this.aladinDic.put(((StringTokenizer)object).nextToken(), string19);
                    }
                    continue;
                }
                if (string40.equals("I") || string40.equals("SeeAction")) {
                    int n3 = 0;
                    int n4 = 0;
                    if (string40.equals("I")) {
                        n4 = string39.indexOf(58);
                        if (n4 > 0) {
                            try {
                                n3 = Integer.parseInt(string39.substring(n4 + 1));
                            }
                            catch (Exception exception) {
                                n3 = 10000;
                            }
                        } else {
                            n4 = string39.length();
                        }
                    } else {
                        n4 = string39.indexOf(32);
                        if (n4 > 0) {
                            try {
                                n3 = Integer.parseInt(string39.substring(n4 + 14));
                            }
                            catch (Exception exception) {
                                n3 = 10000;
                            }
                        } else {
                            n4 = string39.length();
                        }
                    }
                    string38 = string39.substring(0, n4);
                    if (n3 < n2) {
                        n2 = n3;
                        string26 = string38 + (string26 == null ? "" : "\t" + string26);
                    } else {
                        string26 = (string26 == null ? "" : string26 + "\t") + string38;
                    }
                    this.memoAlaSites(string, string39.substring(0, n4));
                    continue;
                }
                if (string40.equals("Aladin.Label") || string40.equals("Aladin.XLabel")) {
                    string16 = Glu.subCR(string39);
                    bl7 = true;
                    continue;
                }
                if (string40.equals("Aladin.Name")) {
                    string16 = Glu.subCR(string39);
                    continue;
                }
                if (string40.equals("Aladin.Profile")) {
                    string36 = string39;
                    bl7 = true;
                    bl9 |= string39.indexOf("hpx") >= 0;
                    continue;
                }
                if (string40.equals("Aladin.VOLabel")) {
                    string16 = Glu.subCR(string39);
                    bl8 = true;
                    continue;
                }
                if (string40.equals("Z") || string40.equals("DistribDomain")) {
                    if (!Glu.getValue(string21, dataInputStream).equals("ALADIN")) continue;
                    bl6 = true;
                    continue;
                }
                if (string40.equals("P.D") || string40.equals("Param.Description")) {
                    hashtable.put(Glu.getNumParam(string39), Glu.getValParam(string39));
                    continue;
                }
                if (string40.equals("P.K") || string40.equals("Param.DataType")) {
                    hashtable2.put(Glu.getNumParam(string39), Glu.getValParam(string39));
                    continue;
                }
                if (string40.equals("M.I") || string40.equals("Institute")) {
                    string27 = string39;
                    continue;
                }
                if (!string40.equals("P.V") && !string40.equals("Param.Value")) continue;
                object = Glu.getNumParam(string39);
                string37 = Glu.getValParam(string39);
                string38 = (String)hashtable3.get(object);
                string38 = string38 != null ? string38 + "\t" + string37 : string37;
                hashtable3.put(object, string38);
            }
            dataInputStream.close();
            if (string26 != null) {
                vector.addElement(string26);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    this.aladinDic.put(stringTokenizer.nextToken(), "%I " + string26);
                }
            }
            if (this.hasValidProfile(string36, string29, bl8) && bl6) {
                if (string35 != null) {
                    this.aladin.bookmarks.memoGluBookmarks(string, string35);
                } else if (bl9) {
                    this.memoGluSky(bl4, string, string2, string16, string15, string19, string22, string23, string24, string36, string4, string5, string29, string32, string33, string34);
                } else if (string29 != null) {
                    this.memoTree(string, string22, string29, string19, string18, string30);
                } else if (bl8) {
                    this.memoApplication(string, string16, string15, string22, string23, string27, string3, string4, string18, string6, string10, string7, string8, string9, string11, string12, string13);
                } else if (bl7) {
                    this.memoServer(string, string22, string23, string14, string15, string16, string17, string18, hashtable, hashtable2, hashtable3, string25, string27, vector2, string28, string11, bl3 ? string13 : null, stringBuffer, string31);
                }
            }
            if (!bl7) {
                this.putAladinFilter(string, vector2);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string26 = (String)enumeration.nextElement();
                string37 = new StringTokenizer(string26, "\t").nextToken();
                if (this.aladinDic.get(string37) != null) continue;
                this.lastA = string37;
                this.loadRemoteGluRecord(string37, n + 1);
            }
        }
        catch (Exception exception) {
            System.err.println("loadGluDic error: " + exception);
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void put(String string, String string2) {
        this.aladinDic.put(string, string2);
    }

    public String get(String string) {
        return (String)this.aladinDic.get(string);
    }

    private boolean isComparator(char c) {
        return c == '<' || c == '>';
    }

    private boolean hasValidNumVersion(String string) {
        block16: {
            if (this.aladin == null) {
                return true;
            }
            double d = this.aladin.realNumVersion("v9.033a");
            int n = 0;
            int n2 = 0;
            try {
                if (string.charAt(n2) == '<') {
                    n = -2;
                    ++n2;
                } else if (string.charAt(n2) == '>') {
                    n = 2;
                    ++n2;
                } else if (string.charAt(n2) == '=') {
                    n = 0;
                    ++n2;
                }
                if (string.charAt(n2) == '=') {
                    n /= 2;
                    ++n2;
                }
                double d2 = Double.parseDouble(string.substring(n2));
                switch (n) {
                    case -2: {
                        return d < d2;
                    }
                    case -1: {
                        return d <= d2;
                    }
                    case 0: {
                        return d == d2;
                    }
                    case 1: {
                        return d >= d2;
                    }
                    case 2: {
                        return d > d2;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("GLU Aladin.profile version number error [" + string + "]");
                if (Aladin.levelTrace < 3) break block16;
                exception.printStackTrace();
            }
        }
        return false;
    }

    private boolean hasValidProfile(String string, String string2, boolean bl) {
        if (Aladin.OUTREACH && !bl && (string == null || string.indexOf("undergraduate") < 0)) {
            return false;
        }
        if (string == null) {
            return true;
        }
        boolean bl2 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (bl2 && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("undergraduate")) {
                if (string2 != null) continue;
                bl2 &= Aladin.OUTREACH;
                continue;
            }
            if (string3.equals("beta")) {
                bl2 &= Aladin.BETA;
                continue;
            }
            if (string3.equals("proto")) {
                bl2 &= Aladin.PROTO;
                continue;
            }
            if (string3.equals("applet")) {
                Glu glu = this;
                bl2 &= glu.aladin.isApplet();
                continue;
            }
            if (string3.equals("standalone")) {
                bl2 &= Aladin.STANDALONE;
                continue;
            }
            if (Character.isDigit(string3.charAt(0)) || this.isComparator(string3.charAt(0))) {
                bl2 &= this.hasValidNumVersion(string3);
                continue;
            }
            if (string3.equals("hpx") || string3.equals("localdef")) continue;
            bl2 = false;
        }
        return bl2;
    }

    private void putAladinFilter(String string, Vector vector) {
        int n;
        if (vector == null || (n = vector.size()) == 0) {
            return;
        }
        String[] stringArray = null;
        stringArray = new String[n];
        Enumeration enumeration = vector.elements();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        if (this.aladinDicFilters == null) {
            this.aladinDicFilters = new Hashtable();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.aladinDicFilters.put(stringTokenizer.nextToken(), stringArray);
        }
    }

    private void memoAlaSites(String string, String string2) {
        if (!string.equals("AlaU")) {
            return;
        }
        this.AlaSites.addElement(string2);
    }

    private boolean testCurrentAlaSite() {
        try {
            URL uRL = new URL(NPHGLUALADIN + "?J2000");
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            if (!dataInputStream.readLine().startsWith("%DataTypeName")) {
                throw new Exception();
            }
            return true;
        }
        catch (Exception exception) {
            int n;
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            if ((n = NPHGLUALADIN.indexOf(47, 8)) < 0) {
                n = NPHGLUALADIN.length();
            }
            String string = NPHGLUALADIN.substring(7, n);
            Aladin.trace(2, "GLU registry site not responding [" + string + "] => Aladin will select another one automatically...");
            return false;
        }
    }

    protected boolean testAlaSites(boolean bl, boolean bl2) {
        long l = Long.MAX_VALUE;
        String string = null;
        boolean bl3 = false;
        Enumeration enumeration = this.AlaSites.elements();
        while (enumeration.hasMoreElements() && !bl3) {
            long l2 = Long.MAX_VALUE;
            String string2 = null;
            try {
                URL uRL;
                DataInputStream dataInputStream;
                long l3 = System.currentTimeMillis();
                string2 = (String)enumeration.nextElement();
                String string3 = this.aladinDic.get(string2) + "/" + NPHGLU;
                if (bl2) {
                    this.aladin.configuration.setSelectGluChoice(string3);
                }
                if (!(dataInputStream = new DataInputStream((uRL = new URL(string3 + "?J2000")).openStream())).readLine().startsWith("%DataTypeName")) {
                    throw new Exception();
                }
                l2 = System.currentTimeMillis() - l3;
            }
            catch (Exception exception) {
                if (Thread.currentThread().isInterrupted()) {
                    bl3 = true;
                }
                l2 = Long.MAX_VALUE;
            }
            if (l2 < l) {
                l = l2;
                string = string2;
            }
            if (!bl || string == null) continue;
            break;
        }
        if (string == null) {
            return false;
        }
        NPHGLUALADIN = this.aladinDic.get(string) + "/" + NPHGLU;
        Aladin.trace(3, "New Glu site selected: [" + NPHGLUALADIN + "]");
        this.aladinDic.put("AlaU", "%I " + string);
        return true;
    }

    protected String setDefaultGluSite(String string) {
        if (!string.endsWith("/" + NPHGLU)) {
            string = string + "/" + NPHGLU;
        }
        if (!this.flagNoGlu && string.equals(NPHGLUALADIN)) {
            return null;
        }
        NPHGLUALADIN = string;
        Aladin.trace(3, "New default Glu site: [" + NPHGLUALADIN + "]");
        try {
            this.aladin.configuration.set(Configuration.GLU, NPHGLUALADIN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flagNoGlu = this.testCurrentAlaSite();
        if (!this.flagNoGlu) {
            Aladin.warning(Aladin.chaine.getString("NOGLU1") + " \n" + NPHGLUALADIN + " " + Aladin.chaine.getString("NOGLU2"));
            this.testAlaSites(true, false);
            return NPHGLUALADIN;
        }
        return null;
    }

    static String removeBackslash(String string, char c) {
        int n;
        if (string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < cArray.length - 1; ++n) {
            if (cArray[n] == '\\' && cArray[n + 1] == c) continue;
            stringBuffer.append(cArray[n]);
        }
        stringBuffer.append(cArray[n]);
        return stringBuffer.toString();
    }

    static String prefixQuote(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    static String[] cutParam(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        Vector<String> vector = new Vector<String>(3);
        String[] stringArray = null;
        while ((n = Glu.afterSpace(cArray, n)) != -1) {
            int n2;
            if (cArray[n] == '\'' || cArray[n] == '\"') {
                char c = cArray[n];
                n2 = ++n;
                while (n < cArray.length && (cArray[n] != c || cArray[n - 1] == '\\')) {
                    ++n;
                }
                if (n == cArray.length) break;
                vector.addElement(Glu.removeBackslash(new String(cArray, n2, n - n2), c));
                ++n;
                continue;
            }
            n2 = n;
            if ((n = Glu.afterWord(cArray, n)) == -1) {
                vector.addElement(new String(cArray, n2, cArray.length - n2));
                break;
            }
            vector.addElement(new String(cArray, n2, n - n2));
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = new String((String)vector.elementAt(n));
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    public static String dollarSet(String var0, String[] var1_1, int var2_2) {
        var4_3 = 0;
        var9_4 = false;
        var10_5 = new StringBuffer();
        var11_6 = (var2_2 & 1) == 1;
        v0 = var12_7 = (var2_2 & 2) == 0;
        if (var0.length() == 0) {
            return "";
        }
        var3_8 = var0.toCharArray();
        block2: while (true) {
            var5_9 = var4_3;
            var8_12 = -1;
            while (true) {
                if (var4_3 < var3_8.length && var3_8[var4_3] != '$') {
                    if (var12_7 && !var11_6 && !var9_4 && var3_8[var4_3] == '?') {
                        var9_4 = true;
                        for (var13_14 = 0; var13_14 < var1_1.length; ++var13_14) {
                            var1_1[var13_14] = URLEncoder.encode(var1_1[var13_14]);
                        }
                    }
                    ++var4_3;
                    continue;
                }
                if (var4_3 == var3_8.length) break block2;
                var7_11 = ++var4_3;
                while (var4_3 < var3_8.length && var3_8[var4_3] > '0' && var3_8[var4_3] <= '9') {
                    ++var4_3;
                }
                try {
                    var8_12 = Integer.parseInt(new String(var3_8, var7_11, var4_3 - var7_11));
                }
                catch (NumberFormatException var13_15) {
                    var8_12 = 0;
                }
                if (--var8_12 >= 0) break;
            }
            var13_13 = var7_11 >= 2 && var3_8[var7_11 - 2] == '=' && (var4_3 >= var3_8.length || var3_8[var4_3] == '&');
            if (var12_7 && var13_13 && (var8_12 >= var1_1.length || var1_1[var8_12].length() == 0)) {
                for (var6_10 = var7_11 - 1; var6_10 > 0 && var3_8[var6_10] != '&' && var3_8[var6_10] != '?'; --var6_10) {
                }
                if (var6_10 == 0) {
                    var6_10 = var7_11 - 1;
                } else if (var3_8[var6_10] == '?') {
                    ++var6_10;
                }
            }
            var10_5.append(new String(var3_8, var5_9, var6_10 - var5_9));
            if (var8_12 >= var1_1.length) continue;
            var10_5.append(var1_1[var8_12]);
            if (!var12_7 || var11_6 || var9_4) continue;
            var14_17 = 0;
            while (true) {
                if (var14_17 >= var1_1[var8_12].length()) continue block2;
                if (var1_1[var8_12].charAt(var14_17) == '?') {
                    var9_4 = true;
                    var15_18 = 0;
                    while (true) {
                        if (var15_18 < var1_1.length) ** break;
                        continue block2;
                        var1_1[var15_18] = URLEncoder.encode(var1_1[var15_18]);
                        ++var15_18;
                    }
                }
                ++var14_17;
            }
            break;
        }
        var10_5.append(new String(var3_8, var5_9, var3_8.length - var5_9));
        var13_16 = var10_5.toString();
        var14_17 = var13_16.length();
        if (var12_7 && var14_17 > 0 && var13_16.charAt(var14_17 - 1) == '?') {
            var13_16 = var13_16.substring(0, var14_17 - 1);
        }
        return var13_16;
    }

    String gluResolver(String string, String string2, boolean bl) {
        return this.gluResolver(string, string2, bl, 1);
    }

    String gluResolver(String string, String string2, boolean bl, int n) {
        int n2 = string.lastIndexOf(44);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if (!this.chut) {
            Aladin.trace(3, "Querying the inside GLU <&" + string + (bl ? ",n" : "") + (string2.length() > 0 ? " " + string2 : "") + ">...");
        }
        String[] stringArray = Glu.cutParam(string2);
        String string3 = (String)this.aladinDic.get(string);
        if (string3 == null) {
            if (Aladin.NETWORK) {
                this.loadRemoteGluRecord(string);
                string3 = (String)this.aladinDic.get(string);
            }
        }
        if (!string3.startsWith("%I ") && string3.indexOf("<&") < 0 && n > 1) {
            return null;
        }
        int n3 = 0;
        while (string3 != null && string3.startsWith("%I ")) {
            if (n3 > 16) {
                System.err.println("Too many GLU %I indirections (>16) => certainly a cycle => ignored");
                return null;
            }
            String string4 = "";
            int n4 = 2;
            int n5 = n3 == 0 ? n : 1;
            for (int i = 1; i <= n5; ++i) {
                int n6 = n4 + 1;
                if ((n4 = string3.indexOf(9, n6)) == -1) {
                    if (i != n) {
                        if (!this.chut) {
                            System.err.println("GLU %I indirection number " + n + " not existing => ignored");
                        }
                        return null;
                    }
                    n4 = string3.length();
                }
                string4 = string3.substring(n6, n4);
            }
            string3 = (String)this.aladinDic.get(string4);
            this.indId = string4;
            ++n3;
        }
        if (string3 == null) {
            return null;
        }
        string3 = Glu.dollarSet(string3, stringArray, bl ? 1 : 0);
        string3 = this.gluRecFilter(string3, n);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkIndirection(String string, String string2) {
        this.lastId = null;
        this.indId = null;
        this.chut = true;
        try {
            URL uRL = this.getURL(string, "", false, false, 2);
            if (uRL == null) {
                boolean bl = false;
                return bl;
            }
            long l = Long.MAX_VALUE;
            int n = 0;
            int n2 = 0;
            while ((uRL = this.getURL(string, "", false, false, n2 + 1)) != null) {
                GluTest gluTest;
                GluTest gluTest2 = gluTest = this.indId == null ? null : this.aladinDicT.get(this.indId);
                if (gluTest == null) {
                    gluTest = this.aladinDicT.get(string);
                }
                String string3 = gluTest != null && gluTest.params != null ? gluTest.params : "";
                boolean bl = gluTest != null ? gluTest.optN : false;
                String string4 = gluTest != null ? gluTest.pattern : null;
                boolean bl2 = gluTest != null ? gluTest.regex : false;
                uRL = this.getURL(string, string3, bl, false, n2 + 1);
                String string5 = uRL + (string2 != null ? string2 : "");
                UrlLoader urlLoader = null;
                long l2 = -1L;
                try {
                    long l3 = System.currentTimeMillis();
                    urlLoader = new UrlLoader(new URL(string5), 1000, string4 != null ? 2 : 1);
                    if (string4 != null) {
                        String string6 = urlLoader.getData();
                        boolean bl3 = !bl2 ? string6.indexOf(string4) >= 0 : string6.matches(string4);
                        if (!bl3) {
                            throw new Exception("Pattern not found");
                        }
                    }
                    long l4 = System.currentTimeMillis();
                    l2 = l4 - l3;
                    l2 = l2 / 100L * 100L;
                    l2 += (long)(Math.random() * 100.0);
                }
                catch (Exception exception) {
                    l2 = -1L;
                }
                Aladin.trace(4, "Glu.checkIndirection(...): " + string + "/" + (n2 + 1) + " => " + string5 + " => " + l2 + "ms");
                if (l2 != -1L && l2 < l) {
                    l = l2;
                    n = n2;
                }
                ++n2;
            }
            if (n != 0) {
                this.setIndirectionOrderOnLastId(n);
            }
        }
        finally {
            this.lastId = null;
            this.indId = null;
            this.chut = false;
        }
        return true;
    }

    private void setIndirectionOrderOnLastId(int n) {
        if (this.lastId == null) {
            return;
        }
        if (n == 0) {
            return;
        }
        String string = (String)this.aladinDic.get(this.lastId);
        if (!string.startsWith("%I ")) {
            return;
        }
        string = string.substring(3);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer("%I " + stringArray[n]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) continue;
            stringBuffer.append("\t" + stringArray[i]);
        }
        this.aladinDic.put(this.lastId, stringBuffer + "");
        Aladin.trace(4, "Glu.CheckIndirections(" + this.lastId + ") => %I " + stringArray[n] + " => " + this.getURL(this.lastId, "", false, false, 1));
    }

    String gluSystem(String string, String string2) {
        String[] stringArray = Glu.cutParam(string2);
        string = Glu.dollarSet(string, stringArray, 2);
        return string;
    }

    private String gluRecFilter(String string, int n) {
        URL uRL;
        int n2;
        int n3 = string.indexOf("<&");
        if (n3 < 0 || (n2 = string.indexOf(62, n3)) < 0) {
            return string;
        }
        int n4 = string.indexOf(",", n3);
        if (n3 >= n4 || n4 >= n2) {
            n4 = n2;
        }
        if ((uRL = this.getURL(string.substring(n3 + 2, n4).trim(), "", false, false, n)) == null) {
            return null;
        }
        return string.substring(0, n3) + uRL + string.substring(n2 + 1);
    }

    private void loadRemoteGluRecord(String string) {
        this.loadRemoteGluRecord(string, 0);
    }

    private void loadRemoteGluRecord(String string, int n) {
        try {
            URL uRL = new URL(NPHGLUALADIN + "?" + URLEncoder.encode(string) + "&param=-p");
            Aladin.trace(3, "Loading GLU record for \"" + string + "\" from " + uRL + "...");
            this.loadGluDic(new DataInputStream(uRL.openStream()), n, true, true, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public MyInputStream getMyInputStream(String string, boolean bl) throws Exception {
        MyInputStream myInputStream;
        if (!string.startsWith("http:") && !string.startsWith("ftp:")) {
            myInputStream = new MyInputStream(new FileInputStream(this.aladin.getFullFileName(string)));
            myInputStream = myInputStream.startRead();
        } else {
            URL uRL = Aladin.STANDALONE ? new URL(string) : this.getURL("Http", string, true, bl);
            myInputStream = Util.openStream(uRL);
        }
        return myInputStream;
    }

    public URL getURL(String string) {
        return this.getURL(string, "", false, true, 1);
    }

    public URL getURL(String string, String string2) {
        return this.getURL(string, string2, false, true, 1);
    }

    public URL getURL(String string, String string2, boolean bl) {
        return this.getURL(string, string2, bl, true, 1);
    }

    public URL getURL(String string, String string2, boolean bl, boolean bl2) {
        return this.getURL(string, string2, bl, bl2, 1);
    }

    public URL getURL(String string, String string2, boolean bl, boolean bl2, int n) {
        URL uRL = null;
        this.lastId = string;
        if (!Aladin.NETWORK) {
            return null;
        }
        if (!this.chut) {
            Aladin.trace(4, "Glu.getURL(" + string + (string2 == null || string2.length() == 0 ? "" : " params=" + string2) + " encode=" + bl + " withLog=" + bl2 + " indexIndirection=" + n + ")");
        }
        if (bl2) {
            this.log(string, string2);
        }
        String string3 = bl ? ",n" : ",";
        try {
            if (Aladin.STANDALONE) {
                String string4 = this.gluResolver(string, string2, bl, n);
                if (string4 == null) {
                    if (!this.chut) {
                        Aladin.trace(3, "getURL error: glu record \"" + string + "\" not found !\n");
                    }
                    return null;
                }
                uRL = new URL(string4);
            } else {
                string3 = string3 + "R";
                String string5 = "<&" + string + string3 + " " + string2 + ">";
                uRL = new URL(Aladin.CGIPATH + "/" + NPHGLU + "?" + URLEncoder.encode(string5));
            }
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                System.err.println("getURL error: " + exception);
                exception.printStackTrace();
            }
            return null;
        }
        if (!this.chut) {
            Aladin.trace(3, "Get: " + (uRL == null ? "null" : uRL.toString()));
        }
        return uRL;
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(100);
            Aladin.trace(4, "Glu.waitLock...");
        }
    }

    synchronized boolean getLock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    synchronized void unlock() {
        this.lock = false;
    }

    protected void log(String string, String string2) {
        if (!(Aladin.NETWORK && Aladin.LOG && this.aladin.configuration.isLog())) {
            return;
        }
        if (string.equals("VizX")) {
            return;
        }
        if (string.equals("Load")) {
            string2 = "";
        }
        if (string.equals("Http") && string2 != null && string2.indexOf("u-strasbg.fr") < 0) {
            string2 = "";
        }
        try {
            this.waitLock();
            this.param = ALADINLOG + "?id=" + (string == null ? "" : URLEncoder.encode(string)) + "&params=" + (string2 == null ? "" : URLEncoder.encode(string2));
            this.flagVers = Aladin.STANDALONE && string.equals("Start");
            this.thread = new Thread((Runnable)this, "AladinLog");
            Util.decreasePriority(Thread.currentThread(), this.thread);
            this.thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            String string = this.param;
            boolean bl = this.flagVers;
            this.unlock();
            try {
                URL uRL;
                if (Aladin.APPLETSERVER == null && Aladin.RHOST == null) {
                    uRL = new URL(string);
                } else {
                    string = string + "&host=";
                    if (Aladin.RHOST != null) {
                        string = string + Aladin.RHOST;
                    }
                    uRL = this.getURL("Http", string, true, false);
                }
                InputStream inputStream = null;
                try {
                    this.logIncr();
                    inputStream = uRL.openStream();
                    if (bl) {
                        this.aladin.waitDialog();
                        DataInputStream dataInputStream = new DataInputStream(inputStream);
                        this.aladin.setCurrentVersion(dataInputStream.readLine());
                    }
                    inputStream.close();
                    inputStream = null;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    this.logDecr();
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block10;
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLogging() {
        Object object = this.lockLog;
        synchronized (object) {
            return this.logCpt > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIncr() {
        Object object = this.lockLog;
        synchronized (object) {
            ++this.logCpt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDecr() {
        Object object = this.lockLog;
        synchronized (object) {
            --this.logCpt;
        }
    }

    static {
        openURL = null;
    }

    class GluTest {
        String pattern;
        boolean regex;
        String params;
        boolean optN;
        String PATTERN = "pattern=";
        String OPTION = "option=";
        String PARAM = "param=";

        GluTest(String string, boolean bl) throws Exception {
            if (bl) {
                this.set1(string);
            } else {
                this.set0(string);
            }
        }

        private void set0(String string) throws Exception {
            int n = string.indexOf(58);
            int n2 = string.indexOf(58, n + 1);
            if (n == -1 || n2 == -1) {
                throw new Exception("%T syntax error [" + string + "]");
            }
            this.set(n > 0 ? string.substring(0, n) : null, n + 1 < n2 ? string.substring(n + 1, n2) : null, string.substring(n2 + 1));
        }

        private void set1(String string) throws Exception {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = string.indexOf(this.PATTERN);
            if (n >= 0) {
                string2 = new Tok(string.substring(n + this.PATTERN.length())).nextToken();
            }
            if ((n = string.indexOf(this.OPTION)) >= 0) {
                string3 = new Tok(string.substring(n + this.OPTION.length())).nextToken();
            }
            if ((n = string.indexOf(this.PARAM)) >= 0) {
                string4 = new Tok(string.substring(n + this.PARAM.length())).nextToken();
            }
            this.set(string2, string3, string4);
        }

        private void set(String string, String string2, String string3) {
            if (string != null && string.length() > 0) {
                this.regex = string.length() > 2 && string.charAt(0) == '/';
                this.pattern = this.regex ? string.substring(1, string.length() - 1) : string;
            }
            boolean bl = this.optN = string2 != null && string2.indexOf(110) >= 0;
            if (string3 != null && string3.length() > 0) {
                this.params = string3;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.pattern != null) {
                stringBuffer.append(" pattern=[" + this.pattern + "]");
            }
            if (this.regex) {
                stringBuffer.append(" regex");
            }
            if (this.optN) {
                stringBuffer.append(" optN");
            }
            if (this.params != null) {
                stringBuffer.append(" params=[" + this.params + "]");
            }
            return stringBuffer.toString();
        }
    }
}

