/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Comparator;

public class GluApp
implements Comparator {
    public static String JAVAPATH = "java";
    public static String JAVAWS = "javaws";
    private Aladin aladin;
    String ordre = "Y";
    public String tagGlu;
    public String aladinLabel;
    public String description;
    public String verboseDescr;
    public String institute;
    public String releaseNumber;
    public String nextNumber;
    public String copyright;
    public String docUrl;
    public String jarUrl;
    public String javaParam;
    public String downloadUrl;
    public String wsUrl;
    public String appletUrl;
    public String activated;
    public String system;
    public String dir;
    protected long downloading;
    protected boolean interrupt;
    private int type;
    static final int JAVA = 1;
    static final int PLASTIC = 2;
    protected static final int JAR = 1;
    protected static final int DOWNLOAD = 2;
    protected static final int WEBSTART = 3;
    protected static final int APPLET = 4;

    public GluApp(Aladin aladin, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, int n) {
        this.aladin = aladin;
        this.tagGlu = string;
        this.aladinLabel = string2;
        this.ordre = string3;
        this.description = string4;
        this.verboseDescr = string5;
        this.institute = string6;
        this.releaseNumber = string7;
        this.copyright = string8;
        this.docUrl = string9;
        this.jarUrl = string10;
        this.javaParam = string11;
        this.downloadUrl = string13;
        this.wsUrl = string14;
        this.appletUrl = string15;
        this.dir = string12;
        this.type = n;
        this.system = string17;
        this.activated = string16;
        this.downloading = -1L;
    }

    public GluApp(Aladin aladin, String string) {
        this.aladin = aladin;
        this.tagGlu = string;
        this.downloading = -1L;
    }

    protected void merge(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, int n) {
        this.tagGlu = this.tagGlu;
        this.aladinLabel = string;
        this.ordre = string2;
        this.description = string3;
        this.verboseDescr = string4;
        this.institute = string5;
        if (!this.releaseNumber.equals(string6)) {
            this.nextNumber = string6;
        }
        this.copyright = string7;
        this.docUrl = string8;
        this.jarUrl = string9;
        this.javaParam = string10;
        this.downloadUrl = string11;
        this.wsUrl = string12;
        this.appletUrl = string13;
        this.activated = this.activated == null ? string14 : this.activated;
        this.type = n;
    }

    protected int getInstallMode() {
        if (this.wsUrl != null) {
            return 3;
        }
        if (this.appletUrl != null) {
            return 4;
        }
        if (this.jarUrl != null) {
            return 1;
        }
        if (this.downloadUrl != null) {
            return 2;
        }
        return 0;
    }

    protected boolean canBeInstall() {
        int n = this.getInstallMode();
        return n != 0 && n != 3 && n != 4;
    }

    protected boolean isDownloading() {
        return this.downloading != -1L;
    }

    protected boolean canBeRun() {
        int n = this.getInstallMode();
        if (n == 3 || n == 4) {
            return true;
        }
        if (this.isDownloading()) {
            return false;
        }
        return this.dir != null || this.system != null;
    }

    protected boolean canBeMenu() {
        if (!this.canBeRun()) {
            return false;
        }
        return this.isActivated();
    }

    protected boolean isActivated() {
        return this.activated != null && !this.activated.equals("No");
    }

    protected boolean hasNewRelease() {
        return this.nextNumber != null;
    }

    protected static String glu(String string, String string2) {
        if (string2 == null || string2.trim().startsWith("--")) {
            return "";
        }
        return "%" + Util.align(string, 20) + string2 + Util.CR;
    }

    protected String getGluDic() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GluApp.glu("ActionName", this.tagGlu));
        stringBuffer.append(GluApp.glu("DistribDomain", "ALADIN"));
        stringBuffer.append(GluApp.glu("Owner", "CDS'aladin"));
        stringBuffer.append(GluApp.glu("Description", this.description));
        stringBuffer.append(GluApp.glu("VerboseDescr", this.verboseDescr));
        stringBuffer.append(GluApp.glu("Institute", this.institute));
        stringBuffer.append(GluApp.glu("ReleaseNumber", this.releaseNumber));
        stringBuffer.append(GluApp.glu("NextNumber", this.nextNumber));
        stringBuffer.append(GluApp.glu("Copyright", this.copyright));
        stringBuffer.append(GluApp.glu("Doc.User", this.docUrl));
        stringBuffer.append(GluApp.glu("Jar", this.jarUrl));
        stringBuffer.append(GluApp.glu("Webstart", this.wsUrl));
        stringBuffer.append(GluApp.glu("Applet", this.appletUrl));
        stringBuffer.append(GluApp.glu("Download", this.downloadUrl));
        stringBuffer.append(GluApp.glu("JavaParam", this.javaParam));
        stringBuffer.append(GluApp.glu("Aladin.VOLabel", this.aladinLabel));
        stringBuffer.append(GluApp.glu("Aladin.Activated", this.activated));
        stringBuffer.append(GluApp.glu("Dir", this.dir));
        stringBuffer.append(GluApp.glu("System", this.system));
        stringBuffer.append(Util.CR);
        return stringBuffer.toString();
    }

    protected String getCommand() {
        if (this.getInstallMode() == 3) {
            return JAVAWS + " " + this.wsUrl;
        }
        if (this.dir == null) {
            return null;
        }
        if (this.system != null) {
            return this.system;
        }
        return this.getJavaCommand();
    }

    protected String getJavaCommand() {
        if (this.javaParam != null) {
            return JAVAPATH + " " + this.javaParam;
        }
        return null;
    }

    protected boolean hasDedicatedCommand() {
        return this.system != null;
    }

    protected boolean hasDedicatedDir() {
        return this.dir != null && !this.dir.equals(this.aladin.getVOPath());
    }

    protected String getDir() {
        int n = this.getInstallMode();
        if (n == 4 || n == 3) {
            return null;
        }
        return this.dir;
    }

    protected boolean exec() {
        this.aladin.log("VOToolExec", this.tagGlu);
        if (this.getInstallMode() == 4) {
            return this.execApplet();
        }
        final String string = this.getDir();
        Aladin.trace(1, "Exec: " + (string != null ? "cd " + string + ";" : "") + this.getCommand());
        try {
            new Thread(this.tagGlu){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(GluApp.this.getCommand(), null, string == null ? null : new File(string));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean execApplet() {
        this.aladin.glu.showDocument("Http", this.appletUrl, true);
        return true;
    }

    protected String getJarName() {
        try {
            return this.jarUrl.substring(this.jarUrl.lastIndexOf(47));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int install() {
        this.aladin.log("VOToolInstall", this.tagGlu);
        switch (this.getInstallMode()) {
            case 1: {
                this.installJar();
                return -3;
            }
            case 2: {
                this.aladin.glu.showDocument("Http", this.downloadUrl, true);
                return -1;
            }
        }
        return -2;
    }

    protected void interrupt() {
        this.interrupt = true;
    }

    synchronized void setDownloading(long l) {
        this.downloading = l;
    }

    protected boolean installJar() {
        this.setDownloading(0L);
        this.interrupt = false;
        new Thread("Install"){

            @Override
            public void run() {
                try {
                    int n;
                    URL uRL = new URL(GluApp.this.jarUrl);
                    InputStream inputStream = uRL.openStream();
                    if (inputStream == null) {
                        throw new Exception();
                    }
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    if (dataInputStream == null) {
                        throw new Exception();
                    }
                    String string = GluApp.this.aladin.getVOPath() + Util.FS + GluApp.this.getJarName();
                    String string2 = string + ".tmp";
                    File file = new File(string2);
                    file.delete();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
                    byte[] byArray = new byte[512];
                    while (!GluApp.this.interrupt && dataInputStream.available() == 0) {
                        Util.pause(100);
                    }
                    while (!GluApp.this.interrupt && (n = dataInputStream.read(byArray)) > 0) {
                        randomAccessFile.write(byArray, 0, n);
                        GluApp.this.setDownloading(GluApp.this.downloading + (long)n);
                    }
                    dataInputStream.close();
                    randomAccessFile.close();
                    if (GluApp.this.interrupt) {
                        file.delete();
                        GluApp.this.setDownloading(-1L);
                    } else {
                        File file2 = new File(string);
                        file2.delete();
                        file.renameTo(file2);
                        GluApp.this.dir = GluApp.this.aladin.getVOPath();
                        if (GluApp.this.nextNumber != null) {
                            GluApp.this.releaseNumber = GluApp.this.nextNumber;
                        }
                        GluApp.this.nextNumber = null;
                    }
                }
                catch (Exception exception) {
                    GluApp.this.aladin;
                    if (Aladin.levelTrace >= 3) {
                        exception.printStackTrace();
                    }
                    GluApp.this.aladin;
                    Aladin.warning("Installation error");
                }
                GluApp.this.setDownloading(-1L);
                ((GluApp)GluApp.this).aladin.frameVOTool.downloadEnd();
            }
        }.start();
        return true;
    }

    public GluApp() {
    }

    protected static Comparator getComparator() {
        return new GluApp();
    }

    public int compare(Object object, Object object2) {
        GluApp gluApp = (GluApp)object;
        GluApp gluApp2 = (GluApp)object2;
        if (gluApp.ordre == gluApp2.ordre) {
            return 0;
        }
        if (gluApp.ordre == null) {
            return -1;
        }
        if (gluApp2.ordre == null) {
            return 1;
        }
        return gluApp.ordre.compareTo(gluApp2.ordre);
    }
}

