/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyIcon;
import cds.aladin.Plan;
import cds.aladin.Projection;
import java.awt.Color;
import java.awt.Graphics;

public class Grid
extends MyIcon {
    private static final int[][] TX = new int[][]{{4, 10, 0}, {2, 3, 1}, {11, 12, 1}, {1, 13, 5}, {2, 3, 8}, {11, 12, 8}, {4, 10, 9}};
    private static final int[][] TY = new int[][]{{3, 6, 0}, {3, 6, 14}, {2, 2, 1}, {7, 7, 1}, {2, 2, 13}, {7, 7, 13}, {3, 6, 3}, {3, 6, 11}, {2, 2, 4}, {7, 7, 4}, {2, 2, 10}, {7, 7, 10}, {1, 8, 7}, {1, 1, 5}, {1, 1, 9}, {8, 8, 5}, {8, 8, 9}};
    private static final int[][] TY1 = new int[][]{{0, 4, 11}, {1, 2, 4}, {1, 11, 12}, {2, 1, 1}, {2, 9, 9}, {2, 13, 13}, {3, 0, 0}, {3, 4, 4}, {3, 9, 9}, {3, 14, 14}, {4, 0, 0}, {4, 9, 9}, {4, 14, 14}, {5, 0, 0}, {5, 2, 5}, {5, 14, 14}, {6, 0, 0}, {6, 14, 14}, {7, 1, 1}, {7, 7, 9}, {7, 13, 13}, {8, 2, 4}, {8, 11, 12}, {9, 4, 10}};
    private static final int[][] SY2 = new int[][]{{11, 12, 2}, {3, 3, 3}, {10, 10, 3}, {13, 13, 3}, {3, 3, 4}, {9, 9, 4}, {4, 4, 5}, {8, 8, 5}, {4, 4, 6}, {7, 7, 6}, {7, 7, 6}, {5, 6, 7}, {14, 14, 7}, {15, 15, 8}, {2, 16, 9}, {15, 15, 10}, {14, 14, 11}};
    private static final int[][] TY2 = new int[][]{{3, 3, 0}, {7, 7, 0}, {11, 11, 0}, {2, 2, 1}, {4, 4, 1}, {6, 6, 1}, {8, 8, 1}, {10, 10, 1}, {12, 12, 1}, {1, 1, 2}, {5, 5, 2}, {9, 9, 2}, {13, 13, 2}, {2, 2, 3}, {4, 4, 3}, {10, 10, 3}, {12, 12, 3}, {14, 14, 3}, {3, 3, 4}, {11, 11, 4}, {15, 15, 4}, {2, 2, 5}, {4, 4, 5}, {10, 10, 5}, {12, 12, 5}, {14, 14, 5}, {1, 1, 6}, {5, 5, 6}, {9, 9, 6}, {13, 13, 6}, {2, 2, 7}, {4, 4, 7}, {6, 6, 7}, {8, 8, 7}, {10, 10, 7}, {12, 12, 7}, {14, 14, 7}, {3, 3, 8}, {7, 7, 8}, {11, 11, 8}, {13, 13, 8}};
    private static final int[][] TY2BG = new int[][]{{3, 3, 1}, {7, 7, 1}, {11, 11, 1}, {2, 12, 2}, {3, 13, 3}, {4, 14, 4}, {3, 13, 5}, {2, 12, 6}, {3, 3, 7}, {7, 7, 7}, {11, 13, 7}};
    private static final int[][] FD = new int[][]{{2, 1, 11, 8}, {1, 3, 13, 4}};
    protected String LABEL = Aladin.chaine.getString("GRID");

    protected Grid(Aladin aladin) {
        super(aladin, 29, 24);
    }

    protected static void drawGrid(Graphics graphics, int n, int n2, Color color) {
        int n3;
        graphics.setColor(color);
        for (n3 = 0; n3 < TX.length; ++n3) {
            graphics.drawLine(TX[n3][0] + n, TX[n3][2] + n2, TX[n3][1] + n, TX[n3][2] + n2);
        }
        for (n3 = 0; n3 < TY.length; ++n3) {
            graphics.drawLine(TY[n3][2] + n, TY[n3][0] + n2, TY[n3][2] + n, TY[n3][1] + n2);
        }
    }

    protected static void drawPolar(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < TY1.length; ++i) {
            graphics.drawLine(TY1[i][1] + n, TY1[i][0] + n2, TY1[i][2] + n, TY1[i][0] + n2);
        }
    }

    protected static void drawMOC(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < TY2.length; ++i) {
            graphics.drawLine(TY2[i][0] + n, TY2[i][2] + n2, TY2[i][1] + n, TY2[i][2] + n2);
        }
    }

    protected static void fillMOC(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < TY2BG.length; ++i) {
            graphics.drawLine(TY2BG[i][0] + n, TY2BG[i][2] + n2, TY2BG[i][1] + n, TY2BG[i][2] + n2);
        }
    }

    protected static void drawSED(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < SY2.length; ++i) {
            graphics.drawLine(SY2[i][0] + n, SY2[i][2] + n2, SY2[i][1] + n, SY2[i][2] + n2);
        }
    }

    protected static void fillBG(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < 2; ++i) {
            graphics.fillRect(FD[i][0] + n, FD[i][1] + n2, FD[i][2], FD[i][3]);
        }
    }

    private boolean isAvailable() {
        if (this.aladin.calque == null) {
            return false;
        }
        Plan plan = this.aladin.calque.getPlanRef();
        return plan != null && Projection.isOk(plan.projd);
    }

    private boolean isActive() {
        return this.aladin.calque.hasGrid();
    }

    private boolean isMouseIn() {
        return false;
    }

    @Override
    protected void drawLogo(Graphics graphics) {
        int n = 5;
        int n2 = 2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.W, this.H);
        Grid.fillBG(graphics, n, n2, Color.white);
        Grid.drawGrid(graphics, n, n2, !this.isAvailable() ? Aladin.MYGRAY : (this.isActive() ? Aladin.GREEN : (this.isMouseIn() ? Color.blue : Color.black)));
        graphics.setColor(this.isAvailable() ? Color.black : Aladin.MYGRAY);
        graphics.setFont(Aladin.SPLAIN);
        graphics.drawString(this.LABEL, this.W / 2 - graphics.getFontMetrics().stringWidth(this.LABEL) / 2, this.H - 2);
    }

    @Override
    protected void submit() {
        this.aladin.calque.switchGrid(true);
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("GRIDH");
    }

    @Override
    protected String Help() {
        return Aladin.chaine.getString("Grid.HELP");
    }
}

