/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.HealpixKey;
import cds.aladin.PlanBG;
import cds.tools.Util;
import cds.tools.pixtools.Hpix;
import java.io.File;

class HealpixAllsky
extends HealpixKey {
    protected int nbPix;
    protected HealpixKey[] pixList;
    private int mem;

    protected HealpixAllsky(PlanBG planBG, int n) {
        this(planBG, n, (int)planBG.getZ());
    }

    protected HealpixAllsky(PlanBG planBG, int n, int n2) {
        this(planBG, n, n2, 1);
    }

    protected HealpixAllsky(PlanBG planBG, int n, int n2, int n3) {
        block3: {
            this.mem = 0;
            this.planBG = planBG;
            this.order = n;
            this.npix = -1L;
            this.z = n2;
            this.allSky = true;
            this.resetTimer();
            String string = n2 <= 0 ? "" : "_" + n2;
            String string2 = "Norder" + n + "/Allsky" + string;
            String string3 = planBG.getCacheName() + "/Norder" + n + "/Allsky" + string;
            this.extCache = this.extNet = planBG.getTileMode();
            this.fileCache = string3 + EXT[this.extCache];
            this.fileNet = string2 + EXT[this.extNet];
            this.alreadyCached = false;
            this.priority = -1;
            this.nbPix = 12 * (int)Math.pow(4.0, n);
            this.pixList = null;
            this.setStatus(1);
            try {
                if (n3 == 2 || n3 == 3 && (planBG.useCache && this.isCached() || planBG.isLocalAllSky())) {
                    this.loadNow();
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected long getLiveTime() {
        return this.planBG.aladin.enoughMemory() ? -1L : 3000L;
    }

    HealpixKey createOneKey(int n, int n2, byte[] byArray) {
        HealpixKey healpixKey = new HealpixKey();
        healpixKey.allSky = true;
        healpixKey.planBG = this.planBG;
        healpixKey.order = this.order;
        healpixKey.z = this.z;
        healpixKey.npix = n;
        healpixKey.hpix = new Hpix(this.order, n, this.planBG.frameOrigin);
        healpixKey.resetTimer();
        healpixKey.width = healpixKey.height = n2;
        healpixKey.pixels = byArray;
        healpixKey.alreadyCached = true;
        healpixKey.setStatus(6);
        return healpixKey;
    }

    HealpixKey createOneKeyRGB(int n, int n2, int[] nArray) {
        HealpixKey healpixKey = new HealpixKey();
        healpixKey.allSky = true;
        healpixKey.planBG = this.planBG;
        healpixKey.order = this.order;
        healpixKey.npix = n;
        healpixKey.z = this.z;
        healpixKey.hpix = new Hpix(this.order, n, this.planBG.frameOrigin);
        healpixKey.resetTimer();
        healpixKey.width = healpixKey.height = n2;
        healpixKey.rgb = nArray;
        healpixKey.alreadyCached = true;
        healpixKey.setStatus(6);
        return healpixKey;
    }

    static boolean isCached(PlanBG planBG, int n) {
        String string = planBG.getCacheDir();
        if (string == null) {
            return false;
        }
        String string2 = planBG.getCacheName() + "/Norder" + n + "/Allsky" + EXT[planBG.getTileMode()];
        File file = new File(string = string + Util.FS + string2);
        return file.exists() && file.canRead();
    }

    protected void createPixList() {
        if (this.getStatus() != 6) {
            return;
        }
        try {
            if (this.planBG.color) {
                this.createPixListRGB1();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        int n = (int)Math.sqrt(this.nbPix);
        int n2 = this.nbPix / n;
        if ((double)(this.nbPix / n) != (double)this.nbPix / (double)n) {
            ++n2;
        }
        int n3 = this.width / n;
        this.pixList = new HealpixKey[this.nbPix];
        for (int i = 0; i < this.nbPix; ++i) {
            byte[] byArray = new byte[n3 * n3];
            int n4 = i / n * n3;
            int n5 = i % n * n3;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n6 = (n4 + j) * this.width + (n5 + k);
                    if (n6 >= this.pixels.length) {
                        System.err.println("offset=" + n6 + " pixels.length=" + this.pixels.length + " x,y=" + k + "," + j);
                        n6 = this.pixels.length - 1;
                    }
                    int n7 = j * n3 + k;
                    byArray[n7] = this.pixels[n6];
                }
            }
            this.pixList[i] = this.createOneKey(i, n3, byArray);
            this.mem += this.pixList[i].getMem();
        }
        this.pixels = null;
    }

    @Override
    protected int getMem() {
        return this.mem;
    }

    private void createPixListRGB1() throws Exception {
        int n = (int)Math.sqrt(this.nbPix);
        int n2 = this.nbPix / n;
        if ((double)(this.nbPix / n) != (double)this.nbPix / (double)n) {
            ++n2;
        }
        int n3 = this.width / n;
        this.pixList = new HealpixKey[this.nbPix];
        for (int i = 0; i < this.nbPix; ++i) {
            int[] nArray = new int[n3 * n3];
            int n4 = i / n * n3;
            int n5 = i % n * n3;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n3; ++k) {
                    nArray[j * n3 + k] = this.rgb[(n4 + j) * this.width + (n5 + k)];
                }
            }
            this.pixList[i] = this.createOneKeyRGB(i, n3, nArray);
            this.mem += this.pixList[i].getMem();
        }
        this.rgb = null;
    }

    @Override
    protected int free() {
        int n = 0;
        if (this.pixList != null) {
            n = this.pixList.length;
            for (int i = 0; i < this.pixList.length; ++i) {
                if (this.pixList[i] == null) continue;
                this.pixList[i].free();
            }
        }
        this.pixList = null;
        this.mem = 0;
        return n;
    }

    @Override
    protected void clearBuf() {
        if (this.pixList == null) {
            return;
        }
        for (int i = 0; i < this.pixList.length; ++i) {
            if (this.pixList[i] == null) continue;
            this.pixList[i].clearBuf();
        }
    }

    @Override
    HealpixKey[] getPixList() {
        if (this.pixList == null) {
            this.createPixList();
        }
        return this.pixList;
    }
}

