/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyPol;
import cds.aladin.PlanBG;
import cds.tools.Util;
import cds.tools.pixtools.Hpix;

class HealpixAllskyPol
extends HealpixKeyPol {
    protected int nbPix;
    protected HealpixKey[] pixList;
    protected int order;

    protected HealpixAllskyPol(PlanBG planBG, int n) {
        this.planBG = planBG;
        this.order = n;
        this.npix = -1L;
        this.allSky = true;
        this.resetTimer();
        String string = "Norder" + n + "/Allsky";
        String string2 = planBG.getCacheName() + "/Norder" + n + "/Allsky";
        this.extCache = this.extNet = planBG.getTileMode();
        this.fileCache = string2 + EXT[this.extCache];
        this.fileNet = string + EXT[this.extNet];
        this.alreadyCached = false;
        this.priority = -1;
        this.nbPix = 12 * (int)Math.pow(4.0, n);
        this.pixList = null;
        this.setStatus(1);
    }

    HealpixKeyPol createOneKey(int n, int n2, byte[] byArray, byte[] byArray2) {
        HealpixKeyPol healpixKeyPol = new HealpixKeyPol();
        healpixKeyPol.planBG = this.planBG;
        healpixKeyPol.order = this.order;
        healpixKeyPol.npix = n;
        healpixKeyPol.hpix = new Hpix(this.order, n, this.planBG.frameOrigin);
        healpixKeyPol.resetTimer();
        healpixKeyPol.width = healpixKeyPol.height = n2;
        healpixKeyPol.pixels = null;
        healpixKeyPol.bitpix = this.bitpix;
        healpixKeyPol.pixelsOrigin = byArray;
        healpixKeyPol.bitpix2 = this.bitpix2;
        healpixKeyPol.pixelsOrigin2 = byArray2;
        healpixKeyPol.alreadyCached = true;
        healpixKeyPol.allSky = true;
        healpixKeyPol.setStatus(6);
        return healpixKeyPol;
    }

    public int getOrder1() {
        return this.order;
    }

    public long getNpix() {
        return -1L;
    }

    protected void createPixList() {
        if (this.getStatus() != 6) {
            return;
        }
        int n = (int)Math.sqrt(this.nbPix);
        int n2 = this.nbPix / n;
        if ((double)(this.nbPix / n) != (double)this.nbPix / (double)n) {
            ++n2;
        }
        int n3 = this.width / n;
        this.pixList = new HealpixKey[this.nbPix];
        for (int i = 0; i < this.nbPix; ++i) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n4 = 0;
            int n5 = 0;
            if (this.bitpix != 0) {
                n4 = Math.abs(this.bitpix) / 8;
                byArray = new byte[n3 * n3 * n4];
            }
            if (this.bitpix2 != 0) {
                n5 = Math.abs(this.bitpix2) / 8;
                byArray2 = new byte[n3 * n3 * n5];
            }
            int n6 = i / n * n3;
            int n7 = i % n * n3;
            if (i % 100 == 0) {
                Util.pause(10);
            }
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n8 = (n6 + j) * this.width + (n7 + k);
                    int n9 = j * n3 + k;
                    if (this.bitpix != 0) {
                        System.arraycopy(this.pixelsOrigin, n8 * n4, byArray, n9 * n4, n4);
                    }
                    if (this.bitpix2 == 0) continue;
                    System.arraycopy(this.pixelsOrigin2, n8 * n5, byArray2, n9 * n5, n5);
                }
            }
            this.pixList[i] = this.createOneKey(i, n3, byArray, byArray2);
        }
        this.pixels = null;
        this.pixelsOrigin2 = null;
        this.pixelsOrigin = null;
    }

    @Override
    protected int free() {
        int n = 0;
        if (this.pixList != null) {
            n = this.pixList.length;
            for (int i = 0; i < this.pixList.length; ++i) {
                this.pixList[i].free();
            }
        }
        this.pixList = null;
        return n;
    }

    @Override
    protected void clearBuf() {
        if (this.pixList == null) {
            return;
        }
        for (int i = 0; i < this.pixList.length; ++i) {
            this.pixList[i].clearBuf();
        }
    }

    @Override
    HealpixKey[] getPixList() {
        if (this.pixList == null) {
            this.createPixList();
        }
        return this.pixList;
    }
}

