/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixKeyPol;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Save;
import cds.aladin.ViewSimple;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import cds.tools.pixtools.Util;
import healpix.essentials.FastMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class HealpixKey
implements Comparable<HealpixKey> {
    static final int UNKNOWN = 0;
    static final int ASKING = 1;
    static final int TOBELOADFROMCACHE = 2;
    static final int TOBELOADFROMNET = 3;
    static final int LOADINGFROMCACHE = 4;
    static final int LOADINGFROMNET = 5;
    static final int READY = 6;
    static final int ERROR = 7;
    static final int ABORTING = 8;
    static final int PURGING = 9;
    public static int NBSTATUS = 10;
    public static final String[] STATUS = new String[]{"UNKOWN", "ASKING", "TOBELOADFROMCACHE", "TOBELOADFROMNET", "LOADINGFROMCACHE", "LOADINGFROMNET", "READY", "ERROR", "ABORTING", "PURGING"};
    protected int status;
    protected long timer;
    protected long timerLoad;
    protected int priority;
    protected PlanBG planBG;
    protected int order;
    protected long npix;
    protected int z;
    protected Hpix hpix;
    protected String fileCache;
    protected String fileNet;
    protected int width;
    protected int height;
    protected byte[] pixels;
    protected byte[] pixelsOrigin;
    protected int[] rgb;
    protected Image imgBuf;
    protected int imgID;
    protected byte[] stream;
    protected boolean truePixels;
    protected boolean alreadyCached;
    protected boolean allSky;
    protected boolean fromNet;
    protected int timeStream;
    protected int timeNet;
    protected long sizeStream;
    private int timeJPEG;
    private int timePixel;
    private int typeColor;
    protected HealpixKey[] fils;
    protected HealpixKey anc;
    protected int parente;
    protected Point p;
    int oiz;
    int vHashCode;
    public static final int NOW = 0;
    public static final int ONLYIFRAMAVAIL = 1;
    public static final int ONLYIFDISKAVAIL = 2;
    public static final int PIX8 = 3;
    protected static final int JPEG = 0;
    protected static final int FITS = 1;
    protected static final int TSV = 2;
    protected static final int XML = 3;
    protected static final int PNG = 4;
    protected static final int IDX = 5;
    public static final String[] EXT = new String[]{".jpg", ".fits", ".tsv", ".xml", ".png", ""};
    protected int extCache;
    protected int extNet;
    public static final int NOLOAD = 0;
    public static final int ASYNC = 1;
    public static final int SYNC = 2;
    public static final int SYNCONLYIFLOCAL = 3;
    public static final int TESTNET = 4;
    boolean retry;
    static final int SIZESLOW = 512;
    static final int SIZEFAST = 8192;
    private static final Component observer = new Label();
    private Object lockStatus;
    static final int DEATH = -1;
    static final int MAYBEDEATH = -2;
    static final int INLIFE = -3;
    protected static final String[] VIE = new String[]{"", "DEATH", "MAYBEDEATH", "INLIFE"};
    static final double M = 78400.0;
    static final double N = 22500.0;
    static final double RAP = 0.7;
    protected static int nDraw = 0;
    protected static int nOut = 0;
    private long loadDate;
    private static final long TIMEFADER = 1500L;
    private static final float MINFADER = 0.6f;
    static final Color BLUE1 = new Color(0, 0, 255);
    static final Color BLUE2 = new Color(10, 52, 128);
    static final Color BLUE3 = new Color(51, 144, 198);

    protected HealpixKey() {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
    }

    protected HealpixKey(PlanBG planBG) {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
        this.planBG = planBG;
    }

    protected HealpixKey(PlanBG planBG, int n, long l) {
        this(planBG, n, l, 1);
    }

    protected HealpixKey(PlanBG planBG, int n, long l, int n2) {
        this(planBG, n, l, (int)planBG.getZ(), n2);
    }

    protected HealpixKey(PlanBG planBG, int n, long l, int n2, int n3) {
        block8: {
            this.status = 0;
            this.priority = -1;
            this.imgID = -2;
            this.fromNet = true;
            this.fils = null;
            this.anc = null;
            this.parente = 0;
            this.p = new Point(0, 0);
            this.oiz = -1;
            this.vHashCode = -1;
            this.extCache = 0;
            this.extNet = 0;
            this.retry = false;
            this.lockStatus = new Object();
            this.loadDate = System.currentTimeMillis();
            this.planBG = planBG;
            this.order = n;
            this.npix = l;
            this.z = n2;
            this.hpix = new Hpix(n, l, planBG.frameOrigin);
            if (n3 == 0) {
                return;
            }
            this.allSky = false;
            this.alreadyCached = false;
            this.setStatus(1);
            if (!this.allSky) {
                ++planBG.nbCreated;
            }
            this.resetTimer();
            this.extCache = this.extNet = planBG.getTileMode();
            this.fileNet = this.getFileNet();
            this.fileCache = this.getFileCache();
            try {
                if (n3 == 4) {
                    this.stream = this.loadStream(planBG.url + "/" + this.fileNet);
                    if (this.stream != null) {
                        this.sizeStream = this.stream.length;
                    }
                    this.stream = null;
                } else if (n3 == 2 || n3 == 3 && (planBG.useCache && this.isCached() || planBG.isLocalAllSky())) {
                    this.loadNow();
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block8;
                exception.printStackTrace();
            }
        }
    }

    protected HealpixKey(int n, long l, int n2) {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
        this.order = n;
        this.npix = l;
        this.hpix = new Hpix(n, l, n2);
    }

    protected String getFileNet() {
        return HealpixKey.getFilePath(null, this.order, this.npix, this.z) + EXT[this.extNet];
    }

    protected String getFileCache() {
        return HealpixKey.getFilePath(this.planBG.getCacheName(), this.order, this.npix, this.z) + EXT[this.extCache];
    }

    protected HealpixKey(HealpixKey healpixKey, int n) {
        this.status = 0;
        this.priority = -1;
        this.imgID = -2;
        this.fromNet = true;
        this.fils = null;
        this.anc = null;
        this.parente = 0;
        this.p = new Point(0, 0);
        this.oiz = -1;
        this.vHashCode = -1;
        this.extCache = 0;
        this.extNet = 0;
        this.retry = false;
        this.lockStatus = new Object();
        this.loadDate = System.currentTimeMillis();
        this.planBG = healpixKey.planBG;
        this.order = healpixKey.order + 1;
        this.npix = healpixKey.npix * 4L + (long)n;
        this.hpix = new Hpix(this.order, this.npix, this.planBG.frameOrigin);
        this.anc = healpixKey.anc;
        if (this.anc == null) {
            this.anc = healpixKey;
        }
        this.width = this.height = healpixKey.width / 2;
        int n2 = n == 2 || n == 3 ? this.width : 0;
        int n3 = n == 1 || n == 3 ? this.width : 0;
        this.p = new Point(healpixKey.p.x + n2, healpixKey.p.y + n3);
        this.parente = healpixKey.parente + 1;
        this.resetTimer();
        this.pixels = null;
        this.rgb = null;
        this.alreadyCached = true;
        this.allSky = healpixKey.allSky;
        this.setStatus(0);
    }

    protected HealpixKey[] getChild() {
        if (this.getStatus() != 6) {
            return null;
        }
        try {
            if (this.fils != null && this.fils[0].getStatus() == 6 && this.fils[1].getStatus() == 6 && this.fils[2].getStatus() == 6 && this.fils[3].getStatus() == 6) {
                return this.fils;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HealpixKey[] healpixKeyArray = new HealpixKey[4];
        for (int i = 0; i < 4; ++i) {
            HealpixKey healpixKey = this instanceof HealpixKeyPol ? new HealpixKeyPol((HealpixKeyPol)this, i) : new HealpixKey(this, i);
            healpixKey.setStatus(6);
            healpixKeyArray[i] = healpixKey;
        }
        this.fils = healpixKeyArray;
        return this.fils;
    }

    protected byte[] getPixelFromAncetre() throws Exception {
        byte[] byArray = this.anc.pixels == null ? this.anc.getPixelFromAncetre() : this.anc.pixels;
        byte[] byArray2 = new byte[this.width * this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                byArray2[i * this.width + j] = byArray[(i + this.p.y) * this.anc.width + (j + this.p.x)];
            }
        }
        return byArray2;
    }

    private int[] getPixelFromAncetreRGB() throws Exception {
        int[] nArray = new int[this.width * this.width];
        int[] nArray2 = this.anc.rgb != null ? this.anc.rgb : this.anc.getPixelFromAncetreRGB();
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                nArray[i * this.width + j] = nArray2[(i + this.p.y) * this.anc.width + (j + this.p.x)];
            }
        }
        return nArray;
    }

    protected static String getFilePath(String string, int n, long l, int n2) {
        return (string != null ? string + "/" : "") + Util.getFilePath(n, l, n2);
    }

    protected String getStringNumber() {
        return this.order + "/" + this.npix + (this.z <= 0 ? "" : "_" + this.z);
    }

    public String toString() {
        String string = this.status == 5 || this.status == 4 ? ">>" : (this.status == 3 || this.status == 2 ? " >" : " .");
        return string + "[" + cds.tools.Util.align(this.priority + "", 5) + "] " + cds.tools.Util.align(this.getStringNumber() + (this.fils != null ? ">" : " "), 8) + cds.tools.Util.align(this.getLongFullMem(), 8) + (this.truePixels ? " truePix " : "         ") + cds.tools.Util.align(this.getStatusString(), 16) + (this.timer == -1L ? -1L : this.getCurrentLiveTime() / 1000L) + "s => " + VIE[-this.getLive()] + (this.getStatus() == 6 ? (this.fromNet ? " Net" : " Cache") + ":" + this.timeStream + "+" + this.timeJPEG + "+" + this.timePixel + "ms" : "");
    }

    protected int free() {
        int n = 0;
        try {
            n += this.free1();
            n += this.filsFree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected int free1() {
        int n = 0;
        int n2 = this.getStatus();
        if (this.parente == 0) {
            ++this.planBG.nbFree;
            if (n2 == 4 || n2 == 5) {
                this.abort();
            } else if (n2 == 6 && this.planBG.useCache) {
                this.write();
            }
        }
        this.setStatus(0);
        if (this.pixels != null) {
            this.pixels = null;
            n = 1;
        }
        if (this.rgb != null) {
            this.rgb = null;
            n = 1;
        }
        if (this.imgBuf != null) {
            this.imgBuf.flush();
            this.imgBuf = null;
            n = 1;
        }
        if (this.pixelsOrigin != null) {
            this.pixelsOrigin = null;
            n = 1;
        }
        return n;
    }

    protected int filsFree() {
        int n = 0;
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                n += this.fils[i].free();
            }
            this.fils = null;
        }
        return n;
    }

    protected boolean purgeFils() {
        boolean bl = true;
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.fils[i] == null) continue;
                bl = bl && this.fils[i].purgeFils();
            }
        }
        if (bl) {
            if (this.parente == 0) {
                this.fils = null;
                return bl;
            }
            if (this.getLive() == -1) {
                this.free();
                return true;
            }
        }
        return false;
    }

    protected void clearBuf() {
        if (this.pixelsOrigin != null) {
            this.pixelsOrigin = null;
        }
        if (this.imgBuf == null) {
            return;
        }
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                if (this.fils[i] == null) continue;
                this.fils[i].clearBuf();
            }
        }
        this.imgBuf = null;
    }

    protected void loadFromNet() {
        block4: {
            this.setStatus(5);
            try {
                long l = System.currentTimeMillis();
                String string = this.planBG.url + "/" + this.fileNet;
                char c = this.planBG.url.charAt(this.planBG.url.length() - 1);
                if (c == '\\' || c == '/') {
                    string = this.planBG.url + this.fileNet;
                }
                this.planBG.nByteReadNet += this.loadNet(string);
                this.alreadyCached = false;
                this.resetTimer();
                this.setTimerLoad();
                this.setStatus(6);
                ++this.planBG.nbLoadNet;
                this.parente = 0;
                this.fromNet = true;
                this.planBG.cumulTimeLoadNet += (long)this.timeNet;
                this.planBG.cumulTimeStream += (long)this.timeStream;
                this.planBG.cumulTimeJPEG += (long)this.timeJPEG;
                this.planBG.cumulTimePixel += (long)this.timePixel;
                this.planBG.askForRepaint();
                Aladin.trace(5, "HealpixKey.LoadFromNet() in " + (System.currentTimeMillis() - l) + "ms : " + this);
            }
            catch (Throwable throwable) {
                boolean bl;
                this.pixels = null;
                this.rgb = null;
                if (this.getStatus() == 8) break block4;
                boolean bl2 = bl = throwable instanceof FileNotFoundException || throwable.getMessage() != null && throwable.getMessage().indexOf("HTTP response code: 40") >= 0;
                if (!bl && !this.retry && this.planBG.checkSite(true)) {
                    this.retry = true;
                    this.loadFromNet();
                    return;
                }
                this.setStatus(7);
                if (!(this instanceof HealpixAllsky)) break block4;
                this.planBG.askForRepaint();
            }
        }
    }

    protected long loadNet(String string) throws Exception {
        long l = 0L;
        l = this.extNet == 0 || this.extNet == 4 ? (long)this.loadJpeg(string) : (long)this.loadFits(string);
        if (!this.planBG.useCache) {
            this.stream = null;
        }
        return l;
    }

    protected void loadFromCache() {
        block7: {
            this.setStatus(4);
            try {
                long l = System.currentTimeMillis();
                String string = this.planBG.getCacheDir();
                if (string == null) {
                    throw new Exception("Cache not ready");
                }
                string = string + cds.tools.Util.FS + this.fileCache;
                try {
                    this.updateCacheIfRequired(1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.planBG.nByteReadCache += this.loadCache(string);
                    this.alreadyCached = true;
                    Aladin.trace(5, "HealpixKey.LoadFromCache() in " + (System.currentTimeMillis() - l) + "ms " + this);
                    this.resetTimer();
                    this.setTimerLoad();
                    this.setStatus(6);
                    this.parente = 0;
                    ++this.planBG.nbLoadCache;
                    this.fromNet = false;
                    this.planBG.cumulTimeLoadCache += System.currentTimeMillis() - l;
                    this.planBG.askForRepaint();
                    this.planBG.touchCache();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new File(string).delete();
                    throw exception;
                }
            }
            catch (Exception exception) {
                this.pixels = null;
                this.alreadyCached = false;
                if (this.getStatus() == 8) break block7;
                this.setStatus(3);
                if (Aladin.levelTrace < 3) break block7;
                exception.printStackTrace();
            }
        }
    }

    protected void updateCacheIfRequired(int n) throws Exception {
    }

    protected void loadNow() throws Exception {
        if (this.getStatus() != 6) {
            if (this.planBG.useCache && this.isCached()) {
                this.setStatus(2);
                this.loadFromCache();
            }
            if (!this.planBG.useCache || !this.isCached()) {
                this.setStatus(3);
                this.loadFromNet();
            }
        } else {
            this.resetTimer();
        }
        if (this.getStatus() == 6) {
            if (this.allSky) {
                this.planBG.setTileOrder(this.getLosangeOrder());
            }
            if (this.planBG.isTruePixels()) {
                this.loadPixelsOrigin(2);
            }
            if (this.planBG.useCache) {
                this.write();
            }
        }
    }

    protected long loadCache(String string) throws Exception {
        long l = this.extCache == 0 || this.extCache == 4 ? (long)this.loadJpeg(string) : (long)this.loadFits(string);
        this.stream = null;
        File file = new File(string);
        file.setLastModified(System.currentTimeMillis());
        return l;
    }

    protected boolean isCached() {
        if (this.alreadyCached) {
            return true;
        }
        String string = this.planBG.getCacheDir();
        if (string == null) {
            return false;
        }
        File file = new File(string = string + cds.tools.Util.FS + this.fileCache);
        if (file.exists() && file.canRead()) {
            this.alreadyCached = true;
            return true;
        }
        return false;
    }

    protected boolean shouldBeCached() {
        if (this.alreadyCached) {
            return false;
        }
        return this.getStatus() == 6;
    }

    protected void write() {
        if (this.alreadyCached) {
            return;
        }
        try {
            long l = System.currentTimeMillis();
            int n = this.writeCache();
            this.planBG.nByteWriteCache += (long)n;
            ++this.planBG.nbWriteCache;
            this.planBG.cumulTimeWriteCache += System.currentTimeMillis() - l;
            PlanBG.addInCache(n / 1024);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alreadyCached = true;
    }

    protected int writeCache() throws Exception {
        int n = 0;
        if (this.stream != null) {
            n = this.writeStream();
            this.stream = null;
        } else {
            n = this.writeFits();
        }
        return n;
    }

    protected void abort() {
        if (this.npix == -1L) {
            return;
        }
        ++this.planBG.nbAborted;
        this.setStatus(8, true);
    }

    private FileOutputStream openOutputStream() throws Exception {
        String string = this.planBG.getCacheDir() + cds.tools.Util.FS + this.fileCache;
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        cds.tools.Util.createPath(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        return fileOutputStream;
    }

    private boolean slowDown() {
        return this.planBG.aladin.view != null && this.planBG.aladin.view.mustDrawFast();
    }

    public byte[] readFully(MyInputStream myInputStream, boolean bl) throws Exception {
        Vector<byte[]> vector = new Vector<byte[]>(10);
        Vector<Integer> vector2 = new Vector<Integer>(10);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = System.currentTimeMillis();
        boolean bl2 = this.slowDown();
        int n5 = 512;
        byte[] byArray = new byte[n5];
        while ((n = myInputStream.read(byArray, 0, n5)) != -1) {
            ++n3;
            if (this.getStatus() == 8) {
                throw new Exception("readFullly aborted !");
            }
            vector.addElement(byArray);
            long l2 = System.currentTimeMillis();
            if (l2 - l > 10L) {
                bl2 = this.slowDown();
                l = l2;
            }
            if (!bl && bl2) {
                cds.tools.Util.pause(10);
                n5 = 512;
            } else {
                n5 = 8192;
            }
            vector2.addElement(new Integer(n));
            n2 += n;
            byArray = new byte[n5];
        }
        byte[] byArray2 = new byte[n2];
        n4 = vector.size();
        n = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            byArray = (byte[])vector.elementAt(n3);
            n2 = (Integer)vector2.elementAt(n3);
            System.arraycopy(byArray, 0, byArray2, n, n2);
            n += n2;
        }
        return byArray2;
    }

    protected byte[] loadStream(String string) throws Exception {
        return this.loadStream(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadStream(String string, int n) throws Exception {
        byte[] byArray;
        boolean bl = true;
        long l = cds.tools.Util.getTime();
        Aladin cfr_ignored_0 = this.planBG.aladin;
        Aladin.trace(5, "HealpixKey.loadStream(" + string + ")...");
        MyInputStream myInputStream = null;
        boolean bl2 = this instanceof HealpixAllsky;
        if (string.startsWith("http://") || string.startsWith("https://")) {
            bl = false;
            try {
                myInputStream = cds.tools.Util.openStream(string, false, 10000);
                if (n > 0) {
                    myInputStream.skip(n);
                }
                byArray = this.readFully(myInputStream, bl2);
            }
            finally {
                if (myInputStream != null) {
                    myInputStream.close();
                }
            }
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray2 = new byte[8];
            randomAccessFile.readFully(byArray2);
            if ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 216) {
                this.typeColor = 0;
            } else if ((byArray2[0] & 0xFF) == 137 && byArray2[1] == 80 && byArray2[2] == 78 && byArray2[3] == 71 && byArray2[4] == 13 && byArray2[5] == 10 && byArray2[6] == 26 && byArray2[7] == 10) {
                this.typeColor = 4;
            }
            if ((byArray2[0] & 0xFF) == 31 && (byArray2[1] & 0xFF) == 139) {
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                myInputStream = new MyInputStream(new GZIPInputStream(fileInputStream));
                if (n > 0) {
                    myInputStream.skip(n);
                }
                byArray = this.readFully(myInputStream, bl2);
            } else {
                randomAccessFile.seek(n);
                byArray = new byte[(int)(randomAccessFile.length() - (long)n)];
                randomAccessFile.readFully(byArray);
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        int n2 = (int)(cds.tools.Util.getTime() - l);
        if (bl) {
            this.timeStream = n2;
        } else {
            this.timeNet = n2;
        }
        return byArray;
    }

    private int loadJpeg(String string) throws Exception {
        this.stream = this.loadStream(string);
        this.truePixels = false;
        int n = this.stream.length;
        long l = cds.tools.Util.getTime();
        Image image = Toolkit.getDefaultToolkit().createImage(this.stream);
        if (this.extCache != 0 && this.extCache != 4 || !this.planBG.useCache) {
            this.stream = null;
        }
        boolean bl = true;
        while (bl) {
            try {
                if (this.getStatus() == 8) {
                    throw new Exception("Aborting");
                }
                MediaTracker mediaTracker = new MediaTracker(Aladin.aladin);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.width = image.getWidth(Aladin.aladin);
        this.height = image.getHeight(Aladin.aladin);
        if (this.width == -1) {
            throw new Exception("width = -1");
        }
        this.timeJPEG = (int)(cds.tools.Util.getTime() - l);
        if (this.planBG.colorUnknown && this instanceof HealpixAllsky) {
            this.planBG.color = cds.tools.Util.isColoredImage(this.stream);
            this.planBG.colorUnknown = false;
            Aladin cfr_ignored_0 = this.planBG.aladin;
            Aladin.trace(4, "HealpixKey.loadJpeg(" + string + ") => " + (this.typeColor == 4 ? "PNG" : "JPEG") + " " + (this.planBG.color ? "color" : " grey levels"));
        }
        if (!this.planBG.color) {
            this.pixels = this.getPixels(image);
        } else {
            this.rgb = this.getPixelsRGB(image);
        }
        if (this.planBG.pixMode == -1) {
            if (!this.planBG.color) {
                this.planBG.pixMode = this.extCache == 0 ? 3 : 4;
                this.planBG.setBufPixels8(this.pixels);
                this.planBG.pixelMin = 0.0;
                this.planBG.pixelMax = 255.0;
                this.planBG.dataMin = 0.0;
                this.planBG.dataMax = 255.0;
            } else {
                this.planBG.pixMode = this.typeColor == 4 ? 0 : 1;
                this.planBG.video = 0;
            }
            this.planBG.creatDefaultCM();
            this.planBG.colorPNG = this.typeColor == 4;
        }
        return n;
    }

    protected double getValue(byte[] byArray, String string) throws Exception {
        int n = byArray.length / 80;
        for (int i = 0; i < n; ++i) {
            String string2 = new String(byArray, i * 80, 8).trim();
            if (!string2.equals(string)) continue;
            int n2 = i * 80 + 9;
            while (byArray[n2] == 32) {
                ++n2;
            }
            int n3 = 0;
            while (Character.isDigit((char)byArray[n2 + n3]) || (char)byArray[n2 + n3] == '-' || (char)byArray[n2 + n3] == '.' || Character.toUpperCase((char)byArray[n2 + n3]) == 'E') {
                ++n3;
            }
            return Double.parseDouble(new String(byArray, n2, n3));
        }
        throw new Exception();
    }

    protected double getPixelValue(long l, int n) {
        long l2 = this.npix * (long)this.width * (long)this.width;
        int n2 = (int)CDSHealpix.log2(this.width);
        if (this.planBG.hpx2xy == null || this.planBG.hpx2xy.length != this.width * this.width) {
            try {
                this.planBG.createHealpixOrder(n2);
            }
            catch (Exception exception) {
                return Double.NaN;
            }
        }
        int n3 = this.planBG.hpx2xy((int)(l - l2));
        return this.getPixel(n3, n);
    }

    protected double getPixel(int n, int n2) {
        double d;
        if (n2 == 3) {
            int n3 = n % this.width;
            int n4 = this.width - n / this.width - 1;
            return this.pixels[n4 * this.width + n3];
        }
        if (!this.loadPixelsOrigin(n2)) {
            return Double.NaN;
        }
        this.resetTimer();
        double d2 = d = this.planBG.bitpix > 0 ? (double)this.getPixValInt(this.pixelsOrigin, this.planBG.bitpix, n) : this.getPixValDouble(this.pixelsOrigin, this.planBG.bitpix, n);
        if (this.planBG.isBlank(d)) {
            d = Double.NaN;
        }
        return d;
    }

    protected byte[] getSample(Coord coord, int n, byte[] byArray, int n2) throws Exception {
        int n3;
        coord = Localisation.frameToFrame(coord, 0, this.planBG.frameOrigin);
        if (Double.isNaN(coord.al) || Double.isNaN(coord.del)) {
            throw new Exception();
        }
        double[] dArray = CDSHealpix.radecToPolar(new double[]{coord.al, coord.del});
        long l = CDSHealpix.pow2((long)this.order + CDSHealpix.log2(n2));
        long l2 = CDSHealpix.ang2pix_nest(l, dArray[0], dArray[1]);
        long l3 = this.npix * (long)n2 * (long)n2;
        if (this.planBG.hpx2xy == null || this.planBG.hpx2xy.length != n2 * n2) {
            this.planBG.createHealpixOrder((int)CDSHealpix.log2(n2));
        }
        int n4 = this.planBG.hpx2xy((int)(l2 - l3));
        int n5 = n4 % n2;
        int n6 = n4 / n2;
        int n7 = Math.abs(this.planBG.bitpix) / 8;
        int n8 = n / 2;
        byte[] byArray2 = new byte[n * n * n7];
        for (n3 = 0; n3 < n * n; ++n3) {
            PlanImage.setPixVal(byArray2, this.planBG.bitpix, n3, this.planBG.blank);
        }
        n3 = 0;
        for (int i = n6 - n8; i < n6 + (n - n8); ++i) {
            for (int j = n5 - n8; j < n5 + (n - n8); ++j) {
                if (j < 0 || j >= n2 || i < 0 || i >= n2) continue;
                int n9 = (i * n2 + j) * n7;
                for (int k = 0; k < n7; ++k) {
                    byArray2[n3++] = byArray[n9 + k];
                }
            }
        }
        return byArray2;
    }

    protected boolean isARGB(byte[] byArray) {
        int n = byArray.length / 80;
        for (int i = 0; i < n; ++i) {
            if (!new String(byArray, i * 80, 8).equals("COLORMOD")) continue;
            return true;
        }
        return false;
    }

    private final int getPixValInt(byte[] byArray, int n, int n2) {
        PlanImage.getPixVal1(byArray, n, n2);
        switch (n) {
            case 8: {
                return byArray[n2] & 0xFF;
            }
            case 16: {
                return byArray[n2 *= 2] << 8 | byArray[n2 + 1] & 0xFF;
            }
            case 32: {
                return byArray[n2 *= 4] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
            }
        }
        return 0;
    }

    private final double getPixValDouble(byte[] byArray, int n, int n2) {
        switch (n) {
            case -32: {
                return Float.intBitsToFloat(byArray[n2 *= 4] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF);
            }
            case -64: {
                return Double.longBitsToDouble((long)(byArray[n2 *= 8] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF) << 32 | (long)(byArray[n2 + 4] << 24 | (byArray[n2 + 5] & 0xFF) << 16 | (byArray[n2 + 6] & 0xFF) << 8 | byArray[n2 + 7] & 0xFF) & 0xFFFFFFFFL);
            }
        }
        return 0.0;
    }

    private final byte[] to8bits(byte[] byArray, int n, double d, double d2, int n2) {
        byte[] byArray2 = new byte[byArray.length / (Math.abs(n) / 8)];
        int n3 = n2 == 4 ? 255 : 256;
        boolean bl = n2 == 4;
        double d3 = (double)n3 / (d2 - d);
        --n3;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                double d4 = PlanImage.getPixVal1(byArray, n, i * this.width + j);
                byArray2[(this.height - 1 - i) * this.width + j] = this.planBG.isBlank(d4) ? (byte)0 : (byte)((int)((double)bl + (d4 <= d ? 0.0 : (d4 >= d2 ? (double)n3 : (d4 - d) * d3))) & 0xFF);
            }
        }
        return byArray2;
    }

    protected void invLine(byte[] byArray, byte[] byArray2, int n) {
        int n2 = Math.abs(n) / 8;
        for (int i = 0; i < this.height; ++i) {
            System.arraycopy(byArray, i * this.width * n2, byArray2, (this.height - i - 1) * this.width * n2, this.width * n2);
        }
    }

    protected int loadFits(String string) throws Exception {
        boolean bl;
        this.stream = this.loadStream(string);
        boolean bl2 = bl = this.planBG.pixMode == -1;
        if (bl) {
            this.planBG.pixMode = 2;
        }
        byte[] byArray = new byte[2880];
        System.arraycopy(this.stream, 0, byArray, 0, 2880);
        int n = 8;
        boolean bl3 = false;
        double d = this.planBG.pixelMin;
        double d2 = this.planBG.pixelMax;
        try {
            this.width = (int)this.getValue(byArray, "NAXIS1");
            this.height = (int)this.getValue(byArray, "NAXIS2");
            n = (int)this.getValue(byArray, "BITPIX");
            bl3 = this.isARGB(byArray);
            if (bl3) {
                n = 0;
                if (bl) {
                    this.planBG.pixMode = 0;
                }
            }
            if (n != 8 && !bl3) {
                this.truePixels = true;
            }
        }
        catch (Exception exception) {
            this.height = 512;
            this.width = 512;
            n = 8;
        }
        int n2 = this.width * this.height * (Math.abs(n) / 8);
        if (bl3) {
            this.planBG.color = true;
            this.rgb = new int[this.width * this.height];
            for (int i = 0; i < this.width * this.height; ++i) {
                this.rgb[i] = (this.stream[2880 + i * 4] & 0xFF) << 24 | (this.stream[2880 + i * 4 + 1] & 0xFF) << 16 | (this.stream[2880 + i * 4 + 2] & 0xFF) << 8 | this.stream[2880 + i * 4 + 3] & 0xFF;
            }
        } else {
            boolean bl4;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.stream, 2880, byArray2, 0, n2);
            boolean bl5 = bl4 = this.planBG.bitpix == 0 || this.planBG.flagRecut;
            if (bl4) {
                boolean bl6 = this.planBG.bitpix == 0;
                this.planBG.bitpix = n;
                this.planBG.flagRecut = false;
                try {
                    this.planBG.bScale = this.getValue(byArray, "BSCALE");
                }
                catch (Exception exception) {
                    this.planBG.bScale = 1.0;
                }
                try {
                    this.planBG.bZero = this.getValue(byArray, "BZERO");
                }
                catch (Exception exception) {
                    this.planBG.bZero = 0.0;
                }
                try {
                    this.planBG.blank = this.getValue(byArray, "BLANK");
                    this.planBG.isBlank = true;
                }
                catch (Exception exception) {
                    this.planBG.isBlank = false;
                }
                boolean bl7 = false;
                boolean bl8 = false;
                if (bl6) {
                    double[] dArray;
                    if (this.planBG.pixelRange != null && (dArray = this.split(this.planBG.pixelRange)) != null) {
                        this.planBG.dataMin = (dArray[0] - this.planBG.bZero) / this.planBG.bScale;
                        this.planBG.dataMax = (dArray[1] - this.planBG.bZero) / this.planBG.bScale;
                        bl7 = true;
                    }
                    if (this.planBG.pixelCut != null && (dArray = this.split(this.planBG.pixelCut)) != null) {
                        this.planBG.pixelMin = d = (dArray[0] - this.planBG.bZero) / this.planBG.bScale;
                        this.planBG.pixelMax = d2 = (dArray[1] - this.planBG.bZero) / this.planBG.bScale;
                        bl8 = true;
                    }
                }
                if (!bl8 && !bl7) {
                    Fits fits;
                    int n3;
                    block31: {
                        n3 = this.width;
                        if (this.planBG.flagRecutRadius > 0.0) {
                            double d3 = CDSHealpix.pixRes(CDSHealpix.pow2((long)this.order + CDSHealpix.log2(this.width))) / 3600.0;
                            n3 = (int)(this.planBG.flagRecutRadius / d3);
                        }
                        if (n3 > this.width) {
                            n3 = this.width;
                        }
                        fits = new Fits(n3, n3, n);
                        if (this.planBG.isBlank) {
                            fits.setBlank(this.planBG.blank);
                        }
                        fits.pixels = byArray2;
                        if (this.planBG.flagRecutRadius > 0.0 && n3 != this.width) {
                            try {
                                fits.pixels = this.getSample(this.planBG.flagRecutCoo, n3, byArray2, this.width);
                            }
                            catch (Exception exception) {
                                Aladin cfr_ignored_0 = this.planBG.aladin;
                                if (Aladin.levelTrace < 3) break block31;
                                exception.printStackTrace();
                            }
                        }
                    }
                    double[] dArray = fits.findAutocutRange(0.0, 0.0, true);
                    if (!bl8) {
                        this.planBG.pixelMin = d = dArray[0];
                        this.planBG.pixelMax = d2 = dArray[1];
                    }
                    if (!bl7) {
                        this.planBG.dataMin = dArray[2];
                        this.planBG.dataMax = dArray[3];
                    }
                    Aladin cfr_ignored_1 = this.planBG.aladin;
                    Aladin.trace(3, "Pixel range detection on " + this.getStringNumber() + "[" + n3 + "x" + n3 + "] NaN=" + cds.tools.Util.round(dArray[4] * 100.0, 1) + "% => PixelMinMax=[" + cds.tools.Util.myRound(this.planBG.pixelMin) + "," + cds.tools.Util.myRound(this.planBG.pixelMax) + "], DataMinMax=[" + cds.tools.Util.myRound(this.planBG.dataMin) + "," + cds.tools.Util.myRound(this.planBG.dataMax) + "] " + (this.planBG.isBlank ? " Blank=" + this.planBG.blank : "") + " bzero=" + this.planBG.bZero + " bscale=" + this.planBG.bScale);
                } else {
                    Aladin cfr_ignored_2 = this.planBG.aladin;
                    Aladin.trace(3, "Pixel properties PixelMinMax=[" + cds.tools.Util.myRound(this.planBG.pixelMin) + "," + cds.tools.Util.myRound(this.planBG.pixelMax) + "], DataMinMax=[" + cds.tools.Util.myRound(this.planBG.dataMin) + "," + cds.tools.Util.myRound(this.planBG.dataMax) + "] " + (this.planBG.isBlank ? " Blank=" + this.planBG.blank : "") + " bzero=" + this.planBG.bZero + " bscale=" + this.planBG.bScale);
                }
                this.planBG.restoreCM();
                if (this.planBG.aladin.frameCM != null && this.planBG.aladin.frameCM.isVisible()) {
                    this.planBG.aladin.frameCM.showCM();
                }
            }
            this.pixels = this.to8bits(byArray2, n, d, d2, 4);
            if (bl4 && !this.planBG.color) {
                this.planBG.pixelsOrigin = byArray2;
                this.planBG.setBufPixels8(this.pixels);
                this.planBG.bitpix = n;
                this.planBG.npix = Math.abs(n) / 8;
                this.planBG.naxis1 = this.planBG.width = this.width;
                this.planBG.naxis2 = this.planBG.height = this.height;
            }
            byArray2 = null;
        }
        return this.stream.length;
    }

    private double[] split(String string) {
        double[] dArray = new double[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        dArray[0] = Double.parseDouble(stringTokenizer.nextToken());
        dArray[1] = Double.parseDouble(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            dArray[2] = PlanImage.getTransfertFct(stringTokenizer.nextToken());
            if (dArray[2] == -1.0) {
                dArray[2] = 3.0;
            }
        }
        return dArray;
    }

    private String getFileNameForPixelsOrigin() {
        String string;
        if (this.isCached() && (string = this.planBG.getCacheDir()) != null) {
            return string + cds.tools.Util.FS + this.fileCache;
        }
        string = this.planBG.url + "/" + this.fileNet;
        char c = this.planBG.url.charAt(this.planBG.url.length() - 1);
        if (c == '\\' || c == '/') {
            string = this.planBG.url + this.fileNet;
        }
        return string;
    }

    protected boolean loadPixelsOrigin(int n) {
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (!this.planBG.hasOriginalPixels()) {
            return false;
        }
        if (this.stream != null) {
            Aladin.trace(4, "HealpixKey.loadPixelsOrigin: from stream for " + this);
            int n2 = this.width * this.width * Math.abs(this.planBG.bitpix) / 8;
            this.pixelsOrigin = new byte[n2];
            System.arraycopy(this.stream, 2880, this.pixelsOrigin, 0, n2);
            return true;
        }
        if (n == 1) {
            return false;
        }
        if (!(n != 2 || this.planBG.isLocalAllSky() || this.planBG.useCache && this.isCached())) {
            return false;
        }
        String string = this.getFileNameForPixelsOrigin();
        try {
            this.pixelsOrigin = this.loadStream(string, 2880);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected int writeStream() throws Exception {
        FileOutputStream fileOutputStream = this.openOutputStream();
        if (fileOutputStream == null) {
            return 0;
        }
        fileOutputStream.write(this.stream);
        fileOutputStream.close();
        return this.stream.length;
    }

    private int writeFits() throws Exception {
        FileOutputStream fileOutputStream = this.openOutputStream();
        if (fileOutputStream == null) {
            return 0;
        }
        int n = 0;
        fileOutputStream.write(Save.getFitsLine("SIMPLE", "T", null));
        n += 80;
        fileOutputStream.write(Save.getFitsLine("BITPIX", "8", null));
        n += 80;
        fileOutputStream.write(Save.getFitsLine("NAXIS", "2", null));
        n += 80;
        fileOutputStream.write(Save.getFitsLine("NAXIS1", this.width + "", null));
        n += 80;
        fileOutputStream.write(Save.getFitsLine("NAXIS2", this.height + "", null));
        n += 80;
        fileOutputStream.write(Save.getFitsLine("NORDER", this.order + "", null));
        n += 80;
        fileOutputStream.write(Save.getFitsLine("NPIX", this.npix + "", null));
        fileOutputStream.write(Save.getEndBourrage(n += 80));
        byte[] byArray = new byte[this.pixels.length];
        this.invLine(this.pixels, byArray, 8);
        fileOutputStream.write(byArray);
        byArray = null;
        fileOutputStream.close();
        return this.pixels.length + 2880;
    }

    protected byte[] getPixels(Image image) throws Exception {
        long l = cds.tools.Util.getTime();
        byte[] byArray = null;
        if (this.planBG.pixMode == 4) {
            int[] nArray = this.getPixelsRGB1(image);
            byArray = new byte[nArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                if ((nArray[i] & 0xFF000000) == 0) {
                    byArray[i] = 0;
                    continue;
                }
                byte by = (byte)(0xFF & nArray[i]);
                if (by == 0) {
                    by = 1;
                }
                byArray[i] = by;
            }
            nArray = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, observer);
            graphics.finalize();
            graphics = null;
            byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            bufferedImage.flush();
            bufferedImage = null;
        }
        this.timePixel = (int)(cds.tools.Util.getTime() - l);
        return byArray;
    }

    protected int[] getPixelsRGB(Image image) throws Exception {
        try {
            return this.getPixelsRGB1(image);
        }
        catch (Throwable throwable) {
            this.planBG.clearBuf();
            return this.getPixelsRGB1(image);
        }
    }

    protected int[] getPixelsRGB1(Image image) throws Exception {
        long l = cds.tools.Util.getTime();
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, observer);
        graphics.finalize();
        graphics = null;
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        bufferedImage.flush();
        bufferedImage = null;
        this.timePixel = (int)(cds.tools.Util.getTime() - l);
        return nArray;
    }

    protected void setStatus(int n) {
        this.setStatus(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int n, boolean bl) {
        Object object = this.lockStatus;
        synchronized (object) {
            if (!bl && this.getStatus() == 8) {
                return;
            }
            this.status = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStatus() {
        Object object = this.lockStatus;
        synchronized (object) {
            return this.status;
        }
    }

    protected String getStatusString() {
        return STATUS[this.getStatus()];
    }

    protected int getLive() {
        int n = this.getStatus();
        long l = this.getLiveTime();
        if (l == -1L) {
            return -3;
        }
        if ((n == 7 || n == 5) && this.parente == 0) {
            return -3;
        }
        if (this.getCurrentLiveTime() <= l) {
            return -3;
        }
        if (this.getCurrentLiveTime() > l + 3000L) {
            return -1;
        }
        return -2;
    }

    protected long getLiveTime() {
        return 3000L;
    }

    protected long getCurrentLiveTime() {
        return System.currentTimeMillis() - this.timer;
    }

    protected void setOld() {
        this.timer -= 3000L;
    }

    protected void resetTimer() {
        this.timer = System.currentTimeMillis();
    }

    private void setTimerLoad() {
        this.timerLoad = System.currentTimeMillis();
    }

    public static PointD[] grow(PointD[] pointDArray, double d) throws Exception {
        int n;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            if (pointDArray[i] != null) continue;
            ++n2;
        }
        if (n2 > 1) {
            return pointDArray;
        }
        PointD[] pointDArray2 = new PointD[pointDArray.length];
        for (n = 0; n < 4; ++n) {
            pointDArray2[n] = new PointD(pointDArray[n].x, pointDArray[n].y);
        }
        for (n = 0; n < 2; ++n) {
            int n3;
            int n4;
            int n5;
            int n6 = n == 1 ? 1 : 0;
            int n7 = n5 = n == 1 ? 2 : 3;
            if (pointDArray2[n6] == null) {
                if (n6 == 0 || n6 == 3) {
                    n4 = 1;
                    n3 = 2;
                } else {
                    n4 = 0;
                    n3 = 3;
                }
                pointDArray2[n6] = new PointD((pointDArray2[n4].x + pointDArray2[n3].x) / 2.0, (pointDArray2[n4].y + pointDArray2[n3].y) / 2.0);
            }
            if (pointDArray2[n5] == null) {
                if (n5 == 0 || n5 == 3) {
                    n4 = 1;
                    n3 = 2;
                } else {
                    n4 = 0;
                    n3 = 3;
                }
                pointDArray2[n5] = new PointD((pointDArray2[n4].x + pointDArray2[n3].x) / 2.0, (pointDArray2[n4].y + pointDArray2[n3].y) / 2.0);
            }
            if (pointDArray2[n6] == null || pointDArray2[n5] == null) continue;
            double d2 = FastMath.atan2(pointDArray2[n5].y - pointDArray2[n6].y, pointDArray2[n5].x - pointDArray2[n6].x);
            double d3 = d * FastMath.cos(d2);
            pointDArray2[n6].x -= d3;
            pointDArray2[n5].x += d3;
            d3 = d * FastMath.sin(d2);
            pointDArray2[n6].y -= d3;
            pointDArray2[n5].y += d3;
        }
        return pointDArray2;
    }

    private int drawFils(Graphics graphics, ViewSimple viewSimple) {
        return this.drawFils(graphics, viewSimple, 1);
    }

    private int drawFils(Graphics graphics, ViewSimple viewSimple, int n) {
        int n2 = 0;
        int n3 = 19;
        if (this.width > 1 && this.order < n3 && this.parente < n) {
            this.fils = this.getChild();
            if (this.fils != null) {
                for (int i = 0; i < 4; ++i) {
                    if (this.fils[i] == null) continue;
                    n2 += this.fils[i].draw(graphics, viewSimple, n);
                }
            }
        }
        return n2;
    }

    private Image createImage() throws Exception {
        if (this.imgBuf != null && (this.planBG.color || this.imgID == this.planBG.imgID)) {
            if (!this.allSky) {
                ++this.planBG.nbImgInBuf;
            }
            return this.imgBuf;
        }
        BufferedImage bufferedImage = null;
        if (this.planBG.color) {
            int[] nArray = this.parente == 0 ? this.rgb : this.getPixelFromAncetreRGB();
            DataBufferInt dataBufferInt = new DataBufferInt(nArray, this.width * this.height);
            int[] nArray2 = new int[]{0xFF0000, 65280, 255, -16777216};
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, this.width, this.height, nArray2);
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, null);
            bufferedImage = new BufferedImage(colorModel, writableRaster, true, null);
        } else {
            byte[] byArray = this.parente == 0 ? this.pixels : this.getPixelFromAncetre();
            bufferedImage = new BufferedImage(this.width, this.height, 13, (IndexColorModel)this.planBG.getCM());
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(0, 0, this.width, this.height, byArray);
        }
        if (!this.allSky) {
            ++this.planBG.nbImgCreated;
        }
        this.imgID = this.planBG.imgID;
        if (this.planBG.aladin.enoughMemory()) {
            this.imgBuf = bufferedImage;
        }
        return bufferedImage;
    }

    protected int getMem() {
        int n = 0;
        if (this.pixels != null) {
            n += this.pixels.length * 2;
        } else if (this.rgb != null) {
            n += this.rgb.length * 8;
        }
        if (this.stream != null) {
            n += this.stream.length;
        }
        if (this.pixelsOrigin != null) {
            n += this.pixelsOrigin.length;
        }
        return n;
    }

    protected int getFullMem() {
        int n = this.getMem();
        if (this.fils != null) {
            for (int i = 0; i < 4; ++i) {
                n += this.fils[i].getFullMem();
            }
        }
        return n;
    }

    protected String getLongFullMem() {
        int n = this.getFullMem() / 1024;
        if (n > 1024) {
            return n / 1024 + "MB";
        }
        return n + "KB";
    }

    protected boolean isBehindSky(PointD[] pointDArray, ViewSimple viewSimple) {
        double d = viewSimple.getProj().sym ? -1.0 : 1.0;
        return ((pointDArray[1].x - pointDArray[0].x) * (pointDArray[2].y - pointDArray[0].y) - (pointDArray[2].x - pointDArray[0].x) * (pointDArray[1].y - pointDArray[0].y)) * d <= 0.0;
    }

    protected boolean mustBeDivided(PointD[] pointDArray) throws Exception {
        double d;
        double d2;
        block7: {
            block6: {
                double d3;
                if (PlanBG.DEBUGMODE) {
                    return false;
                }
                d2 = HealpixKey.dist(pointDArray, 0, 2);
                if (d2 > 78400.0) break block6;
                d = HealpixKey.dist(pointDArray, 2, 1);
                if (!(d3 > 78400.0)) break block7;
            }
            return true;
        }
        if (d2 == 0.0 || d == 0.0) {
            throw new Exception("Rhomb error");
        }
        double d4 = HealpixKey.dist(pointDArray, 0, 3);
        double d5 = HealpixKey.dist(pointDArray, 1, 2);
        if (d5 == 0.0 || d5 == 0.0) {
            throw new Exception("Rhomb error");
        }
        double d6 = d5 > d4 ? d4 / d5 : d5 / d4;
        return d6 < 0.7 && (d4 > 22500.0 || d5 > 22500.0);
    }

    protected boolean isTooLarge(PointD[] pointDArray, int n) throws Exception {
        double d;
        double d2;
        block7: {
            block6: {
                double d3;
                n *= n;
                d2 = HealpixKey.dist(pointDArray, 0, 2);
                if (d2 > (double)n) break block6;
                d = HealpixKey.dist(pointDArray, 2, 1);
                if (!(d3 > (double)n)) break block7;
            }
            return true;
        }
        if (d2 == 0.0 || d == 0.0) {
            throw new Exception("Rhomb error");
        }
        double d4 = HealpixKey.dist(pointDArray, 0, 3);
        double d5 = HealpixKey.dist(pointDArray, 1, 2);
        if (d4 > (double)n || d5 > (double)n) {
            return true;
        }
        if (d5 == 0.0 || d5 == 0.0) {
            throw new Exception("Rhomb error");
        }
        return false;
    }

    protected boolean mayCrossTheSky(ViewSimple viewSimple) {
        Projection projection = this.planBG.projd;
        if (projection.t == 2 || projection.t == 1 || projection.t == 6) {
            return false;
        }
        return viewSimple.getTaille() > 45.0;
    }

    protected int draw(Graphics graphics, ViewSimple viewSimple) {
        return this.draw(graphics, viewSimple, -1);
    }

    protected int draw(Graphics graphics, ViewSimple viewSimple, int n) {
        long l = cds.tools.Util.getTime(0);
        int n2 = 0;
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        ++nDraw;
        boolean bl = false;
        if (pointDArray == null || (bl = this.isOutView(viewSimple, pointDArray))) {
            if (bl) {
                ++nOut;
            }
            return 0;
        }
        try {
            pointDArray = HealpixKey.grow(pointDArray, 1.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = this.planBG.mustDrawFast();
        if (pointDArray[0] != null && pointDArray[1] != null && pointDArray[2] != null && pointDArray[3] != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl2 && (this.planBG.projd.t == 4 || this.planBG.projd.t == 11);
            if (bl3 && (HealpixKey.aDroite(pointDArray[0], pointDArray[1], pointDArray[2]) * HealpixKey.aDroite(pointDArray[3], pointDArray[1], pointDArray[2]) >= 0.0 || HealpixKey.aDroite(pointDArray[1], pointDArray[0], pointDArray[3]) * HealpixKey.aDroite(pointDArray[2], pointDArray[0], pointDArray[3]) >= 0.0)) {
                double d;
                double d2 = HealpixKey.dist(pointDArray, 1, 2);
                if (d2 < (d = HealpixKey.dist(pointDArray, 0, 3))) {
                    double d3;
                    double d4 = HealpixKey.distCentre(pointDArray[0], pointDArray[1], pointDArray[2]);
                    if (d4 < (d3 = HealpixKey.distCentre(pointDArray[3], pointDArray[1], pointDArray[2]))) {
                        pointDArray[3] = null;
                    } else {
                        pointDArray[0] = null;
                    }
                } else {
                    double d5;
                    double d6 = HealpixKey.distCentre(pointDArray[1], pointDArray[0], pointDArray[3]);
                    if (d6 < (d5 = HealpixKey.distCentre(pointDArray[2], pointDArray[0], pointDArray[3]))) {
                        pointDArray[2] = null;
                    } else {
                        pointDArray[1] = null;
                    }
                }
            } else {
                try {
                    boolean bl5;
                    boolean bl6 = this.mayCrossTheSky(viewSimple);
                    boolean bl7 = bl5 = (this.planBG.projd.t == 5 || this.planBG.projd.t == 3 || this.planBG.projd.t == 16 || this.planBG.projd.t == 11 || this.planBG.projd.t == 4) && bl6 || this.planBG.projd.t == 7;
                    if (bl5 && this.isTooLarge(pointDArray, this.planBG.projd.t == 3 || this.planBG.projd.t == 16 ? 100 : 150)) {
                        this.resetTimer();
                        int n3 = this.drawFils(graphics, viewSimple, bl2 ? 1 : (this.planBG.projd.t == 5 ? 8 : 4));
                        if (n3 > 0) {
                            return n3;
                        }
                    } else if (!bl2 && this.mustBeDivided(pointDArray)) {
                        this.resetTimer();
                        int n4 = this.drawFils(graphics, viewSimple, 8);
                        if (n4 > 0) {
                            return n4;
                        }
                    }
                    if (bl6 && this.isTooLarge(pointDArray, 150)) {
                        return 0;
                    }
                    if (this.planBG.projd.t == 6 && this.isTooLarge(pointDArray, 2 * viewSimple.rv.width / 3)) {
                        return 0;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 0;
                }
            }
        }
        if (!bl2 && (n == -1 || this.parente < n) && this.hpix.isPoleCorner() && (n2 = this.drawFils(graphics, viewSimple, this.parente + 1)) > 0) {
            return n2;
        }
        if (!(bl2 || pointDArray[0] != null && pointDArray[1] != null && pointDArray[2] != null && pointDArray[3] != null || (n2 = this.drawFils(graphics, viewSimple)) <= 0)) {
            return n2;
        }
        n2 = this.drawRhomb(graphics, pointDArray);
        this.drawLosangeBorder(graphics, pointDArray);
        long l2 = cds.tools.Util.getTime(0);
        if (!this.allSky) {
            ++this.planBG.nbImgDraw;
        }
        this.planBG.cumulTimeDraw += l2 - l;
        this.resetTimer();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drawRhomb(Graphics graphics, PointD[] pointDArray) {
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        if (pointDArray[0] == null) {
            n2 = 3;
        } else if (pointDArray[3] == null) {
            n3 = 0;
        } else if (pointDArray[1] == null) {
            n2 = 2;
        } else if (pointDArray[2] == null) {
            n3 = 1;
        } else {
            n2 = 0;
            n3 = 3;
        }
        if (n2 == -1 && n3 == -1) {
            return 0;
        }
        if (pointDArray[0] != null && pointDArray[1] != null && pointDArray[2] != null && pointDArray[3] != null && (int)pointDArray[0].x == (int)(pointDArray[1].x + pointDArray[2].x - pointDArray[3].x) && (int)pointDArray[0].y == (int)(pointDArray[2].y + pointDArray[1].y - pointDArray[3].y)) {
            bl = true;
        }
        Image image = null;
        try {
            image = this.createImage();
        }
        catch (Exception exception) {
            return 0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = this.getFadingOpacity();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(cds.tools.Util.getImageComposite(f));
        Shape shape = graphics2D.getClip();
        try {
            if (n2 != -1) {
                n += this.drawTriangle(graphics2D, image, pointDArray, n2, !bl);
            }
            if (n3 != -1 && !bl) {
                n += this.drawTriangle(graphics2D, image, pointDArray, n3, true);
            }
        }
        catch (Throwable throwable) {
            if (Aladin.levelTrace >= 3) {
                throwable.printStackTrace();
            }
            this.planBG.clearBuf();
        }
        finally {
            graphics2D.setComposite(composite);
            graphics2D.setClip(shape);
        }
        if (this.parente > 0) {
            this.pixels = null;
            this.rgb = null;
        }
        if (f < 1.0f) {
            this.planBG.updateFading(true);
        }
        return n;
    }

    private float getFadingOpacity() {
        return 1.0f;
    }

    public static double aDroite(PointD pointD, PointD pointD2, PointD pointD3) {
        double d = pointD3.x - pointD2.x;
        double d2 = pointD3.y - pointD2.y;
        return d * pointD.y - d2 * pointD.x - pointD3.y * d + pointD3.x * d2;
    }

    public static double distCentre(PointD pointD, PointD pointD2, PointD pointD3) {
        double d = (pointD2.x + pointD3.x) / 2.0;
        double d2 = (pointD2.y + pointD3.y) / 2.0;
        return (pointD.x - d) * (pointD.x - d) + (pointD.y - d2) * (pointD.y - d2);
    }

    public static void symetric(PointD pointD, PointD pointD2, PointD pointD3, PointD pointD4) {
        double d = Math.atan2(pointD4.y - pointD3.y, pointD4.x - pointD3.x);
        double d2 = Math.atan2(pointD2.y - pointD3.y, pointD2.x - pointD3.x);
        double d3 = d - d2;
        double d4 = pointD2.x - pointD3.x;
        double d5 = pointD2.y - pointD3.y;
        double d6 = FastMath.cos(-2.0 * d3);
        double d7 = FastMath.sin(-2.0 * d3);
        double d8 = d4 * d6 + d5 * d7;
        double d9 = -d4 * d7 + d5 * d6;
        pointD.x = d8 + pointD3.x;
        pointD.y = d9 + pointD3.y;
    }

    public static double dist(PointD[] pointDArray, int n, int n2) {
        double d = pointDArray[n].x - pointDArray[n2].x;
        double d2 = pointDArray[n].y - pointDArray[n2].y;
        double d3 = d * d + d2 * d2;
        return d3;
    }

    protected int drawTriangle(Graphics2D graphics2D, Image image, PointD[] pointDArray, int n, boolean bl) {
        int n2;
        int n3;
        switch (n) {
            case 0: {
                n3 = 2;
                n2 = 1;
                break;
            }
            case 3: {
                n3 = 1;
                n2 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                n2 = 0;
                break;
            }
            default: {
                n3 = 0;
                n2 = 3;
            }
        }
        if (pointDArray[n3] == null || pointDArray[n2] == null) {
            return 0;
        }
        if (bl) {
            PointD[] pointDArray2 = null;
            try {
                pointDArray2 = HealpixKey.grow(pointDArray, 2.0);
                Polygon polygon = new Polygon(new int[]{(int)(pointDArray2[n].x + 0.5), (int)(pointDArray2[n3].x + 0.5), (int)(pointDArray2[n2].x + 0.5)}, new int[]{(int)(pointDArray2[n].y + 0.5), (int)(pointDArray2[n3].y + 0.5), (int)(pointDArray2[n2].y + 0.5)}, 3);
                graphics2D.setClip(polygon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double d = pointDArray[n].x - pointDArray[n3].x;
        if (n == 0 || n == 2) {
            d = -d;
        }
        double d2 = pointDArray[n].y - pointDArray[n3].y;
        if (n == 0 || n == 2) {
            d2 = -d2;
        }
        double d3 = FastMath.atan2(d2, d);
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = d4 / (double)this.width;
        double d6 = pointDArray[n].x - pointDArray[n2].x;
        if (n == 0 || n == 2) {
            d6 = -d6;
        }
        double d7 = pointDArray[n].y - pointDArray[n2].y;
        if (n == 0 || n == 2) {
            d7 = -d7;
        }
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        double d9 = FastMath.atan2(d7, d6) - d3;
        double d10 = d8 * FastMath.sin(d9) / (double)this.width;
        double d11 = d8 * FastMath.cos(d9) / d4;
        AffineTransform affineTransform = new AffineTransform();
        if (n == 3 || n == 1) {
            affineTransform.translate(pointDArray[n3].x + pointDArray[n2].x - pointDArray[n].x, pointDArray[n3].y + pointDArray[n2].y - pointDArray[n].y);
        } else {
            affineTransform.translate(pointDArray[n].x, pointDArray[n].y);
        }
        affineTransform.rotate(d3);
        affineTransform.scale(d5, d10);
        affineTransform.shear(d11, 0.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.planBG.mustDrawFast() && this.order - this.parente < this.planBG.maxOrder || this.order - this.parente >= this.planBG.maxOrder ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (image == null) {
            return 0;
        }
        graphics2D.drawImage(image, affineTransform, this.planBG.aladin);
        return 1;
    }

    protected final void drawLosangeBorder(Graphics graphics, PointD[] pointDArray) {
        this.drawLosangeBorder(graphics, pointDArray, false);
    }

    protected final void drawLosangeBorder(Graphics graphics, PointD[] pointDArray, boolean bl) {
        if (!this.planBG.ref) {
            return;
        }
        int n = this.planBG.isDebugIn(this.npix);
        if (!bl && n == 0) {
            Aladin cfr_ignored_0 = this.planBG.aladin;
            if (Aladin.levelTrace < 6) {
                return;
            }
        }
        PointD[] pointDArray2 = new PointD[4];
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            if (pointDArray[i] == null) continue;
            pointDArray2[n2++] = pointDArray[i];
        }
        Polygon polygon = null;
        if (n2 == 4) {
            polygon = new Polygon(new int[]{(int)pointDArray2[0].x, (int)pointDArray2[1].x, (int)pointDArray2[3].x, (int)pointDArray2[2].x}, new int[]{(int)pointDArray2[0].y, (int)pointDArray2[1].y, (int)pointDArray2[3].y, (int)pointDArray2[2].y}, 4);
        } else if (n2 == 3) {
            polygon = new Polygon(new int[]{(int)pointDArray2[0].x, (int)pointDArray2[1].x, (int)pointDArray2[2].x}, new int[]{(int)pointDArray2[0].y, (int)pointDArray2[1].y, (int)pointDArray2[2].y}, 3);
        } else {
            return;
        }
        if (n > 0) {
            graphics.setColor(n == 1 ? BLUE1 : (n == 2 ? BLUE2 : BLUE3));
            graphics.fillPolygon(polygon);
        }
        Color color = this.parente > 0 ? new Color(100, 100, 0) : Color.green;
        graphics.setColor(n2 == 3 ? Color.red : color);
        graphics.drawPolygon(polygon);
    }

    protected final void drawLosangeBorder(Graphics graphics, ViewSimple viewSimple) {
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        if (pointDArray == null || pointDArray[0] == null || pointDArray[1] == null || pointDArray[2] == null || pointDArray[3] == null) {
            return;
        }
        double d = HealpixKey.dist(pointDArray, 0, 1);
        double d2 = HealpixKey.dist(pointDArray, 0, 2);
        double d3 = HealpixKey.dist(pointDArray, 1, 3);
        double d4 = HealpixKey.dist(pointDArray, 2, 3);
        double d5 = Math.min(Math.min(d, d2), Math.min(d3, d4));
        double d6 = 20.0 * d5;
        if (d < d6) {
            graphics.drawLine((int)pointDArray[0].x, (int)pointDArray[0].y, (int)pointDArray[1].x, (int)pointDArray[1].y);
        }
        if (d2 < d6) {
            graphics.drawLine((int)pointDArray[0].x, (int)pointDArray[0].y, (int)pointDArray[2].x, (int)pointDArray[2].y);
        }
        if (d3 < d6) {
            graphics.drawLine((int)pointDArray[1].x, (int)pointDArray[1].y, (int)pointDArray[3].x, (int)pointDArray[3].y);
        }
        if (d4 < d6) {
            graphics.drawLine((int)pointDArray[2].x, (int)pointDArray[2].y, (int)pointDArray[3].x, (int)pointDArray[3].y);
        }
        this.drawNumber(graphics, viewSimple, pointDArray);
    }

    private final void drawNumber(Graphics graphics, ViewSimple viewSimple, PointD[] pointDArray) {
        if (viewSimple.isAllSky()) {
            return;
        }
        String string = this.getStringNumber();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        double d = Math.min(Math.min(pointDArray[0].x, pointDArray[1].x), Math.min(pointDArray[2].x, pointDArray[3].x));
        double d2 = Math.max(Math.max(pointDArray[0].x, pointDArray[1].x), Math.max(pointDArray[2].x, pointDArray[3].x));
        double d3 = d2 - d;
        if ((double)n < d3) {
            int n3 = (int)(pointDArray[0].x + pointDArray[1].x + pointDArray[2].x + pointDArray[3].x) / 4 - n / 2;
            int n4 = (int)(pointDArray[0].y + pointDArray[1].y + pointDArray[2].y + pointDArray[3].y) / 4 + n2 / 2;
            boolean bl = false;
            boolean bl2 = false;
            bl = n3 < 3;
            if (bl) {
                n3 = 3;
            } else {
                bl = n3 + n + 3 > viewSimple.rv.width;
                if (bl) {
                    n3 = viewSimple.rv.width - n - 3;
                }
            }
            if (bl2 = n4 < 25) {
                n4 = 25;
            } else {
                bl2 = n4 + 25 > viewSimple.rv.height;
                if (bl2) {
                    n4 = viewSimple.rv.height - 25;
                }
            }
            if (bl || bl2) {
                if (d3 < 150.0) {
                    return;
                }
                Polygon polygon = new Polygon();
                polygon.addPoint((int)pointDArray[0].x, (int)pointDArray[0].y);
                polygon.addPoint((int)pointDArray[1].x, (int)pointDArray[1].y);
                polygon.addPoint((int)pointDArray[3].x, (int)pointDArray[3].y);
                polygon.addPoint((int)pointDArray[2].x, (int)pointDArray[2].y);
                if (!polygon.contains(n3, n4) || !polygon.contains(n3 + n, n4)) {
                    return;
                }
            }
            int n5 = fontMetrics.stringWidth(this.order + "");
            cds.tools.Util.drawStringOutline(graphics, this.order + "", n3, n4 - 4, Color.green, Color.black);
            cds.tools.Util.drawStringOutline(graphics, this.npix + "", n3 + n5 + 4, n4 + 4, Color.green, Color.black);
            graphics.drawString("/", n3 + n5, n4);
        }
    }

    protected void drawRealBorders(Graphics graphics, ViewSimple viewSimple) {
        block4: {
            try {
                Projection projection = viewSimple.getProj();
                double[][] dArray = CDSHealpix.borders(CDSHealpix.pow2(this.order), this.npix, 50);
                for (int i = 0; i < dArray.length; ++i) {
                    Coord coord = new Coord(dArray[i][0], dArray[i][1]);
                    int n = this.hpix.getFrame();
                    if (n != 0) {
                        coord = Localisation.frameToFrame(coord, n, 0);
                    }
                    projection.getXY(coord);
                    if (Double.isNaN(coord.x)) continue;
                    PointD pointD = viewSimple.getViewCoordDble(coord.x, coord.y);
                    graphics.drawLine((int)pointD.x, (int)pointD.y, (int)pointD.x, (int)pointD.y);
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
    }

    protected void drawCtrl(Graphics graphics, ViewSimple viewSimple) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.red);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(2.0f));
        this.drawRealBorders(graphics2D, viewSimple);
        graphics2D.setStroke(stroke);
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        if (pointDArray == null || pointDArray[0] == null || pointDArray[1] == null || pointDArray[2] == null || pointDArray[3] == null) {
            return;
        }
        String string = this.getStringNumber();
        graphics2D.setFont(Aladin.PLAIN);
        try {
            string = string + " (" + CDSHealpix.nest2ring(CDSHealpix.pow2(this.order - this.parente), this.npix / (long)Math.pow(4.0, this.parente)) + ")";
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = graphics2D.getFontMetrics().stringWidth(string);
        int n2 = (int)(pointDArray[0].x + pointDArray[1].x + pointDArray[2].x + pointDArray[3].x) / 4;
        int n3 = (int)(pointDArray[0].y + pointDArray[1].y + pointDArray[2].y + pointDArray[3].y) / 4 + 7;
        if (Math.abs(pointDArray[2].x - pointDArray[1].x) < (double)(n + 18)) {
            n3 = (int)Math.min(Math.min(pointDArray[0].y, pointDArray[1].y), Math.min(pointDArray[2].y, pointDArray[3].y)) - 10;
        }
        graphics2D.drawString(string, n2 - n / 2, n3 + 3);
        graphics2D.setColor(color);
    }

    protected long getFather() {
        return this.npix / 4L;
    }

    protected long[] getChildren() {
        return this.getChildren(null);
    }

    protected long[] getChildren(long[] lArray) {
        if (lArray == null) {
            lArray = new long[]{this.npix * 4L, this.npix * 4L + 1L, this.npix * 4L + 2L, this.npix * 4L + 3L};
        }
        return lArray;
    }

    protected Coord[] getCorners() {
        return this.hpix.getCorners();
    }

    protected boolean isOutView(ViewSimple viewSimple) {
        return this.hpix.isOutView(viewSimple, null);
    }

    protected boolean isOutView(ViewSimple viewSimple, PointD[] pointDArray) {
        return this.hpix.isOutView(viewSimple, pointDArray);
    }

    protected final PointD[] getProjViewCorners(ViewSimple viewSimple) {
        return this.hpix.getProjViewCorners(viewSimple);
    }

    HealpixKey[] getPixList() {
        return null;
    }

    protected int getLosangeOrder() {
        return (int)CDSHealpix.log2(this.width);
    }

    @Override
    public int compareTo(HealpixKey healpixKey) {
        return this.priority - healpixKey.priority;
    }
}

