/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.HealpixKey;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class HealpixKeyCat
extends HealpixKey {
    Pcat pcat = null;
    int mem = 0;
    boolean last;
    int nLoaded;
    int nTotal;
    private static final char[] LAST = new char[]{'#', 'l', 'a', 's', 't', ' ', 'l', 'e', 'v', 'e', 'l'};
    private static final char[] NLOADED = new char[]{'#', ' ', 'n', 'L', 'o', 'a', 'd', 'e', 'd', ':', ' '};
    private static final char[] COMPLETENESS = new char[]{'#', ' ', 'C', 'o', 'm', 'p', 'l', 'e', 't', 'e', 'n', 'e', 's', 's', ' ', '='};

    protected HealpixKeyCat(PlanBG planBG) {
        super(planBG);
    }

    protected HealpixKeyCat(PlanBG planBG, int n, long l) {
        super(planBG, n, l, 1);
        this.last = false;
        this.nTotal = 0;
    }

    @Override
    protected void updateCacheIfRequired(int n) throws Exception {
        if (!this.planBG.live) {
            return;
        }
    }

    @Override
    protected long loadCache(String string) throws Exception {
        this.loadTSV(string);
        this.stream = null;
        return 0L;
    }

    @Override
    protected long loadNet(String string) throws Exception {
        this.loadTSV(string);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTSV(String string) throws Exception {
        this.pcat = new Pcat(this.planBG);
        this.stream = this.loadStream(string);
        this.mem = this.stream.length;
        MyInputStream myInputStream = null;
        try {
            block9: {
                try {
                    this.testLast(this.stream);
                    this.testNLoaded(this.stream);
                    this.testCompleteness(this.stream);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block9;
                    exception.printStackTrace();
                }
            }
            Aladin cfr_ignored_0 = this.planBG.aladin;
            int n = Aladin.levelTrace;
            Aladin cfr_ignored_1 = this.planBG.aladin;
            Aladin.levelTrace = 0;
            Legende legende = this.planBG.getFirstLegende();
            if (legende != null) {
                this.pcat.setGenericLegende(legende);
            }
            myInputStream = new MyInputStream(this.getInputStreamFromStream());
            myInputStream.setFileName(string);
            this.pcat.tableParsing(myInputStream, null);
            Aladin cfr_ignored_2 = this.planBG.aladin;
            Aladin.levelTrace = n;
            if (!this.planBG.useCache) {
                this.stream = null;
            }
            if (legende == null) {
                ((PlanBGCat)this.planBG).setLegende(((Source)this.pcat.iterator().next()).leg);
            }
            this.recomputePosition(legende, this.pcat);
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
    }

    protected InputStream getInputStreamFromStream() throws Exception {
        return new ByteArrayInputStream(this.stream);
    }

    public void recomputePosition(Legende legende, Pcat pcat) {
        if (this.planBG.epoch == null || this.planBG.getEpoch().toString("J").equals("J2000")) {
            return;
        }
        int n = legende.getPmRa();
        int n2 = legende.getPmDe();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        int n3 = legende.getRa();
        int n4 = legende.getDe();
        this.planBG.recomputePosition(pcat.iterator(), legende, n3, n4, n, n2);
    }

    private void testLast(byte[] byArray) {
        if (byArray.length < LAST.length) {
            return;
        }
        for (int i = 0; i < LAST.length; ++i) {
            if (LAST[i] == byArray[i]) continue;
            return;
        }
        this.last = true;
    }

    private void testNLoaded(byte[] byArray) {
        int n;
        int n2;
        if (byArray.length < NLOADED.length) {
            return;
        }
        for (n2 = 0; n2 < NLOADED.length; ++n2) {
            if (NLOADED[n2] == byArray[n2]) continue;
            return;
        }
        n2 = NLOADED.length;
        int n3 = 0;
        for (n = NLOADED.length; n < byArray.length && byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32; ++n) {
            if (byArray[n] != 47) continue;
            n3 = n;
        }
        if (n3 == 0) {
            return;
        }
        if (n == byArray.length) {
            return;
        }
        try {
            this.nLoaded = Integer.parseInt(new String(byArray, n2, n3 - n2));
            this.nTotal = Integer.parseInt(new String(byArray, n3 + 1, n - (n3 + 1)));
            this.last = this.nLoaded == this.nTotal;
        }
        catch (Exception exception) {
            this.nLoaded = 1;
            this.nTotal = 2;
            this.last = false;
        }
    }

    private void testCompleteness(byte[] byArray) {
        int n;
        int n2;
        if (byArray.length < COMPLETENESS.length) {
            return;
        }
        for (n2 = 0; n2 < COMPLETENESS.length; ++n2) {
            if (COMPLETENESS[n2] == byArray[n2]) continue;
            return;
        }
        n2 = COMPLETENESS.length;
        int n3 = 0;
        for (n = COMPLETENESS.length; n < byArray.length && byArray[n] != 10 && byArray[n] != 13; ++n) {
            if (byArray[n] != 47) continue;
            n3 = n;
        }
        if (n3 == 0) {
            return;
        }
        if (n == byArray.length) {
            return;
        }
        try {
            this.nLoaded = Integer.parseInt(new String(byArray, n2, n3 - n2).trim());
            this.nTotal = Integer.parseInt(new String(byArray, n3 + 1, n - (n3 + 1)).trim());
            this.last = this.nLoaded == this.nTotal;
        }
        catch (Exception exception) {
            this.nLoaded = 1;
            this.nTotal = 2;
            this.last = false;
        }
    }

    protected boolean isLast() {
        return this.last;
    }

    protected boolean isReallyLast(ViewSimple viewSimple) {
        return this.last;
    }

    @Override
    protected int writeCache() throws Exception {
        int n = this.writeStream();
        this.stream = null;
        return n;
    }

    @Override
    protected int free() {
        return this.free(true);
    }

    protected int free(boolean bl) {
        if (this.allSky) {
            return 0;
        }
        int n = this.getStatus();
        if (n == 4 || n == 5) {
            this.abort();
        } else if (n == 6 && this.planBG.useCache) {
            this.write();
        }
        if (this.pcat != null) {
            if (!bl && this.pcat.hasSelectedOrTaggedObj()) {
                return 0;
            }
            this.pcat.free();
            this.mem = 0;
        }
        ++this.planBG.nbFree;
        this.setStatus(0);
        return 1;
    }

    @Override
    protected void clearBuf() {
    }

    @Override
    protected int getMem() {
        return this.mem;
    }

    @Override
    protected int draw(Graphics graphics, ViewSimple viewSimple) {
        return this.draw1(graphics, viewSimple, false);
    }

    protected int drawOnlySelected(Graphics graphics, ViewSimple viewSimple) {
        return this.draw1(graphics, viewSimple, true);
    }

    private int draw1(Graphics graphics, ViewSimple viewSimple, boolean bl) {
        if (this.pcat == null || !this.pcat.hasObj()) {
            return 0;
        }
        int n = this.pcat.draw(graphics, null, viewSimple, true, bl, 0, 0);
        this.resetTimer();
        return n;
    }

    protected void resetDrawnInView(ViewSimple viewSimple) {
        if (this.pcat == null || !this.pcat.hasObj()) {
            return;
        }
        this.pcat.resetDrawnInView(viewSimple);
    }

    private int getCounts() {
        if (this.getStatus() == 6 && this.pcat != null) {
            return this.pcat.getCount();
        }
        return 0;
    }

    @Override
    public String toString() {
        int n = this.getStatus();
        String string = n == 5 || n == 4 ? "**" : (n == 3 || n == 2 ? " x" : " .");
        return string + "[" + Util.align(this.priority + "", 5) + "] " + Util.align(this.getStringNumber(), 8) + Util.align(this.getCounts() + "s", 8) + Util.align(this.getLongFullMem(), 8) + Util.align(this.getStatusString(), 16) + (this.timer == -1L ? -1L : this.getCurrentLiveTime() / 1000L) + "s => " + VIE[-this.getLive()] + (this.getStatus() == 6 ? (this.fromNet ? " Net" : " Cache") + ":" + this.timeStream + "ms" : "") + (this.isLast() ? " last" : "") + (this.nTotal != 0 ? " " + this.nLoaded + "/" + this.nTotal : "");
    }
}

