/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixKey;
import cds.aladin.PlanBG;
import cds.aladin.PlanHealpix;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.tools.pixtools.CDSHealpix;
import healpix.essentials.FastMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

class HealpixKeyPol
extends HealpixKey {
    protected int bitpix = 0;
    protected int bitpix2 = 0;
    protected byte[] pixelsOrigin = null;
    protected byte[] pixelsOrigin2 = null;
    protected double deltaAngle = 0.0;
    private static final int PIX8 = 0;
    private static final int PIXORIGIN = 1;
    private static final int PIXORIGIN2 = 2;
    private static final int MAXPOLARSIZE = 15;

    protected HealpixKeyPol() {
    }

    protected HealpixKeyPol(PlanBG planBG, int n, long l) {
        super(planBG, n, l);
    }

    protected HealpixKeyPol(HealpixKeyPol healpixKeyPol, int n) {
        super(healpixKeyPol, n);
        this.bitpix = healpixKeyPol.bitpix;
        this.bitpix2 = healpixKeyPol.bitpix2;
        this.pixelsOrigin = null;
        this.pixelsOrigin2 = null;
    }

    private byte[] getPixelFromAncetre(int n) throws Exception {
        byte[] byArray = null;
        switch (n) {
            case 0: {
                return super.getPixelFromAncetre();
            }
            case 1: {
                if (this.bitpix == 0) {
                    throw new Exception("No pixelsOrigin in memory !");
                }
                byArray = ((HealpixKeyPol)this.anc).pixelsOrigin == null ? ((HealpixKeyPol)this.anc).getPixelFromAncetre(n) : ((HealpixKeyPol)this.anc).pixelsOrigin;
                return this.getPixelFromAncetre1(byArray, Math.abs(this.bitpix) / 8);
            }
            case 2: {
                if (this.bitpix2 == 0) {
                    throw new Exception("No pixelsOrigin2 in memory !");
                }
                byArray = ((HealpixKeyPol)this.anc).pixelsOrigin2 == null ? ((HealpixKeyPol)this.anc).getPixelFromAncetre(n) : ((HealpixKeyPol)this.anc).pixelsOrigin2;
                return this.getPixelFromAncetre1(byArray, Math.abs(this.bitpix2) / 8);
            }
        }
        return null;
    }

    private byte[] getPixelFromAncetre1(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.width * this.height * n];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                System.arraycopy(byArray, ((i + this.p.y) * this.anc.width + (j + this.p.x)) * n, byArray2, (i * this.width + j) * n, n);
            }
        }
        return byArray2;
    }

    @Override
    protected int free1() {
        int n = super.free1();
        if (this.pixelsOrigin != null) {
            this.pixelsOrigin = null;
            n = 1;
        }
        if (this.pixelsOrigin2 != null) {
            this.pixelsOrigin2 = null;
            n = 1;
        }
        return n;
    }

    private final double getPixVal(byte[] byArray, int n, int n2) {
        switch (n) {
            case 8: {
                return byArray[n2] & 0xFF;
            }
            case 16: {
                return byArray[n2 *= 2] << 8 | byArray[n2 + 1] & 0xFF;
            }
            case 32: {
                return byArray[n2 *= 4] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
            }
            case -32: {
                return Float.intBitsToFloat(byArray[n2 *= 4] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF);
            }
            case -64: {
                return Double.longBitsToDouble((long)(byArray[n2 *= 8] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF) << 32 | (long)(byArray[n2 + 4] << 24 | (byArray[n2 + 5] & 0xFF) << 16 | (byArray[n2 + 6] & 0xFF) << 8 | byArray[n2 + 7] & 0xFF) & 0xFFFFFFFFL);
            }
        }
        return 0.0;
    }

    @Override
    protected int loadFits(String string) throws Exception {
        int n;
        byte[] byArray;
        block5: {
            byte[] byArray2 = this.loadStream(string);
            byte[] byArray3 = new byte[2880];
            System.arraycopy(byArray2, 0, byArray3, 0, 2880);
            try {
                this.width = (int)this.getValue(byArray3, "NAXIS1");
                this.height = (int)this.getValue(byArray3, "NAXIS2");
                this.bitpix = (int)this.getValue(byArray3, "BITPIX");
            }
            catch (Exception exception) {
                this.height = 1024;
                this.width = 1024;
                this.bitpix = 8;
            }
            int n2 = this.width * this.height * (Math.abs(this.bitpix) / 8);
            byArray = new byte[n2];
            System.arraycopy(byArray2, 2880, byArray, 0, n2);
            this.pixelsOrigin = new byte[byArray.length];
            this.invLine(byArray, this.pixelsOrigin, this.bitpix);
            n = 2880 + n2;
            int n3 = n / 2880 * 2880;
            if (n % 2880 != 0) {
                n3 += 2880;
            }
            System.arraycopy(byArray2, n3, byArray3, 0, 2880);
            try {
                this.bitpix2 = (int)this.getValue(byArray3, "BITPIX");
                n2 = this.width * this.height * (Math.abs(this.bitpix2) / 8);
                byArray = new byte[n2];
                System.arraycopy(byArray2, n3 + 2880, byArray, 0, n2);
                this.pixelsOrigin2 = new byte[n2];
                this.invLine(byArray, this.pixelsOrigin2, this.bitpix2);
                n = n3 + n2 + 2880;
            }
            catch (Exception exception) {
                Aladin cfr_ignored_0 = this.planBG.aladin;
                if (Aladin.levelTrace < 3) break block5;
                exception.printStackTrace();
                System.err.println("Erreur \u00e0 la lecture de " + string);
            }
        }
        byArray = null;
        return n;
    }

    private int drawPolarisationFils(Graphics graphics, ViewSimple viewSimple, int n) {
        int n2 = 0;
        if (this.width >= 1) {
            this.fils = this.getChild();
            if (this.fils != null) {
                for (int i = 0; i < 4; ++i) {
                    if (this.fils[i] == null) continue;
                    n2 += ((HealpixKeyPol)this.fils[i]).drawPolarisation(graphics, viewSimple, n + 1);
                }
            }
        }
        return n2;
    }

    protected double getPixRes() {
        long l = CDSHealpix.pow2((long)this.order + PlanHealpix.log2(this.width));
        return CDSHealpix.pixRes(l) / 3600.0;
    }

    protected int drawPolarisation(Graphics graphics, ViewSimple viewSimple) {
        return this.drawPolarisation(graphics, viewSimple, 0);
    }

    protected int drawPolarisation(Graphics graphics, ViewSimple viewSimple, int n) {
        try {
            PointD[] pointDArray = this.getProjViewCorners(viewSimple);
            if (pointDArray == null || pointDArray[0] == null || pointDArray[1] == null || pointDArray[2] == null || pointDArray[3] == null) {
                return 0;
            }
            if (this.isBehindSky(pointDArray, viewSimple)) {
                return 0;
            }
            if (n < 8 && this.mustBeDivided(pointDArray)) {
                int n2 = this.drawPolarisationFils(graphics, viewSimple, n + 1);
                this.resetTimer();
                return n2;
            }
            double d = viewSimple.getTaille() / this.getPixRes();
            int n3 = 1;
            double d2 = 15.0f * this.planBG.getSegmentDensityFactor();
            for (double d3 = (double)viewSimple.getWidth() / d; d3 < d2 && n3 * 2 < this.width; d3 *= 2.0) {
                n3 *= 2;
            }
            byte[] byArray = null;
            byte[] byArray2 = null;
            byArray = n == 0 ? this.pixelsOrigin : this.getPixelFromAncetre(1);
            byArray2 = n == 0 ? this.pixelsOrigin2 : this.getPixelFromAncetre(2);
            double d4 = this.getDeltaAngle(viewSimple);
            graphics.setColor(this.planBG.c == Color.black ? Color.green : this.planBG.c);
            double d5 = 0.5;
            for (int i = n3 / 2; i < this.height; i += n3) {
                for (int j = n3 / 2; j < this.width; j += n3) {
                    double d6 = ((double)j + d5) / (double)this.width;
                    double d7 = ((double)i + d5) / (double)this.height;
                    double d8 = pointDArray[0].x + (pointDArray[2].x - pointDArray[0].x) * d6;
                    double d9 = pointDArray[0].y + (pointDArray[2].y - pointDArray[0].y) * d6;
                    double d10 = pointDArray[1].x + (pointDArray[3].x - pointDArray[1].x) * d6;
                    double d11 = pointDArray[1].y + (pointDArray[3].y - pointDArray[1].y) * d6;
                    double d12 = d8 + (d10 - d8) * d7;
                    double d13 = d9 + (d11 - d9) * d7;
                    int n4 = i;
                    int n5 = j;
                    int n6 = n4 * this.width + n5;
                    double d14 = this.getPixVal(byArray, this.bitpix, n6);
                    double d15 = this.getPixVal(byArray2, this.bitpix2, n6);
                    double d16 = Math.toDegrees(0.5 * Math.atan2(d15, d14));
                    double d17 = Math.sqrt(d15 * d15 + d14 * d14);
                    d16 = 90.0 + d16 + d4;
                    this.drawSegment(graphics, d12, d13, Math.toRadians(d16), d17 *= (double)(100.0f * this.planBG.getSegmentLenFactor()), this.planBG.getSegmentThickness());
                }
            }
            return 1;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private double getDeltaAngle(ViewSimple viewSimple) {
        Coord[] coordArray = this.getCorners();
        if (coordArray == null) {
            return 0.0;
        }
        Coord coord = new Coord(coordArray[0].al, coordArray[0].del);
        Projection projection = viewSimple.getProj();
        projection.getXY(coord);
        Coord coord2 = new Coord(coordArray[3].al, coordArray[3].del);
        coord2.del = coord2.del + 0.01 > 90.0 ? coord2.del - 0.01 : coord2.del + 0.01;
        projection.getXY(coord2);
        double d = Math.toDegrees(Math.atan2(coord2.y - coord.y, coord2.x - coord.x));
        return Double.isNaN(d) ? 0.0 : 90.0 + d;
    }

    private void drawSegment(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        double d5 = d + d4 * FastMath.cos(d3);
        double d6 = d2 + d4 * FastMath.sin(d3);
        double d7 = (d5 - d) / 2.0;
        double d8 = (d6 - d2) / 2.0;
        if (n > 1 && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n));
            graphics2D.drawLine((int)(d - d7), (int)(d2 - d8), (int)(d + d7), (int)(d2 + d8));
            graphics2D.setStroke(stroke);
        } else {
            graphics.drawLine((int)(d - d7), (int)(d2 - d8), (int)(d + d7), (int)(d2 + d8));
        }
    }
}

