/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.aladin.stc.STCStringParser;
import cds.tools.Util;
import java.util.ArrayList;
import java.util.List;

public class HealpixProgenItem {
    private String json;
    private List<STCObj> stcObjects = null;
    private boolean stcError = false;
    static final char SEP = Util.FS.charAt(0);
    private long ovIZ;
    private PointD[] viewCorners;
    private Coord[] corners;
    private int nNull;
    private boolean computeCorners;

    public HealpixProgenItem(String string) {
        this.json = string;
    }

    public String getJson() {
        return this.json;
    }

    public String getID() {
        return this.getPath();
    }

    public String getPath() {
        int n = -1;
        String string = Util.extractJSON("path", this.json);
        if (string == null) {
            string = this.json;
        }
        if (string.charAt(string.length() - 1) == ']') {
            n = string.lastIndexOf(91);
        }
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getSTC() {
        return Util.extractJSON("stc", this.json);
    }

    public List<STCObj> getSTCObj() {
        if (this.stcError) {
            return null;
        }
        if (this.stcObjects == null) {
            try {
                this.stcObjects = new STCStringParser().parse(this.getSTC());
            }
            catch (Exception exception) {
                this.stcError = true;
                return null;
            }
        }
        return this.stcObjects;
    }

    public Coord[] getCorners() {
        if (!this.computeCorners) {
            this.corners = this.computeCorners();
        }
        return this.corners;
    }

    private Coord[] computeCorners() {
        this.computeCorners = true;
        List<STCObj> list = this.getSTCObj();
        if (list == null) {
            return null;
        }
        int n = 0;
        for (STCObj sTCObj : list) {
            if (!(sTCObj instanceof STCPolygon)) continue;
            n += ((STCPolygon)sTCObj).getxCorners().size();
            break;
        }
        Coord[] coordArray = new Coord[n];
        int n2 = 0;
        for (STCObj sTCObj : list) {
            if (!(sTCObj instanceof STCPolygon)) continue;
            ArrayList<Double> arrayList = ((STCPolygon)sTCObj).getxCorners();
            ArrayList<Double> arrayList2 = ((STCPolygon)sTCObj).getyCorners();
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                coordArray[n2++] = new Coord(arrayList.get(i), arrayList2.get(i));
            }
        }
        return coordArray;
    }

    private PointD[] getProjViewCorners(ViewSimple viewSimple) {
        int n;
        long l = viewSimple.getIZ();
        if (this.ovIZ == l) {
            if (this.nNull > 1) {
                return null;
            }
            return this.viewCorners;
        }
        Projection projection = viewSimple.getProj();
        Coord[] coordArray = this.getCorners();
        if (projection == null || coordArray == null) {
            return null;
        }
        this.nNull = 0;
        if (this.viewCorners == null) {
            this.viewCorners = new PointD[coordArray.length];
        }
        for (n = 0; n < coordArray.length; ++n) {
            Coord coord = coordArray[n];
            projection.getXY(coord);
            if (Double.isNaN(coord.x)) {
                ++this.nNull;
                if (this.nNull > 1) {
                    return null;
                }
                this.viewCorners[n] = null;
                continue;
            }
            if (this.viewCorners[n] == null) {
                this.viewCorners[n] = new PointD(coord.x, coord.y);
                continue;
            }
            this.viewCorners[n].x = coord.x;
            this.viewCorners[n].y = coord.y;
        }
        for (n = 0; n < coordArray.length; ++n) {
            if (this.viewCorners[n] == null) continue;
            viewSimple.getViewCoordDble(this.viewCorners[n], this.viewCorners[n].x, this.viewCorners[n].y);
        }
        this.ovIZ = l;
        return this.viewCorners;
    }

    public boolean isOutView(ViewSimple viewSimple) {
        double d;
        double d2;
        if (viewSimple.isAllSky()) {
            return false;
        }
        int n = viewSimple.getWidth();
        int n2 = viewSimple.getHeight();
        PointD[] pointDArray = this.getProjViewCorners(viewSimple);
        if (pointDArray == null) {
            return false;
        }
        double d3 = d2 = pointDArray[0].x;
        double d4 = d = pointDArray[0].y;
        for (int i = 1; i < pointDArray.length; ++i) {
            if (pointDArray[i].x < d3) {
                d3 = pointDArray[i].x;
            } else if (pointDArray[i].x > d2) {
                d2 = pointDArray[i].x;
            }
            if (pointDArray[i].y < d4) {
                d4 = pointDArray[i].y;
                continue;
            }
            if (!(pointDArray[i].y > d)) continue;
            d = pointDArray[i].y;
        }
        if (d3 < 0.0 && d2 < 0.0 || d3 >= (double)n && d2 >= (double)n) {
            return true;
        }
        return d4 < 0.0 && d < 0.0 || d4 >= (double)n2 && d >= (double)n2;
    }
}

