/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public final class Help
extends JComponent
implements MouseMotionListener,
MouseListener {
    String text;
    Font font = FI;
    FontMetrics fm = null;
    int ws = 520;
    int hs = 520;
    boolean flagFold = true;
    Aladin aladin;
    static final Font FI = Aladin.LPLAIN;
    static final Font FG;
    static final Font FTITRE;
    static int dy;
    String DEFAUT;
    String VIEW;
    Stack stack = new Stack();
    private boolean center = false;
    private static final int MAXLINK = 200;
    private String[] link = new String[200];
    private Rectangle[] xyLink = new Rectangle[200];
    private int nbLink = 0;
    private int ostyle = 0;
    private int owidth = -1;
    private int oheight = -1;

    protected Help(Aladin aladin) {
        this.aladin = aladin;
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    protected String H() {
        if (this.VIEW == null) {
            this.VIEW = Aladin.chaine.getString("View.HELP");
        }
        return this.VIEW;
    }

    protected void setText(String string) {
        this.flagFold = true;
        if (string != null && string.length() > 1) {
            if (string.charAt(0) == '-') {
                this.font = Aladin.PLAIN;
                string = string.substring(1);
            } else if (string.charAt(0) == '|') {
                this.flagFold = false;
                this.font = Aladin.COURIER;
                string = string.substring(1);
            }
        } else {
            this.font = FI;
        }
        this.fm = null;
        this.text = string;
        this.repaint();
    }

    protected void setHyperText(String string, String string2) {
        this.resetLink();
        if (string != null) {
            this.stack(string);
        }
        this.setText(string2);
    }

    private void goBack() {
        this.stack.pop();
        this.aladin.command.execHelpCmd((String)this.stack.pop());
    }

    private void stack(String string) {
        this.stack.push(string);
    }

    protected void resetStack() {
        while (!this.stack.empty()) {
            this.stack.pop();
        }
    }

    private int hasStack() {
        return this.stack.size() - 1;
    }

    protected void setDefault() {
        if (this.DEFAUT == null) {
            this.DEFAUT = Aladin.chaine.getString("Help.HELP");
        }
        this.setText(this.DEFAUT);
    }

    protected void setCenter(boolean bl) {
        this.center = bl;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getLink(mouseEvent.getX(), mouseEvent.getY()) != null) {
            Aladin.makeCursor(this, 2);
        } else {
            Aladin.makeCursor(this, 0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.aladin.status.setText("");
        if (this.aladin.inHelp) {
            this.setText(this.H());
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        String string;
        if (this.aladin.msgOn) {
            this.aladin.endMsg();
        }
        if ((string = this.getLink(mouseEvent.getX(), mouseEvent.getY())) != null) {
            if (string.equals("Home")) {
                this.resetStack();
                string = "";
            }
            if (string.equals("Back")) {
                this.goBack();
            } else {
                this.aladin.command.execHelpCmd(string);
            }
        } else {
            this.aladin.helpOff();
        }
    }

    int getTextHeight(Graphics graphics, String string, int n, int n2) {
        return this.drawString1(graphics, string, n, n2, false);
    }

    int drawString(Graphics graphics, String string, int n, int n2) {
        return this.drawString1(graphics, string, n, n2, true);
    }

    private int drawString1(Graphics graphics, String string, int n, int n2, boolean bl) {
        boolean bl2;
        Aladin aladin;
        boolean bl3 = false;
        Container container = aladin = this.aladin.isFullScreen() ? this.aladin.fullScreen.viewSimple : this.aladin;
        if (this.fm == null) {
            return n2;
        }
        dy = this.fm.getHeight();
        boolean bl4 = bl2 = string.trim().length() == 0;
        if (string.charAt(0) == '%' || (bl3 = string.indexOf("*%") == 0)) {
            String string2 = string.substring(bl3 ? 2 : 1);
            Image image = this.aladin.getImagette(string2);
            if (image == null) {
                return n2;
            }
            if (bl3) {
                n = this.ws / 2 - image.getWidth(aladin) / 2;
            }
            if (bl) {
                graphics.drawImage(image, n, n2, aladin);
            }
            return n2 += image.getHeight(aladin) + dy;
        }
        if (string.charAt(0) == '!') {
            graphics.setFont(FTITRE);
            n = this.ws / 2 - this.fm.stringWidth(string) / 2;
            n2 += dy / 2;
            if (bl) {
                graphics.drawString(string.substring(1), n, n2);
            }
            n2 = (int)((double)n2 + 1.5 * (double)dy);
            graphics.setFont(this.font);
            return n2;
        }
        if (string.charAt(0) == '*' || this.center) {
            if (string.charAt(0) == '*') {
                string = string.substring(1);
            }
            n = this.ws / 2 - this.fm.stringWidth(string) / 2;
            if (bl) {
                graphics.drawString(string, n, n2);
            }
            return n2 += dy;
        }
        boolean bl5 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t,|(.", true);
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string3 = stringTokenizer.nextToken();
            int n4 = 0;
            int n5 = string3.length();
            if (n5 > 1 && string3.charAt(0) == '@') {
                bl5 = true;
                string3 = string3.substring(1);
                --n5;
            } else {
                bl5 = false;
            }
            if (n5 > 2 && string3.charAt(0) == '#' && string3.charAt(n5 - 1) == '#') {
                n4 = 2;
                string3 = string3.substring(1, n5 - 1);
                n5 -= 2;
            }
            if (n5 > 2 && string3.charAt(0) == '_' && string3.charAt(n5 - 1) == '_') {
                n4 |= 1;
                string3 = string3.substring(1, n5 - 1);
                n5 -= 2;
            }
            if (string3.length() >= 2 && string3.startsWith("\\@")) {
                string3 = string3.substring(1);
            }
            if (n + (n3 = this.fm.stringWidth(string3)) > this.ws) {
                n = 10;
                n2 += dy;
                if (string3.equals(" ")) continue;
            }
            if (!bl) continue;
            n = this.drawWord(graphics, string3, n, n2, bl5, n4);
        }
        return n2 + (bl2 ? dy - 8 : dy);
    }

    private void resetLink() {
        this.nbLink = 0;
    }

    private boolean addLink(String string, int n, int n2, int n3, int n4) {
        if (this.nbLink == 200) {
            return false;
        }
        this.link[this.nbLink] = string;
        this.xyLink[this.nbLink++] = new Rectangle(n, n2, n3, n4);
        return true;
    }

    private String getLink(int n, int n2) {
        for (int i = 0; i < this.nbLink; ++i) {
            if (!this.xyLink[i].contains(n, n2)) continue;
            return this.link[i];
        }
        return null;
    }

    private int drawWord(Graphics graphics, String string, int n, int n2, boolean bl, int n3) {
        Color color = null;
        if (n3 != this.ostyle) {
            this.ostyle = n3;
            graphics.setFont(graphics.getFont().deriveFont(n3));
            this.fm = graphics.getFontMetrics();
        }
        int n4 = this.fm.stringWidth(string);
        if (bl) {
            bl = this.addLink(string, n, n2 + 2 - dy, n4, dy);
        }
        if (bl) {
            color = graphics.getColor();
            graphics.setColor(Color.blue);
            graphics.drawLine(n, n2 + 2, n + n4, n2 + 2);
        }
        graphics.drawString(string, n, n2);
        if (color != null) {
            graphics.setColor(color);
        }
        return n + n4;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        String string;
        boolean bl;
        block17: {
            super.paintComponent(graphics);
            graphics.setFont(this.font);
            this.aladin.setAliasing(graphics);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics();
            }
            if (this.text == null) {
                return;
            }
            this.ws = this.getSize().width;
            this.hs = this.getSize().height;
            if (this.owidth != this.ws || this.oheight != this.hs) {
                this.resetLink();
                this.owidth = this.ws;
                this.oheight = this.hs;
            }
            graphics.setColor(Color.white);
            graphics.fillRect(2, 2, this.ws - 3, this.hs - 3);
            Util.drawEdge(graphics, this.ws, this.hs);
            boolean bl2 = bl = Aladin.OUTREACH && this.center;
            if (bl) {
                try {
                    graphics.drawImage(this.aladin.getImagette("Background.jpg"), 0, 0, this.ws, this.hs, this);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block17;
                    exception.printStackTrace();
                }
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
        int n = 10;
        int n2 = 0;
        if (this.center) {
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (string.startsWith("BETA:")) {
                    if (!Aladin.BETA) continue;
                    string = string.substring("BETA:".length());
                }
                if (string.startsWith("PROTO:")) {
                    if (!Aladin.PROTO) continue;
                    string = string.substring("PROTO:".length());
                }
                n2 = this.getTextHeight(graphics, string, n - 2, n2 - 2);
            }
            n2 = this.getHeight() / 2 - n2 / 2;
            if (n2 < 15) {
                n2 = 15;
            }
        } else {
            n2 = 15;
        }
        stringTokenizer = new StringTokenizer(this.text, "\n");
        n = 10;
        graphics.setColor(bl ? Color.white : Aladin.BLUEHELP);
        while (stringTokenizer.hasMoreElements()) {
            string = (String)stringTokenizer.nextElement();
            if (string.startsWith("BETA:")) {
                if (!Aladin.BETA) continue;
                string = string.substring("BETA:".length());
            }
            if (string.startsWith("PROTO:")) {
                if (!Aladin.PROTO) continue;
                string = string.substring("PROTO:".length());
            }
            n2 = this.drawString(graphics, string, n - 2, n2 - 2);
        }
        if (this.hasStack() > 0) {
            this.drawWord(graphics, "Back", this.ws - 40, 15, true, 0);
        }
        if (this.hasStack() > 1) {
            this.drawWord(graphics, "Home", this.ws - 80, 15, true, 0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    static {
        FTITRE = FG = Aladin.LBOLD;
        dy = -1;
    }
}

