/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Source;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.StringTokenizer;

class Hist
implements Runnable {
    int MARGE = 8;
    int NBHIST = 10;
    int GAP = 3;
    static final int WCROIX = 5;
    Aladin aladin;
    String titre;
    Source o;
    int nField;
    HistItem[] hist;
    HistItem onMouse = null;
    int nb;
    int nbCategorie;
    boolean flagHistPartial;
    int width;
    int height;
    String texte = null;
    static final int MAX = 200000;
    private double[] pixelList;
    private int nPix;
    protected boolean flagHistPixel;
    private volatile Thread thread = null;
    private HistItem oOnMouse = null;

    Hist(Aladin aladin, int n, int n2) {
        this.aladin = aladin;
        this.width = n;
        this.height = n2;
    }

    protected void setText(String string) {
        this.texte = string;
    }

    protected String getCopier() {
        return this.texte;
    }

    protected void startHistPixel() {
        if (this.pixelList == null) {
            this.pixelList = new double[200000];
        }
        this.nPix = 0;
        this.flagHistPixel = true;
        this.texte = null;
    }

    protected boolean isOverFlow() {
        return this.nPix == 200000;
    }

    protected boolean addPixel(double d) {
        if (this.nPix == 200000) {
            return false;
        }
        this.pixelList[this.nPix++] = d;
        return true;
    }

    protected void createHistPixel(String string) {
        this.titre = string;
        this.setHist(this.pixelList);
    }

    protected boolean init(Source source, int n) {
        if (this.thread != null) {
            return false;
        }
        this.flagHistPixel = false;
        this.texte = null;
        this.o = source;
        this.nField = n;
        if (n == -1) {
            this.hist = null;
            return false;
        }
        this.titre = source.leg.field[n].name;
        return this.init();
    }

    protected boolean init() {
        if (this.flagHistPixel) {
            this.setHist(this.pixelList);
            return true;
        }
        if (this.aladin.mesure.getNbSrc() > 10000) {
            this.thread = new Thread((Runnable)this, "Histo");
            this.thread.start();
            return false;
        }
        return this.initThread();
    }

    @Override
    public void run() {
        if (this.initThread()) {
            this.aladin.calque.zoom.zoomView.flagHist = true;
            this.aladin.calque.repaintAll();
        }
        this.thread = null;
    }

    protected boolean initThread() {
        if (this.o.leg.isNumField(this.nField)) {
            double[] dArray = this.aladin.mesure.getFieldNumericValues(this.o, this.nField);
            this.nb = dArray.length;
            this.setHist(dArray);
        } else {
            String[] stringArray = this.aladin.mesure.getFieldStringValues(this.o, this.nField);
            this.nb = stringArray.length;
            this.setHist(stringArray);
        }
        return this.hist != null;
    }

    boolean mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n == 0) {
            return false;
        }
        n = this.NBHIST + (this.NBHIST > 2 ? 2 * n : n);
        this.setNbHist(n);
        return true;
    }

    void setNbHist(int n) {
        this.NBHIST = n;
        if (this.NBHIST < 4) {
            this.NBHIST = 4;
        }
        if (this.NBHIST > 30) {
            this.NBHIST = 30;
        }
        this.GAP = this.NBHIST > 25 ? 0 : (this.NBHIST > 15 ? 2 : 3);
        this.init();
    }

    boolean mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        int n2 = (int)((double)n / (((double)(this.height - 5) - 15.0) / 30.0));
        this.setNbHist(n2);
        return true;
    }

    protected void setHist(double[] dArray) {
        int n;
        int n2;
        int n3 = this.flagHistPixel ? this.nPix : dArray.length;
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (int i = 0; i < n3; ++i) {
            double d3 = dArray[i];
            if (Double.isNaN(d3)) continue;
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        if (d == Double.MAX_VALUE || d2 == -1.7976931348623157E308 || d == d2 || n3 <= 1) {
            this.hist = null;
            return;
        }
        this.hist = new HistItem[this.NBHIST];
        this.flagHistPartial = false;
        this.nbCategorie = -1;
        double d4 = d2 - d;
        double d5 = d4 / (double)this.hist.length;
        for (n2 = 0; n2 < this.hist.length; ++n2) {
            this.hist[n2] = new HistItem();
            this.hist[n2].min = n2 == 0 ? d : this.hist[n2 - 1].max;
            this.hist[n2].max = this.hist[n2].min + d5;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (Double.isNaN(dArray[n2])) continue;
            n = (int)((dArray[n2] - d) / d5);
            if (n > this.hist.length - 1) {
                n = this.hist.length - 1;
                this.hist[n].max = dArray[n2] + 1.0E-11;
            }
            ++this.hist[n].nb;
        }
        n2 = Integer.MIN_VALUE;
        for (n = 0; n < this.hist.length; ++n) {
            if (this.hist[n].nb <= n2) continue;
            n2 = this.hist[n].nb;
        }
        n = this.height - 30;
        double d6 = (double)n / (double)n2;
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i].haut = (int)((double)this.hist[i].nb * d6);
            this.hist[i].prop = (double)this.hist[i].nb / (double)n3 * 100.0;
        }
    }

    protected void setHist(String[] stringArray) {
        int n;
        int n2;
        Object object;
        int n3;
        class Int {
            int val = 1;

            Int() {
            }

            void incr() {
                ++this.val;
            }

            void clear() {
                this.val = -1;
            }
        }
        HashMap<String, Int> hashMap = new HashMap<String, Int>(300);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            String string = stringArray[n3];
            if (string.length() == 0) continue;
            object = (Int)hashMap.get(string);
            if (object != null) {
                ((Int)object).incr();
                continue;
            }
            hashMap.put(string, new Int());
        }
        this.nbCategorie = hashMap.keySet().size();
        n3 = this.nbCategorie;
        if (n3 <= 1) {
            this.hist = null;
            return;
        }
        boolean bl = this.flagHistPartial = n3 > this.NBHIST;
        if (this.flagHistPartial) {
            n3 = this.NBHIST;
        }
        if (this.hist == null || this.hist.length != n3) {
            this.hist = new HistItem[n3];
        }
        for (n2 = 0; n2 < this.hist.length; ++n2) {
            Object object22;
            this.hist[n2] = new HistItem();
            object = null;
            int n4 = -1;
            for (Object object22 : hashMap.keySet()) {
                Int intVal = (Int)hashMap.get(object22);
                if (intVal.val <= n4) continue;
                n4 = intVal.val;
                object = object22;
            }
            if (n2 == 0 && n4 == 1) {
                this.hist = null;
                return;
            }
            if (n4 == -1) continue;
            object22 = (Int)hashMap.get(object);
            this.hist[n2].nb = ((Int)object22).val;
            this.hist[n2].categorie = object;
            ((Int)object22).clear();
        }
        n2 = Integer.MIN_VALUE;
        for (n = 0; n < this.hist.length; ++n) {
            if (this.hist[n].nb <= n2) continue;
            n2 = this.hist[n].nb;
        }
        n = this.height - 30;
        double d = (double)n / (double)n2;
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i].haut = (int)((double)this.hist[i].nb * d);
            this.hist[i].prop = (double)this.hist[i].nb / (double)stringArray.length * 100.0;
        }
    }

    protected void selectHighlightSource() {
        int n;
        if (this.onMouse == null || this.flagHistPixel) {
            return;
        }
        Source[] sourceArray = new Source[this.onMouse.nb];
        int n2 = 0;
        for (n = 0; n < this.aladin.mesure.nbSrc; ++n) {
            if (!this.aladin.mesure.src[n].isHighlighted()) continue;
            sourceArray[n2++] = this.aladin.mesure.src[n];
        }
        this.aladin.view.deSelect();
        for (n = 0; n < sourceArray.length; ++n) {
            sourceArray[n].setSelected(true);
        }
        this.aladin.mesure.adjustScroll();
        this.aladin.appMessagingMgr.sendSelectObjectsMsg();
        this.init();
    }

    protected void resetHighlightSource() {
        if (this.flagHistPixel) {
            return;
        }
        for (int i = 0; i < this.aladin.mesure.nbSrc; ++i) {
            this.aladin.mesure.src[i].setHighlight(false);
        }
    }

    protected void setHighlightSource() {
        if (this.flagHistPixel) {
            return;
        }
        this.resetHighlightSource();
        if (this.onMouse != null) {
            for (int i = 0; i < this.aladin.mesure.nbSrc; ++i) {
                if (this.aladin.mesure.src[i].leg != this.o.leg) continue;
                String string = this.aladin.mesure.src[i].getValue(this.nField);
                if (this.onMouse.categorie != null && this.onMouse.categorie.equals(string)) {
                    this.aladin.mesure.src[i].setHighlight(true);
                    continue;
                }
                try {
                    double d = Double.parseDouble(string);
                    if (!(d >= this.onMouse.min) || !(d < this.onMouse.max)) continue;
                    this.aladin.mesure.src[i].setHighlight(true);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    boolean setOnMouse(int n, int n2) {
        int n3;
        if (this.hist == null) {
            return false;
        }
        HistItem histItem = this.onMouse;
        for (n3 = 0; n3 < this.hist.length; ++n3) {
            if (!this.hist[n3].in(n, n2)) continue;
            this.onMouse = this.hist[n3];
            return this.onMouse != histItem;
        }
        n3 = this.onMouse != null ? 1 : 0;
        this.onMouse = null;
        return n3 != 0;
    }

    protected boolean inCroix(int n, int n2) {
        return n >= this.width - 5 - 2 && n2 <= 7;
    }

    boolean isNumeric() {
        return this.hist != null && this.hist.length > 0 && this.hist[0].categorie == null;
    }

    protected void draw(Graphics graphics) {
        this.draw(graphics, 0, 0);
    }

    protected void draw(Graphics graphics, int n, int n2) {
        int n3;
        String string;
        int n4;
        graphics.clearRect(1 + n, 1 + n2, this.width - 2, this.height - 2);
        if (this.hist == null) {
            return;
        }
        int n5 = this.GAP;
        double d = (double)(this.width - this.MARGE - n5 * (this.hist.length + 1)) / (double)this.hist.length;
        double d2 = n5 + this.MARGE;
        int n6 = this.height - 12;
        graphics.setFont(Aladin.SSBOLD);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (!this.isOverFlow()) {
            for (n4 = 0; n4 < this.hist.length; ++n4) {
                graphics.setColor(Color.black);
                if (this.hist[n4].categorie == null) {
                    if (n4 == 0) {
                        graphics.drawString(Util.myRound(this.hist[n4].min), 2 + n, this.height - 2 + n2);
                    } else if (n4 == this.hist.length - 1) {
                        string = Util.myRound(this.hist[n4].max);
                        graphics.drawString(string, this.width - fontMetrics.stringWidth(string) + n, this.height - 2 + n2);
                    }
                } else {
                    string = this.hist[n4].categorie;
                    while (fontMetrics.stringWidth(string) > this.hist[n4].larg) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (string != this.hist[n4].categorie) {
                        string = string + "..";
                    }
                    graphics.drawString(string, this.hist[n4].x + this.hist[n4].larg / 2 - fontMetrics.stringWidth(string) / 2 + n, this.height - 2 + n2);
                }
                if (this.flagHistPartial && n4 == this.hist.length - 1) {
                    for (n3 = 0; n3 < 3; ++n3) {
                        graphics.setColor(Color.black);
                        Util.fillCircle5(graphics, (int)(d2 + (double)n5 + (double)(n3 * 6)) + n, n6 - 15 + n2);
                    }
                    continue;
                }
                graphics.setColor(this.hist[n4] == this.onMouse ? Aladin.GREEN : Color.cyan);
                graphics.fillRect((int)d2 + n, n6 - this.hist[n4].haut + n2, (int)d, this.hist[n4].haut);
                graphics.setColor(Color.black);
                graphics.drawRect((int)d2 + n, n6 - this.hist[n4].haut + n2, (int)d, this.hist[n4].haut);
                this.hist[n4].x = (int)d2;
                this.hist[n4].y = n6 - this.hist[n4].haut;
                this.hist[n4].larg = (int)d;
                d2 += d + (double)n5;
            }
        }
        boolean bl = this.aladin.view.flagHighlight = this.onMouse != null && !this.flagHistPixel;
        if (this.onMouse != this.oOnMouse) {
            this.setHighlightSource();
            this.aladin.view.repaint();
        }
        this.oOnMouse = this.onMouse;
        graphics.setFont(Aladin.BOLD);
        graphics.setColor(Color.blue);
        fontMetrics = graphics.getFontMetrics();
        if (this.onMouse != null) {
            graphics.setColor(Color.red);
            string = this.onMouse.nb + "";
            graphics.drawString(string, 5, 14);
            n4 = 8 + fontMetrics.stringWidth(string);
            graphics.setColor(Color.blue);
            string = Util.myRound(this.onMouse.prop + "", 1) + "%";
            n3 = this.width - fontMetrics.stringWidth(string) - 12;
            graphics.drawString(string, n3, 14);
            string = this.onMouse.categorie == null ? Util.myRound(this.onMouse.min) + "," + Util.myRound(this.onMouse.max) : this.onMouse.categorie;
            d2 = (this.width - 5) / 2 - fontMetrics.stringWidth(string) / 2;
            if (d2 < (double)n4 && (d2 = (double)((n4 + n3) / 2 - fontMetrics.stringWidth(string) / 2)) < (double)n4) {
                d2 = n4;
            }
            graphics.drawString(string, (int)d2, 14);
        } else {
            string = this.titre;
            if (this.nbCategorie > 0) {
                string = string + " (" + this.nbCategorie + " item" + (this.nbCategorie > 1 ? "s)" : ")");
            }
            if (string != null) {
                graphics.drawString(string, 5, 14);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n5 - 2 + this.MARGE, n6, this.width - 2 * n5 + 2, n6);
        if (!this.isOverFlow() && this.hist.length >= 4) {
            n4 = (int)((double)this.hist.length * ((double)(this.height - 5) - 15.0) / 30.0);
            n3 = this.MARGE / 2 + 1;
            graphics.setColor(Color.gray);
            graphics.drawLine(n3 - 1, 21, n3 - 1, this.height - 15);
            graphics.setColor(Color.black);
            graphics.fillPolygon(new Polygon(new int[]{n3 - 3, n3 + 2, n3 - 3}, new int[]{n4 - 3, n4, n4 + 3}, 3));
        }
        if (!this.flagHistPixel) {
            n4 = 5;
            graphics.setColor(Aladin.BKGD);
            graphics.fillRect(this.width - n4 - 4, 1, n4 + 4, n4 + 4);
            graphics.setColor(Color.red);
            graphics.drawLine(this.width - n4 - 3, 2, this.width - 3, n4 + 2);
            graphics.drawLine(this.width - n4 - 3, 3, this.width - 3, n4 + 3);
            graphics.drawLine(this.width - n4 - 3, n4 + 2, this.width - 3, 2);
            graphics.drawLine(this.width - n4 - 3, n4 + 3, this.width - 3, 3);
        }
        if (this.texte != null) {
            graphics.setFont(Aladin.SBOLD);
            fontMetrics = graphics.getFontMetrics();
            graphics.setColor(Color.red);
            StringTokenizer stringTokenizer = new StringTokenizer(this.texte, "/");
            n6 = 17;
            n3 = fontMetrics.getHeight();
            int n7 = fontMetrics.getAscent();
            graphics.setColor(Color.black);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                int n8 = fontMetrics.stringWidth(string);
                int n9 = this.width - n8 - 5;
                Util.drawCartouche(graphics, n9, n6, n8, n3, 0.8f, null, Color.white);
                graphics.drawString(string, n9, n6 + n7);
                n6 += n3;
            }
        }
    }

    class HistItem {
        int nb = 0;
        double prop;
        double min;
        double max;
        String categorie;
        int larg;
        int haut;
        int x;
        int y;

        HistItem() {
        }

        boolean in(int n, int n2) {
            return n >= this.x && n <= this.x + this.larg;
        }

        boolean contains(double d) {
            return this.min <= d && d < this.max;
        }
    }
}

