/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyListener;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class Histogramme
extends JComponent
implements MyListener,
MouseListener {
    static final int mX = 10;
    static final int mY = 0;
    static final int Hp = 150;
    static final int W = 276;
    static final int H = 150;
    static final String TITLE = "Pixel values histogram";
    double[] hist;
    Image img = null;
    private int level = -1;
    private boolean showPixVal = true;
    boolean flag = false;
    private PlanImage pimg;
    private byte[] pixels;

    protected Histogramme() {
        this.addMouseListener(this);
    }

    protected Histogramme(PlanImage planImage) {
        this();
        if (planImage != null && !(planImage instanceof PlanImageRGB)) {
            this.setImage(planImage);
        }
    }

    private void computeHist() {
        int n;
        double d = 0.0;
        this.hist = new double[256];
        for (n = 0; n < this.pixels.length; ++n) {
            double d2;
            int n2;
            int n3 = n2 = this.pixels[n] < 0 ? 256 + this.pixels[n] : this.pixels[n];
            this.hist[n3] = this.hist[n3] + 1.0;
            if (!(d2 > d)) continue;
            d = d2;
        }
        for (n = 0; n < this.hist.length; ++n) {
            this.hist[n] = Math.log(1.0 + this.hist[n]);
        }
        d = Math.log(1.0 + d);
        d += d / 5.0;
        for (n = 0; n < this.hist.length; ++n) {
            this.hist[n] = this.hist[n] * 150.0 / d;
        }
        this.resize(276, 150);
    }

    @Override
    public boolean mouseMove(Event event, int n, int n2) {
        this.flag = true;
        if (this.showPixVal && n - 10 != this.level) {
            this.setLevel(n - 10);
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseExit(Event event, int n, int n2) {
        this.setLevel(-1);
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.pimg == null && this.pixels == null) {
            return;
        }
        if (this.img == null) {
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.img, 10, 0, this.pimg.aladin);
        if (this.showPixVal) {
            this.drawInfo(graphics);
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (this.img == null) {
            this.img = this.createImage(256, 150);
        } else if (this.flag) {
            this.paint(graphics);
            return;
        }
        Graphics graphics2 = this.img.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, 256, 150);
        graphics2.setColor(Color.blue);
        for (int i = 0; i < 256; ++i) {
            graphics2.drawLine(i, 150, i, 150 - (int)this.hist[i]);
        }
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, 255, 149);
        graphics2.setFont(Aladin.SPLAIN);
        graphics2.drawString(TITLE, 73, 14);
        graphics2.dispose();
        this.paint(graphics);
    }

    private void drawInfo(Graphics graphics) {
        String string;
        if (this.level < 0) {
            return;
        }
        String string2 = this.pimg.getPixelInfoFromGrey(this.level);
        String string3 = string2.equals(string = this.pimg.getPixelInfoFromGrey(this.level + 1)) ? string2 : "[" + string2 + ".." + string + "]";
        String string4 = "pixel: " + string3;
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(string4);
            int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            graphics2D.setComposite(Util.getImageComposite(0.55f));
            graphics2D.setColor(Color.black);
            graphics2D.fillRoundRect(12, 115 - n2, 10 + n + 7, n2 + 6, 20, 20);
            graphics2D.setComposite(composite);
        }
        graphics.setColor(Color.magenta);
        graphics.drawLine(10 + this.level, 150, 10 + this.level, 0);
        graphics.drawString(string4, 17, 115);
    }

    protected void setLevel(int n) {
        if (n == this.level) {
            return;
        }
        this.level = n > 255 ? 255 : (n < -1 ? -1 : n);
        this.repaint();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(276, 150);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    protected void setImage(PlanImage planImage) {
        this.pimg = planImage;
        this.pixels = planImage instanceof PlanBG ? ((PlanBG)planImage).getBufPixels8(planImage.aladin.view.getCurrentView()) : planImage.getBufPixels8();
        this.computeHist();
        this.img = null;
        this.flag = false;
        this.showPixVal = false;
    }

    @Override
    public void fireStateChange(String string) {
        if (string == null) {
            this.showPixVal = false;
            this.repaint();
        }
    }

    @Override
    public void fireStateChange(int n) {
        this.showPixVal = true;
        this.setLevel(n);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPixVal = false;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

