/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.FilterProperties;
import cds.aladin.MyInputStream;
import cds.aladin.Server;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class IDHAGenerator
extends JFrame {
    Server server;
    static final String CR = Util.CR;
    static long keptMask = 8065L;
    private static final String BARATIN_OBSERVING_PROGRAM = "<DESCRIPTION>" + CR + "This is a few resource information for the" + CR + "ObservingProgram " + CR + "</DESCRIPTION>" + CR + "<FIELD ID=\"Name\" name=\"Name\" datatype=\"char\" ucd=\"ID_SURVEY\">" + CR + "<DESCRIPTION> ObservingProgram Name </DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Organisation\" name=\"Organisation\" datatype=\"char\" ucd=\"CURATOR\">" + CR + "<DESCRIPTION> Name of Organisation(s) " + CR + "performing Observing Program" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Begin\" name=\"beginning_date\" datatype=\"char\">" + CR + "<DESCRIPTION> Begin date of the survey" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"End\" name=\"end date\" datatype=\"char\">" + CR + "<DESCRIPTION> End date of Observing program" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"SpectralDomain\" name=\"SpectralCoverageName\" datatype=\"char\">" + CR + "<DESCRIPTION> General spectral domain (Optical X-ray ...)" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_OBSERVATION_GROUP = "<DESCRIPTION> This is a subset of images" + CR + "belonging to a survey, an experiment," + CR + "and organised according to the same" + CR + "common criterion. e.g. exemple of" + CR + "criterion: color or wavelength," + CR + "polarimetry, etc... exemple of" + CR + "Observation_Group: POSSII band J," + CR + "DENIS band K, etc.." + CR + "</DESCRIPTION>" + CR + "<FIELD ID=\"Selection_Criterion\" name=\"Selection_Criterion\" datatype=\"char\">" + CR + "<DESCRIPTION> Sampled Parameter" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Selection-Range\" name=\"Selection-Range\" datatype=\"char\">" + CR + "<DESCRIPTION> Constraint on sampled parameter" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_OBSERVATION = "<DESCRIPTION>" + CR + "This resource describes list of processed observations " + CR + "</DESCRIPTION>" + CR + "<FIELD ID=\"Observation_Name\" name=\"Observation_Name\" datatype=\"char\" ucd=\"ID_IMAGE\">" + CR + "<DESCRIPTION>" + CR + "Name of the Observation" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"ReferenceNumber\" name=\"ReferenceNumber\" datatype=\"char\" ucd=\"ID_IMAGE\">" + CR + "<DESCRIPTION>" + CR + "Reference Number of the Image" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Size_alpha\" name=\"Size_alpha\" datatype=\"float\" precision=\"7\" width=\"11\" unit=\"deg\" ucd=\"INST_DET_SIZE\">" + CR + "<DESCRIPTION>" + CR + "Observation range in alpha (angular) " + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Size_delta\" name=\"Size_delta\" datatype=\"float\" precision=\"F7\" width=\"11\" unit=\"deg\" ucd=\"INST_DET_SIZE\">" + CR + "<DESCRIPTION>" + CR + "Observation range in delta (angular) " + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"PixelSize\" name=\"Angular Pixel Size\"  datatype=\"float\" unit =\"deg\">" + CR + "<DESCRIPTION>" + CR + "Pixel size measured in sky units" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"Origin\" name=\"Origin\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Data provider references" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"OriginalCoding \" name=\"OriginalCoding\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Image coding provided by the data producer" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"AvailableCodings\" name=\"AvailableCodings\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Codings which may be  produced on the fly" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"alpha\" name=\"CentralPoint_RA\" ucd=\"POS_EQ_RA_MAIN\"  datatype=\"float\" precision=\"F7\" width=\"11\" unit=\"deg\">" + CR + "<DESCRIPTION>" + CR + "Position of center\t" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"delta\" name=\"CentralPoint_DEC\" ucd=\"POS_EQ_DEC_MAIN\"  datatype=\"float\" precision=\"F7\" width=\"11\" unit=\"deg\">" + CR + "<DESCRIPTION>" + CR + "Position of center\t" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"date\"  name=\"DateAndTime\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Observation date" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"AP\" name=\"Position Angle\"  datatype=\"float\" precision=\"F7\"  width=\"11\" unit=\"deg\">" + CR + "<DESCRIPTION>" + CR + "Position Angle of th Y axis" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_STORAGE_MAPPING = "<DESCRIPTION>" + CR + "This resource describes list of processed observations " + CR + "</DESCRIPTION>" + CR + "<FIELD ref=\"Observation_Name\" >" + CR + "</FIELD>" + CR + "<FIELD ID=\"Cutout\" name=\"Organisation\"  datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "Status of cutout availability " + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"number\" name=\"NumberOfPatches\"  datatype=\"int\">" + CR + "<DESCRIPTION>" + CR + "Number of subimages" + CR + "</DESCRIPTION>" + CR + "</FIELD>" + CR + "<FIELD ID=\"size\" name=\"Maximum size\"  datatype=\"int\">" + CR + "<DESCRIPTION>" + CR + "Maximum size " + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String BARATIN_STORED_IMAGE = "<DESCRIPTION>" + CR + "This resource describes the actual retrieved file " + CR + "</DESCRIPTION>" + CR + "<FIELD ref=\"Observation_Name\" >" + CR + "</FIELD>" + CR + "<FIELD ID=\"Location\" name=\"LinktoPixels\" datatype=\"char\">" + CR + "<DESCRIPTION>" + CR + "File location" + CR + "</DESCRIPTION>" + CR + "</FIELD>";
    private static final String[] FIELD_ID = new String[]{"alpha", "delta", "Size_alpha", "Size_delta", "AP"};
    static final String SAVE_DIR_FILE = ".aladin_idha";
    private Vector progs = new Vector();
    private ObsProg currentProg;
    private static final String allFiles = "*";
    File[] dirs;
    File[] files;

    IDHAGenerator() {
        super("IDHA generator");
        Aladin.setIcon(this);
    }

    IDHAGenerator(Server server) {
        this();
        this.server = server;
    }

    private ObsProg addObsProg(String string) {
        if (string.length() > 0) {
            ObsProg obsProg = new ObsProg(string);
            this.progs.addElement(obsProg);
            if (this.currentProg == null) {
                this.currentProg = obsProg;
            }
            return obsProg;
        }
        return null;
    }

    protected void reset() {
        this.progs.removeAllElements();
    }

    protected InputStream getStream(File file, Component component) {
        int n;
        File file2 = this.buildDescFile(file);
        if (file2.exists() && (n = JOptionPane.showConfirmDialog(component, "Do you want to use existing description file ?", "Confirmation", 0)) == 0) {
            try {
                Aladin.trace(3, "Return stream from existing description file");
                return new BufferedInputStream(new FileInputStream(file2));
            }
            catch (Exception exception) {
                return new BufferedInputStream(new ByteArrayInputStream("".getBytes()));
            }
        }
        if (this.server != null) {
            this.server.waitCursor();
        }
        Aladin.trace(3, "Build description file for directory " + file);
        this.doScan(file);
        StringBuffer stringBuffer = this.generateXML();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            Aladin.trace(3, "Write file " + file2);
            dataOutputStream.writeBytes(stringBuffer.toString());
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not produce write description file " + file2 + " : " + iOException);
        }
        if (this.server != null) {
            this.server.defaultCursor();
        }
        return new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
    }

    private File buildDescFile(File file) {
        return new File(file + File.separator + SAVE_DIR_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFile(File file) {
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(file));
            myInputStream = myInputStream.startRead();
            long l = myInputStream.getType();
            boolean bl = (l & keptMask) != 0L;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void doScan(File file) {
        Aladin.trace(3, "Setting start directory: " + file);
        this.getFilesAndDirs(file);
        File[] fileArray = this.dirs;
        File[] fileArray2 = this.files;
        ObsProg obsProg = this.addObsProg("First level files obsprog");
        obsProg.hide = true;
        ObsGroup obsGroup = new ObsGroup("");
        obsProg.groups.addElement(obsGroup);
        for (int i = 0; i < fileArray2.length; ++i) {
            if (!this.checkFile(fileArray2[i])) continue;
            Image image = new Image(fileArray2[i]);
            obsGroup.images.addElement(image);
            this.processImage(image);
        }
        Aladin.trace(3, "Retrieving Observing programs directories: " + fileArray.length + " directories found");
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            Aladin.trace(3, "Adding Observation Program " + string);
            ObsProg obsProg2 = this.addObsProg(string);
            this.fillObsProg(obsProg2, new Vector(), fileArray[i], 0);
        }
        this.currentProg = null;
        this.cleanup();
    }

    private void cleanup() {
        Vector<ObsProg> vector = new Vector<ObsProg>();
        Enumeration enumeration = this.progs.elements();
        while (enumeration.hasMoreElements()) {
            ObsProg obsProg = (ObsProg)enumeration.nextElement();
            if (obsProg.groups.size() != 0) continue;
            vector.addElement(obsProg);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.progs.removeElement(enumeration.nextElement());
        }
    }

    private void scanDirectory() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Go into the start directory", 0);
        fileDialog.setFile(allFiles);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        String string3 = (string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        File file = new File(string);
        this.doScan(file);
    }

    private void fillObsProg(ObsProg obsProg, Vector vector, File file, int n) {
        this.getFilesAndDirs(file);
        File[] fileArray = this.dirs;
        if (fileArray == null || fileArray.length == 0) {
            ObsGroup obsGroup = new ObsGroup("group" + obsProg.groups.size());
            for (int i = 0; i < vector.size(); ++i) {
                obsGroup.criteriaValues.put(obsProg.criteriaClasses.elementAt(i), vector.elementAt(i));
            }
            String[] stringArray = file.list();
            FilterProperties.sortLexico(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!this.checkFile(file2)) continue;
                Image image = new Image(file2);
                if (image.file.getName().indexOf(SAVE_DIR_FILE) >= 0) continue;
                obsGroup.images.addElement(image);
                this.processImage(image);
            }
            if (obsGroup.images.size() > 0) {
                obsProg.groups.addElement(obsGroup);
            }
        } else {
            String string = "criterion" + n;
            if (obsProg.criteriaClasses.indexOf(string) < 0) {
                obsProg.criteriaClasses.addElement(string);
                Aladin.trace(3, "Adding constraint " + string);
            }
            for (int i = 0; i < fileArray.length; ++i) {
                Vector vector2 = new Vector();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(enumeration.nextElement());
                }
                vector2.addElement(fileArray[i].getName());
                Aladin.trace(3, "Adding constraint value " + fileArray[i].getName());
                this.fillObsProg(obsProg, vector2, fileArray[i], n + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImage(Image image) {
        Coord coord;
        HeaderFits headerFits = null;
        MyInputStream myInputStream = null;
        try {
            myInputStream = new MyInputStream(new FileInputStream(image.file));
            myInputStream = myInputStream.startRead();
            headerFits = new HeaderFits(myInputStream);
        }
        catch (Exception exception) {
            Aladin.trace(3, "Error : could not create HeaderFits object");
            return;
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        Calib calib = null;
        try {
            calib = new Calib(headerFits);
        }
        catch (Exception exception) {
            Aladin.trace(3, "Error : could not create Calib object");
            return;
        }
        try {
            coord = calib.getImgCenter();
        }
        catch (Exception exception) {
            Aladin.trace(3, "Error while retrieving image center");
            coord = null;
        }
        if (coord != null) {
            image.values[0] = Float.toString((float)coord.al);
            image.values[1] = Float.toString((float)coord.del);
        }
        image.values[2] = Float.toString((float)calib.getImgWidth());
        image.values[3] = Float.toString((float)calib.getImgHeight());
        image.values[4] = Float.toString((float)calib.getProjRot());
    }

    private void getFilesAndDirs(File file) {
        String[] stringArray = file.list();
        FilterProperties.sortLexico(stringArray);
        Vector<File> vector = new Vector<File>();
        Vector<File> vector2 = new Vector<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                vector.addElement(file2);
                continue;
            }
            if (file2.getName().indexOf(SAVE_DIR_FILE) >= 0) continue;
            vector2.addElement(file2);
        }
        this.dirs = new File[vector.size()];
        vector.copyInto(this.dirs);
        vector = null;
        this.files = new File[vector2.size()];
        vector2.copyInto(this.files);
        vector2 = null;
    }

    private void writeEmptyTD(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("<TD></TD>");
        }
    }

    private StringBuffer generateXML() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>" + CR + "<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">");
        stringBuffer.append(CR + "<VOTABLE ID=\"v1.0\">");
        Enumeration enumeration = this.progs.elements();
        while (enumeration.hasMoreElements()) {
            ObsProg obsProg = (ObsProg)enumeration.nextElement();
            if (!obsProg.hide) {
                stringBuffer.append(CR + "<RESOURCE name=\"ObservingProgram\">");
                if (bl) {
                    stringBuffer.append(CR + "<TABLE ID=\"ObservingProgram\">");
                    stringBuffer.append(CR + BARATIN_OBSERVING_PROGRAM);
                    bl = false;
                } else {
                    stringBuffer.append(CR + "<TABLE ref=\"ObservingProgram\">");
                }
                stringBuffer.append(CR + "<DATA><TABLEDATA>");
                stringBuffer.append(CR + "<TR>");
                stringBuffer.append("<TD>" + obsProg.name + "</TD>");
                this.writeEmptyTD(stringBuffer, 4);
                stringBuffer.append("</TR>");
                stringBuffer.append(CR + "</TABLEDATA></DATA>");
                stringBuffer.append(CR + "</TABLE>");
            }
            Enumeration enumeration2 = obsProg.groups.elements();
            while (enumeration2.hasMoreElements()) {
                Object object;
                Enumeration enumeration3;
                ObsGroup obsGroup = (ObsGroup)enumeration2.nextElement();
                stringBuffer.append(CR + "<RESOURCE name=\"Observation_Group\">");
                if (bl2) {
                    stringBuffer.append(CR + "<TABLE ID=\"Observation_Group\">");
                    stringBuffer.append(CR + BARATIN_OBSERVATION_GROUP);
                    bl2 = false;
                } else {
                    stringBuffer.append(CR + "<TABLE ref=\"Observation_Group\">");
                }
                stringBuffer.append(CR + "<DATA><TABLEDATA>");
                Enumeration enumeration4 = obsProg.criteriaClasses.elements();
                while (enumeration4.hasMoreElements()) {
                    enumeration3 = (String)enumeration4.nextElement();
                    stringBuffer.append(CR + "<TR><TD>" + (String)((Object)enumeration3) + "</TD><TD>" + obsGroup.criteriaValues.get(enumeration3) + "</TD></TR>");
                }
                if (obsProg.criteriaClasses.size() == 0 && !obsProg.hide) {
                    stringBuffer.append(CR + "<TR><TD>Group</TD><TD>" + obsGroup.name + "</TD></TR>");
                }
                stringBuffer.append(CR + "</TABLEDATA></DATA>");
                stringBuffer.append(CR + "</TABLE>");
                stringBuffer.append(CR + "<RESOURCE name=\"Observation\">");
                if (bl3) {
                    stringBuffer.append(CR + "<TABLE ID=\"Observation\">");
                    stringBuffer.append(CR + BARATIN_OBSERVATION);
                    bl3 = false;
                } else {
                    stringBuffer.append(CR + "<TABLE ref=\"Observation\">");
                }
                stringBuffer.append(CR + "<DATA><TABLEDATA>");
                enumeration3 = obsGroup.images.elements();
                while (enumeration3.hasMoreElements()) {
                    object = (Image)enumeration3.nextElement();
                    stringBuffer.append(CR + "<TR>");
                    stringBuffer.append("<TD>" + this.buildName(((Image)object).file) + "</TD>");
                    this.writeEmptyTD(stringBuffer, 1);
                    stringBuffer.append("<TD>" + ((Image)object).values[2] + "</TD>");
                    stringBuffer.append("<TD>" + ((Image)object).values[3] + "</TD>");
                    this.writeEmptyTD(stringBuffer, 4);
                    stringBuffer.append("<TD>" + ((Image)object).values[0] + "</TD>");
                    stringBuffer.append("<TD>" + ((Image)object).values[1] + "</TD>");
                    this.writeEmptyTD(stringBuffer, 1);
                    stringBuffer.append("<TD>" + ((Image)object).values[4] + "</TD>");
                    stringBuffer.append(CR + "</TR>");
                }
                stringBuffer.append(CR + "</TABLEDATA></DATA>");
                stringBuffer.append(CR + "</TABLE>");
                stringBuffer.append(CR + "</RESOURCE>");
                stringBuffer.append(CR + "<RESOURCE name=\"StorageMapping\">");
                if (bl4) {
                    stringBuffer.append(CR + "<TABLE ID=\"StorageMapping\">");
                    stringBuffer.append(CR + BARATIN_STORAGE_MAPPING);
                    bl4 = false;
                } else {
                    stringBuffer.append(CR + "<TABLE ref=\"StorageMapping\">");
                }
                stringBuffer.append(CR + "<DATA><TABLEDATA>");
                enumeration3 = obsGroup.images.elements();
                while (enumeration3.hasMoreElements()) {
                    object = ((Image)enumeration3.nextElement()).file;
                    stringBuffer.append(CR + "<TR>");
                    stringBuffer.append("<TD>" + this.buildName((File)object) + "</TD>");
                    this.writeEmptyTD(stringBuffer, 3);
                    stringBuffer.append("</TR>");
                }
                stringBuffer.append(CR + "</TABLEDATA></DATA>");
                stringBuffer.append(CR + "</TABLE>");
                stringBuffer.append(CR + "</RESOURCE>");
                stringBuffer.append(CR + "<RESOURCE name=\"StoredImage\">");
                if (bl5) {
                    stringBuffer.append(CR + "<TABLE ID=\"StoredImage\">");
                    stringBuffer.append(CR + BARATIN_STORED_IMAGE);
                    bl5 = false;
                } else {
                    stringBuffer.append(CR + "<TABLE ref=\"StoredImage\">");
                }
                stringBuffer.append(CR + "<DATA><TABLEDATA>");
                enumeration3 = obsGroup.images.elements();
                while (enumeration3.hasMoreElements()) {
                    String string;
                    object = ((Image)enumeration3.nextElement()).file;
                    try {
                        string = ((File)object).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = "";
                    }
                    stringBuffer.append(CR + "<TR><TD>" + this.buildName((File)object) + "</TD><TD>file://" + string + "</TD></TR>");
                }
                stringBuffer.append(CR + "</TABLEDATA></DATA>");
                stringBuffer.append(CR + "</TABLE>");
                stringBuffer.append(CR + "</RESOURCE>");
                stringBuffer.append(CR + "</RESOURCE>");
            }
            if (obsProg.hide) continue;
            stringBuffer.append(CR + "</RESOURCE>");
        }
        stringBuffer.append(CR + "</VOTABLE>");
        return stringBuffer;
    }

    private String buildName(File file) {
        String string = file.getName();
        return string;
    }

    class Image {
        File file;
        String[] values;

        Image(File file) {
            this.file = file;
            this.values = new String[FIELD_ID.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = "";
            }
        }
    }

    class ObsGroup {
        Vector images = new Vector();
        Hashtable criteriaValues = new Hashtable();
        String name;

        ObsGroup(String string) {
            this.name = string;
        }
    }

    class ObsProg {
        boolean hide = false;
        Vector groups = new Vector();
        Vector criteriaClasses = new Vector();
        String name;

        ObsProg(String string) {
            this.name = string;
        }
    }
}

