/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CalqueStatic;
import cds.aladin.Configuration;
import cds.aladin.Coord;
import cds.aladin.LocalisationStatic;
import cds.aladin.PlanBGStatic;
import cds.aladin.ViewSimpleStatic;
import cds.aladin.ViewStatic;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageMaker {
    public ImageMaker(Aladin aladin, OutputStream outputStream, String string, int n, int n2, String string2, Coord coord, double d) throws Exception {
        this(aladin, outputStream, string, n, n2, string2, coord, d, null);
    }

    public ImageMaker(Aladin aladin, OutputStream outputStream, String string, int n, int n2, String string2, Coord coord, double d, String string3) throws Exception {
        if (string3 == null) {
            string3 = "http://alasky.u-strasbg.fr/DSS/DSSColor";
        }
        PlanBGStatic planBGStatic = new PlanBGStatic(aladin, string, string3);
        ViewSimpleStatic viewSimpleStatic = new ViewSimpleStatic(aladin);
        ((ViewStatic)aladin.view).setViewSimple(viewSimpleStatic);
        viewSimpleStatic.setViewParam(planBGStatic, n, n2, coord, d);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        planBGStatic.drawBackground(graphics2D, viewSimpleStatic);
        planBGStatic.drawLosangesNow(graphics2D, viewSimpleStatic);
        planBGStatic.drawForeground(graphics2D, viewSimpleStatic);
        ImageIO.write((RenderedImage)bufferedImage, string2, outputStream);
    }

    public static Aladin createAladin() throws Exception {
        Aladin aladin = new Aladin();
        aladin.creatFonts();
        Aladin.levelTrace = 3;
        Aladin.aladin = aladin;
        aladin.configuration = new Configuration(aladin);
        aladin.configuration.load();
        aladin.localisation = new LocalisationStatic(aladin);
        aladin.view = new ViewStatic(aladin);
        aladin.calque = new CalqueStatic(aladin, (ViewStatic)aladin.view);
        return aladin;
    }

    public static void main(String[] stringArray) {
        long l = 0L;
        try {
            Aladin aladin = ImageMaker.createAladin();
            l = System.currentTimeMillis();
            FileOutputStream fileOutputStream = new FileOutputStream(new File("/Test.jpg"));
            new ImageMaker(aladin, fileOutputStream, "M101 test", 1024, 1024, "jpeg", new Coord(210.80242, 54.34875), 2.0);
            long l2 = System.currentTimeMillis();
            System.out.println("Image generated in " + (l2 - l) + "ms");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

