/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Kernel;
import cds.aladin.Server;
import cds.aladin.Tok;
import cds.tools.Util;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class KernelList {
    private Aladin aladin;
    private Vector<Kernel> list;
    private static int NK = 0;
    static final double FCTSIGMA = 2.0 * Math.sqrt(2.0 * Math.log(2.0));
    private static final double[][] CONTRAST = new double[][]{{0.0, -1.0, 0.0}, {-1.0, 5.0, -1.0}, {0.0, -1.0, 0.0}};
    private static final double[][] FLOU = new double[][]{{0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.1111111111111111, 0.1111111111111111, 0.1111111111111111}};
    private static final double[][] BORD = new double[][]{{0.0, 1.0, 0.0}, {1.0, -4.0, 1.0}, {0.0, 1.0, 0.0}};
    private static final double[][] PYRAMIDAL = new double[][]{{1.0, 2.0, 1.0}, {2.0, 4.0, 2.0}, {1.0, 2.0, 1.0}};
    private static final double[][] GAUSS1_5 = new double[][]{{0.109853, 0.3007, 0.109853}, {0.3007, 0.823102, 0.3007}, {0.109853, 0.3007, 0.109853}};
    private static final double[][] GAUSS2 = new double[][]{{0.260856, 0.483068, 0.260856}, {0.483068, 0.894573, 0.483068}, {0.260856, 0.483068, 0.260856}};
    private static final double[][] GAUSS2_5 = new double[][]{{0.034673, 0.119131, 0.179633, 0.119131, 0.034673}, {0.119131, 0.409323, 0.6172, 0.409323, 0.119131}, {0.179633, 0.6172, 0.930649, 0.6172, 0.179633}, {0.119131, 0.409323, 0.6172, 0.409323, 0.119131}, {0.034673, 0.119131, 0.179633, 0.119131, 0.034673}};
    private static final double[][] GAUSS3 = new double[][]{{0.092163, 0.221178, 0.296069, 0.221178, 0.092163}, {0.221178, 0.530797, 0.710525, 0.530797, 0.221178}, {0.296069, 0.710525, 0.951108, 0.710525, 0.296069}, {0.221178, 0.530797, 0.710525, 0.530797, 0.221178}, {0.092163, 0.221178, 0.296069, 0.221178, 0.092163}};
    private static final double[][] GAUSS4 = new double[][]{{0.047454, 0.109799, 0.181612, 0.214776, 0.181612, 0.109799, 0.047454}, {0.109799, 0.254053, 0.420215, 0.49695, 0.420215, 0.254053, 0.109799}, {0.181612, 0.420215, 0.695055, 0.821978, 0.695055, 0.420215, 0.181612}, {0.214776, 0.49695, 0.821978, 0.972079, 0.821978, 0.49695, 0.214776}, {0.181612, 0.420215, 0.695055, 0.821978, 0.695055, 0.420215, 0.181612}, {0.109799, 0.254053, 0.420215, 0.49695, 0.420215, 0.254053, 0.109799}, {0.047454, 0.109799, 0.181612, 0.214776, 0.181612, 0.109799, 0.047454}};
    private static final double[][] GAUSS5 = new double[][]{{0.030531, 0.065238, 0.112208, 0.155356, 0.173152, 0.155356, 0.112208, 0.065238, 0.030531}, {0.065238, 0.139399, 0.239763, 0.331961, 0.369987, 0.331961, 0.239763, 0.139399, 0.065238}, {0.112208, 0.239763, 0.412386, 0.570963, 0.636368, 0.570963, 0.412386, 0.239763, 0.112208}, {0.155356, 0.331961, 0.570963, 0.79052, 0.881075, 0.79052, 0.570963, 0.331961, 0.155356}, {0.173152, 0.369987, 0.636368, 0.881075, 0.982004, 0.881075, 0.636368, 0.369987, 0.173152}, {0.155356, 0.331961, 0.570963, 0.79052, 0.881075, 0.79052, 0.570963, 0.331961, 0.155356}, {0.112208, 0.239763, 0.412386, 0.570963, 0.636368, 0.570963, 0.412386, 0.239763, 0.112208}, {0.065238, 0.139399, 0.239763, 0.331961, 0.369987, 0.331961, 0.239763, 0.139399, 0.065238}, {0.030531, 0.065238, 0.112208, 0.155356, 0.173152, 0.155356, 0.112208, 0.065238, 0.030531}};
    private static final double[][] MEX1_5 = new double[][]{{-1.09E-4, -0.002374, -0.006302, -0.002374, -1.09E-4}, {-0.002374, -0.032222, -0.025569, -0.032222, -0.002374}, {-0.006302, -0.025569, 0.276021, -0.025569, -0.006302}, {-0.002374, -0.032222, -0.025569, -0.032222, -0.002374}, {-1.09E-4, -0.002374, -0.006302, -0.002374, -1.09E-4}};
    private static final double[][] MEX2 = new double[][]{{-6.0E-6, -1.32E-4, -8.49E-4, -0.001569, -8.49E-4, -1.32E-4, -6.0E-6}, {-1.32E-4, -0.002989, -0.017229, -0.028788, -0.017229, -0.002989, -1.32E-4}, {-8.49E-4, -0.017229, -0.042689, 0.023455, -0.042689, -0.017229, -8.49E-4}, {-0.001569, -0.028788, 0.023455, 0.356183, 0.023455, -0.028788, -0.001569}, {-8.49E-4, -0.017229, -0.042689, 0.023455, -0.042689, -0.017229, -8.49E-4}, {-1.32E-4, -0.002989, -0.017229, -0.028788, -0.017229, -0.002989, -1.32E-4}, {-6.0E-6, -1.32E-4, -8.49E-4, -0.001569, -8.49E-4, -1.32E-4, -6.0E-6}};
    private static final double[][] MEX2_5 = new double[][]{{-2.84E-4, -0.002194, -0.007273, -0.010722, -0.007273, -0.002194, -2.84E-4}, {-0.002194, -0.01564, -0.041259, -0.050277, -0.041259, -0.01564, -0.002194}, {-0.007273, -0.041259, -0.016356, 0.095837, -0.016356, -0.041259, -0.007273}, {-0.010722, -0.050277, 0.095837, 0.402756, 0.095837, -0.050277, -0.010722}, {-0.007273, -0.041259, -0.016356, 0.095837, -0.016356, -0.041259, -0.007273}, {-0.002194, -0.01564, -0.041259, -0.050277, -0.041259, -0.01564, -0.002194}, {-2.84E-4, -0.002194, -0.007273, -0.010722, -0.007273, -0.002194, -2.84E-4}};
    private static final double[][] MEX3 = new double[][]{{-4.1E-5, -3.16E-4, -0.001357, -0.003226, -0.004294, -0.003226, -0.001357, -3.16E-4, -4.1E-5}, {-3.16E-4, -0.002428, -0.010013, -0.022204, -0.028374, -0.022204, -0.010013, -0.002428, -3.16E-4}, {-0.001357, -0.010013, -0.03545, -0.054426, -0.050313, -0.054426, -0.03545, -0.010013, -0.001357}, {-0.003226, -0.022204, -0.054426, 0.033057, 0.164532, 0.033057, -0.054426, -0.022204, -0.003226}, {-0.004294, -0.028374, -0.050313, 0.164532, 0.42986, 0.164532, -0.050313, -0.028374, -0.004294}, {-0.003226, -0.022204, -0.054426, 0.033057, 0.164532, 0.033057, -0.054426, -0.022204, -0.003226}, {-0.001357, -0.010013, -0.03545, -0.054426, -0.050313, -0.054426, -0.03545, -0.010013, -0.001357}, {-3.16E-4, -0.002428, -0.010013, -0.022204, -0.028374, -0.022204, -0.010013, -0.002428, -3.16E-4}, {-4.1E-5, -3.16E-4, -0.001357, -0.003226, -0.004294, -0.003226, -0.001357, -3.16E-4, -4.1E-5}};
    private static final double[][] MEX4 = new double[][]{{-0.00225, -0.007092, -0.01564, -0.024467, -0.028187, -0.024467, -0.01564, -0.007092, -0.00225}, {-0.007092, -0.021141, -0.041403, -0.054742, -0.057388, -0.054742, -0.041403, -0.021141, -0.007092}, {-0.01564, -0.041403, -0.057494, -0.024939, 0.008058, -0.024939, -0.057494, -0.041403, -0.01564}, {-0.024467, -0.054742, -0.024939, 0.145167, 0.27147, 0.145167, -0.024939, -0.054742, -0.024467}, {-0.028187, -0.057388, 0.008058, 0.27147, 0.459236, 0.27147, 0.008058, -0.057388, -0.028187}, {-0.024467, -0.054742, -0.024939, 0.145167, 0.27147, 0.145167, -0.024939, -0.054742, -0.024467}, {-0.01564, -0.041403, -0.057494, -0.024939, 0.008058, -0.024939, -0.057494, -0.041403, -0.01564}, {-0.007092, -0.021141, -0.041403, -0.054742, -0.057388, -0.054742, -0.041403, -0.021141, -0.007092}, {-0.00225, -0.007092, -0.01564, -0.024467, -0.028187, -0.024467, -0.01564, -0.007092, -0.00225}};
    private static final double[][] MEX5 = new double[][]{{-0.002172, -0.005657, -0.011702, -0.019279, -0.025644, -0.028106, -0.025644, -0.019279, -0.011702, -0.005657, -0.002172}, {-0.005657, -0.014328, -0.028098, -0.04268, -0.052065, -0.054833, -0.052065, -0.04268, -0.028098, -0.014328, -0.005657}, {-0.011702, -0.028098, -0.049016, -0.059439, -0.051288, -0.043047, -0.051288, -0.059439, -0.049016, -0.028098, -0.011702}, {-0.019279, -0.04268, -0.059439, -0.030431, 0.047481, 0.093729, 0.047481, -0.030431, -0.059439, -0.04268, -0.019279}, {-0.025644, -0.052065, -0.051288, 0.047481, 0.235153, 0.339248, 0.235153, 0.047481, -0.051288, -0.052065, -0.025644}, {-0.028106, -0.054833, -0.043047, 0.093729, 0.339248, 0.473518, 0.339248, 0.093729, -0.043047, -0.054833, -0.028106}, {-0.025644, -0.052065, -0.051288, 0.047481, 0.235153, 0.339248, 0.235153, 0.047481, -0.051288, -0.052065, -0.025644}, {-0.019279, -0.04268, -0.059439, -0.030431, 0.047481, 0.093729, 0.047481, -0.030431, -0.059439, -0.04268, -0.019279}, {-0.011702, -0.028098, -0.049016, -0.059439, -0.051288, -0.043047, -0.051288, -0.059439, -0.049016, -0.028098, -0.011702}, {-0.005657, -0.014328, -0.028098, -0.04268, -0.052065, -0.054833, -0.052065, -0.04268, -0.028098, -0.014328, -0.005657}, {-0.002172, -0.005657, -0.011702, -0.019279, -0.025644, -0.028106, -0.025644, -0.019279, -0.011702, -0.005657, -0.002172}};
    private static final double[][] TOPHAT1_5 = new double[][]{{0.0, 0.18, 0.0}, {0.18, 1.0, 0.18}, {0.0, 0.18, 0.0}};
    private static final double[][] TOPHAT2 = new double[][]{{0.08, 0.46, 0.08}, {0.46, 1.0, 0.46}, {0.08, 0.46, 0.08}};
    private static final double[][] TOPHAT2_5 = new double[][]{{0.26, 0.7, 0.26}, {0.7, 1.0, 0.7}, {0.26, 0.7, 0.26}};
    private static final double[][] TOPHAT3 = new double[][]{{0.56, 0.98, 0.56}, {0.98, 1.0, 0.98}, {0.56, 0.98, 0.56}};
    private static final double[][] TOPHAT4 = new double[][]{{0.0, 0.22, 0.48, 0.22, 0.0}, {0.22, 0.99, 1.0, 0.99, 0.22}, {0.48, 1.0, 1.0, 1.0, 0.48}, {0.22, 0.99, 1.0, 0.99, 0.22}, {0.0, 0.22, 0.48, 0.22, 0.0}};
    private static final double[][] TOPHAT5 = new double[][]{{0.15, 0.77, 1.0, 0.77, 0.15}, {0.77, 1.0, 1.0, 1.0, 0.77}, {1.0, 1.0, 1.0, 1.0, 1.0}, {0.77, 1.0, 1.0, 1.0, 0.77}, {0.15, 0.77, 1.0, 0.77, 0.15}};

    private static String createConvName() {
        return "Kernel" + ++NK;
    }

    public KernelList(Aladin aladin) {
        this.aladin = aladin;
        this.list = new Vector();
        this.addDefaultKernels();
    }

    public int findKernel(String string) {
        Enumeration<Kernel> enumeration = this.list.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Kernel kernel = enumeration.nextElement();
            if (kernel.name.equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int addKernel(String string, double d) throws Exception {
        String string2;
        Kernel kernel = null;
        int n = string.indexOf(61);
        int n2 = string.indexOf(40);
        if (n > 0 && (n2 == -1 || n2 > n)) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            string2 = KernelList.createConvName();
        }
        n = string.indexOf(40);
        if (n >= 0) {
            double[] dArray = KernelList.parseGaussCmd(string);
            if (dArray == null) {
                throw new Exception("usage: gauss( {fwhm|sigma}=angle [,radius=x] )");
            }
            kernel = KernelList.createGaussienMatrix(dArray[0], dArray[1], d, (int)dArray[2]);
        } else {
            kernel = new Kernel();
            kernel.matrix = KernelList.parseKernel(string);
        }
        kernel.name = string2;
        int n3 = this.findKernel(string2);
        if (n3 < 0) {
            this.list.addElement(kernel);
            n3 = this.list.size() - 1;
        } else {
            this.list.setElementAt(kernel, n3);
        }
        if (this.aladin.frameConvolution != null) {
            this.aladin.frameConvolution.reloadComboKernel(string2);
        }
        return n3;
    }

    protected double[][] getKernel(int n) {
        return this.list.elementAt((int)n).matrix;
    }

    public String getKernelList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Kernel> enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().name + "\n");
        }
        return stringBuffer.toString();
    }

    public Vector<String> getKernelListAsVector() {
        Vector<String> vector = new Vector<String>();
        Enumeration<Kernel> enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().name);
        }
        return vector;
    }

    public String getKernelDef(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Kernel> enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            Kernel kernel = enumeration.nextElement();
            if (string != null && !Util.matchMask(string, kernel.name)) continue;
            stringBuffer.append(kernel);
        }
        return stringBuffer.toString();
    }

    public static double[] parseGaussCmd(String string) {
        double[] dArray = new double[3];
        try {
            int n = string.indexOf(40);
            if (!string.substring(0, n).trim().endsWith("gauss")) {
                return null;
            }
            int n2 = string.lastIndexOf(41);
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, n2), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n = string2.indexOf(61);
                String string3 = n < 0 ? "fwhm" : string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (string3.equalsIgnoreCase("fwhm")) {
                    dArray[0] = Server.getAngleInArcmin(string4, 1) / 60.0;
                    continue;
                }
                if (string3.equalsIgnoreCase("sigma")) {
                    dArray[1] = Server.getAngleInArcmin(string4, 1) / 60.0;
                    continue;
                }
                if (string3.equalsIgnoreCase("radius")) {
                    dArray[2] = Integer.parseInt(string4);
                    continue;
                }
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return dArray;
    }

    private static double[][] parseKernel(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        Tok tok = new Tok(string);
        int n3 = (int)Math.sqrt(tok.countTokens());
        double[][] dArray = null;
        while (tok.hasMoreTokens()) {
            double d = Double.parseDouble(tok.nextToken());
            if (dArray == null) {
                dArray = new double[n3][n3];
            }
            dArray[n][n2++] = d;
            if (n2 != n3) continue;
            n2 = 0;
            ++n;
        }
        return dArray;
    }

    public Kernel getKernel(String string, double d) throws Exception {
        int n = this.findKernel(string);
        if (n < 0) {
            n = this.addKernel(string, d);
        }
        return this.list.elementAt(n);
    }

    public static Kernel createGaussienMatrix(double d, double d2, double d3, int n) throws Exception {
        double[] dArray = KernelList.computeGaussParam(d, d2, d3, n);
        d = dArray[0];
        d2 = dArray[1];
        n = (int)dArray[2];
        if (n > 500) {
            throw new Exception("Too large kernel [radius=" + n + "]");
        }
        Kernel kernel = new Kernel();
        kernel.matrix = KernelList.createGaussienMatrix(n, d2 / d3);
        kernel.gaussian = KernelList.createFastGaussienMatrix(n, d2 / d3);
        return kernel;
    }

    public static double[] computeGaussParam(double d, double d2, double d3, int n) {
        if (d2 == 0.0 && d == 0.0) {
            d2 = 0.5;
        } else if (d != 0.0) {
            d2 = d / FCTSIGMA;
        } else {
            d = FCTSIGMA * d2;
        }
        double d4 = 3.0 * d;
        double d5 = d4 / d3;
        if (n == 0) {
            n = (int)Math.ceil(d5) / 2;
        }
        if (n < 1) {
            n = 1;
        }
        return new double[]{d, d2, n};
    }

    public static double[][] createGaussienMatrix(int n, double d) {
        int n2;
        int n3 = 2 * n + 1;
        double[][] dArray = new double[n3][n3];
        double d2 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            double d3 = n2 - n;
            for (int i = 0; i < n3; ++i) {
                double d4;
                double d5 = i - n;
                dArray[i][n2] = d4 = Math.exp(-(d5 * d5 + d3 * d3) / (2.0 * d * d));
                d2 += d4;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n3; ++i) {
                double[] dArray2 = dArray[i];
                int n4 = n2;
                dArray2[n4] = dArray2[n4] / d2;
            }
        }
        return dArray;
    }

    public static double[] createFastGaussienMatrix(int n, double d) {
        int n2;
        int n3 = 2 * n + 1;
        double[] dArray = new double[n3];
        double d2 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            double d3;
            double d4 = n2 - n;
            int n4 = n;
            double d5 = n4 - n;
            dArray[n2] = d3 = Math.exp(-(d5 * d5 + d4 * d4) / (2.0 * d * d));
            d2 += d3;
        }
        n2 = 0;
        while (n2 < n3) {
            int n5 = n2++;
            dArray[n5] = dArray[n5] / d2;
        }
        return dArray;
    }

    public void addDefaultKernels() {
        Kernel kernel = new Kernel("Gauss-1.5pix", GAUSS1_5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Gauss-2pix", GAUSS2);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Gauss-2.5pix", GAUSS2_5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Gauss-3pix", GAUSS3);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Gauss-4pix", GAUSS4);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Gauss-5pix", GAUSS5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Mex-1.5pix", MEX1_5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Mex-2pix", MEX2);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Mex-2.5pix", MEX2_5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Mex-3pix", MEX3);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Mex-4pix", MEX4);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Mex-5pix", MEX5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Tophat-1.5pix", TOPHAT1_5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Tophat-2pix", TOPHAT2);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Tophat-2.5pix", TOPHAT2_5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Tophat-3pix", TOPHAT3);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Tophat-4pix", TOPHAT4);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Tophat-5pix", TOPHAT5);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Blur-", CONTRAST);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Blur+", FLOU);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Pyramidal", PYRAMIDAL);
        this.list.add(kernel);
        kernel.normalize();
        kernel = new Kernel("Edge", BORD);
        this.list.add(kernel);
        kernel.normalize();
    }
}

