/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public final class Legende
extends AbstractTableModel {
    String name;
    Field[] field;
    Vector<String> group = null;
    boolean[] computed;
    private int firstLink = -2;
    private boolean sorted = false;
    private static final String[] HEAD = new String[]{"", "Visible", "Coo", "Name", "Description", "Unit", "Datatype", "UCD", "Utype", "Width", "Arraysize", "Precision"};
    private static final int[] WHEAD = new int[]{30, 50, 30, 100, 190, 50, 70, 110, -1, 40, 40, 40};
    private static final int N = 0;
    private static final int VISIBLE = 1;
    private static final int COO = 2;
    public static final int NAME = 3;
    public static final int DESCRIPTION = 4;
    public static final int UNIT = 5;
    public static final int DATATYPE = 6;
    public static final int UCD = 7;
    public static final int UTYPE = 8;
    public static final int WIDTH = 9;
    public static final int ARRAYSIZE = 10;
    public static final int PRECISION = 11;
    private JTable table;
    private Aladin aladin;
    public Plan plan = null;

    protected Legende() {
        this.field = new Field[0];
    }

    protected Legende(Vector<Field> vector) {
        this.field = new Field[vector.size()];
        this.computed = new boolean[vector.size()];
        Enumeration<Field> enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            this.field[n] = enumeration.nextElement();
            this.computed[n] = false;
            ++n;
        }
    }

    protected Legende(ArrayList<Legende> arrayList) {
        int n;
        ArrayList<Field> arrayList2 = new ArrayList<Field>(100);
        for (n = 0; n < arrayList.size(); ++n) {
            Legende legende = arrayList.get(n);
            for (int i = 0; i < legende.field.length; ++i) {
                int n2;
                for (n2 = 0; n2 < arrayList2.size() && !((Field)arrayList2.get(n2)).equals(legende.field[i]); ++n2) {
                }
                if (n2 != arrayList2.size()) continue;
                arrayList2.add(new Field(legende.field[i]));
            }
        }
        this.field = new Field[arrayList2.size()];
        this.computed = new boolean[this.field.length];
        this.name = "[Concatenated]";
        for (n = 0; n < this.field.length; ++n) {
            this.field[n] = (Field)arrayList2.get(n);
        }
    }

    protected Legende(Legende legende) {
        this.field = new Field[legende.field.length];
        for (int i = 0; i < legende.field.length; ++i) {
            this.field[i] = legende.field[i];
        }
        this.name = legende.name;
        this.group = legende.group;
        if (legende.computed != null) {
            this.computed = new boolean[legende.computed.length];
            System.arraycopy(legende.computed, 0, this.computed, 0, legende.computed.length);
        } else {
            this.computed = null;
        }
    }

    public static Legende adjustDefaultLegende(Legende legende, int n, String[] stringArray) {
        if (legende == null || legende.field.length != stringArray.length) {
            legende = new Legende();
            legende.field = new Field[stringArray.length];
            legende.computed = new boolean[stringArray.length];
        }
        block10: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (legende.field[i] == null) {
                legende.field[i] = new Field("Col_" + i);
                legende.computed[i] = false;
            }
            Field field = legende.field[i];
            switch (n) {
                case 3: {
                    field.name = stringArray[i].length() == 0 ? "" : stringArray[i];
                    continue block10;
                }
                case 4: {
                    field.description = stringArray[i].length() == 0 ? "" : stringArray[i];
                    continue block10;
                }
                case 6: {
                    field.datatype = stringArray[i].length() == 0 ? "" : Field.typeVOTable2Fits(stringArray[i]);
                    continue block10;
                }
                case 5: {
                    field.unit = stringArray[i].length() == 0 ? "" : stringArray[i];
                    continue block10;
                }
                case 7: {
                    field.ucd = stringArray[i].length() == 0 ? "" : stringArray[i];
                    continue block10;
                }
                case 9: {
                    field.width = stringArray[i].length() == 0 ? "" : stringArray[i];
                    field.computeColumnSize();
                    continue block10;
                }
                case 10: {
                    field.arraysize = stringArray[i].length() == 0 ? "" : stringArray[i];
                    field.computeColumnSize();
                    continue block10;
                }
                case 11: {
                    field.precision = stringArray[i].length() == 0 ? "" : stringArray[i];
                }
            }
        }
        return legende;
    }

    public void setGroup(Vector<String> vector) {
        this.group = vector;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getGroup() {
        if (this.group == null) {
            return "";
        }
        Enumeration<String> enumeration = this.group.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    protected int find(Field field) {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].equals(field)) continue;
            return i;
        }
        return -1;
    }

    protected int find(String string) {
        for (int i = 0; i < this.field.length; ++i) {
            if (!string.equals(this.field[i].name)) continue;
            return i;
        }
        return -1;
    }

    protected int getRa() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isRa()) continue;
            return i;
        }
        return -1;
    }

    protected int getDe() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isDe()) continue;
            return i;
        }
        return -1;
    }

    protected int getPmRa() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isPmRa()) continue;
            return i;
        }
        return -1;
    }

    protected int getPmDe() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isPmDe()) continue;
            return i;
        }
        return -1;
    }

    protected int getX() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isX()) continue;
            return i;
        }
        return -1;
    }

    protected int getY() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isY()) continue;
            return i;
        }
        return -1;
    }

    protected boolean isVisible(int n) {
        try {
            return this.field[n].visible;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected void addField(Field field) {
        int n = this.field.length;
        Field[] fieldArray = new Field[n + 1];
        System.arraycopy(this.field, 0, fieldArray, 0, n);
        fieldArray[n] = field;
        this.field = fieldArray;
    }

    protected int setField(int n, String string, String string2, String string3, String string4, int n2) {
        int n3 = 0;
        int n4 = this.field.length;
        if (n >= n4) {
            int n5;
            n3 = n - n4;
            Field[] fieldArray = new Field[n + 1];
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.field, 0, fieldArray, 0, n4);
            if (this.computed != null) {
                System.arraycopy(this.computed, 0, blArray, 0, n4);
            } else {
                for (n5 = 0; n5 < n4; ++n5) {
                    blArray[n5] = false;
                }
            }
            for (n5 = n4; n5 < n + 1; ++n5) {
                fieldArray[n5] = new Field("Col_" + (n5 + 1));
                blArray[n5] = true;
            }
            this.computed = blArray;
            this.field = fieldArray;
        }
        Field field = this.field[n];
        if (string != null) {
            field.name = string;
        }
        if (string2 != null) {
            field.datatype = Field.typeFits2VOTable(string2);
        }
        if (string3 != null) {
            field.unit = string3;
        }
        if (string4 != null) {
            field.ucd = string4;
        }
        if (n2 >= 0) {
            field.width = n2 == 0 ? null : n2 + "";
        }
        field.computeColumnSize();
        this.computed[n] = true;
        return n3;
    }

    protected int getRealFieldNumber(int n) {
        if (n == -1) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            int n4 = 0;
            while (!this.field[n4].visible) {
                ++n3;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n2 < n) {
                if (!this.field[n5].visible) {
                    ++n3;
                } else {
                    ++n2;
                }
                ++n5;
            }
        }
        return n + n3;
    }

    protected boolean switchSort(int n) {
        int n2 = this.field[n].sort;
        this.clearSort();
        this.field[n].sort = n2 == 1 ? 2 : 1;
        this.sorted = true;
        return this.field[n].sort == 1;
    }

    protected void setSort(int n, int n2) {
        this.clearSort();
        if (n >= 0) {
            this.field[n].sort = n2;
        }
        this.sorted = n2 != 0;
    }

    protected void clearSort() {
        for (int i = 0; i < this.field.length; ++i) {
            this.field[i].sort = 0;
        }
        this.sorted = false;
    }

    protected boolean isSED() {
        for (Field field : this.field) {
            if (field.sed == 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isSorted() {
        return this.sorted;
    }

    public int getSize() {
        return this.field.length;
    }

    protected int matchColIndex(String string) {
        for (int i = 0; i < this.field.length; ++i) {
            if (this.field[i].name == null || !Util.matchMask(string, this.field[i].name)) continue;
            return i;
        }
        return -1;
    }

    protected int matchIgnoreCaseColIndex(String string) {
        for (int i = 0; i < this.field.length; ++i) {
            if (this.field[i].name == null || !Util.matchMaskIgnoreCase(string, this.field[i].name)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isNullValue(String string, int n) {
        if (n >= this.field.length) {
            return false;
        }
        Field field = this.field[n];
        return field.nullValue != null && field.nullValue.equals(string.trim());
    }

    protected String getUCD(int n) {
        if (n >= this.field.length) {
            return null;
        }
        Field field = this.field[n];
        return field.ucd != null ? field.ucd : "";
    }

    protected String getUtype(int n) {
        if (n >= this.field.length) {
            return null;
        }
        Field field = this.field[n];
        return field.utype != null ? field.utype : "";
    }

    protected int getPrecision(int n) {
        if (n >= this.field.length) {
            return -1;
        }
        Field field = this.field[n];
        try {
            return Integer.parseInt(field.precision);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected int getWidth(int n) {
        if (n >= this.field.length) {
            return -1;
        }
        Field field = this.field[n];
        if (field.refText != null && field.refText.indexOf("${") < 0) {
            return field.refText.length() + 1;
        }
        return field.columnSize;
    }

    protected int getWidth() {
        int n = 0;
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].visible) continue;
            n += this.getWidth(i);
        }
        return n;
    }

    protected int getRefTextLength(int n) {
        if (n >= this.field.length) {
            return -1;
        }
        if (this.field[n].refText == null) {
            return 0;
        }
        return this.field[n].refText.length() + 1;
    }

    protected String getName(int n) {
        return n >= this.field.length ? null : this.field[n].name;
    }

    protected String getHref(int n) {
        return n >= this.field.length ? null : this.field[n].href;
    }

    protected String getGref(int n) {
        return n >= this.field.length ? null : this.field[n].gref;
    }

    protected String getRefText(int n) {
        return n >= this.field.length ? null : this.field[n].refText;
    }

    protected String getRefValue(int n) {
        return n >= this.field.length ? null : this.field[n].refValue;
    }

    protected String getDataType(int n) {
        return n >= this.field.length ? null : this.field[n].datatype;
    }

    protected boolean hasInfo(int n) {
        return n >= this.field.length ? false : n < this.field.length;
    }

    protected boolean isNumField(int n) {
        return n < 0 ? false : (n >= this.field.length ? true : this.field[n].isNumDataType());
    }

    protected int getFirstLink() {
        if (this.firstLink != -2) {
            return this.firstLink;
        }
        for (int i = 0; i < this.field.length; ++i) {
            if (this.getHref(i) == null && this.getGref(i) == null) continue;
            this.firstLink = i;
            return this.firstLink;
        }
        this.firstLink = -1;
        return this.firstLink;
    }

    protected JPanel getTablePanel(Aladin aladin, Plan plan) {
        this.aladin = aladin;
        this.plan = plan;
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.createTable());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JComboBox createCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setMaximumRowCount(15);
        for (int i = 0; i < this.field.length; ++i) {
            jComboBox.addItem(this.field[i].name);
        }
        return jComboBox;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.createTable();
        }
        return this.table;
    }

    private JTable createTable() {
        int n;
        this.table = new JTable(this);
        this.table.setSelectionMode(0);
        MyRenderer myRenderer = new MyRenderer();
        MyComboBoxEditor myComboBoxEditor = new MyComboBoxEditor();
        int n2 = 0;
        for (n = 0; n < HEAD.length; ++n) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
            if (WHEAD[n] != -1) {
                tableColumn.setMinWidth(WHEAD[n]);
            }
            if (n == 2) {
                tableColumn.setCellEditor(myComboBoxEditor);
            }
            if (n != 1) {
                tableColumn.setCellRenderer(myRenderer);
            }
            n2 += WHEAD[n];
        }
        n = Math.min(this.getRowCount(), 15) * 16;
        this.table.setPreferredScrollableViewportSize(new Dimension(n2 + 50, n));
        return this.table;
    }

    @Override
    public String getColumnName(int n) {
        return HEAD[n];
    }

    @Override
    public int getColumnCount() {
        return HEAD.length;
    }

    @Override
    public int getRowCount() {
        return this.field.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 1) {
            return new Boolean(true).getClass();
        }
        return super.getColumnClass(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return n + 1 + "";
            }
            case 2: {
                return this.field[n].getCooSignature();
            }
            case 1: {
                return new Boolean(this.field[n].visible);
            }
            case 3: {
                return this.field[n].name;
            }
            case 5: {
                return this.field[n].unit;
            }
            case 4: {
                return this.field[n].description;
            }
            case 7: {
                return this.field[n].ucd;
            }
            case 8: {
                return this.field[n].utype;
            }
            case 6: {
                return Field.typeFits2VOTable(this.field[n].datatype);
            }
            case 9: {
                return this.field[n].width;
            }
            case 10: {
                return this.field[n].arraysize;
            }
            case 11: {
                return this.field[n].precision;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 3: {
                this.field[n].name = (String)object;
                break;
            }
            case 2: {
                String string = (String)object;
                if (string.equals(this.field[n].getCooSignature())) break;
                int n3 = Util.indexInArrayOf(string, Field.COOSIGN);
                this.modifyRaDecXYField(n, n3);
                break;
            }
            case 1: {
                this.field[n].visible = (Boolean)object;
                break;
            }
            case 5: {
                this.field[n].unit = (String)object;
                break;
            }
            case 4: {
                this.field[n].description = (String)object;
                break;
            }
            case 7: {
                this.field[n].ucd = (String)object;
                break;
            }
            case 8: {
                this.field[n].utype = (String)object;
                break;
            }
            case 6: {
                this.field[n].datatype = Field.typeVOTable2Fits((String)object);
                break;
            }
            case 9: {
                this.field[n].width = (String)object;
                this.field[n].computeColumnSize();
                break;
            }
            case 10: {
                this.field[n].arraysize = (String)object;
                this.field[n].computeColumnSize();
                break;
            }
            case 11: {
                this.field[n].precision = (String)object;
            }
        }
        this.aladin.mesure.redisplay();
    }

    public void modifyRaDecXYField(int n, int n2) {
        if (this.plan == null || this.plan.pcat == null) {
            return;
        }
        this.plan.hasPM = -1;
        if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4) {
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            if (n2 == 1) {
                n3 = n;
            } else if (n2 == 2) {
                n4 = n;
            } else if (n2 == 3) {
                n5 = n;
            } else if (n2 == 4) {
                n6 = n;
            }
            for (int i = 0; i < this.field.length; ++i) {
                Field field = this.field[i];
                if (field.coo == 1) {
                    if (n2 == 1) {
                        field.coo = 0;
                    }
                    if (n3 == -1) {
                        n3 = i;
                    }
                }
                if (field.coo == 2) {
                    if (n2 == 2) {
                        field.coo = 0;
                    }
                    if (n4 == -1) {
                        n4 = i;
                    }
                }
                if (field.coo == 3) {
                    if (n2 == 3) {
                        field.coo = 0;
                    }
                    if (n5 == -1) {
                        n5 = i;
                    }
                }
                if (field.coo == 4) {
                    if (n2 == 4) {
                        field.coo = 0;
                    }
                    if (n6 == -1) {
                        n6 = i;
                    }
                }
                if (field.coo != 5 && field.coo != 6) continue;
                field.coo = 0;
            }
            this.field[n].coo = n2;
            if (n3 >= 0 && n4 >= 0 && n2 != 0) {
                this.plan.modifyRaDecField(this, n3, n4, n5, n6);
            }
        } else {
            int n7 = -1;
            int n8 = -1;
            if (n2 == 5) {
                n7 = n;
            } else if (n2 == 6) {
                n8 = n;
            }
            for (int i = 0; i < this.field.length; ++i) {
                Field field = this.field[i];
                if (field.coo == 5) {
                    if (n2 == 5) {
                        field.coo = 0;
                    }
                    if (n7 == -1) {
                        n7 = i;
                    }
                }
                if (field.coo == 6) {
                    if (n2 == 6) {
                        field.coo = 0;
                    }
                    if (n8 == -1) {
                        n8 = i;
                    }
                }
                if (field.coo != 1 && field.coo != 2 && field.coo != 3 && field.coo != 4) continue;
                field.coo = 0;
            }
            this.field[n].coo = n2;
            if (n7 >= 0 && n8 >= 0 && n2 != 0) {
                this.plan.modifyXYField(this, n7, n8);
            }
        }
        this.fireTableDataChanged();
    }

    public String toString() {
        return this.field[0].name + " " + this.field[0].ucd + " ...";
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            if (n2 == 0) {
                jLabel.setFont(jLabel.getFont().deriveFont(2));
            } else if (n2 == 3) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            } else {
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }
            if (n2 == 0 || n2 == 6 || n2 == 1 || n2 == 10) {
                jLabel.setHorizontalAlignment(0);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
            return component;
        }
    }

    class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor() {
            super(new JComboBox<String>(Field.COOSIGN));
        }
    }
}

