/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Couleur;
import cds.aladin.Hist;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import healpix.essentials.FastMath;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class Ligne
extends Position {
    static final int L = 7;
    static final int DL = 4;
    protected byte bout;
    protected Color couleur = null;
    protected boolean hidden = false;
    protected Ligne debligne = null;
    protected Ligne finligne = null;

    protected Ligne(Plan plan) {
        super(plan);
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, null);
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, String string) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, string);
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, Ligne ligne) {
        this(plan, viewSimple, d, d2, "", ligne);
    }

    protected Ligne(double d, double d2, Plan plan, ViewSimple viewSimple) {
        super(plan, viewSimple, 0.0, 0.0, d, d2, 2, null);
    }

    protected Ligne(ViewSimple viewSimple, double d, double d2) {
        super(null, viewSimple, 0.0, 0.0, d, d2, 4, null);
    }

    protected Ligne(double d, double d2, Plan plan, ViewSimple viewSimple, Ligne ligne) {
        this(d, d2, plan, viewSimple, null, ligne);
    }

    protected Ligne(double d, double d2, Plan plan, ViewSimple viewSimple, String string, Ligne ligne) {
        super(plan, viewSimple, 0.0, 0.0, d, d2, 2, string);
        this.debligne = ligne;
        if (ligne != null) {
            ligne.finligne = this;
        }
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, String string, Ligne ligne) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, string);
        this.debligne = ligne;
        if (ligne != null) {
            ligne.finligne = this;
        }
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, Color color) {
        this(plan, viewSimple, d, d2);
        this.couleur = new Color(color.getRGB());
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, String string, Color color) {
        this(plan, viewSimple, d, d2, string);
        this.couleur = new Color(color.getRGB());
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, Ligne ligne, Color color) {
        this(plan, viewSimple, d, d2, "", ligne, color);
        this.couleur = new Color(color.getRGB());
    }

    protected Ligne(Plan plan, ViewSimple viewSimple, double d, double d2, String string, Ligne ligne, Color color) {
        this(plan, viewSimple, d, d2, string);
        this.debligne = ligne;
        ligne.finligne = this;
        this.couleur = new Color(color.getRGB());
    }

    public Vector getProp() {
        Vector<Prop> vector = super.getProp();
        final Couleur couleur = new Couleur(this.couleur, true);
        final PropAction propAction = new PropAction(){

            @Override
            public int action() {
                Color color = couleur.getCouleur();
                if (color == Ligne.this.couleur) {
                    return -1;
                }
                Ligne.this.setColor(color);
                return 1;
            }
        };
        couleur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction.action();
                Ligne.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("color", "Color", "Alternative color", couleur, null, propAction));
        return vector;
    }

    @Override
    public String getObjType() {
        return this.finligne == null ? "Line" : "Line+";
    }

    protected static boolean inLigne(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if ((d3 - d5) * (d - d5) > (d7 = Math.sqrt(d7)) || (d4 - d6) * (d2 - d6) > d7) {
            return false;
        }
        double d8 = d3 - d;
        double d9 = d4 - d2;
        double d10 = d5 - d;
        double d11 = d6 - d2;
        double d12 = d10 * d10 + d11 * d11;
        if (d8 != 0.0 || d9 != 0.0) {
            double d13 = d8 * d10 + d9 * d11;
            d12 -= d13 * d13 / (d8 * d8 + d9 * d9);
        }
        return d12 <= d7;
    }

    static boolean isLigne(Obj obj) {
        return obj != null && obj instanceof Ligne && !(obj instanceof Cote);
    }

    static boolean isDebLigne(Obj obj) {
        return Ligne.isLigne(obj) && ((Ligne)obj).debligne == null;
    }

    protected void makeLastLigneForPolygone(ViewSimple viewSimple, boolean bl) {
        this.getFirstBout().bout = 0;
        this.bout = (byte)3;
        this.setSelected(bl);
        Ligne ligne = this.getFirstBout();
        this.raj = ligne.raj;
        this.dej = ligne.dej;
        ligne.setSelected(bl);
        this.projection(viewSimple);
    }

    protected void makeLastLigneForClose(ViewSimple viewSimple) {
        Ligne ligne = this.getFirstBout();
        this.raj = ligne.raj;
        this.dej = ligne.dej;
        this.bout = (byte)3;
        this.projection(viewSimple);
    }

    @Override
    protected void remove() {
        Ligne ligne = this.debligne;
        Ligne ligne2 = this.finligne;
        if (ligne != null) {
            ligne.finligne = ligne2;
        }
        if (ligne2 != null) {
            ligne2.debligne = ligne;
        }
        if (this.bout == 3) {
            this.plan.aladin.calque.zoom.zoomView.cutOff(this);
        }
    }

    protected boolean isPolygone() {
        return this.getLastBout().bout == 3;
    }

    @Override
    public String getCommand() {
        StringBuffer stringBuffer = new StringBuffer("draw");
        boolean bl = this.isPolygone();
        if (bl) {
            stringBuffer.append(" polygon(");
        } else if (this instanceof Cote) {
            stringBuffer.append(" dist(");
        } else {
            stringBuffer.append(" line(");
        }
        boolean bl2 = true;
        Ligne ligne = this.getFirstBout();
        while (bl && ligne != null && ligne.finligne != null || !bl && ligne != null) {
            if (!bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ligne.getLocalisation());
            bl2 = false;
            ligne = ligne.finligne;
        }
        if (!(this instanceof Cote) && this.id != null && this.id.trim().length() > 0) {
            stringBuffer.append("," + Tok.quote(this.id));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean hasPhot() {
        return this.isPolygone();
    }

    public boolean hasPhot(Plan plan) {
        if (!this.hasPhot()) {
            return false;
        }
        return plan.hasAvailablePixels();
    }

    private void fillPolygon(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (this.bout != 3) {
            return;
        }
        Ligne ligne = this;
        Polygon polygon = new Polygon();
        while (ligne.debligne != null) {
            Point point = ligne.getViewCoord(viewSimple);
            polygon.addPoint(n + point.x, n2 + point.y);
            ligne = ligne.debligne;
        }
        float f = this.plan == null ? 1.0f : this.plan.getOpacityLevel();
        Util.drawFillPolygon(graphics, polygon, 0.1f * f, null);
    }

    @Override
    protected boolean in(ViewSimple viewSimple, double d, double d2) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.debligne == null) {
            return this.inBout(viewSimple, d, d2);
        }
        PointD pointD = viewSimple.getViewCoordDble(this.debligne.xv[viewSimple.n], this.debligne.yv[viewSimple.n]);
        PointD pointD2 = viewSimple.getViewCoordDble(this.xv[viewSimple.n], this.yv[viewSimple.n]);
        PointD pointD3 = viewSimple.getViewCoordDble(d, d2);
        return Ligne.inLigne(pointD.x, pointD.y, pointD2.x, pointD2.y, pointD3.x, pointD3.y, this.mouseDist(viewSimple)) || this.inBout(viewSimple, d, d2);
    }

    @Override
    protected boolean inBout(ViewSimple viewSimple, double d, double d2) {
        return this.nearArrow(viewSimple, d, d2);
    }

    boolean nearArrow(ViewSimple viewSimple, double d, double d2) {
        if (!this.isVisible()) {
            return false;
        }
        PointD pointD = viewSimple.getViewCoordDble(d, d2);
        PointD pointD2 = viewSimple.getViewCoordDble(this.xv[viewSimple.n], this.yv[viewSimple.n]);
        double d3 = pointD.x - pointD2.x;
        double d4 = pointD.y - pointD2.y;
        double d5 = this.mouseDist(viewSimple);
        boolean bl = Math.sqrt(d3 * d3 + d4 * d4) <= d5;
        return bl;
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        return this.nearArrow(viewSimple, d, d2);
    }

    protected boolean inPolygon(ViewSimple viewSimple, int n, int n2) {
        if (this.bout != 3) {
            return false;
        }
        Ligne ligne = this;
        Polygon polygon = new Polygon();
        while (ligne.debligne != null) {
            polygon.addPoint((int)ligne.xv[viewSimple.n], (int)ligne.yv[viewSimple.n]);
            ligne = ligne.debligne;
        }
        return polygon.contains(n, n2);
    }

    protected Point getViewCoord(ViewSimple viewSimple) {
        return viewSimple.getViewCoord(this.xv[viewSimple.n], this.yv[viewSimple.n]);
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        int n;
        if (!this.isVisible()) {
            return rectangle;
        }
        int n2 = 2048;
        int n3 = 2048;
        int n4 = 0;
        int n5 = 0;
        Point point = this.debligne != null ? this.debligne.getViewCoord(viewSimple) : null;
        Point point2 = this.finligne != null ? this.finligne.getViewCoord(viewSimple) : null;
        Point point3 = this.getViewCoord(viewSimple);
        for (n = 0; n < 3; ++n) {
            Point point4;
            Point point5 = n == 0 ? point : (point4 = n == 1 ? point2 : point3);
            if (point4 == null) continue;
            if (point4.x < n2) {
                n2 = point4.x;
            }
            if (point4.y < n3) {
                n3 = point4.y;
            }
            if (point4.x > n4) {
                n4 = point4.x;
            }
            if (point4.y <= n5) continue;
            n5 = point4.y;
        }
        n = 1;
        if (this.bout > 0 || this.isSelected()) {
            n = 4;
        }
        n2 -= n;
        n3 -= n + this.clipYId();
        n4 += n + this.clipXId();
        n5 += n + this.clipYId();
        if (this.bout == 3 && this.hasOneSelected()) {
            rectangle = Ligne.unionRect(rectangle, this.getStatPosition(viewSimple));
        }
        return Ligne.unionRect(rectangle, n2, n3, n4 - n2 + 1, n5 - n3 + 1);
    }

    @Override
    protected boolean inClip(ViewSimple viewSimple, Rectangle rectangle) {
        int n;
        if (!this.isVisible()) {
            return false;
        }
        int n2 = 2048;
        int n3 = 2048;
        int n4 = 0;
        int n5 = 0;
        Point point = this.debligne != null ? this.debligne.getViewCoord(viewSimple) : null;
        Point point2 = this.finligne != null ? this.finligne.getViewCoord(viewSimple) : null;
        Point point3 = this.getViewCoord(viewSimple);
        for (n = 0; n < 3; ++n) {
            Point point4;
            Point point5 = n == 0 ? point : (point4 = n == 1 ? point2 : point3);
            if (point4 == null) continue;
            if (point4.x < n2) {
                n2 = point4.x;
            }
            if (point4.y < n3) {
                n3 = point4.y;
            }
            if (point4.x > n4) {
                n4 = point4.x;
            }
            if (point4.y <= n5) continue;
            n5 = point4.y;
        }
        n = 1;
        if (this.bout > 0 || this.isSelected()) {
            n = 4;
        }
        n2 -= n;
        n3 -= n + this.clipYId();
        n4 += n + this.clipXId();
        n5 += n + this.clipYId();
        if (this.bout == 3 && this.hasOneSelected()) {
            rectangle = Ligne.unionRect(rectangle, this.getStatPosition(viewSimple));
        }
        return Ligne.intersectRect(rectangle, n2, n3, n4 - n2 + 1, n5 - n3 + 1);
    }

    protected int clipXId() {
        return 0;
    }

    protected int clipYId() {
        return 0;
    }

    @Override
    public Color getColor() {
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null && this.plan.type == 10) {
            this.couleur = ((PlanField)this.plan).getColor(this);
            if (this.couleur == null) {
                return this.plan.c;
            }
            return this.couleur;
        }
        if (this.plan != null) {
            return this.plan.c;
        }
        return Color.black;
    }

    @Override
    public void setColor(Color color) {
        Ligne ligne = this.getFirstBout();
        while (ligne != null) {
            ligne.couleur = color;
            ligne = ligne.finligne;
        }
    }

    @Override
    protected boolean statCompute(Graphics graphics, ViewSimple viewSimple) {
        Ligne ligne;
        if (this.bout != 3) {
            return false;
        }
        if (viewSimple != null && !viewSimple.isFree() && viewSimple.pref.type == 16) {
            return false;
        }
        if (viewSimple == null || viewSimple.isFree() || !this.hasPhot(viewSimple.pref)) {
            return false;
        }
        boolean bl = viewSimple.pref.type == 16;
        this.statInit();
        boolean bl2 = viewSimple == viewSimple.aladin.view.getCurrentView();
        miny = 2.147483647E9;
        minx = 2.147483647E9;
        maxy = -2.147483648E9;
        maxx = -2.147483648E9;
        double d = 2.147483647E9;
        double d2 = 2.147483647E9;
        double d3 = 2.147483647E9;
        double d4 = 2.147483647E9;
        double d5 = -2.147483648E9;
        double d6 = -2.147483648E9;
        double d7 = -2.147483648E9;
        double d8 = -2.147483648E9;
        Ligne ligne2 = ligne = this.getFirstBout();
        int n = 0;
        while (ligne2.finligne != null) {
            ++n;
            ligne2 = ligne2.finligne;
        }
        Segment[] segmentArray = new Segment[n];
        int n2 = 0;
        ligne2 = ligne;
        while (ligne2.finligne != null) {
            int n3 = (int)Math.floor(ligne2.xv[viewSimple.n] - 0.5);
            int n4 = (int)Math.ceil(ligne2.xv[viewSimple.n] - 0.5);
            int n5 = (int)Math.floor(ligne2.yv[viewSimple.n] - 0.5);
            int n6 = (int)Math.ceil(ligne2.yv[viewSimple.n] - 0.5);
            if ((double)n4 > maxx) {
                maxx = n4;
            }
            if ((double)n3 < minx) {
                minx = n3;
            }
            if ((double)n6 > maxy) {
                maxy = n6;
            }
            if ((double)n5 < miny) {
                miny = n5;
            }
            if (ligne2.xv[viewSimple.n] < d2) {
                d2 = ligne2.xv[viewSimple.n];
                d4 = ligne2.raj;
            }
            if (ligne2.xv[viewSimple.n] > d6) {
                d6 = ligne2.xv[viewSimple.n];
                d8 = ligne2.raj;
            }
            if (ligne2.yv[viewSimple.n] < d) {
                d = ligne2.yv[viewSimple.n];
                d3 = ligne2.dej;
            }
            if (ligne2.yv[viewSimple.n] > d5) {
                d5 = ligne2.yv[viewSimple.n];
                d7 = ligne2.dej;
            }
            Ligne ligne3 = ligne2;
            Ligne ligne4 = ligne2.finligne;
            if (ligne2.yv[viewSimple.n] > ligne2.finligne.yv[viewSimple.n]) {
                ligne4 = ligne2;
                ligne3 = ligne2.finligne;
            }
            segmentArray[n2] = bl ? new Segment(ligne3.raj, ligne3.dej, ligne4.raj, ligne4.dej) : new Segment(ligne3.xv[viewSimple.n] - 0.5, ligne3.yv[viewSimple.n] - 0.5, ligne4.xv[viewSimple.n] - 0.5, ligne4.yv[viewSimple.n] - 0.5);
            ligne2 = ligne2.finligne;
            ++n2;
        }
        Arrays.sort(segmentArray, segmentArray[0]);
        Hist.HistItem histItem = null;
        if (bl2) {
            Hist.HistItem histItem2 = histItem = viewSimple.aladin.view.zoomview.hist == null ? null : viewSimple.aladin.view.zoomview.hist.onMouse;
            if (histItem == null) {
                viewSimple.aladin.view.zoomview.initPixelHist();
            } else {
                bl2 = false;
            }
        }
        double d9 = d2 + 2.0 * (d6 - d2) / 3.0;
        double d10 = d + (d5 - d) / 3.0;
        if (bl) {
            PlanBG planBG = (PlanBG)viewSimple.pref;
            double d11 = CDSHealpix.pixRes(CDSHealpix.pow2(planBG.getOrder() + planBG.getTileOrder())) / 3600.0;
            System.out.println("From " + Coord.getUnit(d3) + " to " + Coord.getUnit(d7) + " Delta = " + Coord.getUnit(d11 /= 2.0));
            Coord coord = new Coord((d8 + d4) / 2.0, d3);
            Coord coord2 = new Coord((d8 + d4) / 2.0, d7);
            double d12 = Coord.getDist(coord, coord2);
            int n7 = (int)(d12 / d11);
            System.out.println("Distance entre " + coord + "  et " + coord2 + " => " + Coord.getUnit(d12) + " soit " + n7 + " it\u00e9rations");
            return false;
        }
        int n8 = 0;
        for (double d13 = miny; d13 <= maxy; d13 += 1.0) {
            while (n8 < n && segmentArray[n8].out) {
                ++n8;
            }
            for (n2 = n8; n2 < n; ++n2) {
                segmentArray[n2].init();
            }
            if (posy == -1.0 && (int)d13 == (int)d10) {
                posy = d10;
            }
            for (double d14 = maxx + 1.0; d14 >= minx - 1.0; d14 -= 1.0) {
                int n9 = 0;
                for (n2 = n8; n2 < n; ++n2) {
                    if (!segmentArray[n2].cut(d14, d13)) continue;
                    ++n9;
                }
                if (n9 % 2 == 1) {
                    double d15 = this.statPixel(graphics, (int)d14, (int)d13, viewSimple, histItem);
                    if (bl2) {
                        this.plan.aladin.view.zoomview.addPixelHist(d15);
                    }
                    if (posy == -1.0 || (int)d14 != (int)d9 || posx != -1.0) continue;
                    posx = d9;
                    continue;
                }
                if (posy == -1.0 || posx != -1.0 || n9 <= 0) continue;
                posx = d14 + 1.0;
            }
        }
        minx = d2;
        maxx = d6;
        miny = d;
        d5 = maxy;
        if (bl2) {
            this.plan.aladin.view.zoomview.createPixelHist("Pixels");
        }
        try {
            double d16 = this.plan.proj[viewSimple.n].getPixResAlpha() * this.plan.proj[viewSimple.n].getPixResDelta();
            surface = (double)nombre * d16;
            moyenne = total / (double)nombre;
            variance = carre / (double)nombre - moyenne * moyenne;
            sigma = Math.sqrt(variance);
            if (medianeArrayNb == 10000) {
                mediane = Double.NaN;
            } else {
                Arrays.sort(medianeArray, 0, medianeArrayNb);
                mediane = medianeArray[medianeArrayNb / 2];
            }
            this.setWithStat(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean hasSurface() {
        return this.bout == 3;
    }

    @Override
    public double[] getStatistics(Plan plan) throws Exception {
        Ligne ligne;
        Projection projection = plan.projd;
        if (!plan.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(plan)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(projection)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        if (this.getLastBout().bout != 3) {
            throw new Exception("getStats error: it is not a polygon");
        }
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        Ligne ligne2 = ligne = this.getFirstBout();
        int n = 0;
        while (ligne2.finligne != null) {
            ++n;
            ligne2 = ligne2.finligne;
        }
        Segment[] segmentArray = new Segment[n];
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        ligne2 = ligne;
        while (ligne2.finligne != null) {
            coord.al = ligne2.raj;
            coord.del = ligne2.dej;
            projection.getXY(coord);
            coord2.al = ligne2.finligne.raj;
            coord2.del = ligne2.finligne.dej;
            projection.getXY(coord2);
            int n7 = (int)Math.floor(coord.x - 0.5);
            int n8 = (int)Math.ceil(coord.x - 0.5);
            int n9 = (int)Math.floor(coord.y - 0.5);
            int n10 = (int)Math.ceil(coord.y - 0.5);
            if (n8 > n5) {
                n5 = n8;
            }
            if (n7 < n3) {
                n3 = n7;
            }
            if (n10 > n4) {
                n4 = n10;
            }
            if (n9 < n2) {
                n2 = n9;
            }
            segmentArray[n6] = coord.y > coord2.y ? new Segment(coord2.x - 0.5, coord2.y - 0.5, coord.x - 0.5, coord.y - 0.5) : new Segment(coord.x - 0.5, coord.y - 0.5, coord2.x - 0.5, coord2.y - 0.5);
            ligne2 = ligne2.finligne;
            ++n6;
        }
        Arrays.sort(segmentArray, segmentArray[0]);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n11 = 0;
        for (int i = n2; i <= n4; ++i) {
            while (n11 < n && segmentArray[n11].out) {
                ++n11;
            }
            for (n6 = n11; n6 < n; ++n6) {
                segmentArray[n6].init();
            }
            for (int j = n5 + 1; j >= n3 - 1; --j) {
                double d4;
                int n12 = 0;
                for (n6 = n11; n6 < n; ++n6) {
                    if (!segmentArray[n6].cut(j, i)) continue;
                    ++n12;
                }
                if (n12 % 2 != 1 || Double.isNaN(d4 = ((PlanImage)plan).getPixelInDouble(j, i))) continue;
                d += 1.0;
                d3 += d4;
                d2 += d4 * d4;
            }
        }
        double d5 = projection.getPixResAlpha() * projection.getPixResDelta();
        double d6 = d * d5;
        double d7 = d3 / d;
        double d8 = d2 / d - d7 * d7;
        double d9 = Math.sqrt(d8);
        return new double[]{d, d3, d9, d6};
    }

    protected void drawID(Graphics graphics, ViewSimple viewSimple, Point point, Point point2) {
    }

    protected Ligne getLastBout() {
        Ligne ligne = this;
        while (ligne.finligne != null) {
            ligne = ligne.finligne;
        }
        return ligne;
    }

    protected Ligne getFirstBout() {
        Ligne ligne = this;
        while (ligne.debligne != null) {
            ligne = ligne.debligne;
        }
        return ligne;
    }

    protected boolean hasOneSelected() {
        if (this.isSelected()) {
            return true;
        }
        Ligne ligne = this.getFirstBout();
        while (ligne.finligne != null && !ligne.isSelected()) {
            ligne = ligne.finligne;
        }
        return ligne.isSelected();
    }

    @Override
    protected void statDraw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        super.statDraw(graphics, viewSimple, n, n2);
        this.getFirstBout().id = this.id;
    }

    protected boolean tooLarge(ViewSimple viewSimple, Point point, Point point2) {
        Projection projection = viewSimple.getProj();
        if (projection == null || projection.t == 1) {
            return false;
        }
        if (!viewSimple.isAllSky()) {
            return false;
        }
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3 / (double)viewSimple.rv.width > 0.5;
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        if (!this.hidden) {
            Point point;
            graphics.setColor(this.getColor());
            if (this.debligne != null) {
                point = this.getViewCoord(viewSimple);
                Point point2 = this.debligne.getViewCoord(viewSimple);
                if (point == null || point2 == null) {
                    return false;
                }
                point2.x += n;
                point2.y += n2;
                point.x += n;
                point.y += n2;
                if (this.tooLarge(viewSimple, point2, point)) {
                    return false;
                }
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                if (this.bout == 3 && this.hasPhot(viewSimple.pref)) {
                    this.fillPolygon(graphics, viewSimple, n, n2);
                    if (this.hasOneSelected()) {
                        this.statDraw(graphics, viewSimple, n, n2);
                    }
                }
                this.drawID(graphics, viewSimple, point2, point);
                if (this.bout == 1 || this.bout == 2) {
                    double d;
                    if (point2.x != point.x) {
                        d = Math.atan((double)(point.y - point2.y) / (double)(point.x - point2.x));
                        if (point2.x > point.x) {
                            d += Math.PI;
                        }
                    } else {
                        d = point2.y < point.y ? 1.5707963267948966 : -1.5707963267948966;
                    }
                    double d2 = 2.356194490192345;
                    int n3 = (int)(7.0 * FastMath.cos(d + d2));
                    int n4 = (int)(7.0 * FastMath.sin(d + d2));
                    int n5 = (int)(7.0 * FastMath.cos(d - d2));
                    int n6 = (int)(7.0 * FastMath.sin(d - d2));
                    graphics.drawLine(point.x + n3, point.y + n4, point.x, point.y);
                    graphics.drawLine(point.x, point.y, point.x + n5, point.y + n6);
                    if (this.bout == 2) {
                        graphics.drawLine(point2.x - n3, point2.y - n4, point2.x, point2.y);
                        graphics.drawLine(point2.x, point2.y, point2.x - n5, point2.y - n6);
                    }
                }
            } else {
                point = this.getViewCoord(viewSimple, 0, 0);
                if (point == null) {
                    return false;
                }
                point.x += n;
                point.y += n2;
                if (this.bout == 4) {
                    Util.fillCircle5(graphics, point.x, point.y);
                }
            }
            if (this.isSelected()) {
                if (this.plan != null && this.plan.type == 10) {
                    return true;
                }
                int n7 = 2;
                graphics.setColor(Color.green);
                graphics.fillRect(point.x - n7 + 1, point.y - n7 + 1, 3, 3);
                graphics.setColor(Color.black);
                graphics.drawRect(point.x - n7, point.y - n7, 4, 4);
            }
        }
        return true;
    }

    @Override
    public Iterator<Obj> iterator() {
        return new ObjetIterator();
    }

    class ObjetIterator
    implements Iterator<Obj> {
        private Ligne line;

        ObjetIterator() {
            this.line = Ligne.this.getFirstBout();
        }

        @Override
        public boolean hasNext() {
            return this.line.finligne != null && this.line.bout != 3;
        }

        @Override
        public Obj next() {
            this.line = this.line.finligne;
            return this.line;
        }

        @Override
        public void remove() {
        }
    }

    class Segment
    implements Comparator {
        double x1;
        double y1;
        double x2;
        double y2;
        double dx;
        double dy;
        double dxb;
        double d;
        boolean cut;
        boolean out;

        Segment(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
            this.out = false;
            this.dx = this.x2 - this.x1;
            this.dy = this.y2 - this.y1;
            this.dxb = this.dx * this.y1 - this.dy * this.x1;
        }

        void init() {
            this.d = Double.NaN;
            this.cut = false;
        }

        boolean cut(double d, double d2) {
            if (this.out) {
                return false;
            }
            if (d2 < this.y1) {
                return false;
            }
            if (d2 >= this.y2) {
                this.out = true;
                return false;
            }
            if (this.cut) {
                return true;
            }
            double d3 = d2 * this.dx - d * this.dy - this.dxb;
            if (Double.isNaN(this.d)) {
                this.d = d3;
            } else {
                this.cut = this.d < 0.0 && d3 >= 0.0 || this.d >= 0.0 && d3 < 0.0;
            }
            d3 = this.d;
            return this.cut;
        }

        public int compare(Object object, Object object2) {
            Segment segment = (Segment)object;
            Segment segment2 = (Segment)object2;
            return segment.y1 == segment2.y1 ? 0 : (segment.y1 < segment2.y1 ? -1 : 1);
        }
    }
}

