/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.MyBox;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.Ecliptic;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Supergal;
import cds.tools.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComboBox;

public class Localisation
extends MyBox {
    public static final int ICRS = 0;
    public static final int ICRSD = 1;
    public static final int ECLIPTIC = 2;
    public static final int GAL = 3;
    public static final int SGAL = 4;
    public static final int J2000 = 5;
    public static final int J2000D = 6;
    public static final int B1950 = 7;
    public static final int B1950D = 8;
    public static final int B1900 = 9;
    public static final int B1875 = 10;
    public static final int XY = 11;
    public static final int XYNAT = 12;
    public static final int XYLINEAR = 13;
    public static final int PLANET = 14;
    public static final int PLANETD = 15;
    static final String[] REPERE = new String[]{"ICRS", "ICRSd", "Ecliptic", "Gal", "SGal", "J2000", "J2000d", "B1950", "B1950d", "B1900", "B1875", "XY Fits", "XY image", "XY linear", "Planet", "Planet deg"};
    static final String[] RADECSYS = new String[]{"ICRS", "ICRS", null, null, null, "FK5", "FK5", "FK4", "FK4", "FK4", "FK4", null, null, null, null, null};
    static final String[] CTYPE1 = new String[]{"RA---", "RA---", "ELON-", "GLON-", "SLON-", "RA---", "RA---", "RA---", "RA---", "RA---", "RA---", null, null, "SOLAR", null, null};
    static final String[] CTYPE2 = new String[]{"DEC--", "DEC--", "ELAT-", "GLAT-", "SLAT-", "DEC--", "DEC--", "DEC--", "DEC--", "DEC--", "DEC--", null, null, "SOLAR", null, null};
    static final String[] FRAME = new String[]{"Default", REPERE[0], REPERE[2], REPERE[3], REPERE[4]};
    static final String[] FRAMEBIS = new String[]{"Equatorial", "Galactic", "Ecliptic", "SuperGal"};
    static final int[] FRAMEBISVAL = new int[]{Calib.FK5, Calib.GALACTIC, Calib.ECLIPTIC, Calib.SUPERGALACTIC};
    static final int[] FRAMEVAL = new int[]{0, 3, 2, 4};
    static final String NOREDUCTION = "No astrometrical reduction";
    static final String NOHPX = "No HEALPix map";
    static final String NOPROJECTION = "No proj => select " + REPERE[13];
    static final String NOXYLINEAR = "No XY linear trans.";
    protected static String POSITION;
    protected static String YOUROBJ;
    private int previousFrame = -1;
    Astrocoo afs = new Astrocoo(AF_ICRS);
    boolean first = true;
    int posHist = -1;
    private String lastEditingCmd = null;
    private boolean flagReadyToClear = false;
    private boolean flagStopInfo = false;
    private int frame = 0;
    private Coord coo = new Coord();
    private String lastPosition = "";
    static final Astroframe AF_FK4;
    static final Astroframe AF_FK5;
    static final Astroframe AF_GAL;
    static final Astroframe AF_SGAL;
    static final Astroframe AF_ICRS;
    static final Astroframe AF_ECLI;
    static final Astroframe AF_FK4_1900;
    static final Astroframe AF_FK4_1875;

    static JComboBox createFrameCombo() {
        return new JComboBox<String>(FRAME);
    }

    static JComboBox createFrameComboBis() {
        return new JComboBox<String>(FRAMEBIS);
    }

    static int getFrameComboBisValue(String string) {
        int n = Util.indexInArrayOf(string, FRAMEBIS, true);
        if (n < 0) {
            return 0;
        }
        return FRAMEBISVAL[n];
    }

    static int getFrameComboValue(String string) {
        int n = Util.indexInArrayOf(string, FRAMEBIS, true);
        if (n < 0) {
            return 0;
        }
        return FRAMEVAL[n];
    }

    static final boolean isSameFrame(int n, int n2) {
        if (n == 1 || n == 6 || n == 8) {
            --n;
        }
        if (n2 == 1 || n2 == 6 || n2 == 8) {
            --n2;
        }
        return n == n2;
    }

    protected Localisation() {
    }

    protected Localisation(Aladin aladin) {
        super(aladin, Aladin.chaine.getString("POSITION"));
        String string = Aladin.chaine.getString("TIPPOS");
        Util.toolTip(this.pos, string);
        Util.toolTip(this.label, string);
        Util.toolTip(this.text, Aladin.chaine.getString("TIPCMD"));
        Util.toolTip(this.c, Aladin.chaine.getString("TIPPOSCHOICE"));
        POSITION = Aladin.chaine.getString("POSITION");
        YOUROBJ = Aladin.chaine.getString("YOUROBJ");
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Localisation.this.clearIfRequired();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Localisation.this.clearIfRequired();
                if (keyEvent.getKeyCode() == 10) {
                    Localisation.this.submit();
                }
            }
        });
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Localisation.this.flagReadyToClear = false;
                Localisation.this.setMode(0);
            }
        });
        this.pos.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Localisation.this.setMode(0);
            }
        });
        this.text.requestFocusInWindow();
    }

    @Override
    protected void setTextSaisie(String string) {
        this.first = true;
        super.setTextSaisie(string);
        this.text.select(0, this.text.getText().length());
    }

    @Override
    protected void sendKey(KeyEvent keyEvent) {
        String string;
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (keyEvent.isControlDown() || keyEvent.isAltDown()) {
            return;
        }
        this.clearIfRequired();
        StringBuffer stringBuffer = new StringBuffer(this.text.getText());
        if (n == 10) {
            string = this.shortCutLoad(stringBuffer.toString());
            this.aladin.execAsyncCommand(string);
            this.first = true;
        } else if (n == 8 || n == 127) {
            this.first = false;
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        } else if (n == 38 || n == 40 || n == 34) {
            string = this.browseHistory(n == 34 ? 2 : (n == 38 ? -1 : 1));
            if (string != null) {
                stringBuffer = new StringBuffer(string);
            }
        } else {
            this.posHist = -1;
            if (this.first) {
                stringBuffer.delete(0, stringBuffer.length());
                this.first = false;
            }
            if (c >= '\u001f' && c <= '\u00ff' || c == '@') {
                stringBuffer.append(c);
            }
        }
        this.setMode(0);
        string = stringBuffer.toString();
        if (string.startsWith(this.aladin.GETOBJ)) {
            string = string.substring(this.aladin.GETOBJ.length());
        }
        super.setTextSaisie(string);
    }

    protected String browseHistory(int n) {
        String string;
        boolean bl = false;
        if (this.aladin.console.getIndexArrowHistory() == -1) {
            this.lastEditingCmd = this.text.getText();
            bl = true;
        }
        if ((string = this.aladin.console.getNextArrowHistory(n)) != null && bl && this.lastEditingCmd.equals(string)) {
            string = this.aladin.console.getNextArrowHistory(n);
        }
        if (string == null) {
            string = this.lastEditingCmd;
            this.lastEditingCmd = null;
        }
        if (string == null) {
            return null;
        }
        this.first = false;
        return string;
    }

    protected void clearIfRequired() {
        this.flagStopInfo = true;
        if (!this.flagReadyToClear) {
            return;
        }
        this.flagReadyToClear = false;
        this.text.setText("");
    }

    @Override
    protected void readyToClear() {
        this.flagReadyToClear = true;
    }

    @Override
    protected void setMode(int n) {
        ViewSimple viewSimple;
        super.setMode(n);
        if (n != 0 && (viewSimple = this.aladin.view.getCurrentView()) != null && !viewSimple.hasFocus()) {
            viewSimple.requestFocusInWindow();
        }
    }

    protected void focus(String string) {
        this.focus(string, null);
    }

    protected void focus(String string, final String string2) {
        this.setMode(0);
        this.text.setText(string);
        new Thread(){
            Color def;
            Color deff;
            {
                this.def = Localisation.this.text.getBackground();
                this.deff = Localisation.this.text.getForeground();
            }

            @Override
            public void run() {
                for (int i = 0; i < 2; ++i) {
                    Localisation.this.text.setBackground(Color.green);
                    Localisation.this.text.setForeground(Color.black);
                    Util.pause(1000);
                    Localisation.this.text.setBackground(this.def);
                    Localisation.this.text.setForeground(this.deff);
                    Util.pause(100);
                }
                if (string2 == null) {
                    Localisation.this.text.setText("");
                    Localisation.this.text.requestFocusInWindow();
                } else {
                    Localisation.this.text.setText(string2);
                    Localisation.this.setInitialFocus();
                }
            }
        }.start();
    }

    protected void setInitialFocus() {
        this.setMode(0);
        this.text.requestFocusInWindow();
        this.text.setCaretPosition(this.text.getText().length());
    }

    private void myPause(int n) {
        long l = System.currentTimeMillis();
        while (!this.flagStopInfo && System.currentTimeMillis() - l < (long)n) {
            Util.pause(20);
        }
    }

    protected void infoStart() {
        if (!this.aladin.calque.isFree() || this.text.getText().length() > 0 || this.aladin.dialog == null || this.aladin.dialog.isVisible()) {
            return;
        }
        this.setMode(0);
        final String string = this.aladin.GETOBJ;
        this.text.setText(string);
        this.text.setFont(this.text.getFont().deriveFont(2));
        new Thread(){
            Color def;
            Color deff;
            {
                this.def = Localisation.this.text.getBackground();
                this.deff = Localisation.this.text.getForeground();
            }

            @Override
            public void run() {
                Localisation.this.flagReadyToClear = true;
                Localisation.this.text.setBackground(Color.white);
                for (int i = 0; i < 3 && Localisation.this.aladin.calque.isFree() && !Localisation.this.flagStopInfo; ++i) {
                    if (!Localisation.this.flagStopInfo) {
                        Localisation.this.text.setText("");
                        Localisation.this.text.setForeground(Color.gray);
                        Localisation.this.myPause(100);
                    }
                    if (Localisation.this.flagStopInfo) continue;
                    Localisation.this.text.setText(string);
                    Localisation.this.myPause(1500);
                }
                if (Localisation.this.flagStopInfo) {
                    Localisation.this.text.setCaretPosition(Localisation.this.text.getText().length());
                    Localisation.this.flagReadyToClear = (Localisation.this.flagStopInfo = false);
                }
                Localisation.this.text.setText("");
                Localisation.this.text.setForeground(this.deff);
                Localisation.this.text.setFont(Localisation.this.text.getFont().deriveFont(1));
                Localisation.this.text.requestFocusInWindow();
            }
        }.start();
    }

    protected JComboBox createSimpleChoice() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = Aladin.BETA ? REPERE.length : REPERE.length - 2;
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem(REPERE[i]);
        }
        return jComboBox;
    }

    @Override
    protected JComboBox createChoice() {
        final JComboBox jComboBox = super.createChoice();
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Localisation.this.setInternalFrame(jComboBox.getSelectedIndex());
            }
        });
        jComboBox.setPrototypeDisplayValue(new Integer(100000));
        jComboBox.setFont(F);
        int n = Aladin.BETA ? REPERE.length : REPERE.length - 2;
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem(REPERE[i]);
        }
        jComboBox.setSelectedIndex(0);
        this.previousFrame = 0;
        jComboBox.setMaximumRowCount(REPERE.length);
        return jComboBox;
    }

    protected boolean setPositionMode(String string) {
        if (string.equalsIgnoreCase("xy")) {
            string = REPERE[11];
        }
        for (int i = 0; i < REPERE.length; ++i) {
            if (!REPERE[i].equalsIgnoreCase(string)) continue;
            this.setFrame(i);
            this.actionChoice();
            return true;
        }
        return false;
    }

    private void setInternalFrame(int n) {
        this.frame = n;
    }

    protected void setFrame(int n) {
        this.frame = n;
        this.setChoiceIndex(n);
    }

    protected String getFrameName() {
        return Localisation.getFrameName(this.frame);
    }

    public static String getFrameName(int n) {
        return n < 0 ? "" : REPERE[n];
    }

    protected int getFrame() {
        return this.frame;
    }

    protected int getFrameGeneric() {
        return this.frame == 3 ? 3 : (this.frame == 2 ? 2 : (this.frame == 4 ? 4 : (this.frame != 11 || this.frame != 12 || this.frame != 13 || this.frame != 14 ? 0 : -1)));
    }

    protected void setSesameResult(String string) {
        this.aladin.localisation.setTextSaisie(string);
        this.aladin.localisation.readyToClear();
    }

    protected void setPos(ViewSimple viewSimple, double d, double d2) {
        this.setPos(viewSimple, d, d2, 0);
    }

    protected void setPos(ViewSimple viewSimple, double d, double d2, int n) {
        this.setPos(viewSimple, d, d2, n, false);
    }

    protected void setPos(ViewSimple viewSimple, double d, double d2, int n, boolean bl) {
        Plan plan;
        int n2 = this.getFrame();
        ViewSimple viewSimple2 = this.aladin.view.getMouseView();
        if (viewSimple2 != null && viewSimple2.isPlotView()) {
            n2 = 13;
        }
        if ((plan = viewSimple.pref) == null) {
            return;
        }
        Projection projection = viewSimple.getProj();
        PointD pointD = viewSimple.getPosition(d, d2);
        String string = null;
        if (n2 == 11 || projection != null && projection.modeCalib == 0) {
            string = plan.isImage() ? Util.myRound("" + (pointD.x + 0.5), 4) + "  " + Util.myRound("" + ((double)((PlanImage)plan).naxis2 - pointD.y + 0.5), 4) : "";
        } else if (n2 == 12 || projection != null && projection.modeCalib == 0) {
            string = plan.isImage() ? Util.myRound("" + pointD.x, 0) + "  " + Util.myRound("" + pointD.y, 0) : "";
        } else if (!Projection.isOk(projection)) {
            string = NOREDUCTION;
        } else {
            this.coo.x = pointD.x;
            this.coo.y = pointD.y;
            projection.getCoord(this.coo);
            if (Double.isNaN(this.coo.al)) {
                string = "";
            } else if (n2 == 14) {
                string = this.coo.getSexaPlanet(projection.sym);
            } else if (n2 == 15) {
                string = this.coo.getDegPlanet(projection.sym);
            } else if (n2 == 13) {
                string = !projection.isXYLinear() ? NOXYLINEAR : Util.myRound(this.coo.al + "", 4) + " : " + Util.myRound(this.coo.del + "", 4);
            } else if (projection.isXYLinear()) {
                string = NOPROJECTION;
            } else {
                double d3 = viewSimple.getTailleRA();
                int n3 = d3 == 0.0 ? 3 : (d3 > 0.001 ? 6 : (d3 > 1.0E-5 ? 7 : 9));
                string = this.J2000ToString(this.coo.al, this.coo.del, n3);
                if (Aladin.PLASTIC_SUPPORT && bl) {
                    this.aladin.getMessagingMgr().pointAtCoords(this.coo.al, this.coo.del);
                }
            }
        }
        String string2 = this.lastPosition = string == NOREDUCTION ? "" : string;
        if (n == 1) {
            this.setTextSaisie(string);
            this.setMode(0);
        } else {
            this.setTextAffichage(string);
            this.setMode(1);
        }
    }

    protected String getLastPosition() {
        return this.lastPosition;
    }

    protected Coord getLastCoord() {
        return this.coo;
    }

    protected void setLastCoord(double d, double d2) {
        this.coo = new Coord(d, d2);
    }

    protected static Astroframe getAstroframe(int n) {
        return n == 0 || n == 1 ? AF_ICRS : (n == 3 ? AF_GAL : (n == 5 || n == 6 ? AF_FK5 : (n == 7 || n == 8 ? AF_FK4 : (n == 9 ? AF_FK4_1900 : (n == 10 ? AF_FK4_1875 : (n == 2 ? AF_ECLI : (n == 4 ? AF_SGAL : AF_ICRS)))))));
    }

    public static Coord frameToFrame(Coord coord, int n, int n2) {
        if (n == n2) {
            return coord;
        }
        Coo coo = new Coo(coord.al, coord.del);
        if (n != 0 && n != 1) {
            Localisation.getAstroframe(n).toICRS(coo);
        }
        if (n2 != 0 && n2 != 1) {
            Localisation.getAstroframe(n2).fromICRS(coo);
        }
        coord.al = coo.getLon();
        coord.del = coo.getLat();
        return coord;
    }

    protected Coord ICRSToFrame(Coord coord) {
        if (this.frame == 0 || this.frame == 1) {
            return coord;
        }
        return Localisation.frameToFrame(coord, 0, this.frame);
    }

    protected Coord frameToICRS(Coord coord) {
        if (this.frame == 0 || this.frame == 1) {
            return coord;
        }
        return Localisation.frameToFrame(coord, this.frame, 0);
    }

    protected String getICRSCoord(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Localisation.convert(string, this.frame, 0);
    }

    protected String getFrameCoord(String string) {
        return Localisation.convert(string, 0, this.frame);
    }

    protected static String convert(String string, int n, int n2) {
        if (string == null || string.length() == 0 || string.indexOf("--") >= 0) {
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            return string;
        }
        try {
            String string2;
            Astrocoo astrocoo = new Astrocoo(Localisation.getAstroframe(n));
            astrocoo.setPrecision(11);
            astrocoo.set(string);
            if (n != n2) {
                astrocoo.convertTo(Localisation.getAstroframe(n2));
            }
            String string3 = string2 = n2 == 6 || n2 == 8 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 ? astrocoo.toString("2d") : astrocoo.toString("2s");
            if (string2.indexOf("--") >= 0) {
                return "";
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String J2000ToString(double d, double d2) {
        return this.J2000ToString(d, d2, 6);
    }

    protected String J2000ToString(double d, double d2, int n) {
        Coord coord = new Coord(d, d2);
        coord = this.ICRSToFrame(coord);
        this.afs.setPrecision(n);
        return this.frameToString(coord.al, coord.del, n);
    }

    protected String frameToString(double d, double d2) {
        return this.frameToString(d, d2, 6);
    }

    protected String frameToString(double d, double d2, int n) {
        int n2 = this.getFrame();
        this.afs.setPrecision(n);
        this.afs.set(d, d2);
        try {
            return n2 == 6 || n2 == 8 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 ? this.afs.toString("2d") : this.afs.toString("2:");
        }
        catch (Exception exception) {
            System.err.println(exception);
            return "";
        }
    }

    protected String getGridLabel(double d, double d2, int n, boolean bl) {
        int n2 = this.getFrame();
        if (n2 == 14 || n2 == 15) {
            String string = n2 == 15 ? new Coord(d, d2).getDegPlanet(bl) : new Coord(d, d2).getSexaPlanet(bl);
            if (string.length() == 0) {
                return "";
            }
            int n3 = string.indexOf(44);
            return this.zeroSec(n == 1 ? string.substring(0, n3) : string.substring(n3 + 2));
        }
        String string = this.frameToString(d, d2);
        if (string.length() == 0) {
            return "";
        }
        int n4 = string.indexOf(32);
        return this.zeroSec(n == 0 ? string.substring(0, n4) : string.substring(n4 + 1));
    }

    private String zeroSec(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char c = string.charAt(n - 1);
        if (c != 'N' && c != 'S' && c != 'E' && c != 'W') {
            return this.zeroSec1(string);
        }
        return this.zeroSec1(string.substring(0, n - 2)) + string.substring(n - 2);
    }

    private String zeroSec1(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = cArray.length - 1; i > 0 && (cArray[i] < '1' || cArray[i] > '9'); --i) {
            if (cArray[i] == '.') {
                n = i;
                continue;
            }
            if (cArray[i] == '0') {
                n2 = i;
                continue;
            }
            if (cArray[i] == ':') {
                return string.substring(0, i);
            }
            if (cArray[i] != '\'') continue;
            return string.substring(0, i + 1);
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        if (n2 > 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    protected void seeCoord(Position position) {
        this.seeCoord(position, 0);
    }

    protected void seeCoord(Position position, int n) {
        String string = this.getLocalisation(position);
        if (string == null) {
            return;
        }
        if (n == 0) {
            this.setTextAffichage(string);
            this.setMode(1);
        } else {
            this.setTextSaisie(string);
            this.setMode(0);
            this.aladin.console.printInPad(string + "\n");
        }
    }

    protected String getLocalisation(Obj obj) {
        String string = "";
        int n = this.getFrame();
        switch (n) {
            case 11: {
                ViewSimple viewSimple = this.aladin.view.getCurrentView();
                Projection projection = viewSimple.getProj();
                Coord coord = new Coord(obj.getRa(), obj.getDec());
                projection.getXY(coord);
                double d = coord.x;
                double d2 = coord.y;
                Plan plan = viewSimple.pref;
                if (plan.isImage()) {
                    string = Util.myRound("" + (d + 0.5), 2) + " " + Util.myRound("" + ((double)((PlanImage)plan).naxis2 - (d2 - 0.5)), 2);
                    break;
                }
                string = null;
                break;
            }
            default: {
                string = string + this.J2000ToString(obj.getRa(), obj.getDec());
            }
        }
        return string;
    }

    private boolean isFile(String string) {
        File file = new File(this.aladin.getFullFileName(string));
        return file.canRead();
    }

    private String shortCutLoad(String string) {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://") || string.startsWith("file://") || this.isFile(string)) {
            string = "load " + string;
            this.setTextSaisie(string);
        }
        return string;
    }

    private void submit() {
        String string = this.getTextSaisie();
        if (string.length() > 0) {
            string = this.shortCutLoad(string);
            this.aladin.console.pushCmd(string);
        }
        this.readyToClear();
    }

    @Override
    protected void actionChoice() {
        block3: {
            if (this.text == null) {
                return;
            }
            try {
                this.aladin.calque.resumeFrame();
                this.previousFrame = this.getFrame();
                this.setTextSaisie(Localisation.convert(this.getTextSaisie(), this.previousFrame, this.getFrame()));
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.out.println("keyPressed : " + keyEvent);
    }

    static {
        AF_FK4 = new FK4();
        AF_FK5 = new FK5();
        AF_GAL = new Galactic();
        AF_SGAL = new Supergal();
        AF_ICRS = new ICRS();
        AF_ECLI = new Ecliptic();
        AF_FK4_1900 = new FK4(1900.0);
        AF_FK4_1875 = new FK4(1875.0);
    }
}

