/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMacro;
import cds.aladin.MacroModel;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Source;
import cds.tools.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;

public class MacroController
implements ActionListener,
MouseMotionListener,
MouseListener {
    private MacroModel macroModel;
    private FrameMacro frameMacro;
    private Aladin a;
    private Thread execThread;
    private boolean stopThread = false;
    private JFileChooser fChooser;

    public MacroController(FrameMacro frameMacro, Aladin aladin) {
        this.frameMacro = frameMacro;
        this.a = aladin;
        this.macroModel = new MacroModel(aladin);
    }

    private String getScriptFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + string + "\n";
        }
        bufferedReader.close();
        return string2;
    }

    private void loadParams(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            Vector<Object> vector = new Vector<Object>();
            if (string.trim().startsWith("#") || string.trim().length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t,|");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextElement());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.macroModel.getParamTableModel().addRecord((String[])objectArray);
        }
        bufferedReader.close();
        this.macroModel.getParamTableModel().initTable();
    }

    private void importParams() {
        Plan plan;
        Object object;
        MacroModel.ParamTableModel paramTableModel = this.macroModel.getParamTableModel();
        Vector<Object> vector = this.a.calque.getSelectedPlanes();
        if (vector != null && vector.size() > 0) {
            object = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                plan = (Plan)vector.get(i);
                if (!plan.isReady() || !plan.isSimpleCatalog()) continue;
                ((Vector)object).add(plan);
            }
            vector = object;
        }
        if ((vector == null || vector.size() == 0) && (object = this.a.calque.getFirstCatalog()) != null) {
            vector = new Vector<Object>();
            vector.add(object);
        }
        if (vector.size() == 0) {
            Aladin.warning(this.frameMacro, Aladin.chaine.getString("NEEDCAT"));
        }
        paramTableModel.reset();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            plan = (Plan)enumeration.nextElement();
            if (!plan.isReady() || !plan.isCatalog()) continue;
            Iterator<Obj> iterator = plan.iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                Source source = (Source)obj;
                paramTableModel.addRecord(new String[]{++n + "", source.id, this.a.localisation.J2000ToString(source.raj, source.dej), source.plan.label});
            }
        }
        paramTableModel.initTable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(FrameMacro.LOAD_SCRIPT)) {
            File file;
            JFileChooser jFileChooser = this.getJFileChooser(FrameMacro.LOAD_SCRIPT);
            int n = jFileChooser.showDialog(this.frameMacro, string);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                String string2 = "";
                try {
                    string2 = this.getScriptFromReader(new BufferedReader(new FileReader(file)));
                }
                catch (IOException iOException) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + iOException, 1);
                    return;
                }
                this.frameMacro.setScript(string2);
            }
        } else if (string.equals(FrameMacro.SAVE_SCRIPT)) {
            File file;
            JFileChooser jFileChooser = this.getJFileChooser(FrameMacro.SAVE_SCRIPT);
            int n = jFileChooser.showDialog(this.frameMacro, string);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    String string3 = this.frameMacro.getScriptText();
                    if (!string3.startsWith("#AJS")) {
                        dataOutputStream.writeBytes("#AJS" + Util.CR);
                    }
                    dataOutputStream.writeBytes(string3.replaceAll("\\n", Util.CR));
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + iOException);
                }
            }
        } else if (string.equals(FrameMacro.LOAD_PARAMS)) {
            File file;
            JFileChooser jFileChooser = this.getJFileChooser(FrameMacro.LOAD_PARAMS);
            int n = jFileChooser.showDialog(this.frameMacro, string);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.macroModel.getParamTableModel().reset();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    this.loadParams(bufferedReader);
                }
                catch (IOException iOException) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + iOException, 1);
                    return;
                }
            }
        } else if (string.equals(FrameMacro.IMPORT_PARAMS)) {
            this.importParams();
        } else if (string.equals(FrameMacro.SAVE_PARAMS)) {
            File file;
            JFileChooser jFileChooser = this.getJFileChooser(FrameMacro.SAVE_PARAMS);
            int n = jFileChooser.showDialog(this.frameMacro, string);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    MacroModel.ParamRecord[] paramRecordArray = this.macroModel.getParamTableModel().getRecords();
                    for (int i = 0; i < paramRecordArray.length; ++i) {
                        String string4 = ((Object)paramRecordArray[i]).toString();
                        if (string4.trim().length() <= 0) continue;
                        dataOutputStream.writeBytes(((Object)paramRecordArray[i]).toString());
                        if (i >= paramRecordArray.length - 1) continue;
                        dataOutputStream.writeBytes(Util.CR);
                    }
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + iOException);
                }
            }
        } else if (string.equals(FrameMacro.SEEHELP)) {
            this.frameMacro.showHelp();
        } else if (string.equals(FrameMacro.LOADEX)) {
            this.frameMacro.setScript(Aladin.chaine.getString("FMSCRIPTEX"));
            this.macroModel.getParamTableModel().reset();
            try {
                this.loadParams(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(Aladin.chaine.getString("FMPARAMSEX").getBytes()))));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Aladin.warning("Can't load example parameters !");
            }
        } else if (string.equals(FrameMacro.ADD_COL)) {
            this.macroModel.getParamTableModel().addEmptyCol();
        } else if (string.equals(FrameMacro.CLEAR_PARAMS)) {
            this.macroModel.getParamTableModel().reset();
            this.macroModel.getParamTableModel().initTable();
            this.macroModel.getParamTableModel().addEmptyCol();
        } else if (string.equals(FrameMacro.EXEC_CURRENT)) {
            this.execCurrentParams();
        } else if (string.equals(FrameMacro.EXEC_NEXT)) {
            this.execNextParams();
        } else if (string.equals(FrameMacro.EXEC_ALL)) {
            this.execAllParams(0);
        } else if (string.equals(FrameMacro.EXEC_ALL_FROM_CURRENT)) {
            int n = this.frameMacro.getParamTable().getSelectedRow();
            this.execAllParams(n);
        } else if (string.equals(FrameMacro.STOP)) {
            this.stopCurrentExec();
        } else if (string.equals(FrameMacro.DELETE)) {
            this.deleteSelectedRow();
        } else if (string.equals(FrameMacro.CLOSE)) {
            this.frameMacro.setVisible(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
        int n = jTextPane.viewToModel(mouseEvent.getPoint());
        this.frameMacro.testIfColorLink(n);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.frameMacro.testIfColorLink(-1);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JTable && this.frameMacro.getParamTable().getSelectedRow() >= 0 && mouseEvent.isPopupTrigger() && this.frameMacro.getParamTable().getRowCount() > 1) {
            this.frameMacro.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        String string = this.frameMacro.getCmdWordUnderMouse();
        if (string == null) {
            return;
        }
        this.a.command.execHelpCmd(string);
    }

    private void stopCurrentExec() {
        if (this.execThread != null && this.execThread.isAlive()) {
            this.a.command.killSync();
            this.stopThread = true;
            this.frameMacro.setEnabledStopBtn(false);
        }
    }

    private void deleteSelectedRow() {
        int n = this.frameMacro.getParamTable().getSelectedRow();
        if (n < 0) {
            return;
        }
        this.macroModel.getParamTableModel().deleteRecord(n);
    }

    private synchronized void execCurrentParams() {
        if (this.execThread != null && this.execThread.isAlive()) {
            Aladin.warning(this.frameMacro, "Previous execution not finished yet !", 1);
            return;
        }
        this.execThread = new Thread("AladinMacroExeParam"){

            @Override
            public void run() {
                MacroController.this.frameMacro.setEnabledStopBtn(true);
                MacroController.this.stopThread = false;
                MacroController.this.frameMacro.hilightScriptLine(0);
                ((MacroController)MacroController.this).a.command.execHelpCmd("off");
                String[] stringArray = MacroController.this.getScriptCommands();
                Map map = MacroController.this.getParamMapForRow(MacroController.this.frameMacro.getParamTable().getSelectedRow());
                if (map == null) {
                    return;
                }
                MacroController.this.execScript(stringArray, new Map[]{map}, null);
                MacroController.this.frameMacro.hilightScriptLine(-1);
                MacroController.this.frameMacro.setEnabledStopBtn(false);
            }
        };
        this.execThread.start();
        this.a.log("macroController", "execCurrent");
    }

    private synchronized void execNextParams() {
        int n = this.frameMacro.getParamTable().getSelectedRow() + 1;
        if (n >= this.macroModel.getParamTableModel().getRowCount()) {
            Aladin.warning(this.frameMacro, "No next params row to execute, stop execution !", 1);
            return;
        }
        this.frameMacro.getParamTable().setRowSelectionInterval(n, n);
        this.execCurrentParams();
    }

    private synchronized void execAllParams(final int n) {
        if (this.execThread != null && this.execThread.isAlive()) {
            Aladin.warning(this.frameMacro, "Previous execution not finished yet !", 1);
            return;
        }
        if (n == -1) {
            Aladin.warning(this.frameMacro, "No parameter row selected, stop execution !", 1);
            return;
        }
        this.frameMacro.getParamTable().setRowSelectionInterval(n, n);
        this.execThread = new Thread("AladinMacroExe"){

            @Override
            public void run() {
                MacroController.this.frameMacro.setEnabledStopBtn(true);
                MacroController.this.stopThread = false;
                MacroController.this.frameMacro.hilightScriptLine(0);
                ((MacroController)MacroController.this).a.command.execHelpCmd("off");
                String[] stringArray = MacroController.this.getScriptCommands();
                Map[] mapArray = new Map[MacroController.this.macroModel.getParamTableModel().getRowCount() - n];
                for (int i = 0; i < mapArray.length; ++i) {
                    mapArray[i] = MacroController.this.getParamMapForRow(i + n);
                }
                int[] nArray = new int[mapArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i + n;
                }
                MacroController.this.execScript(stringArray, mapArray, nArray);
                MacroController.this.frameMacro.hilightScriptLine(-1);
                MacroController.this.frameMacro.setEnabledStopBtn(false);
            }
        };
        this.execThread.start();
        this.a.log("macroController", "execAll");
    }

    private void execScript(String[] stringArray, Map[] mapArray, int[] nArray) {
        for (int i = 0; i < mapArray.length; ++i) {
            if (nArray != null && nArray[i] < this.macroModel.getParamTableModel().getRowCount()) {
                this.frameMacro.getParamTable().setRowSelectionInterval(nArray[i], nArray[i]);
            }
            if (mapArray[i] == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (this.stopThread) {
                    this.stopThread = false;
                    this.frameMacro.hilightScriptLine(-1);
                    Aladin.warning(this.frameMacro, "Execution interrupted !", 1);
                    return;
                }
                this.frameMacro.hilightScriptLine(j);
                this.macroModel.executeScript(stringArray[j], mapArray[i]);
            }
        }
    }

    private Map getParamMapForRow(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = this.macroModel.getParamTableModel().getColumnCount();
        if (n == -1) {
            Aladin.warning(this.frameMacro, "No parameter row selected, stop execution !", 1);
            return null;
        }
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            String string = this.macroModel.getParamTableModel().getColumnName(i);
            String string2 = (String)this.macroModel.getParamTableModel().getValueAt(n, i);
            if (bl && string2 != null && string2.trim().length() > 0) {
                bl = false;
            }
            hashMap.put(string, string2);
        }
        return bl ? null : hashMap;
    }

    private String[] getScriptCommands() {
        String string = this.frameMacro.getScriptText();
        String string2 = "\n";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<String> vector = new Vector<String>();
        String string3 = string2;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string2.equals(string4)) {
                if (!string2.equals(string3)) {
                    string3 = string4;
                    continue;
                }
                string3 = string4;
                string4 = "";
            } else {
                string3 = string4;
            }
            vector.addElement(string4);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    private JFileChooser getJFileChooser(String string) {
        if (this.fChooser == null) {
            this.fChooser = new JFileChooser(this.a.getDefaultDirectory());
        }
        if (string.equals(FrameMacro.LOAD_SCRIPT)) {
            this.fChooser.setDialogType(0);
            this.fChooser.setFileSelectionMode(0);
            this.fChooser.resetChoosableFileFilters();
            this.fChooser.addChoosableFileFilter(new FileNameExtensionFilter(new String[]{"ajs", "txt"}, "Aladin script files (*.ajs, *.txt)"));
            this.fChooser.setFileFilter(this.fChooser.getAcceptAllFileFilter());
        } else if (string.equals(FrameMacro.LOAD_PARAMS)) {
            this.fChooser.setDialogType(0);
            this.fChooser.setFileSelectionMode(0);
            this.fChooser.resetChoosableFileFilters();
            this.fChooser.addChoosableFileFilter(new FileNameExtensionFilter(new String[]{"txt", "tsv", "csv"}, "CSV Files (*.txt, *.tsv, *.csv)"));
            this.fChooser.setFileFilter(this.fChooser.getAcceptAllFileFilter());
        } else if (string.equals(FrameMacro.SAVE_SCRIPT) || string.equals(FrameMacro.LOAD_SCRIPT)) {
            this.fChooser.setDialogType(1);
            this.fChooser.resetChoosableFileFilters();
        }
        return this.fChooser;
    }

    protected MacroModel getMacroModel() {
        return this.macroModel;
    }

    protected void setMacroModel(MacroModel macroModel) {
        this.macroModel = macroModel;
    }

    class FileNameExtensionFilter
    extends FileFilter {
        String[] extensions;
        String desc;

        FileNameExtensionFilter(String[] stringArray, String string) {
            this.extensions = stringArray;
            this.desc = string;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            return Util.indexInArrayOf(string, this.extensions) >= 0;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String getExtension(File file) {
            if (file == null) {
                return null;
            }
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

