/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class MacroModel {
    private String script;
    private ParamTableModel paramTableModel;
    private TableCellEditor tableCellEditor;
    private Aladin a;

    public MacroModel(Aladin aladin) {
        this.a = aladin;
        this.paramTableModel = new ParamTableModel(0);
        this.tableCellEditor = new MyCellEditor();
    }

    protected String getScript() {
        return this.script;
    }

    protected void setScript(String string) {
        this.script = string;
    }

    protected void executeScript(String string, Map map) {
        if (string.trim().length() == 0 || string.trim().startsWith("#")) {
            return;
        }
        Set set = map.keySet();
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            string = MetaDataTree.replace(string, string2, (String)map.get(string2), -1);
        }
        this.a.execCommand(string);
    }

    protected ParamTableModel getParamTableModel() {
        return this.paramTableModel;
    }

    protected TableCellEditor getTableCellEditor() {
        return this.tableCellEditor;
    }

    class MyCellEditor
    extends DefaultCellEditor {
        private int row;

        public MyCellEditor() {
            super(new JTextField());
        }

        @Override
        public Object getCellEditorValue() {
            String string = (String)super.getCellEditorValue();
            if (this.row == MacroModel.this.paramTableModel.getRowCount() - 1 && string.length() > 0) {
                MacroModel.this.paramTableModel.addEmptyRecord();
            }
            return string;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        protected String[] columnNames;
        protected Vector dataVector;

        public ParamTableModel(int n) {
            this.initColumnNames(n);
            this.dataVector = new Vector();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == -1 || n == -1) {
                return null;
            }
            ParamRecord paramRecord = (ParamRecord)this.dataVector.get(n);
            return paramRecord.getValue(n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ParamRecord paramRecord = (ParamRecord)this.dataVector.get(n);
            paramRecord.setValue(n2, object.toString());
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public int getRowCount() {
            return this.dataVector.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        private void initColumnNames(int n) {
            this.columnNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.columnNames[i] = "$" + (i + 1);
            }
            this.fireTableStructureChanged();
        }

        public void reset() {
            this.initColumnNames(0);
            this.dataVector = new Vector();
        }

        public void addRecord(ParamRecord paramRecord) {
            if (paramRecord == null) {
                paramRecord = new ParamRecord();
                paramRecord.setValues(new String[this.getColumnCount()]);
            }
            if (paramRecord.values != null && paramRecord.values.length > this.getColumnCount()) {
                this.initColumnNames(paramRecord.values.length);
            }
            this.dataVector.addElement(paramRecord);
            this.fireTableRowsInserted(this.dataVector.size() - 1, this.dataVector.size() - 1);
        }

        public void addRecord(String[] stringArray) {
            ParamRecord paramRecord = new ParamRecord();
            paramRecord.setValues(stringArray);
            this.addRecord(paramRecord);
        }

        public void initTable() {
            this.addEmptyRecord();
        }

        public ParamRecord[] getRecords() {
            Object[] objectArray = new ParamRecord[this.dataVector.size()];
            this.dataVector.copyInto(objectArray);
            return objectArray;
        }

        public void addEmptyRecord() {
            this.addRecord((ParamRecord)null);
        }

        public void addEmptyCol() {
            int n = this.getColumnCount();
            this.initColumnNames(n + 1);
        }

        public void deleteRecord(int n) {
            if (n < 0 || n > this.getRowCount() - 1) {
                return;
            }
            this.dataVector.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    class ParamRecord {
        String[] values;

        ParamRecord() {
        }

        void setValues(String[] stringArray) {
            this.values = stringArray;
        }

        String[] getValues() {
            return this.values;
        }

        String getValue(int n) {
            if (this.values == null || n >= this.values.length) {
                return "";
            }
            return this.values[n];
        }

        void setValue(int n, String string) {
            if (n >= this.values.length) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.values, 0, stringArray, 0, this.values.length);
                this.values = stringArray;
            }
            this.values[n] = string;
        }

        public String toString() {
            if (this.values == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) {
                    stringBuffer.append(this.values[i]);
                }
                if (i >= this.values.length - 1) continue;
                stringBuffer.append("\t");
            }
            return stringBuffer.toString();
        }

        boolean isEmpty() {
            if (this.values == null) {
                return true;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null || this.values[i].length() <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

