/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.BasicNode;
import cds.aladin.BasicTree;
import cds.aladin.Coord;
import cds.aladin.Fov;
import cds.aladin.FrameInfo;
import cds.aladin.MyInputStream;
import cds.aladin.MyListener;
import cds.aladin.Plan;
import cds.aladin.PlanFov;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.aladin.ServerAladin;
import cds.aladin.ServerDialog;
import cds.aladin.ServerFile;
import cds.aladin.Slider;
import cds.aladin.SwingWidgetFinder;
import cds.aladin.TreeView;
import cds.aladin.View;
import cds.aladin.Words;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MetaDataTree
extends BasicTree
implements SwingWidgetFinder,
KeyListener {
    static final String OPENWITHALADIN = "Aladin";
    static String NOLOC;
    static String NOIMG;
    static String IMAGE;
    static String NOSPEC;
    static String NOSPEC1;
    static String BADURL;
    static String ERRSPEC;
    static String OPENWITH;
    static String PLASTICAPPS;
    protected static final Color[] LABEL_COL;
    protected static Color[] LABEL_COL1;
    protected static Color[] LABEL_COL2;
    protected static Color[] LABEL_COL3;
    protected static Color[] LABEL_COL4;
    private boolean colorLabel = false;
    private static final String NOIMAGE_WARNING = "can not be loaded : \nno cutout available at this position !\nClick on the region you are interested in\nAvailable images will be marked with a red tick";
    private static final String SORTBY = "Sort by ...";
    private boolean enableKdShortcut = true;
    MyListener stateChangerLstr;
    private boolean fullExpandAtStart = true;
    private static SortableColumn[] columns;
    int indexSort = -1;
    boolean descSort = true;
    SortFrame sortFrame;
    static boolean firstShow;
    private int defaultIndexSort = 4;
    private boolean defaultDescSort = true;
    private boolean sortable = false;
    static String[] sortName;
    int[][] colBounds;
    static int wChar;
    boolean recomputeColSize = true;
    int[] colSize;
    private static final String DEFAULT_NAME = "Info frame";
    Object spv;

    private static void createLabelColors() {
        int n = LABEL_COL.length;
        LABEL_COL1 = new Color[n];
        LABEL_COL2 = new Color[n];
        LABEL_COL3 = new Color[n];
        LABEL_COL4 = new Color[n];
        double d = 0.1;
        for (int i = 0; i < LABEL_COL.length; ++i) {
            MetaDataTree.LABEL_COL1[i] = new Color((int)((double)LABEL_COL[i].getRed() + (double)((255 - LABEL_COL[i].getRed()) * 3) * d), (int)((double)LABEL_COL[i].getGreen() + (double)((255 - LABEL_COL[i].getGreen()) * 3) * d), (int)((double)LABEL_COL[i].getBlue() + (double)((255 - LABEL_COL[i].getBlue()) * 3) * d));
            MetaDataTree.LABEL_COL2[i] = new Color((int)((double)LABEL_COL[i].getRed() + (double)(255 - LABEL_COL[i].getRed()) * d), (int)((double)LABEL_COL[i].getGreen() + (double)(255 - LABEL_COL[i].getGreen()) * d), (int)((double)LABEL_COL[i].getBlue() + (double)(255 - LABEL_COL[i].getBlue()) * d));
            MetaDataTree.LABEL_COL3[i] = new Color((int)((double)LABEL_COL[i].getRed() - (double)(255 - LABEL_COL[i].getRed()) * d), (int)((double)LABEL_COL[i].getGreen() - (double)(255 - LABEL_COL[i].getGreen()) * d), (int)((double)LABEL_COL[i].getBlue() - (double)(255 - LABEL_COL[i].getBlue()) * d));
            MetaDataTree.LABEL_COL4[i] = new Color((int)((double)LABEL_COL[i].getRed() - (double)((255 - LABEL_COL[i].getRed()) * 3) * d), (int)((double)LABEL_COL[i].getGreen() - (double)((255 - LABEL_COL[i].getGreen()) * 3) * d), (int)((double)LABEL_COL[i].getBlue() - (double)((255 - LABEL_COL[i].getBlue()) * 3) * d));
        }
    }

    protected synchronized void createChaine() {
        if (NOLOC != null) {
            return;
        }
        NOLOC = Aladin.chaine.getString("MTNOLOC");
        NOIMG = Aladin.chaine.getString("MTNOIMG");
        IMAGE = Aladin.chaine.getString("IMAGE");
        NOSPEC = Aladin.chaine.getString("MTNOSPEC");
        NOSPEC1 = Aladin.chaine.getString("MTNOSPEC1");
        BADURL = Aladin.chaine.getString("MTBADURL");
        OPENWITH = Aladin.chaine.getString("MTOPENWITH");
        String string = this.aladin.getMessagingMgr().getProtocolName();
        PLASTICAPPS = Aladin.chaine.getString("MTPLASTICAPPS").replaceAll("SAMP", string);
    }

    MetaDataTree(BasicNode basicNode, Aladin aladin, JScrollPane jScrollPane) {
        super(aladin, basicNode, jScrollPane);
        this.createChaine();
        if (this.enableKdShortcut) {
            this.addKeyListener(this);
        }
    }

    MetaDataTree(Aladin aladin, JScrollPane jScrollPane) {
        this(new ResourceNode(aladin), aladin, jScrollPane);
    }

    MetaDataTree(BasicNode basicNode, Aladin aladin, JScrollPane jScrollPane, boolean bl) {
        super(aladin, basicNode, jScrollPane, bl);
        this.createChaine();
        if (this.enableKdShortcut) {
            this.addKeyListener(this);
        }
    }

    void addNode(ResourceNode resourceNode, ResourceNode resourceNode2) {
        resourceNode.addChild(resourceNode2);
        this.traverseTree();
        this.getStartPosition(resourceNode2);
        this.repaint();
    }

    void setRoot(ResourceNode resourceNode) {
        this.setRootNode(resourceNode);
        this.traverseTree();
        this.getStartPosition(this.getRootNode());
        this.repaint();
    }

    protected void turnOffAllNodes() {
        if (this.nodeTab == null) {
            return;
        }
        for (int i = 0; i < this.nodeTab.length; ++i) {
            ResourceNode resourceNode = (ResourceNode)this.nodeTab[i];
            if (!resourceNode.isLeaf || resourceNode.type != 1) continue;
            this.turnOffNode(resourceNode);
        }
    }

    protected void turnOffNode(ResourceNode resourceNode) {
        if (!resourceNode.litup) {
            return;
        }
        resourceNode.litup = false;
        Graphics graphics = this.getGraphics();
        this.drawPreCheckBox(graphics, resourceNode.x - 22, resourceNode.y, resourceNode, true);
        int n = graphics.getFontMetrics().stringWidth(this.getName(resourceNode));
        graphics.setColor(Aladin.LBLUE);
        graphics.fillRect(resourceNode.x - 1, resourceNode.y / 18 * 18, n + 2, 18);
        if (resourceNode.equals(this.lastInfoNode)) {
            graphics.setFont(boldNameFont);
        } else {
            graphics.setFont(nameFont);
        }
        graphics.setColor(Color.black);
        if (resourceNode.isLeaf && resourceNode.equals(this.lastInfoNode)) {
            this.drawBorder(graphics, resourceNode, n);
        }
        graphics.drawString(this.getName(resourceNode), resourceNode.x, resourceNode.y + 9 + 4);
    }

    protected void litUpNode(BasicNode basicNode) {
        if (basicNode.litup) {
            return;
        }
        basicNode.litup = true;
        Graphics graphics = this.getGraphics();
        this.drawPreCheckBox(graphics, basicNode.x - 22, basicNode.y, basicNode, false);
        int n = graphics.getFontMetrics().stringWidth(this.getName(basicNode));
        graphics.setColor(LITBGCOLOR);
        graphics.fillRect(basicNode.x - 1, basicNode.y / 18 * 18, n + 2, 18);
        graphics.setColor(LITFGCOLOR);
        if (basicNode.equals(this.lastInfoNode)) {
            graphics.setFont(boldNameFont);
        } else {
            graphics.setFont(nameFont);
        }
        if (basicNode.isLeaf && basicNode.equals(this.lastInfoNode)) {
            this.drawBorder(graphics, basicNode, n);
        }
        graphics.drawString(this.getName(basicNode), basicNode.x, basicNode.y + 9 + 4);
    }

    private void getStartPosition(BasicNode[] basicNodeArray) {
        for (int i = 0; i < basicNodeArray.length; ++i) {
            BasicNode basicNode = basicNodeArray[i];
            if (basicNode.isLeaf) continue;
            basicNode.isOpen = this.fullExpandAtStart || basicNode.nbChildren <= 0 || !basicNode.getChildrenAt((int)0).isLeaf && ((ResourceNode)basicNode).valueCriteria == null;
            if (!basicNode.equals(this.getRootNode())) continue;
            basicNode.isOpen = true;
        }
    }

    protected void getStartPosition() {
        this.getStartPosition(this.nodeFullTab);
    }

    protected void getStartPosition(BasicNode basicNode) {
        Vector<BasicNode> vector = new Vector<BasicNode>();
        this.getAllSubnodes(basicNode, vector);
        vector.addElement(basicNode);
        Object[] objectArray = new BasicNode[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        this.getStartPosition((BasicNode[])objectArray);
    }

    @Override
    public void setFlat(boolean bl) {
        this.indexSort = -1;
        super.setFlat(bl);
    }

    @Override
    BasicNode[] getLeavesForFlatView(BasicNode basicNode) {
        BasicNode[] basicNodeArray = super.getLeavesForFlatView(basicNode);
        Object[] objectArray = new ResourceNode[basicNodeArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = (ResourceNode)basicNodeArray[i];
        }
        if (this.flatView && this.sortable && this.indexSort >= 0) {
            MetaDataTree.sort(objectArray, columns[this.indexSort], this.descSort);
        }
        return objectArray;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.flatView && this.sortable && this.nodeFullTab.length > 1 && n2 < 18 && (mouseEvent.getModifiers() & 4) == 0) {
            for (int i = 0; i < this.colBounds.length; ++i) {
                if (n < this.colBounds[i][0]) {
                    return;
                }
                if (n > this.colBounds[i][1]) continue;
                this.descSort = this.indexSort == i ? !this.descSort : true;
                this.indexSort = i;
                this.repaint();
            }
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    protected void onNodeExpanded(BasicNode basicNode) {
    }

    @Override
    protected void onNodeCollapsed(BasicNode basicNode) {
    }

    @Override
    protected void onNodeSelected(BasicNode basicNode) {
        this.showInfo((ResourceNode)basicNode);
    }

    @Override
    protected void onNodeSelectedDbleClick(BasicNode basicNode) {
        this.load((ResourceNode)basicNode, null);
    }

    @Override
    protected void onNodeRemoved(BasicNode basicNode) {
        Vector vector = new Vector();
        this.getAllSubnodes(basicNode, vector);
        if (basicNode.equals(this.lastInfoNode) || vector.contains(this.lastInfoNode)) {
            this.lastInfoNode = null;
        }
    }

    @Override
    protected void onMouseMoved(BasicNode basicNode, boolean bl) {
        ResourceNode resourceNode = (ResourceNode)basicNode;
        if ((resourceNode.type == 1 || resourceNode.type == 3) && bl) {
            this.showFov(resourceNode);
            this.showCutoutFov(resourceNode);
        } else {
            this.deactivateCutoutFov();
        }
        Plan plan = this.aladin.calque.getPlanRef();
        if (resourceNode.isLeaf && resourceNode.type == 1 && bl && plan == null) {
            Coord coord = this.getPos(resourceNode);
            if (coord != null) {
                this.aladin.localisation.setTextSaisie(this.aladin.localisation.J2000ToString(coord.al, coord.del));
            } else {
                this.resetLocalisation();
            }
        } else if (plan == null && this.aladin.localisation.getTextSaisie().length() > 0) {
            this.resetLocalisation();
        }
        if (!bl || resourceNode.type != 1 && resourceNode.type != 3) {
            this.hideFov();
        }
    }

    private void resetLocalisation() {
        this.aladin.localisation.setTextSaisie("");
    }

    private void fillOpenWith(JMenu jMenu, ResourceNode resourceNode) {
        if (resourceNode.type == 1 || resourceNode.type == 2) {
            jMenu.add(this.createItem(OPENWITHALADIN));
            jMenu.addSeparator();
        }
        if (Aladin.PLASTIC_SUPPORT) {
            JMenuItem jMenuItem = this.createItem(PLASTICAPPS);
            jMenuItem.setFont(Aladin.BOLD);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = jMenuItem;
            AppMessagingInterface.AbstractMessage abstractMessage = resourceNode.getPlasticMsg();
            ArrayList<String> arrayList = this.aladin.getMessagingMgr().getAppsSupporting(abstractMessage);
            System.out.println(arrayList.size());
            if (arrayList != null) {
                for (String string : arrayList) {
                    jMenuItem = this.createItem(string);
                    jMenuItem.setActionCommand(PLASTICAPPS);
                    jMenu.add(jMenuItem);
                }
            }
            try {
                jMenuItem2.setEnabled(arrayList != null && arrayList.size() > 0 && this.aladin.getMessagingMgr().isRegistered());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void createMenuItem(JComponent jComponent, String[] stringArray) {
        if (stringArray.length == 1) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
            String string = jComponent instanceof JMenu ? ((JMenu)jComponent).getActionCommand() : "";
            jMenuItem.setActionCommand(string + ";" + stringArray[0]);
            jComponent.add(jMenuItem);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JMenu jMenu = new JMenu(stringArray[i]);
            String string = jComponent instanceof JMenu ? ((JMenu)jComponent).getActionCommand() : "";
            jMenu.setActionCommand(string + ";" + stringArray[i]);
            jComponent.add(jMenu);
            String[] stringArray2 = new String[stringArray.length - 1];
            int n = 0;
            if (i > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, i);
                n = i;
            }
            if (i < stringArray.length - 1) {
                System.arraycopy(stringArray, i + 1, stringArray2, n, stringArray.length - (i + 1));
            }
            this.createMenuItem(jMenu, stringArray2);
        }
    }

    @Override
    protected void onRightClickInNode(BasicNode basicNode, int n, int n2) {
        ResourceNode resourceNode = (ResourceNode)basicNode;
        this.popup.removeAll();
        if (resourceNode.sortCriteria != null && resourceNode.sortCriteria.length > 1) {
            this.popup.addSeparator();
            this.popup.add(this.createItem(SORTBY));
            this.createMenuItem(this.popup, resourceNode.sortCriteria);
        }
        if (resourceNode.isLeaf) {
            JMenu jMenu = new JMenu(OPENWITH);
            this.popup.add(jMenu);
            this.fillOpenWith(jMenu, resourceNode);
        }
        this.popup.addSeparator();
        this.popup.add(this.createItem("Collapse all"));
        this.popup.add(this.createItem("Expand all"));
        if (!this.isHistoryTree && this.hasSpectraOrImages) {
            this.popup.addSeparator();
            this.popup.add(this.createItem("Create a catalog plane with all images/spectra"));
        }
        this.popup.addSeparator();
        this.popup.add(this.flatView ? this.createItem("Hierarchical view") : this.createItem("Flat view"));
        if (!this.flatView && resourceNode.isSIAPEvol) {
            this.popup.addSeparator();
            this.popup.add(this.createItem("Sort"));
        }
        this.popup.show(this, n, n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        ResourceNode resourceNode = (ResourceNode)this.selectedNode;
        if (string.equals("Delete")) {
            return;
        }
        if (string.equals("Collapse this subtree") || string.equals("Expand this subtree")) {
            return;
        }
        if (object instanceof JMenuItem) {
            if (string.equals(OPENWITHALADIN)) {
                this.load(resourceNode, null);
                return;
            }
            String string2 = ((JMenuItem)object).getText();
            if (string2.equals(PLASTICAPPS)) {
                return;
            }
            if (((JMenuItem)object).getActionCommand().equals(PLASTICAPPS)) {
                this.loadNodeWithPlastic(resourceNode, string2);
                return;
            }
            if (string.equals(SORTBY) || string.equals("Collapse all") || string.equals("Expand all") || string.equals("Flat view") || string.equals("Hierarchical view")) {
                if (this.stateChangerLstr != null) {
                    this.stateChangerLstr.fireStateChange(string);
                }
                return;
            }
            if (string.equals("Sort")) {
                this.sortSiapEvol();
                return;
            }
            if (string.equals("Create a catalog plane with all images/spectra")) {
                this.creatCatPlaneForSpectra((ResourceNode)this.getRootNode());
                return;
            }
            this.sortNode(resourceNode, ((JMenuItem)object).getActionCommand());
        }
    }

    private void creatCatPlaneForSpectra(ResourceNode resourceNode) {
        Vector<ResourceNode> vector = new Vector<ResourceNode>();
        MetaDataTree.getAllLeaves(resourceNode, vector);
        if (resourceNode.isLeaf) {
            vector.addElement(resourceNode);
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            ResourceNode resourceNode2 = (ResourceNode)vector.elementAt(i);
            if (resourceNode2.type != 3 && resourceNode2.type != 1) continue;
            vector2.addElement(vector.elementAt(i));
        }
        if (vector2.size() == 0) {
            Aladin.warning(this, "No spectrum/image found in this tree !");
        } else {
            String string;
            int n;
            Object[] objectArray = new ResourceNode[vector2.size()];
            vector2.copyInto(objectArray);
            vector2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\"?>\n<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">\n<VOTABLE version=\"1.0\" xmlns=\"http://vizier.u-strasbg.fr/VOTable\">\n  <DESCRIPTION>Object selection from Aladin</DESCRIPTION>\n  <DEFINITIONS>\n    <COOSYS ID=\"J2000\" equinox=\"2000.\" epoch=\"2000\" system=\"eq_FK5\"/>\n  </DEFINITIONS>\n");
            stringBuffer.append("<RESOURCE>\n");
            stringBuffer.append("<TABLE>\n");
            stringBuffer.append("<FIELD name=\"name\" datatype=\"char\" arraysize=\"*\" />\n");
            stringBuffer.append("<FIELD name=\"RA\" ucd=\"pos.eq.ra;meta.main\" unit=\"deg\" datatype=\"float\" />\n");
            stringBuffer.append("<FIELD name=\"DE\" ucd=\"pos.eq.dec;meta.main\" unit=\"deg\" datatype=\"float\" />\n");
            stringBuffer.append("<FIELD name=\"url_data\" ucd=\"meta.ref.url\"  datatype=\"char\" arraysize=\"*\"  type=\"hidden\" >\n");
            stringBuffer.append("</FIELD>\n");
            stringBuffer.append("<DATA><TABLEDATA>\n");
            String string2 = "";
            for (n = 0; n < objectArray.length; ++n) {
                stringBuffer.append("<TR>");
                stringBuffer.append("<TD>" + ((ResourceNode)objectArray[n]).name + "</TD>");
                if (((ResourceNode)objectArray[n]).getFov() != null) {
                    if (string2 != null && string2.length() == 0 && ((ResourceNode)objectArray[n]).objet != null) {
                        string2 = ((ResourceNode)objectArray[n]).objet;
                    }
                    stringBuffer.append("<TD>" + ((ResourceNode)objectArray[n]).getFov().alpha + "</TD>");
                    stringBuffer.append("<TD>" + ((ResourceNode)objectArray[n]).getFov().delta + "</TD>");
                } else {
                    stringBuffer.append("<TD></TD>");
                    stringBuffer.append("<TD></TD>");
                }
                string = ((ResourceNode)objectArray[n]).location != null ? ((ResourceNode)objectArray[n]).location : "";
                stringBuffer.append("<TD>" + URLEncoder.encode(string) + "</TD>");
                stringBuffer.append("</TR>\n");
            }
            stringBuffer.append("</TABLEDATA></DATA>\n");
            stringBuffer.append("</TABLE>\n");
            stringBuffer.append("</RESOURCE>\n");
            stringBuffer.append("</VOTABLE>");
            try {
                n = this.aladin.calque.newPlanCatalog(new MyInputStream(new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()))), "toto");
                if (n >= 0) {
                    string = "Spectra." + string2;
                    String string3 = new String(string);
                    int n2 = 0;
                    while (MetaDataTree.getPlaneByName(string3, this.aladin) != null) {
                        string3 = string + "_" + ++n2;
                    }
                    this.aladin.calque.plan[n].setLabel(string3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected static Plan getPlaneByName(String string, Aladin aladin) {
        for (int i = aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan plan = aladin.calque.plan[i];
            if (plan.label == null || !plan.label.equals(string)) continue;
            return plan;
        }
        return null;
    }

    protected void loadNodeWithPlastic(ResourceNode resourceNode, String string) {
        if (resourceNode == null || string == null) {
            return;
        }
        AppMessagingInterface appMessagingInterface = this.aladin.getMessagingMgr();
        AppMessagingInterface.AbstractMessage abstractMessage = resourceNode.getPlasticMsg();
        if (abstractMessage == null) {
            Aladin.trace(3, "Could not find a " + appMessagingInterface.getProtocolName() + " message to load node, aborting !");
            return;
        }
        ArrayList arrayList = new ArrayList();
        String string2 = this.resolveLocation(resourceNode.location, resourceNode, null).toString();
        if (string2 == null) {
            Aladin.trace(3, "Could not resolve location of the resource to load");
            return;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(appMessagingInterface.getAppWithName(string));
        appMessagingInterface.getPlasticWidget().animateWidgetSend();
        if (abstractMessage.equals(AppMessagingInterface.ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL)) {
            appMessagingInterface.sendMessageLoadSpectrum(string2, string2, resourceNode.name, resourceNode.getMetadata(), arrayList2);
        } else if (abstractMessage.equals(AppMessagingInterface.ABSTRACT_MSG_LOAD_CHARAC_FROM_URL)) {
            appMessagingInterface.sendMessageLoadCharac(string2, resourceNode.name, arrayList2);
        } else if (abstractMessage.equals(AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS)) {
            appMessagingInterface.sendMessageLoadImage(string2, resourceNode.name, arrayList2);
        }
        Aladin.trace(3, "Sending data or spectrum with url " + string2);
        this.aladin.glu.log(appMessagingInterface.getProtocolName(), "sending data or spectrum URL");
    }

    private void sortSiapEvol() {
        if (this.sortFrame == null) {
            this.sortFrame = new SortFrame("Choose sort fields");
        }
        this.sortFrame.updateList();
        this.sortFrame.pack();
        this.sortFrame.show();
        this.sortFrame.toFront();
    }

    protected static void doSortSiapEvol(String[] stringArray, BasicNode basicNode) {
        Vector vector = new Vector();
        MetaDataTree.getAllObs(basicNode, vector);
        Object[] objectArray = new ResourceNode[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            MetaDataTree.genericSort(objectArray, stringArray[i], true);
        }
        basicNode.removeAllChild();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ResourceNode resourceNode = (ResourceNode)basicNode;
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                String string2 = string + "::: " + (String)((ResourceNode)object).properties.get(string) + " ///" + (String)((ResourceNode)object).propertiesUnits.get(string);
                ResourceNode resourceNode2 = (ResourceNode)resourceNode.getChild(string2);
                if (resourceNode2 == null) {
                    ResourceNode resourceNode3 = null;
                    if (((ResourceNode)object).links != null) {
                        resourceNode3 = (ResourceNode)((ResourceNode)object).links.get(string);
                    }
                    resourceNode2 = resourceNode3 == null ? new ResourceNode(basicNode.aladin, string2) : new ResourceNode(basicNode.aladin, resourceNode3);
                    resourceNode2.type = ((ResourceNode)object).type;
                    resourceNode.addChild(resourceNode2);
                }
                resourceNode = resourceNode2;
            }
            resourceNode.addChild((BasicNode)object);
        }
    }

    private void doSortSiapEvol(String[] stringArray) {
        MetaDataTree.doSortSiapEvol(stringArray, this.getRootNode());
        this.traverseTree();
        this.repaint();
    }

    private void sortNode(ResourceNode resourceNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        Vector vector = new Vector();
        MetaDataTree.getAllLeaves(resourceNode, vector);
        Object[] objectArray = new ResourceNode[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        vector = new Vector();
        MetaDataTree.getAllNonLeaves(resourceNode, vector);
        Enumeration enumeration = vector.elements();
        Hashtable<String, ResourceNode> hashtable = new Hashtable<String, ResourceNode>();
        while (enumeration.hasMoreElements()) {
            ResourceNode resourceNode2 = (ResourceNode)enumeration.nextElement();
            resourceNode2.removeAllChild();
            hashtable.put(resourceNode2.name, resourceNode2);
        }
        resourceNode.removeAllChild();
        this.sortAndCreate((ResourceNode[])objectArray, resourceNode, stringArray, hashtable);
        this.traverseTree();
        this.repaint();
    }

    private void sortAndCreate(ResourceNode[] resourceNodeArray, ResourceNode resourceNode, String[] stringArray, Hashtable hashtable) {
        if (resourceNodeArray.length == 0) {
            return;
        }
        for (int i = 0; i < resourceNodeArray.length; ++i) {
            ResourceNode resourceNode2 = resourceNodeArray[i];
            Hashtable hashtable2 = resourceNode2.criteriaVal;
            ResourceNode resourceNode3 = resourceNode;
            String string = null;
            for (int j = 0; j < stringArray.length; ++j) {
                string = (String)hashtable2.get(stringArray[j]);
                ResourceNode resourceNode4 = (ResourceNode)resourceNode3.getChild(string);
                if (resourceNode4 == null) {
                    resourceNode4 = new ResourceNode(this.aladin, (ResourceNode)hashtable.get(string));
                    resourceNode3.addChild(resourceNode4);
                }
                resourceNode3 = resourceNode4;
            }
            resourceNode3.addChild(resourceNode2);
            if (resourceNode3.col != null) continue;
            resourceNode3.col = resourceNode2.col;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.aladin.calque.curFov = null;
        this.aladin.calque.cutoutFov = null;
        this.resetLocalisation();
        this.clearSelected();
        this.aladin.calque.repaintAll();
    }

    private void showInfo(ResourceNode resourceNode) {
        String string;
        FrameInfo frameInfo = this.aladin.getFrameInfo();
        if (resourceNode.server != null && resourceNode.server instanceof ServerAladin && resourceNode.isAvailableFormat(string = ((ServerAladin)this.aladin.dialog.server[ServerDialog.ALADIN]).getDefaultFormat())) {
            resourceNode.curFormat = string;
        }
        if (this.dontShow(resourceNode)) {
            return;
        }
        frameInfo.update(resourceNode, this);
        frameInfo.toFront();
        frameInfo.show();
    }

    private boolean dontShow(ResourceNode resourceNode) {
        if (resourceNode != null && this.aladin.calque.curFov != null) {
            return false;
        }
        return resourceNode == null || resourceNode.description == null || resourceNode.explanation == null || resourceNode.description.length == 0 && resourceNode.links == null && (resourceNode.filterDesc == null || resourceNode.filterExpla == null);
    }

    @Override
    protected void drawNodeName(Graphics graphics, BasicNode basicNode, boolean bl) {
        int n;
        boolean bl2;
        ResourceNode resourceNode = (ResourceNode)basicNode;
        boolean bl3 = bl2 = this.getName(basicNode).indexOf("::: ") >= 0 && !basicNode.isLeaf;
        if (!this.useColorLabel() || resourceNode.nbChildren == 0 || bl2 || (n = ((ResourceNode)resourceNode.getChildrenAt((int)0)).type) == 0) {
            super.drawNodeName(graphics, basicNode, bl);
        } else {
            graphics.setFont(nameFont);
            if (basicNode == this.getRootNode() && this.flatView) {
                return;
            }
            String string = this.getName(basicNode);
            graphics.setColor(LABEL_COL2[n]);
            graphics.fillRect(basicNode.x, basicNode.y + 1, graphics.getFontMetrics().stringWidth(string) + 1, 16);
            graphics.fillArc(basicNode.x - 8, basicNode.y + 1, 16, 17, 90, 90);
            graphics.fillArc(basicNode.x + graphics.getFontMetrics().stringWidth(string) + 1 - 8, basicNode.y + 1, 16, 17, 0, 90);
            graphics.setColor(LABEL_COL3[n]);
            graphics.fillRect(basicNode.x, basicNode.y + 1 + 9, graphics.getFontMetrics().stringWidth(string) + 1, 8);
            graphics.fillArc(basicNode.x - 8, basicNode.y + 1, 16, 17, 180, 90);
            graphics.fillArc(basicNode.x + graphics.getFontMetrics().stringWidth(string) + 1 - 8, basicNode.y + 1, 16, 17, 270, 90);
            graphics.setColor(LABEL_COL1[n]);
            graphics.drawLine(basicNode.x, basicNode.y + 1, basicNode.x + graphics.getFontMetrics().stringWidth(string), basicNode.y + 1);
            graphics.setColor(LABEL_COL4[n]);
            graphics.drawLine(basicNode.x, basicNode.y + 1 + 18 - 2, basicNode.x + graphics.getFontMetrics().stringWidth(string), basicNode.y + 1 + 18 - 2);
            boolean bl4 = false;
            if (this.oHilightNode >= 0 && this.oHilightNode < this.nodeTab.length && this.nodeTab != null && basicNode.equals(this.nodeTab[this.oHilightNode])) {
                bl4 = true;
                if (basicNode.isLeaf) {
                    this.drawSelectedLeafNodeName(graphics, basicNode, string);
                }
            }
            graphics.setColor(bl4 ? this.getMouseOverColor(basicNode) : Color.black);
            graphics.setFont(basicNode.equals(this.lastInfoNode) ? boldNameFont : nameFont);
            graphics.drawString(string, basicNode.x, basicNode.y + 9 + 4);
        }
    }

    void showFov(ResourceNode resourceNode) {
        if (firstShow) {
            this.aladin.cardView.show(this.aladin.bigView, "View");
            firstShow = false;
        }
        this.aladin.calque.curFov = this.getFovs(resourceNode, false);
        ResourceNode resourceNode2 = (ResourceNode)resourceNode.getParent();
        this.aladin.calque.fovProj = resourceNode.isLeaf && resourceNode2 != null && resourceNode2.type == 1 && resourceNode.getFov() != null ? PlanFov.getProjection(this.getFovs(resourceNode2, false)) : null;
        this.aladin.view.repaintAll();
    }

    protected Fov[] getFovs(ResourceNode resourceNode, boolean bl, boolean bl2) {
        Vector<ResourceNode> vector = new Vector<ResourceNode>();
        MetaDataTree.getAllLeaves(resourceNode, vector);
        if (resourceNode.isLeaf && (!bl || resourceNode.cutout && resourceNode.getFov() != null)) {
            vector.addElement(resourceNode);
        }
        Enumeration enumeration = vector.elements();
        Fov[] fovArray = new Fov[vector.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            fovArray[n] = bl ? this.getCutoutFov((ResourceNode)enumeration.nextElement()) : (bl2 ? (resourceNode.cutout && resourceNode.getFov() != null ? this.getCutoutFov((ResourceNode)enumeration.nextElement()) : ((ResourceNode)enumeration.nextElement()).getFov()) : ((ResourceNode)enumeration.nextElement()).getFov());
            ++n;
        }
        return fovArray;
    }

    protected Fov[] getFovs(ResourceNode resourceNode, boolean bl) {
        return this.getFovs(resourceNode, bl, false);
    }

    void showCutoutFov(ResourceNode resourceNode) {
        this.aladin.calque.cutoutFov = this.getFovs(resourceNode, true);
        this.aladin.view.repaintAll();
    }

    private Fov getCutoutFov(ResourceNode resourceNode) {
        Fov fov;
        try {
            fov = new Fov(MetaDataTree.resolveTarget(resourceNode.getCutoutTarget(), this.aladin), resourceNode.getFov().cutout_x, resourceNode.getFov().cutout_y, resourceNode.getFov().angle);
        }
        catch (Exception exception) {
            return null;
        }
        return fov;
    }

    static String resolveTarget(String string, Aladin aladin) {
        Coord coord;
        try {
            coord = !View.notCoord(string) ? new Coord(string) : aladin.view.sesame(string);
        }
        catch (Exception exception) {
            return null;
        }
        return coord.getSexa(":");
    }

    void deactivateCutoutFov() {
        this.aladin.calque.cutoutFov = null;
        this.aladin.view.repaintAll();
    }

    void hideFov() {
        this.aladin.calque.curFov = null;
        this.aladin.view.repaintAll();
    }

    void setSortable(boolean bl) {
        this.sortable = bl;
        if (this.sortable) {
            this.indexSort = this.defaultIndexSort;
            this.descSort = this.defaultDescSort;
        }
    }

    void setFullExpandAtStart(boolean bl) {
        this.fullExpandAtStart = bl;
    }

    @Override
    protected int initMaxWidth() {
        if (this.flatView && this.sortable) {
            int n = 44;
            if (this.recomputeColSize) {
                this.computeColSize();
                this.recomputeColSize = false;
            }
            for (int i = 0; i < this.colSize.length; ++i) {
                n += (this.colSize[i] + 1) * wChar;
            }
            return n;
        }
        return super.initMaxWidth();
    }

    @Override
    void fullDisplay(Graphics graphics) {
        if (this.flatView && this.sortable && this.nodeFullTab.length > 1) {
            int n;
            this.colBounds = new int[this.colSize.length][2];
            int n2 = 44;
            int n3 = 14;
            graphics.setColor(Color.blue);
            for (n = 0; n < this.colSize.length; ++n) {
                int n4 = wChar * this.colSize[n] - 1;
                this.colBounds[n][0] = n2;
                this.colBounds[n][1] = n2 + n4;
                n2 += n4 + wChar;
            }
            for (n = 0; n < this.colBounds.length; ++n) {
                this.drawOnglet(graphics, n);
            }
        }
        super.fullDisplay(graphics);
    }

    private void drawOnglet(Graphics graphics, int n) {
        int n2 = this.colBounds[n][1] - this.colBounds[n][0];
        int n3 = 14;
        int n4 = this.colBounds[n][0];
        graphics.setColor(grayFill);
        graphics.fillRect(n4 + 1, 3, n2, n3);
        graphics.setColor(Color.white);
        graphics.drawRect(n4 + 1, 3, n2, n3);
        graphics.setColor(grayCB);
        graphics.drawRect(n4, 2, n2, n3);
        graphics.setColor(Color.black);
        graphics.setFont(nameFont);
        graphics.drawString(sortName[n], wChar + n4, n3);
        if (n == this.indexSort) {
            if (this.descSort) {
                n4 = this.colBounds[n][1] - wChar - 3 + wChar / 2;
                graphics.setColor(Color.white);
                graphics.drawLine(n4, 14, n4 + wChar / 2, 5);
                n4 = this.colBounds[n][1] - wChar - 3;
                graphics.setColor(Color.black);
                graphics.drawLine(n4, 5, n4 + wChar / 2, 14);
                n4 = this.colBounds[n][1] - wChar - 3;
                graphics.setColor(Color.black);
                graphics.drawLine(n4, 5, n4 + wChar - 1, 5);
            } else {
                n4 = this.colBounds[n][1] - wChar - 3 + wChar / 2;
                graphics.setColor(Color.white);
                graphics.drawLine(n4, 5, n4 + wChar / 2, 14);
                n4 = this.colBounds[n][1] - wChar - 3;
                graphics.setColor(Color.black);
                graphics.drawLine(n4, 14, n4 + wChar / 2, 5);
                n4 = this.colBounds[n][1] - wChar - 3;
                graphics.setColor(Color.white);
                graphics.drawLine(n4, 14, n4 + wChar - 1, 14);
            }
        }
    }

    @Override
    void traverseTree() {
        this.recomputeColSize = true;
        super.traverseTree();
    }

    private void computeColSize() {
        this.colSize = new int[columns.length];
        if (this.sortable) {
            for (int i = 0; i < this.colSize.length; ++i) {
                this.colSize[i] = sortName[i].length() + 3;
            }
        }
        Vector vector = new Vector();
        MetaDataTree.getAllLeaves(this.getRootNode(), vector);
        Object[] objectArray = new ResourceNode[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            for (int j = 0; j < columns.length; ++j) {
                this.colSize[j] = Math.max(this.colSize[j], columns[j].getColName((ResourceNode)object).length());
            }
        }
    }

    protected String getName(BasicNode basicNode, boolean bl) {
        if (basicNode.name == null) {
            basicNode.name = "NULL";
        }
        if (!basicNode.isLeaf) {
            return basicNode.name.length() > 0 ? basicNode.name : DEFAULT_NAME;
        }
        ResourceNode resourceNode = (ResourceNode)basicNode;
        if (!bl) {
            if (resourceNode.isSIAPEvol && resourceNode.altName != null && resourceNode.getParent().isObs) {
                return resourceNode.altName;
            }
            int n = resourceNode.name.indexOf("-EPOCH");
            if (n > 0) {
                return resourceNode.name.substring(0, n);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (resourceNode.machine != null && resourceNode.machine.length() > 0) {
                stringBuffer.append(resourceNode.machine + ".");
            }
            stringBuffer.append(resourceNode.name.length() > 0 ? resourceNode.name : DEFAULT_NAME);
            if (resourceNode.getFov() != null) {
                stringBuffer.append(" " + resourceNode.getFov().getSizeStr(resourceNode.cutout));
            }
            if (resourceNode.obsDate != null) {
                stringBuffer.append(" " + resourceNode.obsDate);
            }
            return stringBuffer.toString().trim();
        }
        if (!resourceNode.isLeaf || resourceNode.survey == null) {
            String string = this.getName(resourceNode, false);
            for (ResourceNode resourceNode2 = (ResourceNode)resourceNode.getParent(); resourceNode2 != null && resourceNode2.type == 1; resourceNode2 = (ResourceNode)resourceNode2.getParent()) {
                String string2 = resourceNode2.name;
                int n = string2.indexOf("::: ");
                if (n >= 0) {
                    string2 = string2.substring(n + 4);
                }
                string2 = MetaDataTree.replace(string2, " ///", "", 1);
                string = string + " " + string2;
            }
            string = string + (resourceNode.getPixSize() != null ? " " + resourceNode.getPixSize() : "");
            string = string + (resourceNode.obsDate != null ? " " + resourceNode.obsDate : "");
            return string;
        }
        if (this.recomputeColSize) {
            this.computeColSize();
            this.recomputeColSize = false;
        }
        String string = "";
        for (int i = 0; i < columns.length; ++i) {
            string = string + Util.fillWithBlank(columns[i].getColName(resourceNode), this.colSize[i] + 1);
        }
        return string.trim();
    }

    @Override
    protected String getName(BasicNode basicNode) {
        return this.getName(basicNode, this.flatView);
    }

    protected boolean checkCutoutAvailability(BasicNode basicNode, double d, double d2, Aladin aladin) {
        return true;
    }

    private URL resolveLocation(String string, ResourceNode resourceNode, String string2) {
        URL uRL;
        String string3;
        if (resourceNode.type != 1) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (string != null && (string.startsWith("/") || string.toLowerCase().startsWith("c:/"))) {
                    return this.resolveLocation("file://" + string, resourceNode, string2);
                }
                Aladin.warning("Can't interpret location " + string);
                return null;
            }
        }
        String string4 = resourceNode.gluLink;
        boolean bl = string4 != null;
        Coord coord = null;
        coord = this.getPos(resourceNode);
        if (coord != null) {
            if (resourceNode.cutout && !this.checkCutoutAvailability(resourceNode, coord.al, coord.del, this.aladin)) {
                Aladin.warning(IMAGE + " " + resourceNode.name + " " + NOIMAGE_WARNING, 1);
                return null;
            }
            string3 = TreeView.getDeciCoord(coord.getSexa());
            if (string.indexOf("alapre") >= 0) {
                string3 = coord.getSexa();
            }
            if (bl) {
                string4 = MetaDataTree.replace(string4, "$POS", URLEncoder.encode(string3), -1);
            } else {
                string = MetaDataTree.replace(string, "$POS", URLEncoder.encode(string3), -1);
            }
        }
        string3 = resourceNode.curFormat;
        if (string2 != null && resourceNode.isAvailableFormat(string2)) {
            string3 = string2;
        }
        if (string3 != null) {
            if (bl) {
                string4 = MetaDataTree.replace(string4, "$COMPRESSION", URLEncoder.encode(string3), -1);
            } else {
                string = MetaDataTree.replace(string, "$COMPRESSION", URLEncoder.encode(string3), -1);
            }
        }
        if (resourceNode.curMode != null) {
            if (bl) {
                string4 = MetaDataTree.replace(string4, "$MODE", URLEncoder.encode(resourceNode.curMode), -1);
            } else {
                string = MetaDataTree.replace(string, "$MODE", URLEncoder.encode(resourceNode.curMode), -1);
            }
        }
        if (bl) {
            string4 = MetaDataTree.replace(string4, "$RESOLUTION", "FULL", -1);
        } else {
            string = MetaDataTree.replace(string, "$RESOLUTION", "FULL", -1);
        }
        if (bl) {
            string4 = MetaDataTree.replace(string4, "$NumberOfPatches", resourceNode.curImgNumber, -1);
        } else {
            string = MetaDataTree.replace(string, "$NumberOfPatches", resourceNode.curImgNumber, -1);
        }
        String[] stringArray = resourceNode.getImagePosTarget();
        String string5 = stringArray[0];
        String string6 = stringArray[1];
        if (bl) {
            string4 = MetaDataTree.replace(string4, "$Xpix", string5, -1);
            string4 = MetaDataTree.replace(string4, "$Ypix", string6, -1);
        } else {
            string = MetaDataTree.replace(string, "$Xpix", string5, -1);
            string = MetaDataTree.replace(string, "$Ypix", string6, -1);
        }
        if (bl) {
            Words words = new Words("");
            words.tagGlu(string4.toCharArray());
            uRL = this.aladin.glu.getURL(words.id, words.param, true);
        } else {
            uRL = this.aladin.glu.getURL("Http", string, true);
        }
        return uRL;
    }

    private void loadImage(ResourceNode resourceNode, String string, String string2) {
        String string3;
        URL uRL;
        Object object;
        String string4;
        boolean bl;
        String string5 = resourceNode.getLocation();
        String string6 = resourceNode.gluLink;
        if (string5 == null && string6 == null) {
            Aladin.warning(NOLOC);
            return;
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string5.equalsIgnoreCase("NoData") && string6 == null) {
            Aladin.warning(NOIMG);
            return;
        }
        if (resourceNode.indexing != null && resourceNode.indexing.equals("HTML")) {
            this.aladin.glu.showDocument("Http", string5, true);
            return;
        }
        boolean bl2 = bl = string6 != null;
        if (string5.startsWith("file:")) {
            string5 = string5.substring(5);
            ((ServerFile)this.aladin.dialog.server[ServerDialog.LOCAL]).creatLocalPlane(string5, resourceNode.name, "", null, resourceNode, null, null, null, null);
            return;
        }
        Coord coord = null;
        coord = this.getPos(resourceNode);
        if (coord != null) {
            if (resourceNode.cutout && !this.checkCutoutAvailability(resourceNode, coord.al, coord.del, this.aladin)) {
                Aladin.warning(IMAGE + " " + resourceNode.name + " " + NOIMAGE_WARNING, 1);
                return;
            }
            string4 = TreeView.getDeciCoord(coord.getSexa());
            if (string5.indexOf("alapre") >= 0) {
                string4 = coord.getSexa();
            }
            if (bl) {
                string6 = MetaDataTree.replace(string6, "$POS", URLEncoder.encode(string4), -1);
            } else {
                string5 = MetaDataTree.replace(string5, "$POS", URLEncoder.encode(string4), -1);
            }
        }
        string4 = resourceNode.curFormat;
        if (string != null && resourceNode.isAvailableFormat(string)) {
            string4 = string;
        }
        if (string4 != null) {
            if (bl) {
                string6 = MetaDataTree.replace(string6, "$COMPRESSION", URLEncoder.encode(string4), -1);
            } else {
                string5 = MetaDataTree.replace(string5, "$COMPRESSION", URLEncoder.encode(string4), -1);
            }
        }
        if (resourceNode.curMode != null) {
            if (bl) {
                string6 = MetaDataTree.replace(string6, "$MODE", URLEncoder.encode(resourceNode.curMode), -1);
            } else {
                string5 = MetaDataTree.replace(string5, "$MODE", URLEncoder.encode(resourceNode.curMode), -1);
            }
        }
        if (bl) {
            string6 = MetaDataTree.replace(string6, "$RESOLUTION", "FULL", -1);
        } else {
            string5 = MetaDataTree.replace(string5, "$RESOLUTION", "FULL", -1);
        }
        if (bl) {
            string6 = MetaDataTree.replace(string6, "$NumberOfPatches", resourceNode.curImgNumber, -1);
        } else {
            string5 = MetaDataTree.replace(string5, "$NumberOfPatches", resourceNode.curImgNumber, -1);
        }
        String[] stringArray = resourceNode.getImagePosTarget();
        String string7 = stringArray[0];
        String string8 = stringArray[1];
        if (bl) {
            string6 = MetaDataTree.replace(string6, "$Xpix", string7, -1);
            string6 = MetaDataTree.replace(string6, "$Ypix", string8, -1);
        } else {
            string5 = MetaDataTree.replace(string5, "$Xpix", string7, -1);
            string5 = MetaDataTree.replace(string5, "$Ypix", string8, -1);
        }
        if (bl) {
            object = new Words("");
            ((Words)object).tagGlu(string6.toCharArray());
            uRL = this.aladin.glu.getURL(((Words)object).id, ((Words)object).param, true);
        } else {
            uRL = this.aladin.glu.getURL("Http", string5, true);
        }
        if (string2 == null) {
            string2 = this.buildStackLabel(resourceNode);
        }
        object = this.buildQual(resourceNode);
        int n = string4 != null ? PlanImage.getFmt(string4) : 0;
        String string9 = string3 = coord != null ? coord.getSexa(":") : "";
        if (string3.length() == 0 || resourceNode.objet != null && (!resourceNode.cutout && (resourceNode.modes == null || resourceNode.modes.length <= 1 || resourceNode.curMode == null || resourceNode.curMode.equals("ORIGIN")) || resourceNode.targetObjet != null && string3.equals(resourceNode.targetObjet))) {
            string3 = resourceNode.objet;
        }
        if (resourceNode.server != null && resourceNode.server instanceof ServerAladin && !this.aladin.dialog.server[this.aladin.dialog.current].verif(1, string3, (String)object, n + "/" + 0)) {
            return;
        }
        String string10 = resourceNode.getScriptCommand();
        if (string10 != null) {
            this.aladin.console.printCommand(string10);
        }
        if (resourceNode.server instanceof ServerAladin) {
            this.aladin.calque.newPlanImage(uRL, 0, string2, string3, (String)object, resourceNode.origin != null && resourceNode.origin.length() > 0 ? resourceNode.origin : (resourceNode.server != null ? resourceNode.server.institute : null), n, 0, null, resourceNode);
        } else {
            ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(uRL.toString(), string2, resourceNode.origin != null && resourceNode.origin.length() > 0 ? resourceNode.origin : (resourceNode.server != null ? resourceNode.server.institute : null), null, resourceNode, null, resourceNode.server != null ? resourceNode.server : null, null, null);
        }
    }

    private String buildStackLabel(ResourceNode resourceNode) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (resourceNode.resol != null && resourceNode.survey != null) {
            if (resourceNode.resol.equals("PLATE")) {
                stringBuffer.append("Pl-");
            } else if (resourceNode.resol.equals("LOW")) {
                stringBuffer.append("Lw-");
            }
        }
        if (resourceNode.survey != null) {
            stringBuffer.append(resourceNode.survey);
        }
        if (resourceNode.epoch != null) {
            stringBuffer.append("." + resourceNode.epoch);
        }
        if (resourceNode.bandPass != null) {
            stringBuffer.append("." + resourceNode.bandPass);
        }
        if (resourceNode.machine != null) {
            stringBuffer.append("." + resourceNode.machine);
        }
        stringBuffer.append("." + resourceNode.name);
        if (!resourceNode.curImgNumber.equals("1") || !resourceNode.maxImgNumber.equals("1")) {
            stringBuffer.append(resourceNode.curImgNumber);
            if (resourceNode.velStep != 0.0) {
                try {
                    double d = Slider.round(resourceNode.beginVel + (double)(Integer.parseInt(resourceNode.curImgNumber) - 1) * resourceNode.velStep, 2);
                    string = "_" + d + "km/s";
                }
                catch (NumberFormatException numberFormatException) {
                    string = "";
                }
                stringBuffer.append(string);
            }
        }
        string = stringBuffer.toString().trim();
        while (string.length() > 0 && string.charAt(0) == '.') {
            string = string.substring(1);
        }
        string = MetaDataTree.replace(string, "..", ".", -1);
        while (string.length() > 0 && string.charAt(string.length() - 1) == '.') {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private String buildQual(ResourceNode resourceNode) {
        StringBuffer stringBuffer = new StringBuffer();
        if (resourceNode.survey != null) {
            stringBuffer.append(resourceNode.survey + " ");
        }
        if (resourceNode.bandPass != null) {
            stringBuffer.append(resourceNode.bandPass + " ");
        }
        if (resourceNode.curMode != null) {
            stringBuffer.append(resourceNode.curMode + " ");
        }
        stringBuffer.append(resourceNode.name + " ");
        return stringBuffer.toString();
    }

    private Coord getPos(ResourceNode resourceNode) {
        if (resourceNode.cutout) {
            Coord coord = null;
            try {
                coord = new Coord(resourceNode.getCutoutTarget());
            }
            catch (Exception exception) {
                try {
                    coord = this.aladin.view.sesame(resourceNode.getCutoutTarget());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return coord;
        }
        if (resourceNode.modes != null && resourceNode.modes.length > 1 && !resourceNode.curMode.equals("ORIGIN")) {
            Coord coord = null;
            try {
                coord = new Coord(resourceNode.getMosaicTarget());
            }
            catch (Exception exception) {
                try {
                    coord = this.aladin.view.sesame(resourceNode.getMosaicTarget());
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return coord;
        }
        if (resourceNode.getFov() == null) {
            return null;
        }
        return new Coord(resourceNode.getFov().alpha, resourceNode.getFov().delta);
    }

    void loadSelected(String string) {
        Vector vector = this.getSelectedLeaves();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResourceNode resourceNode = (ResourceNode)enumeration.nextElement();
            this.load(resourceNode, string, null, this);
        }
    }

    void loadSelected() {
        this.loadSelected(null);
    }

    int nbSelected() {
        return this.getSelectedLeaves().size();
    }

    void clear() {
        ResourceNode resourceNode = new ResourceNode(this.aladin);
        resourceNode.hide = true;
        this.setRoot(resourceNode);
        if (this.sortable) {
            this.indexSort = this.defaultIndexSort;
            this.descSort = this.defaultDescSort;
        }
    }

    protected void load(final ResourceNode resourceNode, final String string, final String string2, final Component component) {
        final String string3 = this.aladin.synchroServer.start("MetaDataTree.load");
        new Thread("LoadResourceNode"){

            @Override
            public void run() {
                try {
                    if (resourceNode.location == null || resourceNode.location.length() == 0) {
                        return;
                    }
                    if (resourceNode.type == 1 || resourceNode.type == 4) {
                        MetaDataTree.this.loadImage(resourceNode, string, string2);
                    } else if (resourceNode.type == 2) {
                        MetaDataTree.this.loadCat(resourceNode, string2);
                    } else if (resourceNode.type == 3) {
                        MetaDataTree.this.loadSpectrum(resourceNode, component);
                    } else if (resourceNode.type == 7) {
                        MetaDataTree.this.loadOther(resourceNode, string2);
                    } else if (resourceNode.indexing != null && resourceNode.indexing.equals("HTML")) {
                        MetaDataTree.this.aladin.glu.showDocument("Http", resourceNode.location, true);
                    }
                }
                finally {
                    MetaDataTree.this.aladin.synchroServer.stop(string3);
                }
            }
        }.start();
        Util.pause(100);
    }

    protected void load(ResourceNode resourceNode, String string) {
        this.load(resourceNode, null, string, null);
    }

    private void loadOther(BasicNode basicNode, String string) {
        if (string == null) {
            string = basicNode.name;
        }
        this.aladin.calque.newPlan(((ResourceNode)basicNode).location, string, null, null, null);
    }

    private void loadSpectrum(ResourceNode resourceNode, Component component) {
        ArrayList<String> arrayList;
        boolean bl = false;
        if (!this.aladin.getMessagingMgr().isRegistered()) {
            bl = true;
        }
        if ((arrayList = this.aladin.getMessagingMgr().getAppsSupporting(resourceNode.getPlasticMsg())) == null || arrayList.size() == 0) {
            bl = true;
        }
        if (bl) {
            System.out.println("Can't load spectrum " + resourceNode.name + " : couldn't find any PLASTIC-compatible spectrum viewer");
        } else {
            this.loadNodeWithPlastic(resourceNode, arrayList.get(0));
        }
    }

    private void loadCat(BasicNode basicNode, String string) {
        this.loadOther(basicNode, string);
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void sort(Object[] objectArray, SortableColumn sortableColumn, boolean bl) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        if (sortableColumn == null) {
            sortableColumn = new SortableColumn(){

                @Override
                public String getColName(ResourceNode resourceNode) {
                    return "";
                }

                @Override
                public int compare(Object object, Object object2, boolean bl) {
                    return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
                }
            };
        }
        MetaDataTree.mergeSort(objectArray2, objectArray, 0, objectArray.length, sortableColumn, bl);
    }

    public static void genericSort(Object[] objectArray, final String string, boolean bl) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        SortableColumn sortableColumn = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                String string2 = (String)resourceNode.properties.get(string);
                return string2 == null ? "" : string2;
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                String string3 = this.getColName(resourceNode).toLowerCase();
                String string2 = this.getColName(resourceNode2).toLowerCase();
                try {
                    Double d = new Double(string3);
                    Double d2 = new Double(string2);
                    return d.compareTo(d2);
                }
                catch (NumberFormatException numberFormatException) {
                    return string3.compareTo(string2);
                }
            }
        };
        MetaDataTree.mergeSort(objectArray2, objectArray, 0, objectArray.length, sortableColumn, bl);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, SortableColumn sortableColumn, boolean bl) {
        int n3;
        int n4 = n2 - n;
        int n5 = n3 = bl ? 1 : -1;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && n3 * sortableColumn.compare(objectArray2[j - 1], objectArray2[j], true) > 0; --j) {
                    MetaDataTree.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n6 = n + n2 >> 1;
        MetaDataTree.mergeSort(objectArray2, objectArray, n, n6, sortableColumn, bl);
        MetaDataTree.mergeSort(objectArray2, objectArray, n6, n2, sortableColumn, bl);
        if (n3 * sortableColumn.compare(objectArray[n6 - 1], objectArray[n6], true) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n4);
            return;
        }
        int n7 = n;
        int n8 = n6;
        for (int i = n; i < n2; ++i) {
            objectArray2[i] = n8 >= n2 || n7 < n6 && n3 * sortableColumn.compare(objectArray[n7], objectArray[n8], true) <= 0 ? objectArray[n7++] : objectArray[n8++];
        }
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (string == null || string2 == null || string3 == null || string2.length() == 0 || n == 0) {
            return string;
        }
        if (string.indexOf(string2) < 0) {
            return string;
        }
        int n2 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n3 = 0;
        int n4 = 0;
        while ((n4 = string.indexOf(string2, n3)) != -1) {
            stringBuffer.append(string.substring(n3, n4)).append(string3);
            n3 = n4 + n2;
            if (--n != 0) continue;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    void setStateChangedListener(MyListener myListener) {
        this.stateChangerLstr = myListener;
    }

    @Override
    public BasicNode searchNodeByName(String string) {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            if (!this.nodeFullTab[i].name.equals(string)) continue;
            return this.nodeFullTab[i];
        }
        return null;
    }

    private ResourceNode searchNodeByName(String string, String string2) {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            boolean bl;
            ResourceNode resourceNode = (ResourceNode)this.nodeFullTab[i];
            boolean bl2 = resourceNode.isLeaf && (resourceNode.machine.indexOf(string) >= 0 || resourceNode.survey.indexOf(string) >= 0);
            boolean bl3 = bl = string2 == null || resourceNode.bandPass != null && resourceNode.bandPass.equalsIgnoreCase(string2);
            if (!bl2 || !bl) continue;
            return resourceNode;
        }
        return null;
    }

    @Override
    public boolean findWidget(String string) {
        return true;
    }

    @Override
    public Point getWidgetLocation(String string) {
        ResourceNode resourceNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/ ");
        string = stringTokenizer.nextToken();
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if ((resourceNode = this.searchNodeByName(string, string2)) != null) {
            return new Point(resourceNode.x - 18, resourceNode.y + 6);
        }
        return null;
    }

    public boolean useColorLabel() {
        return this.colorLabel;
    }

    public void setColorLabel(boolean bl) {
        this.colorLabel = bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        Event event = null;
        if (c == 'c') {
            super.action(event, "Collapse all");
        } else if (c == 'e') {
            super.action(event, "Expand all");
        }
        if (c == 't') {
            super.action(event, "Hierarchical view");
            if (this.stateChangerLstr != null) {
                this.stateChangerLstr.fireStateChange("Hierarchical view");
            }
        } else if (c == 'l') {
            super.action(event, "Flat view");
            if (this.stateChangerLstr != null) {
                this.stateChangerLstr.fireStateChange("Flat view");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    static {
        LABEL_COL = new Color[]{Aladin.BKGD, new Color(249, 188, 97), new Color(208, 160, 224), new Color(192, 229, 107), new Color(255, 124, 116), new Color(127, 183, 255)};
        columns = new SortableColumn[6];
        MetaDataTree.createLabelColors();
        MetaDataTree.columns[0] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                return resourceNode.survey != null ? resourceNode.survey : "";
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                int n = this.getColName(resourceNode).compareTo(this.getColName(resourceNode2));
                if (n != 0 || !bl) {
                    return n;
                }
                n = columns[1].compare(resourceNode, resourceNode2, false);
                if (n != 0) {
                    return n;
                }
                n = columns[2].compare(resourceNode, resourceNode2, false);
                return n;
            }
        };
        MetaDataTree.columns[1] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                String string = "";
                if (resourceNode.bandPass != null) {
                    string = string + resourceNode.bandPass;
                    if (resourceNode.wavelengthExpla != null) {
                        string = string + "(" + resourceNode.wavelengthExpla + ")";
                    } else if (resourceNode.wavelength != null) {
                        string = string + "(" + resourceNode.wavelength + ")";
                    }
                }
                return string;
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                int n = this.getColName(resourceNode).compareTo(this.getColName(resourceNode2));
                if (n != 0 || !bl) {
                    return n;
                }
                n = columns[0].compare(resourceNode, resourceNode2, false);
                if (n != 0) {
                    return n;
                }
                n = columns[2].compare(resourceNode, resourceNode2, false);
                return n;
            }
        };
        MetaDataTree.columns[2] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                if (resourceNode.getFov() == null) {
                    return "";
                }
                return resourceNode.getFov().getSizeStr(resourceNode.cutout);
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                int n;
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                if (resourceNode.getFov() == null) {
                    n = resourceNode2.getFov() == null ? 0 : -1;
                } else if (resourceNode2.getFov() == null) {
                    n = 1;
                } else {
                    double d;
                    double d2 = resourceNode.cutout ? resourceNode.getFov().cutout_x * resourceNode.getFov().cutout_y : resourceNode.getFov().x * resourceNode.getFov().y;
                    double d3 = d = resourceNode2.cutout ? resourceNode2.getFov().cutout_x * resourceNode2.getFov().cutout_y : resourceNode2.getFov().x * resourceNode2.getFov().y;
                    if (d2 == d) {
                        n = 0;
                    } else {
                        int n2 = n = d2 > d ? 1 : -1;
                    }
                }
                if (n != 0 || !bl) {
                    return n;
                }
                n = columns[0].compare(resourceNode, resourceNode2, false);
                if (n != 0) {
                    return n;
                }
                n = columns[1].compare(resourceNode, resourceNode2, false);
                return n;
            }
        };
        MetaDataTree.columns[5] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                return resourceNode.obsDate != null ? resourceNode.obsDate : "";
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                return this.getColName(resourceNode).compareTo(this.getColName(resourceNode2));
            }
        };
        MetaDataTree.columns[4] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                return resourceNode.getPixSize() != null ? resourceNode.getPixSize() : "";
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                int n = resourceNode.getPixSizeDeg() == 0.0 ? (resourceNode2.getPixSizeDeg() == 0.0 ? 0 : -1) : (resourceNode2.getPixSizeDeg() == 0.0 ? 1 : (resourceNode.getPixSizeDeg() == resourceNode2.getPixSizeDeg() ? 0 : (resourceNode.getPixSizeDeg() > resourceNode2.getPixSizeDeg() ? 1 : -1)));
                return n;
            }
        };
        MetaDataTree.columns[3] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode resourceNode) {
                String string = "";
                if (resourceNode.machine != null && resourceNode.machine.length() != 0) {
                    string = string + resourceNode.machine + ".";
                }
                string = string + resourceNode.name;
                return string;
            }

            @Override
            public int compare(Object object, Object object2, boolean bl) {
                ResourceNode resourceNode = (ResourceNode)object;
                ResourceNode resourceNode2 = (ResourceNode)object2;
                return this.getColName(resourceNode).compareTo(this.getColName(resourceNode2));
            }
        };
        firstShow = true;
        sortName = new String[]{"SURVEY", "COLOR", "SIZE", "OBS ID", "RESOL", "DATE"};
        wChar = fm.stringWidth("A");
    }

    class SortFrame
    extends JFrame {
        List leftList;
        List rightList;
        Button arrow;
        Button go;

        public SortFrame(String string) {
            super(string);
            Aladin.setIcon(this);
            this.setBackground(Aladin.BLUE);
            this.setLayout(new BorderLayout());
            this.leftList = new List(15, true);
            this.rightList = new List(15, true);
            this.arrow = new Button("-->");
            this.go = new Button("OK");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            jPanel.add(this.leftList);
            jPanel.add(this.arrow);
            jPanel.add(this.rightList);
            Aladin.makeAdd(this, jPanel, "North");
            Aladin.makeAdd(this, this.go, "South");
        }

        public void updateList() {
            this.leftList.removeAll();
            this.rightList.removeAll();
            ResourceNode resourceNode = null;
            Vector vector = new Vector();
            BasicTree.getAllLeaves(MetaDataTree.this.getRootNode(), vector);
            resourceNode = (ResourceNode)vector.elementAt(0);
            for (int i = 0; i < resourceNode.description.length; ++i) {
                this.leftList.add(resourceNode.description[i]);
            }
        }

        @Override
        public boolean action(Event event, Object object) {
            if (event.target.equals(this.arrow)) {
                String[] stringArray = this.leftList.getSelectedItems();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.rightList.add(stringArray[i]);
                    this.leftList.remove(stringArray[i]);
                }
            } else if (event.target.equals(this.go)) {
                MetaDataTree.this.doSortSiapEvol(this.rightList.getItems());
                this.hide();
            }
            return true;
        }

        @Override
        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                this.hide();
            }
            return super.handleEvent(event);
        }
    }

    public static interface SortableColumn {
        public String getColName(ResourceNode var1);

        public int compare(Object var1, Object var2, boolean var3);
    }
}

