/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class MyBox
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected static final int SAISIE = 0;
    protected static final int AFFICHAGE = 1;
    private static final String LABEL_SAISIE = "SAISIE";
    private static final String LABEL_AFFICHAGE = "AFFICHAGE";
    protected static final int DF = Aladin.SIZE;
    protected static final Font F = Aladin.PLAIN;
    protected static String UNDEF = "";
    protected Aladin aladin;
    protected Text pos;
    protected Text text;
    private int mode = 1;
    private CardLayout cl;
    private JPanel cardPanel;
    protected JComboBox c;
    protected JLabel label;
    static final Font FONT = new Font("Sans serif", 1, 12);

    protected MyBox() {
    }

    protected MyBox(Aladin aladin, String string) {
        this.aladin = aladin;
        this.c = this.createChoice();
        this.c.setFont(this.c.getFont().deriveFont((float)this.c.getFont().getSize() - 1.0f));
        this.c.addMouseListener(this);
        this.pos = new Text("", 30);
        this.pos.setFont(FONT);
        this.pos.setForeground(Color.gray);
        this.pos.addMouseListener(this);
        this.text = new Text("", 30);
        this.text.setFont(FONT);
        this.text.setForeground(Aladin.MYBLUE);
        this.text.addMouseListener(this);
        this.text.addMouseMotionListener(this);
        this.cl = new CardLayout(0, 0);
        this.cardPanel = new JPanel(this.cl);
        this.cardPanel.add(LABEL_AFFICHAGE, this.pos);
        this.cardPanel.add(LABEL_SAISIE, this.text);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.label = new Lab(string);
        jPanel.add((Component)this.label, "West");
        jPanel.add((Component)this.cardPanel, "Center");
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)jPanel, "Center");
        if (!Aladin.OUTREACH) {
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
            jPanel2.add((Component)new Lab(Aladin.chaine.getString("FRAME")), "West");
            jPanel2.add((Component)this.c, "East");
            this.add((Component)jPanel2, "East");
        }
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
    }

    protected JComboBox getComboBox() {
        return this.c;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.text.setEnabled(bl);
        this.text.setBackground(bl ? Color.white : this.getBackground());
        if (!bl) {
            this.text.setText("");
        }
        this.pos.setBackground(bl ? Color.white : this.getBackground());
        this.label.setForeground(bl ? Aladin.DARKBLUE : Color.lightGray);
        this.c.setEnabled(bl);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = this.text.getCursor();
        Cursor cursor2 = this.text.in(mouseEvent.getX(), mouseEvent.getY()) ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(2);
        if (cursor2.equals(cursor)) {
            return;
        }
        this.text.setCursor(cursor2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(Aladin.chaine.getString("LCoord.HELP"));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
        }
        if (this.text.in(mouseEvent.getX(), mouseEvent.getY())) {
            this.reset();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected boolean isPopupVisible() {
        return this.c.isPopupVisible();
    }

    protected JComboBox createChoice() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MyBox.this.actionChoice();
            }
        });
        return jComboBox;
    }

    protected abstract void actionChoice();

    protected void setTextSaisie(String string) {
        this.text.setText(string);
        if (string.length() > 0) {
            this.text.select(0, 0);
        }
    }

    protected void setTextAffichage(String string) {
        this.pos.setText(string);
    }

    protected void reset() {
        this.text.setText("");
        this.pos.setText("");
    }

    protected void readyToClear() {
        this.text.selectAll();
    }

    protected String getTextAffichage() {
        return this.pos.getText().trim();
    }

    protected String getTextSaisie() {
        return this.text.getText().trim();
    }

    protected void setMode(int n) {
        if (this.mode == n) {
            return;
        }
        this.mode = n;
        this.cl.show(this.cardPanel, this.mode == 0 ? LABEL_SAISIE : LABEL_AFFICHAGE);
    }

    protected void setUndef() {
        this.pos.setText(UNDEF);
    }

    protected int getChoiceIndex() {
        return this.c.getSelectedIndex();
    }

    protected void setChoiceIndex(int n) {
        this.c.setSelectedIndex(n);
    }

    protected void sendKey(KeyEvent keyEvent) {
    }

    class Text
    extends JTextField {
        private Dimension dim;
        private Rectangle cross;
        private static final int X = 6;

        Text(String string, int n) {
            super(string, n);
            this.dim = null;
            this.cross = null;
            this.dim = new Dimension(n, super.getPreferredSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        boolean in(int n, int n2) {
            if (this.cross == null || MyBox.this.text.getText().length() == 0) {
                return false;
            }
            return n >= this.cross.x;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.drawCross(graphics, this.getWidth() - 6 - 8, this.getHeight() / 2 - 3);
        }

        private void drawCross(Graphics graphics, int n, int n2) {
            graphics.setColor(Color.white);
            graphics.fillOval(n - 3, n2 - 3, 13, 13);
            graphics.setColor(MyBox.this.text.getText().length() > 0 ? Color.red.darker() : Color.gray);
            graphics.drawLine(n, n2, n + 6, n2 + 6);
            graphics.drawLine(n + 1, n2, n + 6 + 1, n2 + 6);
            graphics.drawLine(n + 2, n2, n + 6 + 2, n2 + 6);
            graphics.drawLine(n + 6, n2, n, n2 + 6);
            graphics.drawLine(n + 6 + 1, n2, n + 1, n2 + 6);
            graphics.drawLine(n + 6 + 2, n2, n + 2, n2 + 6);
            this.cross = new Rectangle(n, n2, 6, 6);
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.getID() == 401 && (n == 38 || n == 40 || n == 34)) {
                MyBox.this.sendKey(keyEvent);
            } else {
                super.processComponentKeyEvent(keyEvent);
            }
        }
    }

    class Lab
    extends JLabel {
        Lab(String string) {
            super(string, 4);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
            this.setFont(Aladin.BOLD);
            this.setForeground(Aladin.DARKBLUE);
        }
    }
}

