/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Plan;
import cds.fits.HeaderFits;
import cds.image.Bzip2;
import cds.tools.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public final class MyInputStream
extends FilterInputStream {
    private static final int BLOCCACHE = 65536;
    public static final long UNKNOWN = 0L;
    public static final long FITS = 1L;
    public static final long JPEG = 2L;
    public static final long GIF = 4L;
    public static final long MRCOMP = 8L;
    public static final long HCOMP = 16L;
    public static final long GZ = 32L;
    public static final long XML = 64L;
    public static final long ASTRORES = 128L;
    public static final long VOTABLE = 256L;
    public static final long AJ = 512L;
    public static final long AJS = 1024L;
    public static final long IDHA = 2048L;
    public static final long SIA_SSA = 4096L;
    public static final long CSV = 8192L;
    public static final long NOTAVAILABLE = 16384L;
    public static final long AJSx = 32768L;
    public static final long PNG = 65536L;
    public static final long XFITS = 131072L;
    public static final long FOV = 262144L;
    public static final long FOV_ONLY = 524288L;
    public static final long CATLIST = 0x100000L;
    public static final long RGB = 0x200000L;
    public static final long BSV = 0x400000L;
    public static final long FITST = 0x800000L;
    public static final long FITSB = 0x1000000L;
    public static final long CUBE = 0x2000000L;
    public static final long SEXTRA = 0x4000000L;
    public static final long HUGE = 0x8000000L;
    public static final long AIPSTABLE = 0x10000000L;
    public static final long IPAC = 0x20000000L;
    public static final long BMP = 0x40000000L;
    public static final long RICE = 0x80000000L;
    public static final long HEALPIX = 0x100000000L;
    public static final long GLU = 0x200000000L;
    public static final long ARGB = 0x400000000L;
    public static final long PDS = 0x800000000L;
    public static final long HPXMOC = 0x1000000000L;
    public static final long DS9REG = 0x2000000000L;
    public static final long SED = 0x4000000000L;
    public static final long BZIP2 = 0x8000000000L;
    public static final long AJTOOL = 0x10000000000L;
    public static final long TAP = 0x20000000000L;
    public static final long OBSTAP = 0x40000000000L;
    public static final long EOF = 0x80000000000L;
    static final String[] FORMAT = new String[]{"UNKNOWN", "FITS", "JPEG", "GIF", "MRCOMP", "HCOMP", "GZIP", "XML", "ASTRORES", "VOTABLE", "AJ", "AJS", "IDHA", "SIA", "CSV", "UNAVAIL", "AJSx", "PNG", "XFITS", "FOV", "FOV_ONLY", "CATLIST", "RGB", "BSV", "FITS-TABLE", "FITS-BINTABLE", "CUBE", "SEXTRACTOR", "HUGE", "AIPSTABLE", "IPAC-TBL", "BMP", "RICE", "HEALPIX", "GLU", "ARGB", "PDS", "HPXMOC", "DS9REG", "SED", "BZIP2", "AJTOOL", "TAP", "OBSTAP", "EOF"};
    private static final int DEFAULT = 0;
    private static final int FITSEND = 1;
    private boolean withBuffer;
    private byte[] cache = null;
    private int offsetCache = 0;
    private int inCache = 0;
    private boolean flagEOF = false;
    private long type = -1L;
    private boolean flagGetType;
    private boolean alreadyRead;
    private long dejaLu;
    private String commentCalib = null;
    private String filename = null;
    private boolean fitsHeadRead;
    public static int NBOPENFILE = 0;
    private byte[] bufRead = new byte[1];
    private static final String SEP = "\t;:,!| /&";
    private char sepCSV = (char)65535;
    private String HEX = "0123456789ABCDEF";
    Hashtable<String, String> avm = null;
    double avmRefWidth = -1.0;
    private int posAfterFitsHead = -1;

    public MyInputStream(InputStream inputStream) {
        this(inputStream, 0L, true);
    }

    public MyInputStream(InputStream inputStream, long l, boolean bl) {
        super(inputStream);
        this.type = l;
        this.withBuffer = bl;
        this.flagGetType = false;
        this.alreadyRead = false;
        this.fitsHeadRead = false;
        this.dejaLu = 0L;
        this.in = inputStream != null && bl && !(inputStream instanceof BufferedInputStream) ? new BufferedInputStream(inputStream) : inputStream;
        ++NBOPENFILE;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public void close() throws IOException {
        --NBOPENFILE;
        this.in.close();
    }

    protected static long NativeImage() {
        return 1073807366L;
    }

    public MyInputStream startRead() throws IOException {
        long l = this.isGZorBzip2();
        if ((l & 0x20L) != 0L) {
            return new MyInputStream(new GZIPInputStream(this), 32L, this.withBuffer);
        }
        if ((l & 0x8000000000L) != 0L) {
            return new MyInputStream(new Bzip2(this), 0x8000000000L, this.withBuffer);
        }
        return this;
    }

    public long getPos() {
        return this.dejaLu;
    }

    public void resetType() {
        this.type = this.type & 0x20L | this.type & 0x20000L;
        this.alreadyRead = false;
        this.flagGetType = false;
    }

    public boolean isHCOMP() throws Exception {
        return (this.getType() & 0x10L) != 0L;
    }

    public boolean isGZ() throws IOException {
        return (this.isGZorBzip2() & 0x20L) != 0L;
    }

    public long isGZorBzip2() throws IOException {
        if (this.flagGetType) {
            return this.type;
        }
        if (this.alreadyRead) {
            return 0L;
        }
        int[] nArray = new int[2];
        if (this.inCache < nArray.length) {
            this.loadInCache(nArray.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.cache[this.offsetCache + i] & 0xFF;
        }
        if (nArray[0] == 31 && nArray[1] == 139) {
            return 32L;
        }
        if (nArray[0] == 66 && nArray[1] == 90) {
            return 0x8000000000L;
        }
        return 0L;
    }

    private void getTypeFitsImg() throws IOException {
        int n;
        int n2;
        int n3;
        if (this.hasFitsKey("NAXIS", "3") && !this.hasFitsKey("NAXIS3", "1") || this.hasFitsKey("NAXIS", "4") && !this.hasFitsKey("NAXIS3", "1") && this.hasFitsKey("NAXIS4", "1")) {
            this.type |= 0x2000000L;
        }
        if (this.hasFitsKey("COLORMOD", "ARGB")) {
            this.type |= 0x400000000L;
        }
        if (this.hasFitsKey("EXTEND", null) || this.hasFitsKey("NAXIS", "0")) {
            this.type |= 0x20000L;
        }
        if (this.hasFitsKey("CTYPE3", "RGB")) {
            this.type |= 0x200000L;
        }
        if ((this.type & 0x2200000L) == 0L) {
            try {
                n3 = Integer.parseInt(this.getFitsValue("NAXIS1"));
                n2 = Integer.parseInt(this.getFitsValue("NAXIS2"));
                n = Integer.parseInt(this.getFitsValue("BITPIX"));
                if ((long)n3 * (long)n2 * (long)(Math.abs(n) / 8) > Aladin.LIMIT_HUGEFILE) {
                    this.type |= 0x8000000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((this.type & 0x20000L) != 0L && (this.hasFitsKey("MOCORDER", null) || this.hasFitsKey("HPXMOC", null) || this.hasFitsKey("HPXMOCM", null) || this.hasFitsKey("ORDERING", "UNIQ") || this.hasFitsKey("ORDERING", "NUNIQ"))) {
            this.type |= 0x1000000000L;
        } else if ((this.hasFitsKey("PIXTYPE", "HEALPIX") || this.hasFitsKey("ORDERING", "NEST") || this.hasFitsKey("ORDERING", "RING")) && !this.hasFitsKey("XTENSION", "IMAGE")) {
            this.type |= 0x100000000L;
        }
        n3 = this.findFitsEnd();
        n2 = this.cache[n3] & 0xFF;
        n = this.cache[n3 + 1] & 0xFF;
        if (n2 == 221 && n == 153) {
            this.type |= 0x10L;
        }
    }

    public long getType() throws Exception {
        return this.getType(0);
    }

    public long getType(int n) throws Exception {
        block48: {
            if (this.flagGetType) {
                return this.type;
            }
            this.flagGetType = true;
            if (this.alreadyRead) {
                return 16384L;
            }
            try {
                int[] nArray = new int[16];
                if (this.inCache < nArray.length) {
                    this.loadInCache(nArray.length);
                }
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.cache[this.offsetCache + i] & 0xFF;
                }
                if (nArray[0] == 31 && nArray[1] == 139) {
                    this.type |= 0x20L;
                    break block48;
                }
                if (Aladin.PROTO && nArray[0] == 66 && nArray[1] == 90) {
                    this.type |= 0x8000000000L;
                    break block48;
                }
                if (nArray[0] == 80 && nArray[1] == 68 && nArray[2] == 83) {
                    this.type |= 0x800000000L;
                    break block48;
                }
                if (nArray[0] == 79 && nArray[1] == 82 && nArray[2] == 68 && nArray[3] == 69 && nArray[4] == 82) {
                    this.type |= 0x1000000000L;
                    break block48;
                }
                if (nArray[0] == 35 && nArray[1] == 32 && nArray[2] == 82 && nArray[3] == 101 && nArray[4] == 103 && nArray[5] == 105 && nArray[6] == 111 && nArray[7] == 110 && nArray[8] == 32 && nArray[9] == 102 && nArray[10] == 105 && nArray[11] == 108 && nArray[12] == 101) {
                    this.type |= 0x2000000400L;
                    break block48;
                }
                if (nArray[0] == 35 && nArray[1] == 72 && nArray[2] == 80 && nArray[3] == 88 && nArray[4] == 77 && nArray[5] == 79 && nArray[6] == 67) {
                    this.type |= 0x1000000000L;
                    break block48;
                }
                if (nArray[0] == 35 && nArray[1] == 77 && nArray[2] == 79 && nArray[3] == 67 && nArray[4] == 79 && nArray[5] == 82 && nArray[6] == 68) {
                    this.type |= 0x1000000000L;
                    break block48;
                }
                if (this.isJsonMoc(nArray)) {
                    this.type |= 0x1000000000L;
                    break block48;
                }
                if (nArray[0] == 255 && nArray[1] == 216) {
                    this.type |= 2L;
                    this.lookForJpegCalib(n);
                    break block48;
                }
                if (nArray[0] == 71 && nArray[1] == 73 && nArray[2] == 70 && nArray[5] == 97) {
                    this.type |= 4L;
                    break block48;
                }
                if (nArray[0] == 137 && nArray[1] == 80 && nArray[2] == 78 && nArray[3] == 71 && nArray[4] == 13 && nArray[5] == 10 && nArray[6] == 26 && nArray[7] == 10) {
                    this.type |= 0x10000L;
                    this.lookForPNGCalib(n);
                    break block48;
                }
                if (nArray[0] == 1 && nArray[1] == 121 && nArray[2] == 1 && nArray[3] == 75 && nArray[4] == 1 && nArray[5] == 121 && nArray[6] == 64) {
                    this.type |= 8L;
                    if (this.lookForSignature("SIMPLE  =", false) > 0) {
                        this.type |= 1L;
                    }
                    break block48;
                }
                if (nArray[0] == 88 && nArray[1] == 84 && nArray[2] == 69 && nArray[3] == 78 && nArray[4] == 83 && nArray[5] == 73 && nArray[6] == 79 && nArray[7] == 78 && nArray[8] == 61 && nArray[11] == 73 && nArray[12] == 77 && nArray[13] == 65 && nArray[14] == 71 && nArray[15] == 69) {
                    this.type |= 1L;
                    this.getTypeFitsImg();
                    break block48;
                }
                if (nArray[0] == 88 && nArray[1] == 84 && nArray[2] == 69 && nArray[3] == 78 && nArray[4] == 83 && nArray[5] == 73 && nArray[6] == 79 && nArray[7] == 78 && nArray[8] == 61 && nArray[11] == 84 && nArray[12] == 65 && nArray[13] == 66 && nArray[14] == 76 && nArray[15] == 69) {
                    this.type |= 0x800000L;
                    break block48;
                }
                if (nArray[0] == 88 && nArray[1] == 84 && nArray[2] == 69 && nArray[3] == 78 && nArray[4] == 83 && nArray[5] == 73 && nArray[6] == 79 && nArray[7] == 78 && nArray[8] == 61 && nArray[11] == 66 && nArray[12] == 73 && nArray[13] == 78 && nArray[14] == 84 && nArray[15] == 65) {
                    this.type |= 0x1000000L;
                    if (this.hasFitsKey("ZCMPTYPE", "RICE_1")) {
                        this.type |= 0x80000000L;
                    } else if (this.hasFitsKey("EXTNAME", "AIPS CC") && this.hasFitsKey("TFIELDS", "3") && this.hasFitsKey("TTYPE2", "DELTAX") && this.hasFitsKey("TUNIT2", "DEGREES") && this.hasFitsKey("TTYPE3", "DELTAY") && this.hasFitsKey("TUNIT3", "DEGREES")) {
                        this.type |= 0x10000000L;
                    }
                    break block48;
                }
                if (nArray[0] == 83 && nArray[1] == 73 && nArray[2] == 77 && nArray[3] == 80 && nArray[4] == 76 && nArray[5] == 69 && nArray[6] == 32 && nArray[7] == 32 && nArray[8] == 61) {
                    this.type |= 1L;
                    this.getTypeFitsImg();
                    break block48;
                }
                if (this.lookForSignature("\n%A", false, this.offsetCache, 2048, false) > 0 && this.lookForSignature("\n%U", false, this.offsetCache, 2048, false) > 0) {
                    this.type |= 0x200000000L;
                    break block48;
                }
                if (this.lookForSignature("<!DOCTYPE ASTRO", false) > 0) {
                    this.type |= 0xC0L;
                    break block48;
                }
                if (this.lookForSignature("<ALADINJAVA", false) > 0) {
                    this.type |= 0x240L;
                    break block48;
                }
                if (this.lookForSignature("<VOTABLE", true) > 0 || this.lookForSignature(":VOTABLE", true) > 0) {
                    this.type |= 0x140L;
                    if (this.lookForSignature("name=\"ObservingProgram\"", true) > 0) {
                        this.type |= 0x840L;
                    }
                    if (this.lookForSignature("name=\"Observation_Group\"", true) > 0) {
                        this.type |= 0x840L;
                    } else if (this.lookForSignature("ucd=\"VOX:Image_Title\"", true) > 0 || this.lookForSignature("ucd=\"VOX:Image_AccessReference\"", true) > 0 || this.lookForSignature("SSAP</INFO>", true) > 0 || this.lookForSignature("utype=\"ssa:Access.Reference\"", true) > 0 || this.lookForSignature("Dataset.DataModel", true) > 0 && this.lookForSignature("Dataset.Length", true) > 0 && this.lookForSignature("Access.Reference", true) > 0 && this.lookForSignature("Access.Format", true) > 0 && this.lookForSignature("DataID.Title", true) > 0) {
                        this.type |= 0x1000L;
                    } else if (this.lookForSignature("name=\"FoVRef\"", true) > 0 || this.lookForSignature("ID=\"FoVRef\"", true) > 0 || this.lookForSignature("utype=\"dal:footprint.geom.id\"", true) > 0) {
                        this.type |= 0x40000L;
                    } else if (this.lookForSignature("utype=\"dal:fov", true) > 0 || this.lookForSignature("utype=\"dal:footprint.geom\"", true) > 0 || this.lookForSignature("utype=\"ivoa:characterization/[ucd=pos]/coverage/support", true) > 0) {
                        this.type |= 0x80000L;
                    } else if (this.lookForSignature("utype=\"photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value", true) > 0) {
                        this.type |= 0x4000000000L;
                    }
                    break block48;
                }
                if (this.lookForSignature("#AJS", true) > 0) {
                    this.type |= 0x400L;
                    break block48;
                }
                int n2 = this.isCSV();
                if (n2 == 1) {
                    this.type |= 0x2000L;
                    break block48;
                }
                if (n2 == 5) {
                    this.type |= 0x10000002000L;
                    break block48;
                }
                if (this.lookForSignature("#CATLIST", true) > 0) {
                    this.type |= 0x100000L;
                    break block48;
                }
                if (this.lookForSignature("^IMAGE", true) > 0) {
                    this.type |= 0x800000000L;
                    break block48;
                }
                if (n2 == 4) {
                    this.type |= 0x20400000L;
                    break block48;
                }
                if (n2 == 3) {
                    this.type |= 0x4400000L;
                    break block48;
                }
                if (n2 == 2) {
                    this.type |= 0x400000L;
                    break block48;
                }
                return 16384L;
            }
            catch (EOFException eOFException) {
                this.type |= 0x80000000000L;
            }
        }
        return this.type;
    }

    public long skipOnNext2880() throws IOException {
        long l = this.getPos();
        if (l % 2880L == 0L) {
            return 0L;
        }
        long l2 = (l / 2880L + 1L) * 2880L - l;
        return this.skip(l2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.alreadyRead = true;
        long l2 = l;
        while (l > 0L) {
            l -= this.skipInternal(l);
        }
        return l2;
    }

    private long skipInternal(long l) throws IOException {
        if (this.inCache > 0) {
            if (l > (long)this.inCache) {
                l = this.inCache;
            }
            this.offsetCache += (int)l;
            this.inCache -= (int)l;
            this.dejaLu += l;
            return l;
        }
        l = super.skip(l);
        this.dejaLu += l;
        return l;
    }

    @Override
    public int available() throws IOException {
        if (this.inCache != 0) {
            return this.inCache;
        }
        return super.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.bufRead, 0, 1);
        return n == -1 ? -1 : this.bufRead[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.alreadyRead = true;
        if (this.cache == null || this.inCache == 0) {
            int n3 = super.read(byArray, n, n2);
            if (n3 < 0) {
                return n3;
            }
            this.dejaLu += (long)n3;
            return n3;
        }
        if (this.inCache < n2) {
            n2 = this.inCache;
        }
        System.arraycopy(this.cache, this.offsetCache, byArray, n, n2);
        this.offsetCache += n2;
        this.inCache -= n2;
        this.dejaLu += (long)n2;
        return n2;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i < 512 ? n2 - i : 512);
            if (n3 != -1) continue;
            throw new EOFException();
        }
    }

    public byte[] readFully() {
        byte[] byArray;
        int n = 8192;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1000);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1000);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            byArray = new byte[n];
            while ((n2 = this.read(byArray, 0, n)) != -1) {
                ++n4;
                arrayList.add(byArray);
                arrayList2.add(new Integer(n2));
                n3 += n2;
                byArray = new byte[n];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray2 = new byte[n3];
        n5 = arrayList.size();
        n2 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            byArray = (byte[])arrayList.get(n4);
            n3 = (Integer)arrayList2.get(n4);
            System.arraycopy(byArray, 0, byArray2, n2, n3);
            n2 += n3;
        }
        return byArray2;
    }

    public String readLine() throws IOException {
        int n;
        try {
            n = this.findSignature("\n", false);
        }
        catch (EOFException eOFException) {
            if (this.inCache == 0) {
                return null;
            }
            n = this.offsetCache + this.inCache;
        }
        String string = new String(this.cache, this.offsetCache, n - this.offsetCache);
        this.dejaLu += (long)(n - this.offsetCache);
        this.inCache -= n - this.offsetCache;
        this.offsetCache = n;
        return string;
    }

    public static String decodeType(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = 1L;
        for (int i = 1; i < FORMAT.length; ++i) {
            if ((l & l2) != 0L && l2 != 0x80000000000L) {
                stringBuilder.append(" " + FORMAT[i]);
            }
            l2 <<= 1;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(FORMAT[0]);
        }
        return stringBuilder.toString();
    }

    private void loadInCache(int n) throws IOException {
        int n2;
        int n3;
        if (this.flagEOF) {
            throw new EOFException();
        }
        if (this.cache == null) {
            this.cache = new byte[65536];
        } else {
            n3 = this.cache.length - (this.offsetCache + this.inCache);
            if (n > n3) {
                n2 = ((this.inCache + n) / 65536 + 1) * 65536;
                byte[] byArray = new byte[n2];
                System.arraycopy(this.cache, this.offsetCache, byArray, 0, this.inCache);
                this.offsetCache = 0;
                this.cache = byArray;
            }
        }
        n2 = this.offsetCache + this.inCache;
        for (int i = 0; i < n; i += n3) {
            n3 = super.read(this.cache, n2, n - i);
            if (n3 == -1) {
                this.flagEOF = true;
                throw new EOFException();
            }
            n2 += n3;
            this.inCache += n3;
        }
    }

    private void substitute(int n, int n2, String string) throws Exception {
        char[] cArray = string.toCharArray();
        if (cArray.length > n2 || n < this.offsetCache) {
            throw new Exception("MyInputStream substitution error");
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < cArray.length) {
            this.cache[n4] = (byte)cArray[n3];
            ++n3;
            ++n4;
        }
        System.arraycopy(this.cache, n + n2, this.cache, n + cArray.length, this.inCache - (n + n2));
        this.inCache -= n2 - cArray.length;
    }

    private boolean isSextra(String string) {
        if (string.length() < 7) {
            return false;
        }
        if (string.charAt(0) != '#') {
            return false;
        }
        try {
            Integer.parseInt(string.substring(1, 5).trim());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static int[] count(String string, boolean bl, boolean bl2) {
        int[] nArray = new int[128];
        boolean bl3 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (bl) {
                if (bl3) {
                    if (c2 == '\\') {
                        ++i;
                    } else if (c2 == '\"') {
                        bl3 = false;
                    }
                } else {
                    boolean bl4 = bl3 = c2 == '\"';
                }
                if (bl3) continue;
            }
            if (bl2 && i == 0 || (c = c2) >= nArray.length) continue;
            char c3 = c;
            nArray[c3] = nArray[c3] + 1;
        }
        return nArray;
    }

    private static int analyseCSV(String[] stringArray, int n) {
        int n2 = MyInputStream.analyseCSV1(stringArray, n, true);
        if (n2 == -1) {
            n2 = MyInputStream.analyseCSV1(stringArray, n, false);
        }
        return n2;
    }

    public static boolean isSimpleDashLine(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    private static int analyseCSV1(String[] stringArray, int n, boolean bl) {
        int n2;
        int[][] nArrayArray = new int[n][];
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == 1 && MyInputStream.isSimpleDashLine(stringArray[n2].trim())) {
                nArrayArray[n2] = nArrayArray[n2 - 1];
                continue;
            }
            if (Aladin.levelTrace >= 4) {
                String string = stringArray[n2];
                if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                    string = string.substring(0, string.length() - 1);
                }
                Aladin.trace(4, "analyseCSV (quoted=" + bl + ") ligne " + n2 + " [" + string + "]");
            }
            nArrayArray[n2] = MyInputStream.count(stringArray[n2], bl, true);
        }
        for (n2 = 0; n2 < SEP.length(); ++n2) {
            int n3;
            char c = SEP.charAt(n2);
            if (nArrayArray[0][c] == 0) continue;
            for (n3 = 1; n3 < n && nArrayArray[n3][c] == nArrayArray[n3 - 1][c]; ++n3) {
            }
            if (n3 != n) continue;
            return c;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("C:\\Users\\Pierre\\Desktop\\Data\\Scuba");
            File[] fileArray = file.listFiles();
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            for (File file2 : fileArray) {
                l2 += file2.length();
                long l3 = System.currentTimeMillis();
                long l4 = System.currentTimeMillis();
                l += l4 - l3;
                if (++n <= 0 || n % 100 != 0) continue;
                System.out.print(".");
            }
            System.out.println("\nn=" + n + " size=" + Util.getUnitDisk(l2) + " tps=" + Util.getTemps(l));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String translateSextraHeader(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            int n = (string2 = stringTokenizer.nextToken()).indexOf(32, 6);
            String string3 = string2.substring(6, n < 0 ? string2.length() : n);
            stringBuilder.append("   " + string3);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private boolean isJsonMoc(int[] nArray) {
        int n = 0;
        block11: for (int i = 0; i < nArray.length; ++i) {
            char c = (char)nArray[i];
            switch (n) {
                case 0: {
                    if (Character.isSpace(c)) continue block11;
                    n = 1;
                }
                case 1: {
                    if (c != '{') {
                        return false;
                    }
                    n = 2;
                    continue block11;
                }
                case 2: {
                    if (Character.isSpace(c)) continue block11;
                    n = 3;
                }
                case 3: {
                    if (c != '\"') {
                        return false;
                    }
                    n = 4;
                    continue block11;
                }
                case 4: {
                    if (c == '\"') {
                        n = 5;
                        continue block11;
                    }
                    if (Character.isDigit(c)) continue block11;
                    return false;
                }
                case 5: {
                    if (Character.isSpace(c)) continue block11;
                    n = 6;
                }
                case 6: {
                    if (c != ':') {
                        return false;
                    }
                    n = 7;
                    continue block11;
                }
                case 7: {
                    if (Character.isSpace(c)) continue block11;
                    n = 8;
                }
                case 8: {
                    return c == '[';
                }
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private int isCSV() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public char getSepCSV() {
        return this.sepCSV;
    }

    private void setSepCSV(char c) {
        this.sepCSV = c;
    }

    private int getLigne(StringBuilder stringBuilder, int n) throws Exception {
        char c;
        do {
            int n2;
            if ((n2 = this.getValAt(n++)) == -1) {
                return -1;
            }
            c = (char)n2;
            if (c == '\r') continue;
            stringBuilder.append(c);
        } while (c != '\n');
        return n;
    }

    private int getValAt(int n) throws Exception {
        try {
            while (this.offsetCache + n >= this.inCache && !this.flagEOF) {
                this.loadInCache(8192);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.offsetCache + n >= this.inCache && this.flagEOF) {
            return -1;
        }
        try {
            return this.cache[this.offsetCache + n] & 0xFF;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String H(int n) {
        return "" + this.HEX.charAt(n / 16) + this.HEX.charAt(n % 16);
    }

    private String ASC(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            char c = (char)byArray[i];
            stringBuilder.append(!Character.isISOControl(c) ? c : (char)'.');
            if (i % 80 != 0 || n2 >= 80 && i <= 0) continue;
            stringBuilder.append("\n        ");
        }
        return stringBuilder + "";
    }

    private String lz77Uncompress(byte[] byArray) throws Exception {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[8192];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inflaterInputStream.read(byArray2)) != -1) {
            String string = new String(byArray2, 0, n);
            stringBuilder.append(string);
        }
        inflaterInputStream.close();
        return stringBuilder.toString();
    }

    private boolean memoPNGCalib(int n, int n2, boolean bl) {
        while (this.cache[n] != 0 && n2 > 1) {
            ++n;
            --n2;
        }
        ++n;
        --n2;
        if (!bl) {
            this.commentCalib = new String(this.cache, n, n2);
        } else {
            try {
                byte[] byArray = new byte[--n2];
                System.arraycopy(this.cache, ++n, byArray, 0, n2);
                this.commentCalib = this.lz77Uncompress(byArray);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                return false;
            }
        }
        if (this.commentCalib.indexOf("CTYPE1") < 0) {
            this.commentCalib = null;
            return false;
        }
        return true;
    }

    private boolean memoJpegCalib(int n, int n2) {
        return this.memoJpegCalib(n, n2, this.cache);
    }

    private boolean memoJpegCalib(int n, int n2, byte[] byArray) {
        this.commentCalib = new String(byArray, n, n2);
        if (this.commentCalib.indexOf("CTYPE1") < 0) {
            this.commentCalib = null;
            return false;
        }
        return true;
    }

    private void memoOneAVM(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        String string = stringBuilder2.toString().trim();
        if (string.length() == 0) {
            return;
        }
        if (this.avm == null) {
            this.avm = new Hashtable(30);
        }
        this.avm.put(stringBuilder.toString().trim(), string);
        if (Aladin.levelTrace >= 3) {
            System.out.println("AVM tag: " + stringBuilder + "=[" + string + "] ");
        }
    }

    private void appendValue(StringBuilder stringBuilder, char c) {
        int n = stringBuilder.length();
        if (c == '\n' || c == '\r') {
            c = (char)32;
        }
        if (n == 0 || !Character.isSpaceChar(c)) {
            stringBuilder.append(c);
            return;
        }
        char c2 = stringBuilder.charAt(n - 1);
        if (Character.isSpaceChar(c2)) {
            return;
        }
        stringBuilder.append(c);
    }

    private boolean memoJpegAVMCalib(int n, int n2) {
        return this.memoJpegAVMCalib(n, n2, this.cache);
    }

    private boolean memoJpegAVMCalib(int n, int n2, byte[] byArray) {
        boolean bl = false;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        this.avm = null;
        this.avmRefWidth = -1.0;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        block10: for (int i = 0; i < n2; ++i) {
            char c = (char)byArray[n + i];
            switch (n3) {
                case 0: {
                    bl7 = bl6 && c == ':';
                    bl6 = bl5 && c == 'm';
                    bl5 = bl4 && c == 'v';
                    bl4 = bl3 && c == 'a';
                    boolean bl8 = bl3 = c == '<' || c == ' ';
                    if (bl3) {
                        boolean bl9 = bl2 = c == ' ';
                    }
                    if (!bl7) continue block10;
                    stringBuilder = new StringBuilder();
                    if (!bl2) {
                        n3 = 1;
                        n5 = 1;
                        continue block10;
                    }
                    n3 = 10;
                    continue block10;
                }
                case 1: {
                    if (c == '>') {
                        n3 = 2;
                        stringBuilder2 = new StringBuilder();
                        continue block10;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
                case 2: {
                    if (c == '<') {
                        n3 = 3;
                        continue block10;
                    }
                    this.appendValue(stringBuilder2, c);
                    continue block10;
                }
                case 3: {
                    n5 = c == '/' ? --n5 : ++n5;
                    n3 = 4;
                    continue block10;
                }
                case 4: {
                    if (c == '>') {
                        if (bl3) {
                            --n5;
                        }
                        if (n5 == 0) {
                            this.memoOneAVM(stringBuilder, stringBuilder2);
                            bl = true;
                            n3 = 0;
                        } else {
                            this.appendValue(stringBuilder2, ' ');
                            n3 = 2;
                        }
                    }
                    bl3 = c == ' ' ? bl3 : c == '/';
                    bl3 = c == '/';
                    continue block10;
                }
                case 10: {
                    if (c == '=') {
                        n3 = 11;
                        stringBuilder2 = new StringBuilder();
                        continue block10;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
                case 11: {
                    if (c != '\"') continue block10;
                    n3 = 12;
                    continue block10;
                }
                case 12: {
                    if (c == '\"') {
                        this.memoOneAVM(stringBuilder, stringBuilder2);
                        bl = true;
                        n3 = 0;
                        continue block10;
                    }
                    this.appendValue(stringBuilder2, c);
                }
            }
        }
        return bl;
    }

    private void createJpegAVMCalib(int n) {
        StringTokenizer stringTokenizer;
        StringBuilder stringBuilder = new StringBuilder(1000);
        double d = 1.0;
        stringBuilder.append("COMMENT FITS header built by Aladin from AVM tags\n");
        String string = this.avm.get("Spatial.CoordsystemProjection");
        if (string == null) {
            string = "TAN";
        }
        String string2 = "RA---";
        String string3 = "DEC--";
        String string4 = this.avm.get("Spatial.CoordinateFrame");
        if (string4 != null) {
            if (string4.equals("GAL")) {
                string2 = "GLON-";
                string3 = "GLAT-";
            } else if (string4.equals("ECL")) {
                string2 = "ELON-";
                string3 = "ELAT-";
            }
            if (string4.equals("SGAL")) {
                string2 = "SLON-";
                string3 = "SLAT-";
            }
        }
        stringBuilder.append("CTYPE1  = '" + string2 + string + "'\n");
        stringBuilder.append("CTYPE2  = '" + string3 + string + "'\n");
        try {
            stringTokenizer = new StringTokenizer(this.avm.get("Spatial.ReferenceDimension"));
            d = (double)n / Double.parseDouble(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringTokenizer = new StringTokenizer(this.avm.get("Spatial.ReferencePixel"));
            stringBuilder.append("CRPIX1  = " + Double.parseDouble(stringTokenizer.nextToken()) * d + "\n");
            stringBuilder.append("CRPIX2  = " + Double.parseDouble(stringTokenizer.nextToken()) * d + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringTokenizer = new StringTokenizer(this.avm.get("Spatial.ReferenceValue"));
            stringBuilder.append("CRVAL1  = " + stringTokenizer.nextToken() + "\n");
            stringBuilder.append("CRVAL2  = " + stringTokenizer.nextToken() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringTokenizer = new StringTokenizer(this.avm.get("Spatial.Scale"));
            stringBuilder.append("CDELT1  = " + Double.parseDouble(stringTokenizer.nextToken()) / d + "\n");
            stringBuilder.append("CDELT2  = " + Double.parseDouble(stringTokenizer.nextToken()) / d + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringTokenizer = new StringTokenizer(this.avm.get("Spatial.CDMatrix"));
            stringBuilder.append("CD1_1   = " + stringTokenizer.nextToken() + "\n");
            stringBuilder.append("CD1_2   = " + stringTokenizer.nextToken() + "\n");
            stringBuilder.append("CD2_1   = " + stringTokenizer.nextToken() + "\n");
            stringBuilder.append("CD2_2   = " + stringTokenizer.nextToken() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        string4 = this.avm.get("Spatial.Rotation");
        if (string4 != null) {
            stringBuilder.append("CROTA2  = " + string4 + "\n");
        }
        if ((string4 = this.avm.get("Spatial.Equinox")) != null) {
            stringBuilder.append("EQUINOX = " + string4 + "\n");
        }
        if ((string4 = this.avm.get("Spatial.CoordinateFrame")) != null && (string4.equals("FK4") || string4.equals("FK5") || string4.equals("ICRS"))) {
            stringBuilder.append("RADECSYS= " + string4 + "\n");
        }
        stringBuilder.append("COMMENT Original AVM tags:\n");
        Enumeration<String> enumeration = this.avm.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = enumeration.nextElement();
            String string6 = this.avm.get(string5);
            string4 = "COMMENT " + string5 + "=" + string6 + "\n";
            if (string4.length() > 80) {
                string4 = string4.substring(0, 79) + "\n";
            }
            stringBuilder.append(string4);
        }
        this.commentCalib = stringBuilder.toString();
    }

    protected void jpegCalibAddNAXIS(int n, int n2) {
        if (this.avm != null) {
            this.createJpegAVMCalib(n);
        }
        if (this.commentCalib == null) {
            return;
        }
        this.commentCalib = "SIMPLE  = T\nBITPIX  = 8\nNAXIS   = 2\nNAXIS1  = " + n + "\nNAXIS2  = " + n2 + "\n" + this.commentCalib;
    }

    protected FrameHeaderFits createFrameHeaderFitsFromCommentCalib(Plan plan) {
        return new FrameHeaderFits(plan, this.commentCalib);
    }

    public HeaderFits createHeaderFitsFromCommentCalib(int n, int n2) throws Exception {
        HeaderFits headerFits;
        try {
            headerFits = new HeaderFits(this.commentCalib);
        }
        catch (Exception exception) {
            this.jpegCalibAddNAXIS(n, n2);
            headerFits = new HeaderFits(this.commentCalib);
        }
        return headerFits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderFits fastExploreCommentOrAvmCalib(String string) throws Exception {
        HeaderFits headerFits;
        block11: {
            headerFits = null;
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
                if ((this.type & 2L) != 0L) {
                    this.fastExploreJpg(randomAccessFile);
                    break block11;
                }
                HeaderFits headerFits2 = null;
                return headerFits2;
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return headerFits;
    }

    private boolean fastExploreJpg(RandomAccessFile randomAccessFile) throws Exception {
        int n;
        randomAccessFile.seek(2L);
        while ((n = randomAccessFile.read()) != -1) {
            byte[] byArray;
            if (n != 255) {
                return false;
            }
            int n2 = randomAccessFile.read();
            int n3 = randomAccessFile.read() << 8 | randomAccessFile.read();
            long l = randomAccessFile.getFilePointer();
            if (n2 == 225) {
                byArray = new byte[n3 - 2];
                randomAccessFile.readFully(byArray);
                if (this.memoJpegAVMCalib(0, byArray.length, byArray)) {
                    return true;
                }
            } else if (n2 == 254) {
                byArray = new byte[n3 - 2];
                randomAccessFile.readFully(byArray);
                if (this.memoJpegCalib(0, byArray.length, byArray)) {
                    return true;
                }
            }
            randomAccessFile.seek(l + (long)n3 - 2L);
        }
        return false;
    }

    public boolean hasCommentCalib() {
        return this.commentCalib != null || this.avm != null;
    }

    public boolean hasCommentAVM() {
        return this.avm != null;
    }

    private boolean lookForJpegCalib(int n) {
        block10: {
            int n2 = 2;
            try {
                while (this.getValAt(n2) == 255 && (n <= 0 || this.inCache < n)) {
                    int n3 = this.getValAt(n2 + 1);
                    int n4 = this.getValAt(n2 + 2) << 8 | this.getValAt(n2 + 3);
                    try {
                        while (this.offsetCache + n2 + 2 + n4 >= this.inCache) {
                            this.loadInCache(8192);
                        }
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    if (Aladin.levelTrace == 6) {
                        Aladin.trace(6, "(" + n2 + ") Segment JPEG " + this.H(this.getValAt(n2)) + " " + this.H(this.getValAt(n2 + 1)) + " " + n4 + " octets : ");
                        Aladin.trace(6, this.ASC(this.cache, this.offsetCache + n2 + 8, n4 > 128 ? 128 : n4));
                    }
                    if (n3 == 225) {
                        this.memoJpegAVMCalib(this.offsetCache + n2 + 4, n4 - 2);
                    } else if (n3 == 254 && this.memoJpegCalib(this.offsetCache + n2 + 4, n4 - 2)) {
                        return true;
                    }
                    n2 += n4 + 2;
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block10;
                exception.printStackTrace();
            }
        }
        return false;
    }

    private boolean lookForPNGCalib(int n) {
        block15: {
            boolean bl = true;
            int n2 = 8;
            boolean bl2 = true;
            try {
                while (bl && (n <= 0 || this.inCache < n)) {
                    int n3 = this.getValAt(n2) << 24 | this.getValAt(n2 + 1) << 16 | this.getValAt(n2 + 2) << 8 | this.getValAt(n2 + 3);
                    String string = new String(new char[]{(char)this.getValAt(n2 + 4), (char)this.getValAt(n2 + 5), (char)this.getValAt(n2 + 6), (char)this.getValAt(n2 + 7)});
                    try {
                        if (bl2) {
                            while (this.offsetCache + n2 + 8 + n3 >= this.inCache) {
                                this.loadInCache(8192);
                            }
                        } else if (this.offsetCache + n2 + 8 + n3 >= this.inCache) {
                            bl = false;
                        }
                    }
                    catch (EOFException eOFException) {
                        bl2 = false;
                    }
                    if (Aladin.levelTrace == 6) {
                        Aladin.trace(6, "(" + n2 + ") Segment PNG " + string + " " + n3 + " octets : ");
                        Aladin.trace(6, this.ASC(this.cache, this.offsetCache + n2 + 8, n3 > 128 ? 128 : n3));
                    }
                    if (string.equals("tEXt") && this.memoPNGCalib(this.offsetCache + n2 + 8, n3, false)) {
                        return true;
                    }
                    if (string.equals("zTXt")) {
                        if (this.memoPNGCalib(this.offsetCache + n2 + 8, n3, true)) {
                            return true;
                        }
                    } else if (string.equals("IEND")) {
                        bl = false;
                    }
                    n2 += n3 + 12;
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block15;
                exception.printStackTrace();
            }
        }
        return false;
    }

    private int lookForSignature(String string, boolean bl) throws IOException {
        return this.lookForSignature(string, bl, this.offsetCache, false);
    }

    private int lookForSignature(String string, boolean bl, int n, boolean bl2) throws IOException {
        return this.lookForSignature(string, bl, n, -1, bl2);
    }

    private int lookForSignature(String string, boolean bl, int n, int n2, boolean bl2) throws IOException {
        int n3;
        boolean bl3 = false;
        if (n2 >= 0 && n >= n2) {
            return -1;
        }
        if (this.offsetCache + this.inCache - n < 65526) {
            try {
                int n4 = this.offsetCache;
                this.loadInCache(65526);
                if (this.offsetCache == 0) {
                    n -= n4;
                }
            }
            catch (EOFException eOFException) {
                bl3 = true;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        char[] cArray = string.toCharArray();
        int n5 = n == 0 && cArray[0] == '\n' && cArray.length > 1 ? 1 : 0;
        for (n3 = n - this.offsetCache; n5 < cArray.length && n3 < this.inCache; ++n3) {
            char c = cArray[n5];
            while (n3 < this.inCache && this.isSpace((char)this.cache[this.offsetCache + n3])) {
                ++n3;
            }
            char c2 = (char)this.cache[this.offsetCache + n3];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c == c2) {
                ++n5;
            } else {
                if (n5 > 0) {
                    --n3;
                }
                n5 = 0;
            }
            while (n5 < cArray.length && this.isSpace(cArray[n5])) {
                ++n5;
            }
        }
        if (n5 == cArray.length) {
            return this.offsetCache + n3;
        }
        if (bl3 && bl2) {
            throw new EOFException();
        }
        return -1;
    }

    private final boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean isFitsVal(char c) {
        return !this.isSpace(c) && c != '/' && c != '\'';
    }

    private int findFitsEnd() throws IOException {
        if (this.fitsHeadRead) {
            return this.posAfterFitsHead;
        }
        this.posAfterFitsHead = this.findSignature("END", false, 1);
        this.fitsHeadRead = true;
        return this.posAfterFitsHead;
    }

    private boolean hasFitsKey(String string, String string2) throws IOException {
        if (!this.fitsHeadRead) {
            this.findFitsEnd();
        }
        int n = string2 == null ? -1 : string2.length();
        int n2 = this.offsetCache;
        while ((n2 = this.lookForSignature(string + "=", false, n2, false)) >= 0) {
            int n3 = n2;
            if ((n3 - 9) % 80 != 0) continue;
            if (n == -1) {
                return true;
            }
            while (!this.isFitsVal((char)this.cache[n3]) && n3 < n2 + 71) {
                ++n3;
            }
            int n4 = 0;
            while (n4 < n && string2.charAt(n4) == (char)this.cache[n3]) {
                ++n4;
                ++n3;
            }
            if (n4 != n || this.isFitsVal((char)this.cache[n3])) continue;
            return true;
        }
        return false;
    }

    private String getFitsValue(String string) throws IOException {
        if (!this.fitsHeadRead) {
            this.findFitsEnd();
        }
        int n = this.offsetCache;
        while ((n = this.lookForSignature(string + "=", false, n, false)) >= 0) {
            char c;
            int n2 = n;
            if ((n2 - 9) % 80 != 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            while (!this.isFitsVal((char)this.cache[n2]) && n2 < n + 71) {
                ++n2;
            }
            while (this.isFitsVal(c = (char)this.cache[n2])) {
                stringBuilder.append(c);
                ++n2;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private int findSignature(String string, boolean bl) throws IOException {
        return this.findSignature(string, bl, 0);
    }

    private int findSignature(String string, boolean bl, int n) throws IOException {
        int n2;
        int n3 = this.offsetCache;
        while (true) {
            if ((n2 = this.lookForSignature(string, bl, n3, true)) < 0) {
                n3 = this.offsetCache + this.inCache;
                continue;
            }
            if (n == 1) {
                if ((n2 - string.length()) % 80 == 0) {
                    int n4 = (n2 / 80 + 1) * 80;
                    if (this.inCache < n4 + 2) {
                        this.loadInCache(n4 + 2 - this.inCache);
                    }
                    return n4;
                }
                n3 = n2;
                n2 = -1;
            }
            if (n2 >= 0) break;
        }
        return n2;
    }
}

