/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.ActionExecutor;
import cds.aladin.Aladin;
import cds.aladin.ComponentLocator;
import cds.aladin.FilterProperties;
import cds.aladin.ScriptFactory;
import cds.aladin.TranslationScript;
import cds.tools.Util;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MyRobot {
    static Robot robot;
    static boolean robotCompatible;
    static ActionExecutor ae;
    Aladin a;
    private ScriptFactory scriptFact;
    static Point lastLoc;
    static final int NBSTEPS100 = 10;
    private static Dimension screenSize;

    public MyRobot(Aladin aladin) {
        MyRobot.createRobot();
        this.scriptFact = new ScriptFactory();
        this.a = aladin;
    }

    public static void createRobot() {
        if (robot != null) {
            return;
        }
        try {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        catch (AWTException aWTException) {
            robotCompatible = false;
        }
    }

    public boolean executeCommand(String string, String string2) {
        TranslationScript translationScript = this.scriptFact.getScript(string, string2);
        if (translationScript == null) {
            Aladin.trace(3, "No robot task found for command " + string + ".\n" + string + " will be executed as a normal script command.");
            return false;
        }
        ae = new ActionExecutor(translationScript.actions, this.a);
        ae.execute();
        return true;
    }

    public static void info(String string, final Aladin aladin) {
        Object object;
        JFrame jFrame = aladin.command.robotInfo;
        JTextArea jTextArea = aladin.command.infoTxt;
        if (aladin.command.robotInfo == null) {
            aladin.command.robotInfo = new JFrame(){

                @Override
                public boolean handleEvent(Event event) {
                    if (event.id == 401 && event.key == 27 && aladin.command.robotMode) {
                        aladin.stopRobot(this);
                        return true;
                    }
                    if (event.id == 201) {
                        this.hide();
                    }
                    return super.handleEvent(event);
                }
            };
            Util.setCloseShortcut(aladin.command.robotInfo, false, aladin);
            Aladin.setIcon(aladin.command.robotInfo);
            jFrame = aladin.command.robotInfo;
            jFrame.setLayout(new BorderLayout(0, 10));
            aladin.command.infoTxt = new JTextArea("", 10, 50);
            jFrame.add((Component)new JScrollPane(aladin.command.infoTxt), "Center");
            aladin.command.infoTxt.setWrapStyleWord(true);
            aladin.command.infoTxt.setLineWrap(true);
            jTextArea = aladin.command.infoTxt;
            object = new JLabel("Press [ESC] to stop the demonstration", 0);
            ((JComponent)object).setFont(Aladin.BOLD);
            ((JComponent)object).setBackground(Aladin.BLUE);
            jFrame.add((Component)object, "South");
            jFrame.pack();
            jFrame.setLocation(0, 100);
            jTextArea.setFont(Aladin.BOLD);
            jTextArea.setForeground(Color.blue);
        }
        Object object2 = object = aladin.command.curTuto != null ? aladin.command.curTuto : "Info";
        if (!jFrame.getTitle().equals(object)) {
            jFrame.setTitle((String)object);
        }
        jFrame.setVisible(true);
        jFrame.toFront();
        FilterProperties.insertInTA(jTextArea, "\n\n", jTextArea.getText().length());
        MyRobot.type(string, jTextArea);
    }

    private static double dist(Point point, Point point2) {
        return Math.sqrt(Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0));
    }

    protected void reset() {
        lastLoc = null;
    }

    public static void moveTo(int n, int n2, Aladin aladin) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        Point point = new Point(n, n2);
        if (lastLoc == null) {
            ComponentLocator componentLocator = new ComponentLocator();
            Point point2 = componentLocator.getLocation(aladin);
            Dimension dimension = aladin.f.getSize();
            lastLoc = new Point(point2.x + dimension.width / 2, point2.y + dimension.height / 2);
        }
        int n3 = (int)MyRobot.dist(point, lastLoc) * 10 / 100;
        for (int i = 0; i < n3; ++i) {
            int n4 = MyRobot.lastLoc.x + i * (point.x - MyRobot.lastLoc.x) / n3;
            int n5 = MyRobot.lastLoc.y + i * (point.y - MyRobot.lastLoc.y) / n3;
            robot.mouseMove(n4, n5);
            if ((double)i >= 0.9 * (double)n3 || (double)i <= 0.1 * (double)n3) {
                robot.delay(80);
                continue;
            }
            robot.delay(30);
        }
        robot.mouseMove(point.x, point.y);
        lastLoc = point;
    }

    public static void press(int n, int n2, Component component) {
        MyRobot.press(new Point(n, n2), component);
    }

    private static void press(Point point, int n, Component component) {
        Component component2;
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        robot.mouseMove(point.x / 2, point.y / 2);
        if (component != null && (component2 = MyRobot.getRootParent(component)) instanceof JFrame) {
            JFrame jFrame = (JFrame)component2;
            jFrame.toFront();
        }
        robot.mouseMove(point.x, point.y);
        robot.mousePress(16);
        robot.delay(n);
        robot.mouseRelease(16);
    }

    public static void press(Point point, Component component) {
        MyRobot.press(point, 1500, component);
    }

    public static void select(String string, Component component, Point point) {
        if (!(component instanceof JComboBox)) {
            return;
        }
        MyRobot.press(point, 0, component);
        robot.delay(300);
        Integer n = null;
        boolean bl = true;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl) {
            ((JComboBox)component).setSelectedItem(n);
        } else {
            ((JComboBox)component).setSelectedItem(string);
        }
        component.doLayout();
        robot.keyPress(10);
        robot.keyRelease(10);
        robot.delay(300);
        component.repaint();
    }

    public static void toFront(Component component) {
        if (!(component instanceof JFrame)) {
            return;
        }
        ((JFrame)component).toFront();
    }

    public static void type(String string, Component component) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        if (component != null) {
            component.requestFocus();
        }
        if (component instanceof JTextField || component instanceof JTextArea) {
            robot.keyPress(32);
            robot.keyRelease(32);
            robot.keyPress(8);
            robot.keyRelease(8);
        }
        Random random = new Random();
        for (int i = 0; i < string.length(); ++i) {
            if (component == null) continue;
            if (component instanceof JTextField) {
                ((JTextField)component).setText(string.substring(0, i));
                ((JTextField)component).setCaretPosition(i);
            } else if (component instanceof JTextArea) {
                ((JTextArea)component).setText(string.substring(0, i));
                ((JTextArea)component).setCaretPosition(i);
            }
            int n = random.nextInt(140) + 50;
            if (n > 160) {
                n += 50;
            }
            robot.delay(n);
        }
        if (component != null) {
            if (component instanceof JTextField) {
                ((JTextField)component).setText(string);
                ((JTextField)component).setCaretPosition(string.length());
            } else if (component instanceof JTextArea) {
                ((JTextArea)component).setText(string);
                ((JTextArea)component).setCaretPosition(string.length());
            }
        }
    }

    private static void type(String string, JTextArea jTextArea) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        if (jTextArea == null) {
            return;
        }
        Random random = new Random();
        for (int i = 0; i < string.length(); ++i) {
            jTextArea.append("" + string.charAt(i));
            jTextArea.setCaretPosition(jTextArea.getDocument().getLength());
            int n = random.nextInt(140) + 50;
            if (n > 160) {
                n += 50;
            }
            robot.delay(n);
        }
        jTextArea.setCaretPosition(jTextArea.getDocument().getLength());
    }

    public static void adjustPos(Component component) {
        if (screenSize == null) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (!(component instanceof JFrame)) {
            return;
        }
        JFrame jFrame = (JFrame)component;
        Point point = jFrame.getLocation();
        Dimension dimension = jFrame.getSize();
        if (point.x < 0 || point.y < 0 || point.x + dimension.width > MyRobot.screenSize.width || point.y + dimension.height > MyRobot.screenSize.height) {
            jFrame.setLocation(MyRobot.screenSize.width / 2 - dimension.width / 2, MyRobot.screenSize.height / 2 - dimension.height / 2);
        }
        jFrame.toFront();
    }

    public static void pause(int n) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        robot.delay(n);
    }

    private static Component getRootParent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        return component2;
    }

    static {
        robotCompatible = true;
    }
}

