/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.TreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class MyTree
extends JTree
implements Iterable<TreeNode> {
    protected String info;
    protected String info1;
    protected DefaultMutableTreeNode root;
    private Aladin aladin;

    protected MyTree(Aladin aladin) {
        this.aladin = aladin;
        this.createTree();
    }

    protected DefaultMutableTreeNode getRoot() {
        if (this.root == null) {
            this.root = new DefaultMutableTreeNode(new TreeNode(this.aladin, "root", null, "", ""));
        }
        return this.root;
    }

    private void createTree() {
        this.root = this.getRoot();
        ((DefaultTreeModel)this.getModel()).setRoot(this.root);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        NoeudRenderer noeudRenderer = new NoeudRenderer();
        this.setCellRenderer(noeudRenderer);
        this.setCellEditor(new NoeudEditor(this));
        this.setEditable(true);
    }

    protected void freeTree() {
        if (this.root != null && this.root.getChildCount() == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TreeNode(this.aladin, "root", null, "", ""));
        ((DefaultTreeModel)this.getModel()).setRoot(defaultMutableTreeNode);
        this.root = defaultMutableTreeNode;
    }

    protected synchronized void updateTree(Enumeration enumeration) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (TreeNode treeNode : this) {
            arrayList.add(treeNode);
        }
        this.freeTree();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            int n = arrayList.indexOf(treeNode);
            if (n >= 0) {
                TreeNode treeNode2 = (TreeNode)arrayList.get(n);
                treeNode.setCheckBox(treeNode2.isCheckBoxSelected());
            }
            this.createTreeBranch(this.root, treeNode, 0);
        }
        this.defaultExpand();
    }

    @Override
    public Iterator<TreeNode> iterator() {
        return new TreeIterator();
    }

    protected void populateTree(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            this.createTreeBranch(this.root, treeNode, 0);
        }
        this.defaultExpand();
    }

    public void reset() {
        for (TreeNode treeNode : this) {
            treeNode.setCheckBox(false);
        }
        this.validate();
    }

    public void submit() {
        boolean bl = false;
        for (TreeNode treeNode : this) {
            if (!treeNode.isCheckBoxSelected()) continue;
            this.submit(treeNode);
            bl = true;
        }
        if (!bl) {
            this.warning();
        }
        this.reset();
    }

    protected void warning() {
    }

    protected void updateColor() {
    }

    private void submit(TreeNode treeNode) {
        treeNode.submit();
    }

    protected void createTreeBranch(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode, int n) {
        int n2;
        int n3 = n;
        do {
            n3 = n2 = treeNode.path.indexOf(47, n3);
            if (n2 > 1 && treeNode.path.charAt(n2 - 1) == '\\') {
                ++n3;
                continue;
            }
            n3 = -1;
        } while (n3 != -1);
        String string = n2 < 0 ? treeNode.path.substring(n) : treeNode.path.substring(n, n2);
        ((TreeNode)defaultMutableTreeNode.getUserObject()).noCheckbox();
        try {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            Enumeration<javax.swing.tree.TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                TreeNode treeNode2 = (TreeNode)defaultMutableTreeNode2.getUserObject();
                if (string.equals(treeNode2.label)) break;
                defaultMutableTreeNode2 = null;
            }
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(n2 != -1 ? new TreeNode(this.aladin, "", null, string, "") : treeNode);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                if (n2 != -1) {
                    this.createTreeBranch(defaultMutableTreeNode2, treeNode, n2 + 1);
                }
            } else if (n2 != -1) {
                this.createTreeBranch(defaultMutableTreeNode2, treeNode, n2 + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireTreeChanged() {
        ((DefaultTreeModel)this.getModel()).reload();
    }

    protected boolean removeTreeBranch(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        boolean bl = false;
        Enumeration<javax.swing.tree.TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            TreeNode treeNode = (TreeNode)defaultMutableTreeNode2.getUserObject();
            String string2 = treeNode.getID();
            if (string2 != null && string2.equals(string)) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                bl = true;
                break;
            }
            if (!this.removeTreeBranch(defaultMutableTreeNode2, string) || defaultMutableTreeNode.getChildCount() != 0) continue;
            defaultMutableTreeNode.remove(defaultMutableTreeNode2);
            bl = true;
            break;
        }
        return bl;
    }

    protected void defaultExpand() {
        this.expandPath(new TreePath(this.root));
        Enumeration<javax.swing.tree.TreeNode> enumeration = this.root.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.isLeaf()) continue;
            this.collapsePath(new TreePath(defaultMutableTreeNode));
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.updateColor();
        super.paint(graphics);
    }

    class NoeudEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        JTree tree;
        NoeudRenderer renderer;
        TreeNode n1;

        public NoeudEditor(JTree jTree) {
            this.renderer = new NoeudRenderer();
            this.n1 = null;
            this.tree = jTree;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                TreePath treePath = this.tree.getPathForLocation(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
                TreeNode treeNode = (TreeNode)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                return treeNode.hasCheckBox();
            }
            return false;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            TreeNode treeNode;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            this.n1 = treeNode = (TreeNode)defaultMutableTreeNode.getUserObject();
            if (treeNode != null && treeNode.hasCheckBox()) {
                if (treeNode.isOk()) {
                    treeNode.checkbox.setForeground(Color.black);
                } else {
                    treeNode.checkbox.setForeground(Color.lightGray);
                }
                return treeNode.getPanel();
            }
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
            if (treeNode.isOk()) {
                component.setForeground(Color.black);
            } else {
                component.setForeground(Color.lightGray);
            }
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.n1;
        }
    }

    class NoeudRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color textForeground = UIManager.getColor("Tree.textForeground");
        Color textBackground = UIManager.getColor("Tree.textBackground");

        NoeudRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            TreeNode treeNode = (TreeNode)defaultMutableTreeNode.getUserObject();
            if (treeNode != null && treeNode.hasCheckBox()) {
                if (treeNode.isOk()) {
                    treeNode.checkbox.setForeground(Color.black);
                } else {
                    treeNode.checkbox.setForeground(Color.lightGray);
                }
                JPanel jPanel = treeNode.getPanel();
                if (bl) {
                    jPanel.setForeground(this.selectionForeground);
                    jPanel.setBackground(this.selectionBackground);
                } else {
                    jPanel.setForeground(this.textForeground);
                    jPanel.setBackground(this.textBackground);
                }
                return jPanel;
            }
            Component component = this.nonLeafRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (treeNode.isOk()) {
                component.setForeground(Color.black);
            } else {
                component.setForeground(Color.lightGray);
            }
            return component;
        }
    }

    class TreeIterator
    implements Iterator<TreeNode> {
        private Enumeration e;

        TreeIterator() {
            this.e = MyTree.this.root.preorderEnumeration();
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public TreeNode next() {
            return (TreeNode)((DefaultMutableTreeNode)this.e.nextElement()).getUserObject();
        }

        @Override
        public void remove() {
        }
    }
}

