/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.aladin.prop.Propable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public abstract class Obj
implements Propable {
    public static final int OVAL = 0;
    public static final int SQUARE = 1;
    public static final int CIRCLE = 2;
    public static final int RHOMB = 3;
    public static final int CROSS = 4;
    public static final int TRIANGLE = 5;
    public static final int PLUS = 6;
    public static final int CIRCLES = 7;
    public static final int POINT = 8;
    public static final int DOT = 9;
    public static final int SOLIDOVAL = 10;
    public static final int SOLIDSQUARE = 11;
    public static final int SOLIDCIRCLE = 12;
    public static final int SOLIDRHOMB = 13;
    public static final int SOLIDTRIANGLE = 14;
    public static final int RETICULE = 15;
    protected static final int XY = 1;
    protected static final int RADE = 2;
    protected static final int RADE_COMPUTE = 4;
    protected static final int XY_COMPUTE = 8;
    protected static final byte SELECT = 1;
    protected static final byte TAG = 2;
    protected static final byte VISIBLE = 4;
    protected static final byte WITHLABEL = 8;
    protected static final byte HIGHLIGHT = 16;
    protected static final byte WITHSTAT = 32;
    protected static final byte LOCKED = 64;
    protected Plan plan;
    public double raj = Double.NaN;
    public double dej;
    public String id;
    protected byte flags = (byte)4;

    @Override
    public boolean hasProp() {
        return this.plan != null && this.plan.type != 10;
    }

    @Override
    public Vector<Prop> getProp() {
        Vector<Prop> vector = new Vector<Prop>();
        JLabel jLabel = new JLabel("\"" + this.getObjType() + "\" object in plane: \"" + this.plan.getLabel() + "\"");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setFont(jLabel.getFont().deriveFont(14.0f));
        vector.add(Prop.propFactory("object", "", null, jLabel, null, null));
        final Obj obj = this;
        final JTextField jTextField = new JTextField(20);
        PropAction propAction = new PropAction(){

            @Override
            public int action() {
                jTextField.setText(Obj.this.plan.aladin.localisation.getLocalisation(obj));
                return 1;
            }
        };
        PropAction propAction2 = new PropAction(){

            @Override
            public int action() {
                jTextField.setForeground(Color.black);
                String string = Obj.this.plan.aladin.localisation.getLocalisation(obj);
                try {
                    String string2 = jTextField.getText();
                    if (string2.equals(string)) {
                        return -1;
                    }
                    Coord coord = new Coord(jTextField.getText());
                    if (("" + coord).indexOf("--") >= 0) {
                        throw new Exception();
                    }
                    coord = Obj.this.plan.aladin.localisation.frameToICRS(coord);
                    Obj.this.setRaDec(coord.al, coord.del);
                    return 1;
                }
                catch (Exception exception) {
                    jTextField.setForeground(Color.red);
                    jTextField.setText(string);
                    return 0;
                }
            }
        };
        vector.add(Prop.propFactory("coord", "Coord", "Object position", jTextField, propAction, propAction2));
        if (this.id != null && this.id.length() > 0) {
            final JLabel jLabel2 = new JLabel(this.id);
            PropAction propAction3 = new PropAction(){

                @Override
                public int action() {
                    jLabel2.setText(Obj.this.id);
                    return 1;
                }
            };
            vector.add(Prop.propFactory("id", "Info", "associated information", jLabel2, propAction3, null));
        }
        return vector;
    }

    protected void setSelect(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public Color getColor() {
        return this.plan.c;
    }

    public void setColor() throws Exception {
        throw new Exception("Not specifical color property");
    }

    public boolean hasPhot() {
        return false;
    }

    public boolean hasPhot(ViewSimple viewSimple) {
        return false;
    }

    public final boolean isSelected() {
        return (this.flags & 1) != 0;
    }

    public double getRa() {
        return this.raj;
    }

    public double getDec() {
        return this.dej;
    }

    public String getInfo() {
        return this.id;
    }

    public Iterator<Obj> iterator() {
        return null;
    }

    public String getCommand() {
        return null;
    }

    public boolean hasSurface() {
        return false;
    }

    public double[] getStatistics(AladinData aladinData) throws Exception {
        return this.getStatistics(aladinData.plan);
    }

    protected double[] getStatistics(Plan plan) throws Exception {
        throw new Exception("no statistics available");
    }

    public double getRadius() {
        return 0.0;
    }

    public double getDistance(Obj obj) {
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        coord.al = this.raj;
        coord.del = this.dej;
        coord2.al = obj.raj;
        coord2.del = obj.dej;
        return Coord.getDist(coord, coord2);
    }

    public String getXMLMetaData() {
        return null;
    }

    public String[] getValues() {
        return null;
    }

    public String[] getNames() {
        return null;
    }

    public String[] getUnits() {
        return null;
    }

    public String[] getDataTypes() {
        return null;
    }

    public String[] getUCDs() {
        return null;
    }

    public String[] getArraysizes() {
        return null;
    }

    public String[] getWidths() {
        return null;
    }

    public String[] getPrecisions() {
        return null;
    }

    public int getSize() {
        return 0;
    }

    public int indexOf(String string) {
        return -1;
    }

    public void setColumn(int n, String string, String string2, String string3, int n2) {
    }

    public boolean setValue(int n, String string) {
        return false;
    }

    public void setShape(int n) {
    }

    public void setColor(Color color) {
    }

    public void setInfo(String string) {
        this.id = string;
    }

    public String getObjType() {
        return "";
    }

    public String getSexa() {
        return Coord.getSexa(this.raj, this.dej);
    }

    public InputStream getVOTable() throws Exception {
        throw new Exception("Not a source");
    }

    public void setSelected(boolean bl) {
        this.plan.aladin.view.setSelected(this, bl);
    }

    public void setHighlighted(boolean bl) {
    }

    public void setRaDec(double d, double d2) {
        this.raj = d;
        this.dej = d2;
    }

    public void setXY(double d, double d2) {
        this.setPosition(this.plan.aladin.view.getCurrentView(), d, d2);
    }

    protected abstract void setPosition(ViewSimple var1, double var2, double var4);

    protected abstract void deltaPosition(ViewSimple var1, double var2, double var4);

    protected abstract void deltaRaDec(double var1, double var3);

    protected abstract void setText(String var1);

    protected abstract Point getViewCoord(ViewSimple var1, int var2, int var3);

    protected abstract boolean inside(ViewSimple var1, double var2, double var4);

    protected abstract boolean in(ViewSimple var1, double var2, double var4);

    protected abstract boolean inBout(ViewSimple var1, double var2, double var4);

    protected Rectangle getClip(ViewSimple viewSimple) {
        return this.extendClip(viewSimple, null);
    }

    protected abstract Rectangle extendClip(ViewSimple var1, Rectangle var2);

    protected boolean inClip(ViewSimple viewSimple, Rectangle rectangle) {
        if (rectangle == null) {
            return true;
        }
        Rectangle rectangle2 = this.getClip(viewSimple);
        if (rectangle2 == null) {
            return true;
        }
        return Obj.intersectRect(rectangle, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    protected void remove() {
    }

    protected void projection(ViewSimple viewSimple) {
    }

    protected abstract boolean draw(Graphics var1, ViewSimple var2, int var3, int var4);

    protected abstract void writeLink(OutputStream var1, ViewSimple var2) throws Exception;

    protected abstract void drawSelect(Graphics var1, ViewSimple var2);

    protected abstract void info(Aladin var1);

    protected abstract void status(Aladin var1);

    protected String getSpecificAJInfo() {
        return this.id;
    }

    protected void setSpecificAJInfo(String string) {
        this.id = string == null || string.length() == 0 ? null : string;
    }

    protected abstract void setVisibleGenerique(boolean var1);

    protected abstract void switchSelect();

    protected abstract Plan getPlan();

    protected abstract boolean cutOn();

    protected final double mouseDist(ViewSimple viewSimple) {
        return 10.0;
    }

    protected static final Rectangle unionRect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null) {
            return rectangle;
        }
        return Obj.unionRect(rectangle, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    protected static final Rectangle unionRect(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null) {
            return new Rectangle(n, n2, n3, n4);
        }
        int n5 = Math.max(rectangle.x + rectangle.width, n + n3);
        int n6 = Math.max(rectangle.y + rectangle.height, n2 + n4);
        rectangle.x = Math.min(rectangle.x, n);
        rectangle.y = Math.min(rectangle.y, n2);
        rectangle.width = n5 - rectangle.x;
        rectangle.height = n6 - rectangle.y;
        return rectangle;
    }

    protected static final boolean intersectRect(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null) {
            return false;
        }
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        int n7 = rectangle.x + rectangle.width - 1;
        int n8 = rectangle.y + rectangle.height - 1;
        return !(n < rectangle.x && n5 < rectangle.x || n > n7 && n5 > n7 || n2 < rectangle.y && n6 < rectangle.y || n2 > n8 && n6 > n8);
    }

    public String toString() {
        return "(" + this.raj + "," + this.dej + ") -> " + this.id;
    }
}

