/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyIcon;
import cds.aladin.Plan;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;

public class Oeil
extends MyIcon {
    private static final int[][] TX = new int[][]{{0, 5, 9}, {1, 2, 4}, {1, 6, 8}, {1, 10, 12}, {2, 0, 1}, {2, 5, 6}, {2, 9, 9}, {2, 13, 14}, {3, 5, 6}, {3, 9, 9}, {4, 5, 9}, {5, 0, 1}, {5, 6, 8}, {5, 13, 14}, {6, 2, 4}, {6, 10, 12}, {7, 5, 9}};
    protected String LABEL = Aladin.chaine.getString("OEIL");

    protected Oeil(Aladin aladin) {
        super(aladin, 29, 24);
    }

    protected static void drawOeil(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < TX.length; ++i) {
            graphics.drawLine(TX[i][1] + n, TX[i][0] + n2, TX[i][2] + n, TX[i][0] + n2);
        }
    }

    private boolean isAvailable() {
        if (this.aladin.calque == null || this.aladin.calque.isFree()) {
            return false;
        }
        if (this.isActive()) {
            return true;
        }
        Plan plan = this.aladin.calque.getPlanBase();
        if (plan == null || !plan.isPixel()) {
            return false;
        }
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        int n = 0;
        for (int i = 0; i < this.aladin.calque.plan.length; ++i) {
            Plan plan2 = this.aladin.calque.plan[i];
            if (plan2.hasError() || !plan2.active || plan2.getOpacityLevel() < 0.1f || plan2 == plan || !plan2.hasNoReduction() && !plan.hasNoReduction() && !plan.projd.agree(plan2.projd, viewSimple)) continue;
            ++n;
        }
        return n > 0;
    }

    private boolean isActive() {
        return this.aladin.calque.hasClinDoeil();
    }

    private boolean isMouseIn() {
        return false;
    }

    @Override
    protected void drawLogo(Graphics graphics) {
        int n = 5;
        int n2 = 2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.W, this.H);
        Oeil.drawOeil(graphics, n, n2, !this.isAvailable() ? Aladin.MYGRAY : (this.isActive() ? Color.red : (this.isMouseIn() ? Color.blue : Color.black)));
        graphics.setColor(this.isAvailable() ? Color.black : Aladin.MYGRAY);
        graphics.setFont(Aladin.SPLAIN);
        graphics.drawString(this.LABEL, this.W / 2 - graphics.getFontMetrics().stringWidth(this.LABEL) / 2, this.H - 2);
    }

    @Override
    protected void submit() {
        this.aladin.calque.clinDoeil();
        this.aladin.calque.repaintAll();
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("OEILH");
    }

    @Override
    protected String Help() {
        return Aladin.chaine.getString("OEILH");
    }
}

