/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.Cercle;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FootprintBean;
import cds.aladin.FootprintParser;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanField;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Source;
import cds.aladin.Status;
import cds.aladin.Tag;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.TableParser;
import cds.xml.TableParserConsumer;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class Pcat
implements TableParserConsumer {
    static String OUTOFMEMORY;
    static String CATABORT;
    static final int DEFAULTBLOC = 200;
    static final int MAXBLOC = 100000;
    protected Obj[] o;
    protected int nb_o;
    Color c;
    int nbTable = 0;
    int iz = -1;
    int nId = -1;
    int nIdVraisemblance = 0;
    boolean badRaDecDetection;
    boolean flagVOTable = false;
    boolean flagLabelFromData = false;
    protected StringBuffer parsingInfo = null;
    protected StringBuffer description = null;
    private final boolean[] drawnInViewSimple = new boolean[16];
    Calque calque;
    Plan plan;
    Status status;
    Aladin aladin;
    protected Projection[] projpcat = new Projection[16];
    String catalog;
    String table;
    double rajc;
    double dejc;
    double rm;
    public Legende leg = null;
    Vector vField = new Vector(10);
    boolean flagXY;
    boolean flagTarget;
    boolean flagEndResource;
    boolean flagFirstRecord = true;
    double minRa;
    double maxRa;
    double minDec;
    double maxDec;
    private Vector<String> group = null;
    boolean[] hiddenField;
    boolean firstTrace = true;
    private int indexAccessUrl = -1;
    private int indexAccessFormat = -1;
    private int indexOID = -1;
    private TableParser res;
    private StringBuffer line = new StringBuffer(500);
    private Legende genericLeg = null;
    private int nextID = 0;
    protected boolean removable = false;

    protected static void createChaine(Chaine chaine) {
        OUTOFMEMORY = chaine.getString("POOUTOFMEMORY");
        CATABORT = chaine.getString("POCATABORT");
    }

    protected Pcat(Plan plan, Color color, Calque calque, Status status, Aladin aladin) {
        this.aladin = aladin;
        this.status = status;
        this.calque = calque;
        this.plan = plan;
        this.c = color;
        this.nb_o = 0;
    }

    protected void free() {
        this.nb_o = 0;
        this.o = null;
    }

    protected Pcat(Aladin aladin) {
        this.aladin = aladin;
        this.nb_o = 0;
    }

    protected Pcat(PlanBG planBG) {
        this.plan = planBG;
        this.aladin = planBG.aladin;
        this.nb_o = 0;
    }

    protected Obj[] getObj() {
        return this.o;
    }

    protected void reallocObjetCache() {
        for (int i = 0; i < this.nb_o; ++i) {
            if (!(this.o[i] instanceof Position)) continue;
            ((Position)this.o[i]).createCacheXYVP();
        }
    }

    protected boolean isDrawnInSimpleView(int n) {
        return this.drawnInViewSimple[n];
    }

    protected void resetDrawnInView(ViewSimple viewSimple) {
        this.drawnInViewSimple[viewSimple.n] = false;
    }

    protected void projection(ViewSimple viewSimple) {
        long l = Util.getTime();
        this.drawnInViewSimple[viewSimple.n] = false;
        if (viewSimple.isFree()) {
            return;
        }
        Projection projection = viewSimple.getProj();
        if (this.plan.proj[viewSimple.n] == projection && Projection.isOk(projection) && (!(this.plan instanceof PlanBGCat) || this.plan instanceof PlanBGCat && this.projpcat[viewSimple.n] == projection)) {
            this.drawnInViewSimple[viewSimple.n] = true;
            return;
        }
        if (!(!Projection.isOk(projection) || this.plan.type == 9 || this.plan.type == 10 || this.plan.isSimpleCatalog() && (this.plan.hasXYorig || viewSimple.isPlotView()) || projection.agree(this.plan.projd, viewSimple))) {
            return;
        }
        this.plan.proj[viewSimple.n] = projection;
        this.projpcat[viewSimple.n] = projection;
        for (int i = 0; i < this.nb_o; ++i) {
            try {
                this.o[i].projection(viewSimple);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        viewSimple.newView();
        this.drawnInViewSimple[viewSimple.n] = true;
        long l2 = Util.getTime();
        this.plan.statTimeComputing = l2 - l;
        ++this.plan.statNbComputing;
    }

    protected void setCoord(Projection projection) {
        if (!this.plan.hasXYorig) {
            System.err.println("Recalibration on a no-XYlocked planed !!! Aborted");
            return;
        }
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (viewSimple == null) {
            System.out.println("Y a un probs !");
        }
        Aladin.trace(3, "Recalibration \"" + projection.label + "\" XY->ra/dec on \"" + this.plan.label + "\"");
        for (int i = 0; i < this.nb_o; ++i) {
            Position position = (Position)this.o[i];
            position.xv[viewSimple.n] = position.x;
            position.yv[viewSimple.n] = projection.r1 - position.y;
            position.setCoord(viewSimple, projection);
        }
        viewSimple.newView(1);
    }

    @Override
    public void startResource(String string) {
        if (this.plan.label.equals("PLASTIC") && string != null && string.length() > 0) {
            this.plan.setLabel(string);
        }
        this.catalog = this.plan.label;
        this.table = this.plan.label;
    }

    @Override
    public void setFilter(String string) {
        this.plan.addFilter(string);
    }

    @Override
    public void setResourceInfo(String string, String string2) {
        if (this.description == null) {
            this.description = new StringBuffer();
        }
        if (string.equals("NAME")) {
            this.catalog = string2;
            if (this.plan.label == null || this.plan.label.length() == 0) {
                this.plan.setLabel(string2);
            }
            this.description.append("\nRESOURCE name: " + string2 + "\n");
        } else if (string.equals("TITLE")) {
            this.description.append("        title: " + string2 + "\n");
        } else if (string.equals("DESCRIPTION")) {
            this.description.append(string2 + "\n");
        }
    }

    @Override
    public void endResource() {
        this.flagEndResource = true;
        if (this.plan instanceof PlanBGCat) {
            return;
        }
        if (!this.flagTarget && !this.flagXY && this.nb_o > 0) {
            this.computeTarget();
        }
        this.postJob(this.rajc, this.dejc, this.rm, true);
    }

    protected void postJob(double d, double d2, double d3, boolean bl) {
        if (this.plan.type == 14) {
            return;
        }
        if (bl) {
            ((PlanCatalog)this.plan).setSourceType(Source.getDefaultType(this.nb_o));
        }
        if (this.flagXY) {
            this.plan.hasXYorig = true;
            this.plan.error = Plan.NOREDUCTION;
            return;
        }
        int n = Projection.getDefaultType(d3 / 60.0);
        this.plan.setNewProjD(new Projection(null, 3, d, d2, d3 * 2.0, 250.0, 250.0, 500.0, 0.0, false, n, Calib.FK5));
        this.plan.co = new Coord(d, d2);
    }

    @Override
    public void startTable(String string) {
        Aladin.trace(3, "startTable " + string);
        if (this.plan.label.equals("PLASTIC") && string != null && string.length() > 0) {
            this.plan.setLabel(string);
            this.catalog = this.plan.label;
            this.table = this.plan.label;
        }
        if (string != null && string.length() > 0) {
            this.table = string;
        }
        this.flagFirstRecord = true;
        this.flagXY = false;
        this.vField = new Vector(10);
        this.nId = -1;
        this.nIdVraisemblance = 0;
        this.group = null;
    }

    private void addGroup(String string) {
        if (string == null) {
            this.group = null;
            return;
        }
        if (this.group == null) {
            this.group = new Vector();
        }
        this.group.addElement(string);
    }

    @Override
    public void setTableInfo(String string, String string2) {
        if (this.description == null) {
            this.description = new StringBuffer();
        }
        if (string.equals("NAME")) {
            this.table = string2;
            this.description.append("  TABLE name: " + string2 + "\n");
        } else if (string.equals("TITLE")) {
            this.description.append("       title: " + string2 + "\n");
        } else if (string.equals("DESCRIPTION")) {
            this.description.append(string2 + "\n");
        } else if (string.equals("GROUP")) {
            this.addGroup(string2);
        } else if (string.equals("__XYPOS") && string2.equals("true")) {
            this.flagXY = true;
        }
    }

    @Override
    public void endTable() {
    }

    @Override
    public void setField(Field field) {
        Aladin.trace(3, "setField " + field);
        if (this.nIdVraisemblance == 0) {
            int n = this.vField.size();
            if (field.ucd != null && field.ucd.equalsIgnoreCase("meta.id;meta.main") && this.nIdVraisemblance < 40) {
                this.nIdVraisemblance = 40;
                this.nId = n;
            } else if (field.ucd != null && (field.ucd.equals("ID_MAIN") || field.ucd.startsWith("meta.id")) && this.nIdVraisemblance < 30) {
                this.nIdVraisemblance = 30;
                this.nId = n;
            } else if (field.name != null && (field.name.equalsIgnoreCase("name") || field.name.equalsIgnoreCase("designation")) && this.nIdVraisemblance < 20) {
                this.nIdVraisemblance = 20;
                this.nId = n;
            } else if (!(field.name == null || field.name.length() <= 1 || field.name.charAt(0) != 'I' && field.name.charAt(0) != 'i' || field.name.charAt(1) != 'D' && field.name.charAt(1) != 'd' || this.nIdVraisemblance >= 20)) {
                this.nIdVraisemblance = 10;
                this.nId = n;
            }
        }
        this.vField.addElement(field);
    }

    private int getFieldIndex(String string) {
        Field field;
        Enumeration enumeration = this.vField.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            field = (Field)enumeration.nextElement();
            if (field.name != null && field.name.equals(string)) {
                return n;
            }
            ++n;
        }
        n = 0;
        while (enumeration.hasMoreElements()) {
            field = (Field)enumeration.nextElement();
            if (field.ID != null && field.ID.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String dollarSub(String string, String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (n == 1) {
            n = 2;
        }
        block7: for (int i = 0; i <= cArray.length; ++i) {
            char c = i == cArray.length ? (char)'\u0000' : cArray[i];
            switch (n2) {
                case 0: {
                    if (n == 2 && c == '?') {
                        n = 1;
                    }
                    if (c != '$') continue block7;
                    n2 = 1;
                    stringBuffer.append(cArray, n3, i - n3);
                    n3 = i;
                    continue block7;
                }
                case 1: {
                    n4 = i;
                    if (c == '{') {
                        n2 = 10;
                        bl = true;
                        continue block7;
                    }
                    n2 = 2;
                    bl = false;
                    continue block7;
                }
                case 10: {
                    if (c != '}') continue block7;
                    n2 = 3;
                    continue block7;
                }
                case 2: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue block7;
                    n2 = 3;
                    continue block7;
                }
                case 3: {
                    String string2;
                    int n5;
                    boolean bl2 = false;
                    if (bl) {
                        ++n4;
                    }
                    int n6 = i - n4 - 1;
                    boolean bl3 = bl2 = n == 1;
                    if (cArray[n4] == '-') {
                        bl2 = false;
                        ++n4;
                        --n6;
                    }
                    if (cArray[n4] == '+') {
                        bl2 = true;
                        ++n4;
                        --n6;
                    }
                    if (cArray[n4] == '*') {
                        ++n4;
                        --n6;
                    }
                    if ((n5 = this.getFieldIndex(string2 = new String(cArray, n4, n6))) < 0) {
                        n2 = 0;
                        continue block7;
                    }
                    stringBuffer.append(bl2 ? URLEncoder.encode(stringArray[n5]) : stringArray[n5]);
                    n3 = bl ? i : i - 1;
                    n2 = 0;
                    --i;
                }
            }
        }
        stringBuffer.append(cArray, n3, cArray.length - n3);
        return stringBuffer.toString();
    }

    protected void setGenericLegende(Legende legende) {
        this.genericLeg = legende;
    }

    @Override
    public void setRecord(double d, double d2, String[] stringArray) {
        String string = null;
        try {
            String string2;
            Object object;
            Object object2;
            int n;
            int n2;
            if (this.flagFirstRecord) {
                this.firstTrace = true;
                this.indexAccessUrl = -1;
                this.indexAccessFormat = -1;
                n2 = this.vField.size();
                Vector<Field> vector = new Vector<Field>(n2);
                this.hiddenField = new boolean[n2];
                Enumeration enumeration = this.vField.elements();
                this.indexOID = -1;
                int n3 = -1;
                int n4 = -1;
                n = -1;
                int n5 = -1;
                object2 = null;
                object = null;
                int n6 = 0;
                while (enumeration.hasMoreElements()) {
                    Field field = (Field)enumeration.nextElement();
                    if (field != null) {
                        if (this.indexOID == -1 && field.name != null && field.name.equals("_OID")) {
                            this.indexOID = n6;
                        }
                        if (field.name != null) {
                            if (field.name.equals("_RAJ2000")) {
                                n5 = n6;
                                object2 = field;
                            } else if (field.name.equals("_DEJ2000")) {
                                n = n6;
                                object = field;
                            } else if (field.name.equals("RAJ2000")) {
                                n4 = n6;
                            } else if (field.name.equals("DEJ2000")) {
                                n3 = n6;
                            } else if (field.name.equals("RA(ICRS)")) {
                                n4 = n6;
                            } else if (field.name.equals("DE(ICRS)")) {
                                n3 = n6;
                            }
                        }
                        if (field.type != null && (field.type.indexOf("hidden") >= 0 || field.type.indexOf("trigger") >= 0)) {
                            this.hiddenField[n6] = true;
                            field.visible = false;
                        }
                        vector.addElement(field);
                    }
                    ++n6;
                }
                if (n4 != -1 && n3 != -1 && n5 != -1 && n != -1) {
                    this.hiddenField[n] = true;
                    this.hiddenField[n5] = true;
                    ((Field)object).visible = false;
                    ((Field)object2).visible = false;
                }
                if (this.genericLeg != null) {
                    this.leg = this.genericLeg;
                } else {
                    this.leg = new Legende(vector);
                    this.leg.name = this.table;
                }
                if (this.group != null) {
                    this.leg.setGroup(this.group);
                }
                ++this.nbTable;
                this.flagFirstRecord = false;
            }
            if (stringArray == null) {
                return;
            }
            if (this.nb_o == this.o.length) {
                this.nextIndex();
                --this.nb_o;
            }
            Util.resetString(this.line);
            if (this.catalog != null && this.catalog.equals("Simbad")) {
                this.line.append("<&_SIMBAD |Simbad>");
            } else if (this.catalog != null && (this.catalog.equals("NED") || this.catalog.equals("Ned"))) {
                this.line.append("<&_NED |NED>");
            } else {
                this.line = this.line.append("<&_getReadMe " + this.table + " |" + this.table + ">");
            }
            n2 = stringArray.length;
            int n7 = -1;
            for (int i = 0; i < n2; ++i) {
                if (stringArray[i] == null) {
                    stringArray[i] = "";
                }
                if (this.indexOID >= 0 && i == this.indexOID) {
                    string = stringArray[i];
                }
                String string3 = stringArray[i].trim();
                if (this.leg == null || !this.leg.hasInfo(++n7) || string3.length() == 0 || string3.equals("0") || string3.equals("-")) {
                    this.line.append("\t" + (string3.length() == 0 ? " " : stringArray[i]));
                    continue;
                }
                String string4 = this.leg.getHref(n7);
                String string5 = this.leg.getGref(n7);
                String string6 = this.leg.getRefText(n7);
                object2 = this.leg.getRefValue(n7);
                if (string4 == null && (stringArray[i].startsWith("http://") || stringArray[i].startsWith("https://") || stringArray[i].startsWith("ftp://"))) {
                    string4 = stringArray[i];
                    if (object2 == null && (object = this.leg.getUCD(n7)) != null && ((String)object).indexOf("Image_AccessReference") >= 0) {
                        object2 = "image/fits";
                    }
                    if (object2 == null && (object = this.leg.getUtype(n7)) != null && ((String)object).indexOf("ssa:Access.Reference") >= 0) {
                        object2 = "spectrum/???";
                    }
                    if (object2 == null && (object = this.leg.getUCD(n7)) != null && ((String)object).indexOf("meta.ref.url;datalink.preview") >= 0) {
                        object2 = "image/???";
                    }
                }
                Object object3 = string5 != null ? string5 : (object = string4 != null ? "Http " + string4 : null);
                if (object != null && object2 != null && ((String)object2).startsWith("spectr") && ((String)object2).indexOf(47) > 0) {
                    object = "\u00a3" + (String)object;
                } else if (object != null && object2 != null && ((String)object2).indexOf(47) > 0) {
                    object = "^" + (String)object;
                }
                String string7 = stringArray[i];
                this.line.append("\t");
                if (object != null) {
                    this.line.append("<&" + this.dollarSub((String)object, stringArray, string4 != null ? 1 : 0));
                    if (string7 != null) {
                        this.line.append("|" + this.dollarSub(string7, stringArray, 0));
                    }
                    this.line.append(">");
                    continue;
                }
                this.line.append(string7);
            }
            if (this.flagXY || !this.flagTarget) {
                if (d < this.minRa) {
                    this.minRa = d;
                }
                if (d > this.maxRa) {
                    this.maxRa = d;
                }
                if (d2 < this.minDec) {
                    this.minDec = d2;
                }
                if (d2 > this.maxDec) {
                    this.maxDec = d2;
                }
            }
            String string8 = string2 = this.nId >= 0 ? stringArray[this.nId] : "Source #" + (this.nb_o + 1);
            if (this.firstTrace) {
                Aladin.trace(3, "setRecord " + (string != null ? "(oid=" + string + ")" : "") + " \"" + string2 + "\" " + (this.flagXY ? "XY" : "pos") + "=(" + d + "," + d2 + ") [" + this.line + "]");
                this.firstTrace = false;
                this.indexAccessUrl = this.leg.find("access_url");
                this.indexAccessFormat = this.leg.find("access_format");
                if (this.indexAccessFormat == -1) {
                    this.indexAccessFormat = this.leg.find("content_type");
                }
            }
            Source source = this.flagXY ? new Source(this.plan, d, d2, 0.0, 0.0, 1, string2, this.line.toString(), this.leg) : new Source(this.plan, d, d2, string2, this.line.toString(), this.leg);
            if (string != null) {
                source.setOID(string);
            }
            this.o[this.nb_o++] = source;
            n = source.findUtype("stc:ObservationLocation.AstroCoordArea.Region");
            if (n < 0) {
                n = source.findUtype("Char.SpatialAxis.Coverage.Support.Area");
            }
            if (n >= 0) {
                try {
                    source.setFootprint(source.getValue(n));
                    source.setIdxFootprint(n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.indexAccessFormat >= 0 && this.indexAccessUrl >= 0) {
                try {
                    String string9 = source.getCodedValue(this.indexAccessFormat);
                    String string10 = source.getCodedValue(this.indexAccessUrl);
                    if (string10.startsWith("<&") && string9.length() > 0 && string9.indexOf("html") < 0 && string9.indexOf("plain") < 0) {
                        object2 = "^";
                        if (string9.startsWith("spectr") && string9.indexOf(47) > 0) {
                            object2 = "\u00a3";
                        }
                        string10 = "<&" + (String)object2 + string10.substring(2);
                        source.setValue(this.indexAccessUrl, string10);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (Aladin.isSlow && this.nb_o % 200 == 0) {
                Util.pause(10);
            }
        }
        catch (Exception exception) {
            System.out.println("setRecord (3p) " + exception);
            exception.printStackTrace();
        }
    }

    protected boolean hasCatalogInfo() {
        return this.parsingInfo != null || this.description != null;
    }

    protected boolean hasSelectedOrTaggedObj() {
        Iterator<Obj> iterator = this.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (obj.isSelected()) {
                return true;
            }
            if (!(obj instanceof Source) || !((Source)obj).isTagged()) continue;
            return true;
        }
        return false;
    }

    protected void seeCatalogInfo() {
        if (this.parsingInfo == null && this.description == null) {
            return;
        }
        JFrame jFrame = new JFrame("Catalog information");
        Util.setCloseShortcut(jFrame, false, this.aladin);
        jFrame.setIconImage(this.aladin.getImagette("AladinIconSS.gif"));
        JTextArea jTextArea = new JTextArea(25, 80);
        jTextArea.setFont(Aladin.COURIER);
        if (this.description != null) {
            jTextArea.setText(this.description.toString() + "\n\n");
        }
        if (this.parsingInfo != null) {
            jTextArea.append("Parsing information:\n\n" + this.parsingInfo.toString());
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Aladin.makeAdd(jFrame, jScrollPane, "Center");
        jFrame.pack();
        jFrame.show();
    }

    @Override
    public void tableParserWarning(String string) {
        if (string.startsWith("!!!")) {
            if (string.indexOf("OVERFLOW") >= 0) {
                this.plan.error = string;
            }
            if (string.indexOf("ERROR") >= 0) {
                this.plan.error = string;
            }
        }
        this.tableParserInfo(string);
    }

    @Override
    public void tableParserInfo(String string) {
        if (this.parsingInfo == null) {
            this.parsingInfo = new StringBuffer();
        }
        this.parsingInfo.append(string + "\n");
        Aladin.trace(3, string);
    }

    @Override
    public void setTableRaDecXYIndex(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = this.vField.size();
        if (n >= 0 && n < n7) {
            ((Field)this.vField.elementAt((int)n)).coo = 1;
        }
        if (n2 >= 0 && n2 < n7) {
            ((Field)this.vField.elementAt((int)n2)).coo = 2;
        }
        if (n3 >= 0 && n3 < n7) {
            ((Field)this.vField.elementAt((int)n3)).coo = 3;
        }
        if (n4 >= 0 && n4 < n7) {
            ((Field)this.vField.elementAt((int)n4)).coo = 4;
        }
        if (n5 >= 0 && n5 < n7) {
            ((Field)this.vField.elementAt((int)n5)).coo = 5;
        }
        if (n6 >= 0 && n6 < n7) {
            ((Field)this.vField.elementAt((int)n6)).coo = 6;
        }
        this.badRaDecDetection = bl;
        this.plan.hasPM = -1;
    }

    @Override
    public void setTarget(String string) {
        double[] dArray = this.parseTarget(string);
        if (dArray == null) {
            return;
        }
        this.flagTarget = true;
        this.rajc = dArray[0];
        this.dejc = dArray[1];
        this.rm = dArray[2];
    }

    protected int tableParsing(MyInputStream myInputStream, String string) throws Exception {
        boolean bl;
        this.o = new Obj[200];
        this.nb_o = 0;
        if (this.plan != null) {
            this.catalog = this.plan.label;
            this.table = this.plan.label;
        }
        this.leg = null;
        this.flagTarget = false;
        this.minDec = Double.MAX_VALUE;
        this.minRa = Double.MAX_VALUE;
        this.maxDec = -1.7976931348623157E308;
        this.maxRa = -1.7976931348623157E308;
        this.hiddenField = null;
        this.flagEndResource = false;
        long l = System.currentTimeMillis();
        long l2 = myInputStream.getType();
        if ((l2 & 0x1800000L) != 0L) {
            this.plan.headerFits = new FrameHeaderFits(this.plan, myInputStream);
            this.res = new TableParser(this.aladin, this, ((PlanCatalog)this.plan).headerFits.getHeaderFits(), this.plan.flagSkip);
            bl = this.res.parse(myInputStream);
        } else {
            String string2 = this.plan instanceof PlanBGCat ? "\t" : ((l2 & 0x400000L) == 0x400000L ? " " : (myInputStream.getSepCSV() != '\uffffffff' ? myInputStream.getSepCSV() + "" : this.aladin.CSVCHAR));
            this.res = new TableParser(this.aladin, (TableParserConsumer)this, string2);
            this.res.setFileName(myInputStream.getFileName());
            bl = this.res.parse(myInputStream, string);
        }
        if (bl && this.plan instanceof PlanBGCat) {
            if (this.nb_o == 0) {
                this.setRecord(0.0, 0.0, null);
            }
            return this.nb_o;
        }
        if (bl) {
            if (!this.flagEndResource) {
                this.endResource();
            }
            long l3 = System.currentTimeMillis() - l;
            String string3 = "Catalog parsed in " + Util.myRound("" + (double)l3 / 1000.0, 3) + "s" + (this.nb_o < 1000 ? "" : " (" + Util.myRound("" + 1000.0 * (double)this.nb_o / (double)l3) + " objects per sec)");
            this.tableParserInfo("\n" + string3);
            Aladin.trace(3, string3);
            if (!this.flagXY && this.rm == 0.0) {
                Aladin.error = "no RA or DE rows";
                this.plan.error = "no RA or DE rows";
            }
        } else {
            this.plan.error = Aladin.error = "Error: " + this.res.getError();
        }
        if (this.plan.error != null) {
            System.out.println("!!! " + this.plan.label + ": " + this.plan.error);
        }
        return bl && this.nb_o >= 0 ? this.nb_o : -1;
    }

    protected void createDefaultProj() {
        for (int i = 0; i < this.nb_o; ++i) {
            Position position = (Position)this.o[i];
            if (i == 0 || position.raj < this.minRa) {
                this.minRa = position.raj;
            }
            if (i == 0 || position.raj > this.maxRa) {
                this.maxRa = position.raj;
            }
            if (i == 0 || position.dej < this.minDec) {
                this.minDec = position.dej;
            }
            if (i != 0 && !(position.dej > this.maxDec)) continue;
            this.maxDec = position.dej;
        }
        this.computeTarget();
        this.postJob(this.rajc, this.dejc, this.rm, false);
    }

    private void computeTarget() {
        if (this.maxDec - this.minDec > 90.0) {
            this.rajc = 0.0;
            this.dejc = 0.0;
            this.rm = 7200.0;
        } else {
            double d;
            if (this.maxRa - this.minRa > 180.0) {
                d = 360.0 - this.maxRa;
                this.rajc = (this.minRa + d) / 2.0 - d;
            } else {
                this.rajc = (this.minRa + this.maxRa) / 2.0;
            }
            this.dejc = (this.minDec + this.maxDec) / 2.0;
            d = Math.max(Math.abs(this.minRa - this.rajc) * Math.cos(this.dejc * Math.PI / 180.0), Math.abs(this.minDec - this.dejc));
            this.rm = this.nb_o == 1 || d == 0.0 ? 7.0 : d * 60.0 * 1.4142;
        }
        Aladin.trace(3, "computeTarget ra=[" + this.minRa + ".." + this.maxRa + "]=>" + this.rajc + " de=[" + this.minDec + ".." + this.maxDec + "]=>" + this.dejc + " rm=[" + this.rm + "]");
    }

    double[] parseTarget(String string) {
        double[] dArray = new double[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-,=/");
        try {
            dArray[0] = Double.valueOf(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            return null;
        }
        boolean bl = string.lastIndexOf(45) > 0;
        try {
            dArray[1] = Double.valueOf(stringTokenizer.nextToken().trim());
            if (bl) {
                dArray[1] = -dArray[1];
            }
        }
        catch (Exception exception) {
            return null;
        }
        try {
            stringTokenizer.nextToken();
            dArray[2] = 11.0;
            dArray[2] = Double.valueOf(stringTokenizer.nextToken().trim());
            if (string.indexOf("bm") > 0) {
                dArray[2] = dArray[2] / 2.0;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return dArray;
    }

    protected int setPlanCat(Plan plan, URL uRL, boolean bl) {
        return this.setPlanCat(plan, uRL, null, null, bl);
    }

    protected int setPlanCat(Plan plan, MyInputStream myInputStream, String string, boolean bl) {
        return this.setPlanCat(plan, null, myInputStream, string, bl);
    }

    protected int setPlanCat(Plan plan, URL uRL, MyInputStream myInputStream, String string, boolean bl) {
        int n = -1;
        boolean bl2 = false;
        try {
            if (uRL != null) {
                this.tableParserInfo(uRL + "\n");
            }
            if (myInputStream == null) {
                try {
                    myInputStream = Util.openStream(uRL);
                }
                catch (Exception exception) {
                    myInputStream = Util.openStream(uRL);
                }
            }
            plan.dis = myInputStream;
            this.flagVOTable = (myInputStream.getType() & 0x100L) != 0L;
            boolean bl3 = bl2 = (myInputStream.getType() & 0x40000L) != 0L;
            if (bl2) {
                string = "TABLE";
            }
            n = this.tableParsing(myInputStream, string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = OUTOFMEMORY;
            if (bl) {
                System.out.println("!!! " + (plan == null ? "" : plan.label + ": ") + Aladin.error);
                Aladin.warning(Aladin.error);
            }
            this.o = new Obj[200];
            this.nb_o = 0;
            this.aladin.gc();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.error = CATABORT + "\n --> " + exception;
            this.o = new Obj[200];
            this.nb_o = 0;
            this.aladin.gc();
            if (bl) {
                System.out.println("!!! " + (plan == null ? "" : plan.label + ": ") + Aladin.error);
                Aladin.warning(Aladin.error);
            }
            n = -1;
        }
        if (bl2) {
            FootprintParser footprintParser = new FootprintParser(myInputStream, this.res.getUnreadBuffer());
            Hashtable<String, FootprintBean> hashtable = footprintParser.getFooprintHash();
            this.attachFootprintToSources(hashtable);
        }
        return n;
    }

    private void attachFootprintToSources(Hashtable<String, FootprintBean> hashtable) {
        int n = -1;
        for (int i = 0; i < this.nb_o; ++i) {
            double d;
            if (!(this.o[i] instanceof Source)) continue;
            Source source = (Source)this.o[i];
            PlanField planField = null;
            n = source.findColumn("FoVRef");
            if (n < 0) {
                n = source.findUtype("char:SpatialAxis.coverage.support.id");
            }
            if (n < 0) continue;
            String string = source.getValue(n);
            FootprintBean footprintBean = hashtable.get(string);
            source.setIdxFootprint(n);
            if (footprintBean != null) {
                planField = new PlanField(this.aladin, footprintBean, string);
                source.setFootprint(planField);
            }
            if ((n = source.findUCD("pos.posAng")) < 0) continue;
            String string2 = source.getValue(n);
            if (string2 == null) {
                string2 = "";
            }
            try {
                d = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            if (planField == null) continue;
            planField.make(source.raj, source.dej, d);
        }
    }

    protected int getNextID() {
        return this.nextID;
    }

    int nextIndex() {
        if (this.o == null) {
            this.o = new Obj[200];
            this.nb_o = 0;
        }
        ++this.nextID;
        if (this.nb_o < this.o.length) {
            return this.nb_o++;
        }
        Obj[] objArray = new Obj[this.o.length > 100000 ? this.o.length + 100000 : this.o.length * 2];
        System.arraycopy(this.o, 0, objArray, 0, this.o.length);
        this.o = objArray;
        objArray = null;
        return this.nb_o++;
    }

    protected int setObjet(Obj obj) {
        int n = this.nextIndex();
        if (n < 0) {
            return -1;
        }
        if (obj instanceof Tag) {
            Tag tag = (Tag)obj;
            tag.setEditing(false);
        } else if (obj instanceof Cote) {
            Cote cote = (Cote)obj;
            if (cote.debligne != null) {
                cote.setId();
                this.aladin.console.printInPad(cote.id + "\n");
            }
        }
        this.o[n] = obj;
        return n;
    }

    protected void insertSource(Source source) {
        for (int i = this.nb_o - 1; i >= 0; --i) {
            int n;
            if (!(this.o[i] instanceof Source) || ((Source)this.o[i]).leg != source.leg) continue;
            for (int j = n = this.nextIndex(); j > i + 1; --j) {
                this.o[j] = this.o[j - 1];
            }
            this.o[i + 1] = source;
            return;
        }
        this.setObjetFast(source);
    }

    protected void setObjetFast(Obj obj) {
        int n = this.nextIndex();
        this.o[n] = obj;
    }

    protected void fixInfo(Legende legende) {
        int n = 0;
        for (int i = 0; i < this.nb_o; ++i) {
            if (!(this.o[i] instanceof Source)) continue;
            Source source = (Source)this.o[i];
            if (source.leg != legende) continue;
            source.fixInfo();
            ++n;
        }
    }

    protected int getIndex(Obj obj) {
        for (int i = 0; i < this.nb_o; ++i) {
            if (obj != this.o[i]) continue;
            return i;
        }
        return -1;
    }

    protected boolean delObjet(Obj obj) {
        return this.delObjet(obj, this.removable);
    }

    protected boolean delObjet(Obj obj, boolean bl) {
        int n;
        if (!bl && obj instanceof Source) {
            return false;
        }
        obj.remove();
        for (n = 0; n < this.nb_o && obj != this.o[n]; ++n) {
        }
        if (n < this.nb_o) {
            while (n < this.nb_o - 1) {
                this.o[n] = this.o[n + 1];
                ++n;
            }
            --this.nb_o;
            return true;
        }
        return false;
    }

    protected void showBaratin(int n) {
        this.o[n].status(this.aladin);
    }

    protected boolean computeAndTestDraw(ViewSimple viewSimple, boolean bl) {
        if (this.plan.isCatalog() || this.plan.type == 9 || this.plan.type == 10 || this.plan.type == 13) {
            this.projection(viewSimple);
        }
        if (!this.drawnInViewSimple[viewSimple.n]) {
            return false;
        }
        return bl;
    }

    protected int draw(Graphics graphics, Rectangle rectangle, ViewSimple viewSimple, boolean bl, int n, int n2) {
        return this.draw(graphics, rectangle, viewSimple, bl, false, n, n2);
    }

    protected synchronized int draw(Graphics graphics, Rectangle rectangle, ViewSimple viewSimple, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        block5: {
            if (!this.computeAndTestDraw(viewSimple, bl)) {
                return 0;
            }
            long l = Util.getTime();
            n3 = 0;
            try {
                if (n == 0 && this.plan != null && Aladin.isFootprintPlane(this.plan) && Aladin.ENABLE_FOOTPRINT_OPACITY && (double)this.plan.getOpacityLevel() > 0.02 && graphics instanceof Graphics2D) {
                    this.drawFovInTransparency(graphics, rectangle, viewSimple, bl, n, n2);
                }
                graphics.setColor(this.c);
                for (int i = 0; i < this.nb_o; ++i) {
                    if (rectangle != null && !this.o[i].inClip(viewSimple, rectangle) || bl2 && !this.o[i].isSelected() || !this.o[i].draw(graphics, viewSimple, n, n2)) continue;
                    ++n3;
                }
                long l2 = Util.getTime();
                this.plan.statTimeDisplay = l2 - l;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block5;
                exception.printStackTrace();
            }
        }
        this.plan.statNbItems = n3;
        return n3;
    }

    private void drawFovInTransparency(Graphics graphics, Rectangle rectangle, ViewSimple viewSimple, boolean bl, int n, int n2) {
        Graphics2D graphics2D = null;
        Composite composite = null;
        graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.plan.c);
        composite = graphics2D.getComposite();
        Composite composite2 = Util.getFootprintComposite(this.plan.getOpacityLevel());
        graphics2D.setComposite(composite2);
        ArrayList<Obj> arrayList = new ArrayList<Obj>();
        for (int i = 0; i < this.nb_o; ++i) {
            if (this.o[i] instanceof Cercle || !(this.o[i] instanceof Ligne)) continue;
            arrayList.add(this.o[i]);
        }
        if (arrayList.size() > 0) {
            Ligne[] ligneArray = arrayList.toArray(new Ligne[arrayList.size()]);
            ArrayList<Ligne> arrayList2 = new ArrayList<Ligne>();
            for (int i = ligneArray.length - 1; i >= 0; --i) {
                Ligne ligne;
                if (!arrayList.contains(ligneArray[i])) continue;
                arrayList2.clear();
                Ligne ligne2 = ligne = ligneArray[i];
                arrayList.remove(ligne);
                while (ligne.debligne != null && ligne.debligne != ligne2) {
                    ligne = ligne.debligne;
                    arrayList2.add(ligne);
                    arrayList.remove(ligne);
                }
                if (arrayList2.size() <= 0) continue;
                Point[] pointArray = new Point[arrayList2.size()];
                int[] nArray = new int[arrayList2.size()];
                int[] nArray2 = new int[arrayList2.size()];
                Iterator iterator = arrayList2.iterator();
                int n3 = 0;
                while (iterator.hasNext()) {
                    pointArray[n3] = ((Ligne)iterator.next()).getViewCoord(viewSimple);
                    if (pointArray[n3] == null) {
                        graphics2D.setComposite(composite);
                        return;
                    }
                    nArray[n3] = pointArray[n3].x;
                    nArray2[n3] = pointArray[n3].y;
                    ++n3;
                }
                graphics2D.setColor(ligne.getColor());
                if (!ligne.isVisible()) continue;
                graphics2D.fill(new Polygon(nArray, nArray2, n3));
            }
        }
        graphics2D.setComposite(composite);
    }

    protected synchronized void writeLink(OutputStream outputStream, ViewSimple viewSimple, boolean bl) throws Exception {
        if (!this.computeAndTestDraw(viewSimple, bl)) {
            return;
        }
        for (int i = 0; i < this.nb_o; ++i) {
            this.o[i].writeLink(outputStream, viewSimple);
        }
    }

    protected synchronized void writeLinkFlex(OutputStream outputStream, ViewSimple viewSimple, boolean bl) throws Exception {
        if (!this.computeAndTestDraw(viewSimple, bl)) {
            return;
        }
        for (int i = 0; i < this.nb_o; ++i) {
            if (!(this.o[i] instanceof Source)) continue;
            ((Source)this.o[i]).writeLinkFlex(outputStream, viewSimple);
        }
    }

    protected int getCount() {
        return this.nb_o;
    }

    protected boolean hasObj() {
        return this.nb_o > 0;
    }

    protected Obj getObj(int n) {
        return n >= this.nb_o ? null : this.o[n];
    }

    protected Iterator<Obj> iterator() {
        return new PlanObjetIterator(null);
    }

    protected Iterator<Obj> iterator(ViewSimple viewSimple) {
        return new PlanObjetIterator(viewSimple);
    }

    class PlanObjetIterator
    implements Iterator<Obj> {
        private int index = 0;
        boolean visible = true;

        PlanObjetIterator(ViewSimple viewSimple) {
            this.visible = viewSimple != null ? Pcat.this.drawnInViewSimple[viewSimple.n] : true;
        }

        @Override
        public boolean hasNext() {
            return this.visible && this.index < Pcat.this.nb_o;
        }

        @Override
        public Obj next() {
            return Pcat.this.o[this.index++];
        }

        @Override
        public void remove() {
        }
    }
}

